/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.homepage;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hpdi.formplugin.web.homepage.BizDataHomePagePlugin;
import kd.swc.hsbp.business.servicehelper.SWCSecurityServiceHelper;

public class BizDataShowAllTimePlugin
extends AbstractBillPlugIn {
    public void preOpenForm(PreOpenFormEventArgs args) {
        SWCSecurityServiceHelper.checkSwcSecurityFlag((PreOpenFormEventArgs)args);
        super.preOpenForm(args);
    }

    public void afterCreateNewData(EventObject evt) {
        DynamicObject[] bizItemGroups = BizDataHomePagePlugin.queryAllBizItemGroup();
        List<Map<String, Object>> params = BizDataHomePagePlugin.queryAllCalPeriod(bizItemGroups);
        Map codResult = BizDataHelper.getCod(params);
        List<Map<String, Object>> totalDataList = BizDataHomePagePlugin.queryAllDataByCod(codResult, params, true);
        if (CollectionUtils.isEmpty(totalDataList)) {
            return;
        }
        List<Map<String, Object>> filterList = BizDataHomePagePlugin.filterTotalList(totalDataList);
        this.filledData(filterList);
    }

    private void filledData(List<Map<String, Object>> filterList) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (int i = 0; i < filterList.size(); ++i) {
            vs.set("bizitemgroup", filterList.get(i).get("bizitemgroupid"), i);
            vs.set("calperiodtype", filterList.get(i).get("calperiod"), i);
            String startDateStr = HRInteDateTimeUtil.formatDate((String)"hsbs_calperiodtype", (String)"startdate", (Date)((Date)filterList.get(i).get("calperiodstartdate")));
            String endDateStr = HRInteDateTimeUtil.formatDate((String)"hsbs_calperiodtype", (String)"enddate", (Date)((Date)filterList.get(i).get("calperiodenddate")));
            vs.set("periodtext", (Object)(filterList.get(i).get("calperiodstartdate") == null ? "" : startDateStr + "~" + endDateStr), i);
            vs.set("starttime", filterList.get(i).get("starttime"), i);
            vs.set("endtime", filterList.get(i).get("endtime"), i);
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        ChangeData[] changeData = args.getChangeSet();
        if ("checkboxfield".equals(fieldKey)) {
            if (((Boolean)this.getView().getModel().getValue("checkboxfield")).booleanValue()) {
                List<Map<String, Object>> data = this.getRecentLyData();
                this.filledData(data);
            } else {
                List<Map<String, Object>> data = this.getAllData(false);
                this.filledData(data);
            }
        }
    }

    private List<Map<String, Object>> getAllData(boolean isCompareToCurrDate) {
        ArrayList<Map<String, Object>> result = new ArrayList(10);
        DynamicObject[] bizItemGroups = BizDataHomePagePlugin.queryAllBizItemGroup();
        List<Map<String, Object>> params = BizDataHomePagePlugin.queryAllCalPeriod(bizItemGroups);
        Map codResult = BizDataHelper.getCod(params);
        result = BizDataHomePagePlugin.queryAllDataByCod(codResult, params, isCompareToCurrDate);
        return result;
    }

    private List<Map<String, Object>> getRecentLyData() {
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>(10);
        List<Map<String, Object>> allData = this.getAllData(true);
        if (!CollectionUtils.isEmpty(allData)) {
            result = BizDataHomePagePlugin.filterTotalList(allData);
        }
        return result;
    }
}

