/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.homepage;

import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.swc.hpdi.business.bizdata.enums.BizDataStatusEnum;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hpdi.formplugin.web.homepage.BizDataErrorComparePlugin;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSecurityServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class BizDataStatusTrackPlugin
extends AbstractBillPlugIn
implements HyperLinkClickListener,
PagerClickListener {
    private static final Log logger = LogFactory.getLog(BizDataStatusTrackPlugin.class);
    private static final String KEY_MORE = "more";
    private static final String HPDI_BIZDATASTATUSTRACK = "hpdi_bizdatastatustrack";
    private static final int DISPLAY_NUMBER = 5;
    private static final char HYPHEN = '-';
    private static final String FORE_COLOR_212121 = "#212121";
    private static final String FORE_COLOR_FB2323 = "#FB2323";
    private static final String TITLE_FLEX_PANEL = "titleflexpanel";
    private static final String ALIAS_BIZDATASTATUSCOUNT = "bizDataStatusCount";
    private static final String BIZ_DATA_SELECT_FIELDS = "id,billno,bizitemgroup.id as bizitemgroup,personcount,bizdatacount,bizdatafailcount as submitfailednum, createtime";
    private static final String BIZ_DATA_ENT_SELECT_FIELDS = "bizdatabillid, empposorgrel.id as empposorgrel, bizdatastatus";
    private static final String[] LEFT_TABLE_FIELDS = new String[]{"bizitemgroup", "bizitemgroupname", "persontime", "bizdatanum", "submitfailednum", "empcount", "empfailcount", "entcount"};
    private static final String[] RIGHT_TABLE_FIELDS = new String[]{"tocalculatepayrollnum", "failedtransferpayrollnum", "transferredpayrollnum", "rejecttransferpayrollnum"};
    private static final String[] BIZ_DATA_FIELDS = new String[]{"bizitemgroup", "tocalculatepayrollnum", "failedtransferpayrollnum", "transferredpayrollnum", "rejecttransferpayrollnum"};
    private static final DataType[] BIZ_DATA_TYPES = new DataType[]{DataType.LongType, DataType.IntegerType, DataType.IntegerType, DataType.IntegerType, DataType.IntegerType};

    public void preOpenForm(PreOpenFormEventArgs args) {
        SWCSecurityServiceHelper.checkSwcSecurityFlagForWidgets((PreOpenFormEventArgs)args);
        super.preOpenForm(args);
    }

    public void initialize() {
        super.initialize();
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        super.propertyChanged(propertyChangedArgs);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Object customParam = this.getView().getFormShowParameter().getCustomParam(KEY_MORE);
        if (customParam != null && SWCStringUtils.equals((String)((String)customParam), (String)"1")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TITLE_FLEX_PANEL});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{TITLE_FLEX_PANEL});
        }
        IDataModel dataModel = this.getModel();
        if (!(dataModel instanceof AbstractFormDataModel)) {
            return;
        }
        Map<String, Object> homeFilter = this.handleHomeFilter();
        this.handleData(dataModel, homeFilter);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{KEY_MORE});
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addPagerClickListener((PagerClickListener)this);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "more": {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId(HPDI_BIZDATASTATUSTRACK);
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                StyleCss inlineStyleCss = new StyleCss();
                inlineStyleCss.setHeight("490");
                inlineStyleCss.setWidth("1000");
                formShowParameter.getOpenStyle().setInlineStyleCss(inlineStyleCss);
                formShowParameter.setCustomParam(KEY_MORE, (Object)"1");
                this.getView().showForm(formShowParameter);
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        HashMap<String, Object> customParam = new HashMap<String, Object>(7);
        ArrayList<String> dateDataRangeList = new ArrayList<String>(2);
        Map<String, Object> filterMap = this.handleHomeFilter();
        if (!filterMap.isEmpty()) {
            Date startDate = (Date)filterMap.get("datarange_startdate");
            Date endDate = (Date)filterMap.get("datarange_enddate");
            dateDataRangeList.add(SWCDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd") + " 00:00:00");
            dateDataRangeList.add(SWCDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd") + " 23:59:59");
            if (SWCStringUtils.equals((String)fieldName, (String)"submitfailednum")) {
                customParam.put("auditdate", dateDataRangeList);
            } else {
                customParam.put("submitdate", dateDataRangeList);
            }
        }
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        long bizItemGroupId = entryRowEntity.getLong("bizitemgroup");
        customParam.put("bizitemgroup", bizItemGroupId);
        switch (fieldName) {
            case "submitfailednum": {
                ArrayList<String> dataStatus = new ArrayList<String>(3);
                dataStatus.add(BizDataStatusEnum.PART_PRESENT.getCode());
                dataStatus.add(BizDataStatusEnum.ALL_FAILED_PRESENT.getCode());
                customParam.put("datastatus", dataStatus);
                customParam.put("isStatusTrackFlag", "isStatusTrackFlag");
                this.openBizDataBillListPage(customParam);
                break;
            }
            case "tocalculatepayrollnum": {
                customParam.put("bizdatastatus", "1");
                this.openBizDataListPage(customParam, bizItemGroupId);
                break;
            }
            case "failedtransferpayrollnum": {
                customParam.put("bizdatastatus", "4");
                this.openBizDataListPage(customParam, bizItemGroupId);
                break;
            }
            case "transferredpayrollnum": {
                customParam.put("bizdatastatus", "3");
                this.openBizDataListPage(customParam, bizItemGroupId);
                break;
            }
            case "rejecttransferpayrollnum": {
                customParam.put("bizdatastatus", "6");
                this.openBizDataListPage(customParam, bizItemGroupId);
                break;
            }
        }
    }

    public void pagerClick(PagerClickEvent pagerClickEvent) {
    }

    private Map<String, Object> handleHomeFilter() {
        HashMap<String, Object> filterMap = new HashMap<String, Object>(5);
        Object customParam = this.getView().getFormShowParameter().getCustomParam(KEY_MORE);
        IFormView formView = customParam != null && SWCStringUtils.equals((String)((String)customParam), (String)"1") ? this.getView().getParentView() : this.getView();
        if (BizDataErrorComparePlugin.validateRightDate(formView)) {
            IDataModel dataModel = formView.getParentView().getModel();
            Date startDate = (Date)dataModel.getValue("datarange_startdate");
            Date endDate = (Date)dataModel.getValue("datarange_enddate");
            DynamicObject bizItemGroup = (DynamicObject)dataModel.getValue("bizitemgroup");
            long bizItemGroupId = SWCObjectUtils.isEmpty((Object)bizItemGroup) ? 0L : bizItemGroup.getLong("id");
            try {
                startDate = SWCDateTimeUtils.parseDate((String)(SWCDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd") + " 00:00:00"));
                endDate = SWCDateTimeUtils.parseDate((String)(SWCDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd") + " 23:59:59"));
                filterMap.put("datarange_startdate", startDate);
                filterMap.put("datarange_enddate", endDate);
                filterMap.put("bizitemgroup", bizItemGroupId);
            }
            catch (Exception parseException) {
                logger.info(MessageFormat.format("BizDataStatusTrackPlugin-handleHomeFilter parseException:{0}", parseException.getMessage()));
            }
        }
        return filterMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleData(IDataModel dataModel, Map<String, Object> filterMap) {
        DataSet bizDataBillDataSet = null;
        DataSet copyBizDataBillDataSet = null;
        DataSet groupedBizDataBillDataSet = null;
        DataSet copyGroupedBizDataBillDataSet = null;
        DataSet billDataSet1 = null;
        DataSet submitFailedNumDataSet = null;
        DataSet bizDataDataSet = null;
        DataSet groupBizDataSet = null;
        DataSet tempBizDataSet = null;
        DataSet joinedResultDataSet = null;
        DataSet bizItemGroupNameDataSet = null;
        DataSet resultDataSet = null;
        DataSet bizDataBillDataSet1 = null;
        DataSet copyEntBizDataBillDataSet = null;
        DataSet bizDataBillEntDataSet = null;
        DataSet copyEntDataSet = null;
        DataSet groupedEntDataSet = null;
        DataSet groupedEntEmpDataSet = null;
        DataSet billDataSet2 = null;
        DataSet billEntFailDataSet = null;
        DataSet groupedEntFailDataSet = null;
        try {
            bizDataBillDataSet1 = this.getBizDataBillDataSet(filterMap, null);
            copyEntBizDataBillDataSet = bizDataBillDataSet1.copy();
            List<Long> bizDataBillIds = this.getBizDataBillIds(copyEntBizDataBillDataSet);
            bizDataBillEntDataSet = this.getBizDataBillEntDataSet(bizDataBillIds, null);
            copyEntDataSet = bizDataBillEntDataSet.copy();
            groupedEntEmpDataSet = bizDataBillEntDataSet.groupBy(new String[]{"empposorgrel", "bizdatabillid"}).finish().groupBy(new String[]{"bizdatabillid"}).count("empcount").finish();
            groupedEntDataSet = copyEntDataSet.groupBy(new String[]{"bizdatabillid"}).count("entcount").finish();
            bizDataBillDataSet = bizDataBillDataSet1.join(groupedEntEmpDataSet, JoinType.LEFT).on("id", "bizdatabillid").select(new String[]{"id", "billno", "bizitemgroup", "personcount", "bizdatacount", "submitfailednum", "empcount"}).finish().join(groupedEntDataSet, JoinType.LEFT).on("id", "bizdatabillid").select(new String[]{"billno", "bizitemgroup", "personcount", "bizdatacount", "submitfailednum", "empcount", "entcount"}).finish();
            copyBizDataBillDataSet = bizDataBillDataSet.copy();
            groupedBizDataBillDataSet = bizDataBillDataSet.groupBy(new String[]{"bizitemgroup"}).sum("personcount", "persontime").sum("bizdatacount", "bizdatanum").sum("empcount").sum("entcount").finish();
            copyGroupedBizDataBillDataSet = groupedBizDataBillDataSet.copy();
            ArrayList<String> dataStatus = new ArrayList<String>(2);
            dataStatus.add(BizDataStatusEnum.PART_PRESENT.getCode());
            dataStatus.add(BizDataStatusEnum.ALL_FAILED_PRESENT.getCode());
            billDataSet1 = this.getBizDataBillDataSet(filterMap, dataStatus);
            ArrayList<String> bizDataStatus = new ArrayList<String>();
            bizDataStatus.add("2");
            billEntFailDataSet = this.getBizDataBillEntDataSet(bizDataBillIds, bizDataStatus);
            groupedEntFailDataSet = billEntFailDataSet.groupBy(new String[]{"empposorgrel", "bizdatabillid"}).finish().groupBy(new String[]{"bizdatabillid"}).count("empfailcount").finish();
            billDataSet2 = billDataSet1.join(groupedEntFailDataSet, JoinType.LEFT).on("id", "bizdatabillid").select(new String[]{"bizitemgroup", "submitfailednum", "empfailcount"}).finish();
            submitFailedNumDataSet = billDataSet2.groupBy(new String[]{"bizitemgroup"}).sum("submitfailednum").sum("empfailcount").finish();
            List<String> billNumbers = this.getBizDataBillNumbers(copyBizDataBillDataSet);
            List<Long> bizItemGroupIds = this.getBizItemGroupIds(groupedBizDataBillDataSet);
            bizDataDataSet = this.getBizDataSet(billNumbers, filterMap);
            groupBizDataSet = bizDataDataSet.groupBy(new String[]{"bizdatacode", "bizitemgroup", "bizdatastatus"}).finish().groupBy(new String[]{"bizitemgroup", "bizdatastatus"}).count(ALIAS_BIZDATASTATUSCOUNT).finish();
            ArrayList<Object[]> collection = new ArrayList<Object[]>();
            RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])BIZ_DATA_FIELDS, (DataType[])BIZ_DATA_TYPES);
            CollectionInput inputs = new CollectionInput(rowMeta, collection);
            tempBizDataSet = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
            Object[] tempData = new Object[BIZ_DATA_FIELDS.length];
            for (Row row : groupBizDataSet) {
                String tempBizItemGroup = row.getString(BIZ_DATA_FIELDS[0]);
                if (!tempBizItemGroup.equals(tempData[0])) {
                    tempData = new Object[BIZ_DATA_FIELDS.length];
                    collection.add(tempData);
                }
                tempData[0] = tempBizItemGroup;
                this.setStatusAmount(tempData, row);
            }
            joinedResultDataSet = copyGroupedBizDataBillDataSet.join(submitFailedNumDataSet, JoinType.LEFT).on("bizitemgroup", "bizitemgroup").select(new String[]{"bizitemgroup", "persontime", "bizdatanum", "submitfailednum", "empcount", "empfailcount", "entcount"}).finish().join(tempBizDataSet, JoinType.LEFT).on("bizitemgroup", "bizitemgroup").select(new String[]{"bizitemgroup", "persontime", "bizdatanum", "submitfailednum", "empcount", "empfailcount", "entcount"}, RIGHT_TABLE_FIELDS).finish();
            bizItemGroupNameDataSet = this.getBizItemGroupName(bizItemGroupIds);
            resultDataSet = joinedResultDataSet.join(bizItemGroupNameDataSet).on("bizitemgroup", "id").select(LEFT_TABLE_FIELDS, RIGHT_TABLE_FIELDS).finish();
            this.setEntryEntity(dataModel, resultDataSet);
        }
        finally {
            if (null != bizDataBillDataSet) {
                bizDataBillDataSet.close();
            }
            if (null != groupedBizDataBillDataSet) {
                groupedBizDataBillDataSet.close();
            }
            if (null != copyBizDataBillDataSet) {
                copyBizDataBillDataSet.close();
            }
            if (null != submitFailedNumDataSet) {
                submitFailedNumDataSet.close();
            }
            if (null != billDataSet1) {
                billDataSet1.close();
            }
            if (null != copyGroupedBizDataBillDataSet) {
                copyGroupedBizDataBillDataSet.close();
            }
            if (null != bizDataDataSet) {
                bizDataDataSet.close();
            }
            if (null != groupBizDataSet) {
                groupBizDataSet.close();
            }
            if (null != tempBizDataSet) {
                tempBizDataSet.close();
            }
            if (null != joinedResultDataSet) {
                joinedResultDataSet.close();
            }
            if (null != bizItemGroupNameDataSet) {
                bizItemGroupNameDataSet.close();
            }
            if (null != resultDataSet) {
                resultDataSet.close();
            }
            if (null != bizDataBillDataSet1) {
                bizDataBillDataSet1.close();
            }
            if (null != copyEntBizDataBillDataSet) {
                copyEntBizDataBillDataSet.close();
            }
            if (null != bizDataBillEntDataSet) {
                bizDataBillEntDataSet.close();
            }
            if (null != copyEntDataSet) {
                copyEntDataSet.close();
            }
            if (null != groupedEntDataSet) {
                groupedEntDataSet.close();
            }
            if (null != groupedEntEmpDataSet) {
                groupedEntEmpDataSet.close();
            }
            if (null != billDataSet2) {
                billDataSet2.close();
            }
            if (null != billEntFailDataSet) {
                billEntFailDataSet.close();
            }
            if (null != groupedEntFailDataSet) {
                groupedEntFailDataSet.close();
            }
        }
    }

    private List<String> getBizDataBillNumbers(DataSet dataSet) {
        ArrayList<String> billNumbers = new ArrayList<String>(10);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            billNumbers.add(row.getString("billno"));
        }
        return billNumbers;
    }

    private List<Long> getBizDataBillIds(DataSet dataSet) {
        ArrayList<Long> billIds = new ArrayList<Long>(10);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            billIds.add(row.getLong("id"));
        }
        return billIds;
    }

    private List<Long> getBizItemGroupIds(DataSet groupedBizDataBillDataSet) {
        ArrayList<Long> bizItemGroupIds = new ArrayList<Long>(10);
        while (groupedBizDataBillDataSet.hasNext()) {
            Row row = groupedBizDataBillDataSet.next();
            bizItemGroupIds.add(row.getLong("bizitemgroup"));
        }
        return bizItemGroupIds;
    }

    private DataSet getBizDataBillDataSet(Map<String, Object> filterMap, List<String> dataStatus) {
        QFilter bizDataBillFilter = new QFilter("billstatus", "=", (Object)"C");
        if (!SWCListUtils.isEmpty(dataStatus)) {
            bizDataBillFilter.and("datastatus", "in", dataStatus);
        }
        bizDataBillFilter.and(BizDataHelper.assembleOrgFilterByBizOrgPerm());
        this.getFilter(filterMap, bizDataBillFilter, 1);
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"hpdi_bizdatabill", (String)BIZ_DATA_SELECT_FIELDS, (QFilter[])new QFilter[]{bizDataBillFilter}, (String)"createtime desc");
    }

    private DataSet getBizDataBillEntDataSet(List<Long> bizDataBillIds, List<String> bizDataStatus) {
        Set bizDataDimIds;
        QFilter bizDataBillEntFilter = new QFilter("bizdatabillid", "in", bizDataBillIds);
        if (!SWCListUtils.isEmpty(bizDataStatus)) {
            bizDataBillEntFilter.and("bizdatastatus", "in", bizDataStatus);
        }
        if (null != (bizDataDimIds = SWCPermissionServiceHelper.getBizDataDimSetByPermItem((String)"0NXW1VOPH+QV", (String)"hpdi_bizdatabillent", (String)"47150e89000000ac"))) {
            QFilter bizDataDimFilter = new QFilter("bizdatadim.id", "in", (Object)bizDataDimIds);
            bizDataBillEntFilter.and(bizDataDimFilter);
        }
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"hpdi_bizdatabillent", (String)BIZ_DATA_ENT_SELECT_FIELDS, (QFilter[])new QFilter[]{bizDataBillEntFilter}, null);
    }

    private DataSet getBizDataSet(List<String> billNumbers, Map<String, Object> filterMap) {
        QFilter bizDataFilter = new QFilter("applyno", "in", billNumbers);
        this.getFilter(filterMap, bizDataFilter, 0);
        Set bizDataDimIds = SWCPermissionServiceHelper.getBizDataDimSetByPermItem((String)"0NXW1VOPH+QV", (String)"hpdi_allbizdata", (String)"47150e89000000ac");
        if (null != bizDataDimIds) {
            QFilter bizDataDimFilter = new QFilter("bizdatadim.id", "in", (Object)bizDataDimIds);
            bizDataFilter.and(bizDataDimFilter);
        }
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"hpdi_bizdata", (String)"bizitemgroup.id as bizitemgroup,bizdatastatus,bizdatacode", (QFilter[])new QFilter[]{bizDataFilter}, null);
    }

    private void getFilter(Map<String, Object> filterMap, QFilter filter, int flag) {
        List permissionFilters;
        if (!filterMap.isEmpty()) {
            Date startDate = (Date)filterMap.get("datarange_startdate");
            Date endDate = (Date)filterMap.get("datarange_enddate");
            long bizItemGroupId = (Long)filterMap.get("bizitemgroup");
            if (startDate != null && endDate != null) {
                if (flag == 1) {
                    filter.and("auditdate", ">", (Object)startDate);
                    filter.and("auditdate", "<", (Object)endDate);
                } else {
                    filter.and("submitdate", ">", (Object)startDate);
                    filter.and("submitdate", "<", (Object)endDate);
                }
            }
            if (bizItemGroupId != 0L) {
                filter.and("bizitemgroup", "=", (Object)bizItemGroupId);
            }
        }
        if (flag == 1 && (permissionFilters = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"0NXW1VOPH+QV", (String)"hpdi_bizdatabill", (String)"47150e89000000ac")) != null && permissionFilters.size() > 0) {
            permissionFilters.stream().forEach(permissionFilter -> {
                filter.and(permissionFilter);
                logger.info(MessageFormat.format("BizDataStatusTrackPlugin-getDateFilter,permissionFilter.getProperty()={0},permissionFilter.getValue()={1}", permissionFilter.getProperty(), permissionFilter.getValue().toString()));
            });
        }
    }

    private void setStatusAmount(Object[] tempData, Row row) {
        String bizDataStatus;
        switch (bizDataStatus = row.getString("bizdatastatus")) {
            case "1": {
                tempData[1] = row.getInteger(ALIAS_BIZDATASTATUSCOUNT);
                break;
            }
            case "4": {
                tempData[2] = row.getInteger(ALIAS_BIZDATASTATUSCOUNT);
                break;
            }
            case "3": {
                tempData[3] = row.getInteger(ALIAS_BIZDATASTATUSCOUNT);
                break;
            }
            case "6": {
                tempData[4] = row.getInteger(ALIAS_BIZDATASTATUSCOUNT);
                break;
            }
        }
    }

    private DataSet getBizItemGroupName(List<Long> bizItemGroupIds) {
        QFilter filter = new QFilter("id", "in", bizItemGroupIds);
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"hsbs_bizitemgroup", (String)"id,name as bizitemgroupname", (QFilter[])new QFilter[]{filter}, null);
    }

    private void setEntryEntity(IDataModel dataModel, DataSet resultDataSet) {
        Object customParam = this.getView().getFormShowParameter().getCustomParam(KEY_MORE);
        boolean isControlPageNum = customParam == null || !SWCStringUtils.equals((String)((String)customParam), (String)"1");
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        int index = 0;
        while (resultDataSet.hasNext() && (!isControlPageNum || index < 5)) {
            Row row = resultDataSet.next();
            Integer bizDataNum = row.getInteger("entcount");
            if (null == bizDataNum || 0 == bizDataNum) continue;
            this.setTableValueSetter(setter, index, row);
            ++index;
        }
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void setTableValueSetter(TableValueSetter setter, int index, Row row) {
        String bizItemGroupName = row.getString(LEFT_TABLE_FIELDS[1]);
        Integer personTime = row.getInteger(LEFT_TABLE_FIELDS[5]);
        Integer bizDataNum = row.getInteger(LEFT_TABLE_FIELDS[7]);
        Integer idCount = row.getInteger(LEFT_TABLE_FIELDS[6]);
        setter.set(LEFT_TABLE_FIELDS[0], (Object)row.getString(LEFT_TABLE_FIELDS[0]), index);
        setter.set(LEFT_TABLE_FIELDS[1], (Object)bizItemGroupName, index);
        setter.set(LEFT_TABLE_FIELDS[2], this.isEmpty(personTime) ? personTime : DecimalFormat.getNumberInstance().format(personTime), index);
        setter.set(LEFT_TABLE_FIELDS[3], this.isEmpty(bizDataNum) ? bizDataNum : DecimalFormat.getNumberInstance().format(bizDataNum), index);
        setter.set(LEFT_TABLE_FIELDS[4], this.isEmpty(idCount) ? idCount : DecimalFormat.getNumberInstance().format(idCount), index);
        if (!this.isEmpty(idCount)) {
            this.setForeColor(LEFT_TABLE_FIELDS[4], index, FORE_COLOR_FB2323);
        }
        this.setRightTableValueSetter(setter, index, row);
    }

    private void setRightTableValueSetter(TableValueSetter setter, int index, Row row) {
        Integer toCalculatePayrollNum = row.getInteger(RIGHT_TABLE_FIELDS[0]);
        Integer failedTransferPayrollNum = row.getInteger(RIGHT_TABLE_FIELDS[1]);
        Integer transferredPayrollNum = row.getInteger(RIGHT_TABLE_FIELDS[2]);
        Integer rejectTransferPayrollNum = row.getInteger(RIGHT_TABLE_FIELDS[3]);
        setter.set(RIGHT_TABLE_FIELDS[0], this.isEmpty(toCalculatePayrollNum) ? toCalculatePayrollNum : DecimalFormat.getNumberInstance().format(toCalculatePayrollNum), index);
        setter.set(RIGHT_TABLE_FIELDS[1], this.isEmpty(failedTransferPayrollNum) ? failedTransferPayrollNum : DecimalFormat.getNumberInstance().format(failedTransferPayrollNum), index);
        setter.set(RIGHT_TABLE_FIELDS[2], this.isEmpty(transferredPayrollNum) ? transferredPayrollNum : DecimalFormat.getNumberInstance().format(transferredPayrollNum), index);
        setter.set(RIGHT_TABLE_FIELDS[3], this.isEmpty(rejectTransferPayrollNum) ? rejectTransferPayrollNum : DecimalFormat.getNumberInstance().format(rejectTransferPayrollNum), index);
        if (!this.isEmpty(toCalculatePayrollNum)) {
            this.setForeColor(RIGHT_TABLE_FIELDS[0], index, FORE_COLOR_FB2323);
        }
        if (!this.isEmpty(failedTransferPayrollNum)) {
            this.setForeColor(RIGHT_TABLE_FIELDS[1], index, FORE_COLOR_FB2323);
        }
        if (!this.isEmpty(transferredPayrollNum)) {
            this.setForeColor(RIGHT_TABLE_FIELDS[2], index, FORE_COLOR_FB2323);
        }
        if (!this.isEmpty(rejectTransferPayrollNum)) {
            this.setForeColor(RIGHT_TABLE_FIELDS[3], index, FORE_COLOR_FB2323);
        }
    }

    private void setForeColor(String fieldKey, int rowIndex, String foreColor) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
        CellStyle cellStyle = new CellStyle();
        cellStyle.setFieldKey(fieldKey);
        cellStyle.setRow(rowIndex);
        cellStyle.setForeColor(foreColor);
        cellStyles.add(cellStyle);
        entryGrid.setCellStyle(cellStyles);
    }

    private boolean isEmpty(Integer number) {
        return number == null || number == 0;
    }

    private void openBizDataListPage(Map<String, Object> customParam, long bizItemGroupId) {
        DynamicObject bizItemGroup = HPDIDataServiceHelper.HSBS_BIZITEMGROUP_HELPER.queryOriginalOne("id,modeltype", (Object)bizItemGroupId);
        if (SWCObjectUtils.isEmpty((Object)bizItemGroup)) {
            logger.info("BizDataStatusTrackPlugin-openBizDataListPage queryBizItemGroupModelType result is empty!");
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String modelType = bizItemGroup.getString("modeltype");
        logger.info("BizDataStatusTrackPlugin-openBizDataListPage queryBizItemGroupModelType is:{}", (Object)modelType);
        switch (modelType) {
            case "1": {
                formShowParameter.setCustomParam("condition", customParam);
                formShowParameter.setFormId("hpdi_bizdatalist");
                break;
            }
            case "2": {
                formShowParameter.setCustomParam("condition", customParam);
                formShowParameter.setCustomParam("bizitemgroup", (Object)bizItemGroupId);
                formShowParameter.setFormId("hpdi_bizdataherizonlist");
                break;
            }
        }
        this.getView().showForm(formShowParameter);
    }

    private void openBizDataBillListPage(Map<String, Object> customParam) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("hpdi_bizdatabill");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("condition", customParam);
        showParameter.setFilterSchemeId("0");
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

