/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.msgreceive;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.factory.ShowReviseDetailServiceFactory;
import kd.swc.hpdi.business.helper.EmpInfoReviseHelper;
import kd.swc.hpdi.business.service.IShowReviseDetailService;
import org.apache.commons.collections4.MapUtils;

public class EmpInfoReviseLogList
extends AbstractListPlugin {
    private static final Log LOGGER = LogFactory.getLog(EmpInfoReviseLogList.class);
    private Map<Long, String> idVsAbstractMap;
    private Map<Long, List<Long>> idMap;

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String formId = args.getRefEntityId();
        if (!"hrcs_msgcenter".equalsIgnoreCase(formId)) {
            return;
        }
        List qfilters = args.getQfilters();
        ArrayList<QFilter> removeList = new ArrayList<QFilter>(10);
        if (!CollectionUtils.isEmpty((Collection)qfilters)) {
            for (QFilter qfilter : qfilters) {
                String property = qfilter.getProperty();
                if (!"status".equalsIgnoreCase(property)) continue;
                removeList.add(qfilter);
            }
            qfilters.removeAll(removeList);
        }
        qfilters.add(new QFilter("action.actiontype.id", "=", (Object)1929789824022237184L));
        args.getCustomParams().put("showDisabledCheckbox", "false");
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String source = MapUtils.getString((Map)customParams, (Object)"PARENT_SOURCE_FROM");
        if ("SOURCE_CARD".equals(source)) {
            FilterColumn filterColumn = args.getFilterColumn("processstatus");
            filterColumn.setDefaultValue("A");
        }
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObjectCollection pageDataCol = e.getPageData();
        List idList = pageDataCol.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
        DynamicObject[] dynamicObjects = EmpInfoReviseHelper.getInstance().queryReviseDetByLogId(idList);
        this.idMap = new HashMap<Long, List<Long>>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            long centerId = dynamicObject.getLong("msgcenter.id");
            List tempList = this.idMap.computeIfAbsent(centerId, item -> new ArrayList(10));
            tempList.add(dynamicObject.getLong("id"));
        }
        this.idVsAbstractMap = EmpInfoReviseHelper.getInstance().generateAbstract(idList);
    }

    public void packageData(PackageDataEvent e) {
        DynamicTextColumnDesc colum;
        Object source = e.getSource();
        if (source instanceof DynamicTextColumnDesc && "reviseabstract".equals((colum = (DynamicTextColumnDesc)e.getSource()).getKey())) {
            Long id = e.getRowData().getLong("id");
            e.setFormatValue((Object)MapUtils.getString(this.idVsAbstractMap, (Object)id));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("donothing_viewdetail".equals(operateKey)) {
            this.viewDetail(args, source);
        }
    }

    private void viewDetail(BeforeDoOperationEventArgs args, FormOperate source) {
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        if (CollectionUtils.isEmpty((Collection)listSelectedData)) {
            return;
        }
        OperateOption option = source.getOption();
        Long id = (Long)source.getListSelectedData().get(0).getPrimaryKeyValue();
        DynamicObject viewObject = EmpInfoReviseHelper.getInstance().queryReviseLogByLogId(id);
        if (viewObject == null) {
            return;
        }
        String msgType = viewObject.getString("msgtype");
        DynamicObject[] dynamicObjects = EmpInfoReviseHelper.getInstance().queryReviseDetByLogId(Collections.singletonList(id));
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        IShowReviseDetailService service = ShowReviseDetailServiceFactory.getService((String)msgType);
        if ("LIST".equalsIgnoreCase(service.listCLickShowMode())) {
            HashMap<String, Object> param = new HashMap<String, Object>(16);
            param.put("entityNumber", viewObject.getString("msgtype"));
            param.put("employeeId", viewObject.getLong("employee.id"));
            param.put("reviseLogId", viewObject.getLong("id"));
            param.put("msgContent", viewObject.getString("msgcenter.params"));
            Optional formShowParameter = service.showMulti(param);
            if (formShowParameter.isPresent()) {
                this.getView().showForm((FormShowParameter)formShowParameter.get());
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u672a\u627e\u5230\u3002", (String)"EmpInfoReviseLogList_0", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        DynamicObject object = dynamicObjects[0];
        long reviseBeforeId = object.getLong("revisebefore");
        long reviseAfterId = object.getLong("reviseafter");
        long reviseBoId = object.getLong("revisebo");
        long reviseDetId = object.getLong("id");
        String reviseType = object.getString("revisetype");
        Optional formShowParameter = service.showSingle((Map)ImmutableMap.of((Object)"reviseBeforeId", (Object)reviseBeforeId, (Object)"reviseAfterId", (Object)reviseAfterId, (Object)"reviseBoId", (Object)reviseBoId, (Object)"reviseDetId", (Object)reviseDetId, (Object)"reviseType", (Object)reviseType));
        if (formShowParameter.isPresent()) {
            this.getView().showForm((FormShowParameter)formShowParameter.get());
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u672a\u627e\u5230\u3002", (String)"EmpInfoReviseLogList_0", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
        }
    }
}

