/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.verify;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.formplugin.web.SWCCoreBaseBillEdit;
import org.apache.commons.collections4.MapUtils;

public class AdjFileVerifyBillExtEdit
extends SWCCoreBaseBillEdit
implements BeforeF7SelectListener {
    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        OrgEdit orgEdit = (OrgEdit)this.getControl("org");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit countryEdit = (BasedataEdit)this.getControl("country");
        countryEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit depcyType = (BasedataEdit)this.getControl("depcytype");
        depcyType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit salayStructure = (BasedataEdit)this.getControl("salaystructure");
        salayStructure.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit stdscm = (BasedataEdit)this.getControl("stdscm");
        stdscm.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit assoadminorg = (BasedataEdit)this.getControl("assoadminorg");
        assoadminorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit empgroup = (BasedataEdit)this.getControl("empgroup");
        empgroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String flowType = MapUtils.getString((Map)customParams, (Object)"flowType");
        if ("2".equals(flowType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"org", "country", "depcytype", "salaystructure", "stdscm", "assoadminorg", "bsed", "isinputnewfile", "empgroup"});
        }
    }

    public void propertyChanged(PropertyChangedArgs event) {
        String name;
        super.propertyChanged(event);
        IDataEntityProperty property = event.getProperty();
        switch (name = property.getName()) {
            case "org": {
                this.onOrgPropertyChanged(event);
                break;
            }
            case "country": {
                this.onCountryPropertyChanged(event);
                break;
            }
            case "salaystructure": {
                this.onSalaryStructPropertyChanged(event);
                break;
            }
        }
    }

    private void onOrgPropertyChanged(PropertyChangedArgs event) {
        this.getModel().setValue("salaystructure", null);
        this.getModel().setValue("stdscm", null);
    }

    private void onSalaryStructPropertyChanged(PropertyChangedArgs event) {
        ChangeData changeSet = event.getChangeSet()[0];
        Object newValue = changeSet.getNewValue();
        if (newValue != null) {
            DynamicObject[] query;
            SWCDataServiceHelper stdScm = new SWCDataServiceHelper("hcdm_stdscm");
            List<QFilter> stdsCmFilter = this.getStdsCmFilter();
            if (!CollectionUtils.isEmpty(stdsCmFilter) && (query = stdScm.query("id", stdsCmFilter.toArray(new QFilter[0]))) != null && query.length != 0) {
                this.getModel().setValue("stdscm", (Object)query[0].getLong("id"));
                return;
            }
        }
        this.getModel().setValue("stdscm", null);
    }

    private void onCountryPropertyChanged(PropertyChangedArgs event) {
        this.getModel().setValue("salaystructure", null);
        this.getModel().setValue("stdscm", null);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name;
        IDataEntityProperty property = event.getProperty();
        switch (name = property.getName()) {
            case "org": {
                this.addOrgFilter(event);
                break;
            }
            case "country": {
                this.addCountryFilter(event);
                break;
            }
            case "depcytype": {
                this.addDepcyTypeFilter(event);
                break;
            }
            case "salaystructure": {
                this.addSalaryStructureFilter(event);
                break;
            }
            case "stdscm": {
                this.addStdsCmFilter(event);
                break;
            }
            case "assoadminorg": {
                this.addAssoAdminOrgFilter(event);
                break;
            }
            case "empgroup": {
                this.addEmpGroupFilter(event);
                break;
            }
        }
    }

    private void addEmpGroupFilter(BeforeF7SelectEvent event) {
        List customQFilters = event.getCustomQFilters();
        customQFilters.add(this.getEmpGroupQfilter("hcdm"));
        QFilter dataRuleForBdProp = SWCPermissionServiceHelper.getDataRuleForBdProp((String)"0VO5EV13=I9W", (String)"hcdm_adjfileinfo", (String)"empgroup");
        if (dataRuleForBdProp != null) {
            customQFilters.add(dataRuleForBdProp);
        }
    }

    private QFilter getEmpGroupQfilter(String appNumber) {
        List empGroupByAppNumber = SWCPermissionServiceHelper.getEmpgroupByAppNumber((String)appNumber);
        if (CollectionUtils.isEmpty((Collection)empGroupByAppNumber)) {
            return new QFilter("id", "in", Collections.emptyList());
        }
        return new QFilter("id", "in", (Object)empGroupByAppNumber);
    }

    private void addAssoAdminOrgFilter(BeforeF7SelectEvent event) {
        Set adminOrgSet = SWCPermissionServiceHelper.getAdminOrgSetByPermItem((String)"0VO5EV13=I9W", (String)"hcdm_adjfileinfo", (String)"47150e89000000ac", (String)"assoadminorg");
        if (adminOrgSet != null) {
            event.getCustomQFilters().add(new QFilter("id", "in", (Object)adminOrgSet));
        }
    }

    private void addDepcyTypeFilter(BeforeF7SelectEvent event) {
        List customQFilters = event.getCustomQFilters();
        QFilter depcyType = SWCPermissionServiceHelper.getDataRuleForBdProp((String)"0VO5EV13=I9W", (String)"hcdm_adjfileinfo", (String)"depcytype");
        if (depcyType != null) {
            customQFilters.add(depcyType);
        }
    }

    private void addStdsCmFilter(BeforeF7SelectEvent event) {
        if (!this.checkInput("org", "country", "salaystructure")) {
            event.setCancel(true);
            return;
        }
        List customQFilters = event.getCustomQFilters();
        List<QFilter> stdsCmFilter = this.getStdsCmFilter();
        if (!CollectionUtils.isEmpty(stdsCmFilter)) {
            customQFilters.addAll(stdsCmFilter);
        }
    }

    private List<QFilter> getStdsCmFilter() {
        ArrayList<QFilter> result = new ArrayList<QFilter>(10);
        QFilter stdScm = SWCPermissionServiceHelper.getDataRuleForBdProp((String)"0VO5EV13=I9W", (String)"hcdm_adjfileinfo", (String)"stdscm");
        if (stdScm != null) {
            result.add(stdScm);
        }
        long orgId = this.getModel().getDataEntity().getLong("org.id");
        QFilter ctrFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hcdm_stdscm", (Long)orgId);
        result.add(ctrFilter);
        DynamicObject country = this.getModel().getDataEntity().getDynamicObject("country");
        QFilter countryTypeCommon = new QFilter("country", "=", (Object)country.getLong("id"));
        result.add(countryTypeCommon);
        long structId = this.getModel().getDataEntity().getLong("salaystructure.id");
        result.add(new QFilter("salaystructure.fbasedataid", "=", (Object)structId));
        return result;
    }

    private boolean checkInput(String ... fields) {
        if (fields == null || fields.length == 0) {
            return true;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        IDataEntityType dataEntityType = dataEntity.getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        boolean result = true;
        ArrayList<String> nameList = new ArrayList<String>(10);
        for (String field : fields) {
            Object value = dataEntity.get(field);
            if (value != null) continue;
            IDataEntityProperty pro = (IDataEntityProperty)properties.get((Object)field);
            nameList.add(pro.getDisplayName().getLocaleValue());
            result = false;
        }
        if (!result && !CollectionUtils.isEmpty(nameList)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9{0}\u3002", (String)"AdjFileVerifyBillExtEdit_0", (String)"swc-hpdi-formplugin", (Object[])new Object[]{String.join((CharSequence)"\u3001", nameList)}));
        }
        return result;
    }

    private void addSalaryStructureFilter(BeforeF7SelectEvent event) {
        if (!this.checkInput("org", "country")) {
            event.setCancel(true);
            return;
        }
        List customQFilters = event.getCustomQFilters();
        QFilter salaryStructFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((String)"0VO5EV13=I9W", (String)"hcdm_adjfileinfo", (String)"salaystructure");
        if (salaryStructFilter != null) {
            customQFilters.add(salaryStructFilter);
        }
        long orgId = this.getModel().getDataEntity().getLong("org.id");
        QFilter ctrFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hcdm_salaystructure", (Long)orgId);
        customQFilters.add(ctrFilter);
        DynamicObject country = this.getModel().getDataEntity().getDynamicObject("country");
        QFilter countryTypeCommon = new QFilter("country", "=", (Object)country.getLong("id"));
        customQFilters.add(countryTypeCommon);
    }

    private void addCountryFilter(BeforeF7SelectEvent event) {
        List customQFilters = event.getCustomQFilters();
        QFilter countryFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((String)"0VO5EV13=I9W", (String)"hcdm_adjfileinfo", (String)"country");
        if (countryFilter != null) {
            customQFilters.add(countryFilter);
        }
    }

    private void addOrgFilter(BeforeF7SelectEvent event) {
        List customQFilters = event.getCustomQFilters();
        HasPermOrgResult adminOrg = SWCPermissionServiceHelper.getPermOrgs((String)"0VO5EV13=I9W", (String)"hcdm_adjfileinfo", (String)"47150e89000000ac");
        if (!adminOrg.hasAllOrgPerm()) {
            customQFilters.add(new QFilter("id", "in", (Object)adminOrg.getHasPermOrgs()));
        }
    }
}

