/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.verify;

import java.text.ParseException;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hpdi.business.msgreceive.CollaMsgVerifyBillHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCCoreBaseBillEdit;

public class SalaryVerifyBillExtEdit
extends SWCCoreBaseBillEdit
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(SalaryVerifyBillExtEdit.class);
    public static final String CACHE_ORG_CHANGED_VALUE = "CACHE_ORG_CHANGED_VALUE";
    public static final String CACHE_ORG_CHANGED_FLAG = "CACHE_ORG_CHANGED_FLAG";
    public static final String CALLBACK_ORG_CHANGED = "CALLBACK_ORG_CHANGED";

    public void initialize() {
        super.initialize();
        this.getView().getFormShowParameter().setCustomParam("customHREntityNumber", (Object)"hsas_salaryfile");
        this.getView().getFormShowParameter().setCustomParam("customHRPermItemId", (Object)"47156aff000000ac");
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        BasedataEdit payRollGroup = (BasedataEdit)this.getControl("payrollgroup");
        payRollGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit adminOrg = (BasedataEdit)this.getControl("adminorg");
        adminOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit empGroup = (BasedataEdit)this.getControl("empgroup");
        empGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit SsalaryStyle = (BasedataEdit)this.getControl("salarycalcstyle");
        SsalaryStyle.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        this.getView().setVisible(Boolean.FALSE, new String[]{"org"});
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.EDIT.equals((Object)status)) {
            DynamicObject parentData;
            IFormView parentView = this.getView().getParentView();
            String trClass = (parentData = parentView.getModel().getDataEntity(true)).getString("taskarrangeclass");
            long createOrg = parentData.getLong("hpdi_taskrule".equalsIgnoreCase(trClass) ? "org.id" : "morg.id");
            if (createOrg != 0L) {
                this.getModel().setValue("org", (Object)createOrg);
                this.getModel().setDataChanged(false);
            }
            this.updateViewByHistorySalaryFile();
        }
    }

    private Long parseToLong(Object data) {
        return CollaMsgVerifyBillHelper.getInstance().parseToLong(data);
    }

    private void updateViewByHistorySalaryFile() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long depEmpId = this.parseToLong(customParams.get("depEmpId"));
        Long depEmpBoId = this.parseToLong(customParams.get("depEmpBoId"));
        String changeTimeStr = (String)customParams.get("changeTime");
        if (SWCStringUtils.isEmpty((String)changeTimeStr)) {
            return;
        }
        Date changeTime = null;
        try {
            changeTime = SWCDateTimeUtils.parseDate((String)changeTimeStr, (String)"yyyy-MM-dd HH:mm:ss");
        }
        catch (ParseException ex) {
            LOGGER.info("[verifybill] par date {} error", (Object)changeTimeStr, (Object)ex);
        }
        if (depEmpBoId == null || changeTime == null) {
            return;
        }
        DynamicObject existSalaryFile = CollaMsgVerifyBillHelper.getInstance().getExistSalaryFile(depEmpBoId, changeTime);
        if (existSalaryFile == null) {
            return;
        }
        this.getModel().setValue("payrollgroup", (Object)existSalaryFile.getLong("payrollgroup.id"));
        this.getView().setEnable(Boolean.FALSE, new String[]{"org", "payrollgroup"});
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name;
        IDataEntityProperty property = event.getProperty();
        switch (name = property.getName()) {
            case "payrollgroup": {
                this.addPayRollGroupFilter(event);
                break;
            }
            case "adminorg": {
                this.addAdminOrgFilter(event);
                break;
            }
            case "empgroup": {
                this.addEmpGroupFilter(event);
                break;
            }
            case "salarycalcstyle": {
                this.addSalaryCalcStyleFilter(event);
                break;
            }
        }
    }

    private void addSalaryCalcStyleFilter(BeforeF7SelectEvent event) {
        List customQFilters = event.getCustomQFilters();
        QFilter hsasSalaryCalStyle = SWCPermissionServiceHelper.getDataRuleForBdProp((String)"/UHMBBGZQ65X", (String)"hsas_salaryfile", (String)"salarycalcstyle");
        if (hsasSalaryCalStyle != null) {
            customQFilters.add(hsasSalaryCalStyle);
        }
        long orgId = this.getModel().getDataEntity().getLong("org.id");
        QFilter ctrFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsas_salarycalcstyle", (Long)orgId);
        QFilter countryTypeCommon = new QFilter("countrytype", "=", (Object)"1");
        customQFilters.add(ctrFilter.and(new QFilter("1", "=", (Object)1).or(countryTypeCommon)));
    }

    private void addEmpGroupFilter(BeforeF7SelectEvent event) {
        List customQFilters = event.getCustomQFilters();
        QFilter dataRuleForBdProp = SWCPermissionServiceHelper.getDataRuleForBdProp((String)"/UHMBBGZQ65X", (String)"hsas_salaryfile", (String)"empgroup");
        if (dataRuleForBdProp != null) {
            customQFilters.add(dataRuleForBdProp);
        }
        customQFilters.add(new QFilter("bussinessfield", "=", (Object)107010L));
    }

    private void addAdminOrgFilter(BeforeF7SelectEvent event) {
        Set adminOrgSet = SWCPermissionServiceHelper.getAdminOrgSetByPermItem((String)"/UHMBBGZQ65X", (String)"hsas_salaryfile", (String)"47150e89000000ac", (String)"adminorg");
        if (adminOrgSet != null) {
            event.getCustomQFilters().add(new QFilter("id", "in", (Object)adminOrgSet));
        }
    }

    private void addPayRollGroupFilter(BeforeF7SelectEvent event) {
        List customQFilters = event.getCustomQFilters();
        QFilter dataRuleForBdProp = SWCPermissionServiceHelper.getDataRuleForBdProp((String)"/UHMBBGZQ65X", (String)"hsas_salaryfile", (String)"payrollgroup");
        if (dataRuleForBdProp != null) {
            customQFilters.add(dataRuleForBdProp);
        }
        long orgId = this.getModel().getDataEntity().getLong("org.id");
        customQFilters.add(new QFilter("org", "=", (Object)orgId));
    }
}

