/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.verify;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.cloudcolla.HPDICloudCollaHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCCoreBaseBillEdit;

public class SummaryVerifyBillViewEdit
extends SWCCoreBaseBillEdit {
    public static final String NOT_SAVE_BILL_FROM_IDS = "notSaveBillFromIds";

    public void registerListener(EventObject event) {
        super.registerListener(event);
        Vector closeTips = (Vector)this.getControl("closetips");
        closeTips.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.setOrgVisible();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("closetips".equalsIgnoreCase(key)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flextips"});
        }
    }

    private void setOrgVisible() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String taskArrangeClass = dataEntity.getString("taskarrangeclass");
        boolean collaCtrFunctional = "hpdi_taskrule".equalsIgnoreCase(taskArrangeClass);
        if (SWCStringUtils.isEmpty((String)taskArrangeClass)) {
            collaCtrFunctional = HPDICloudCollaHelper.getInstance().getCollaCtrFunctional();
        }
        this.getView().setVisible(Boolean.valueOf(collaCtrFunctional), new String[]{"org", "multaskcenter"});
        this.getView().setVisible(Boolean.valueOf(!collaCtrFunctional), new String[]{"morg", "mulcollatask"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey().toLowerCase(Locale.ROOT);
        source.getOption().setVariableValue(NOT_SAVE_BILL_FROM_IDS, (String)this.getView().getFormShowParameter().getCustomParam(NOT_SAVE_BILL_FROM_IDS));
        switch (operateKey) {
            case "save": 
            case "submit": 
            case "submiteffect": {
                this.generateRelatedBillDataList(source);
                break;
            }
        }
    }

    private void generateRelatedBillDataList(FormOperate source) {
        Map subCardPageId = (Map)new SWCPageCache(this.getView()).get("CACHE_SUB_CARD_PAGE_ID", Map.class);
        if (CollectionUtils.isEmpty((Map)subCardPageId)) {
            return;
        }
        HashMap billFieldValues = new HashMap(16);
        long billId = this.getModel().getDataEntity().getLong("id");
        subCardPageId.forEach((appNumber, cacheMapList) -> {
            if (CollectionUtils.isEmpty((Collection)cacheMapList)) {
                return;
            }
            for (Map cacheMap : cacheMapList) {
                DynamicObject dataEntity;
                String bizObjectId = (String)cacheMap.get("bizObjectId");
                if (SWCStringUtils.isEmpty((String)bizObjectId)) continue;
                String cardType = (String)cacheMap.get("cardType");
                String triggerCollaIdStr = (String)cacheMap.get("triggerCollaId");
                String pageId = (String)cacheMap.get("pageId");
                IFormView view = this.getView().getView(pageId);
                IDataModel model = view.getModel();
                if (!model.isDataLoaded() || (dataEntity = model.getDataEntity()) == null) continue;
                Map triggerMap = billFieldValues.computeIfAbsent(billId, key -> new HashMap(16));
                Long triggerCollaId = Long.valueOf(triggerCollaIdStr);
                Map triggerMapData = triggerMap.computeIfAbsent(triggerCollaId, key -> new HashMap(16));
                triggerMapData.put("cardType", cardType);
                triggerMapData.put("objectNumber", bizObjectId);
                triggerMapData.put("appNumber", appNumber);
                ArrayList exeParams = new ArrayList(10);
                triggerMapData.put("exeParams", exeParams);
                ArrayList objectValueList = new ArrayList(10);
                triggerMapData.put("objectValues", objectValueList);
                IDataEntityType dataEntityType = dataEntity.getDataEntityType();
                MainEntityType objectType = EntityMetadataCache.getDataEntityType((String)bizObjectId);
                DataEntityPropertyCollection properties = objectType.getProperties();
                Map allFields = ((MainEntityType)dataEntityType).getAllFields();
                allFields.forEach((propName, property) -> {
                    HashMap<String, Object> objectValue = new HashMap<String, Object>(16);
                    objectValue.put("fieldNumber", property.getName());
                    objectValue.put("fieldValue", property.getValue((Object)dataEntity));
                    if (properties.containsKey((Object)property.getName())) {
                        objectValueList.add(objectValue);
                    } else {
                        exeParams.add(objectValue);
                    }
                });
            }
        });
        source.getOption().setVariableValue("billFieldValues", SerializationUtils.serializeToBase64(billFieldValues));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "submit": 
            case "audit": 
            case "unaudit": 
            case "unsubmit": 
            case "save": 
            case "submiteffect": {
                OperationResult operationResult = args.getOperationResult();
                if (!operationResult.isSuccess()) break;
                this.getView().getPageCache().remove("CACHE_RULE_ENGINE_RESULT");
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }
}

