/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.verify;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.msgreceive.CollaMsgVerifyBillHelper;
import kd.swc.hpdi.business.msgreceive.DataSyncMsgHelper;
import kd.swc.hpdi.business.verify.SumVerifyBillEventBus;
import kd.swc.hpdi.business.verify.event.RuleEngineConvertEvent;
import kd.swc.hpdi.common.constants.PayRollActGrpConstants;
import kd.swc.hsbp.business.cloudcolla.verify.VerifyBillDataService;
import kd.swc.hsbp.business.cloudcolla.verify.event.object.AbstractVerifyBillEvent;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.verify.AbstractVerifyBillLoadSubCardEdit;

public class SummaryVerifyBillViewLoadSubCardEdit
extends AbstractVerifyBillLoadSubCardEdit {
    private static final Log LOGGER = LogFactory.getLog(SummaryVerifyBillViewLoadSubCardEdit.class);

    protected List<DynamicObject> getSubCardData() {
        String ruleEngineResult = this.getView().getPageCache().get("CACHE_RULE_ENGINE_RESULT");
        long billId = this.getModel().getDataEntity().getLong("id");
        ArrayList<DynamicObject> result = new ArrayList(10);
        Long taskArrangeId = null;
        if (!SWCStringUtils.isEmpty((String)ruleEngineResult)) {
            DynamicObject verifyBill;
            Map reData = (Map)SerializationUtils.deSerializeFromBase64((String)ruleEngineResult);
            result = this.getDataFromRuleEngine(reData, billId);
            if (!CollectionUtils.isEmpty((Map)reData) && (verifyBill = (DynamicObject)reData.get("verifyBill")) != null) {
                taskArrangeId = verifyBill.getLong("taskarrange.id");
            }
        } else {
            result = this.getDataFromDataBase(billId);
            taskArrangeId = this.getModel().getDataEntity().getLong("taskarrange.id");
        }
        if (CollectionUtils.isEmpty(result)) {
            return Collections.emptyList();
        }
        if (taskArrangeId != null && taskArrangeId != 0L) {
            String taskArrangeClass = this.getModel().getDataEntity().getString("taskarrangeclass");
            List<Long> sortedTriggerIds = this.getTriggerIdByTaskRuleId(taskArrangeClass, taskArrangeId);
            result.sort((first, second) -> {
                Long firstBizAppId = first.getLong("triggercolla.id");
                Long secondBizAppId = second.getLong("triggercolla.id");
                return sortedTriggerIds.indexOf(firstBizAppId) - sortedTriggerIds.indexOf(secondBizAppId);
            });
        }
        return result;
    }

    protected List<String> getIgnoreCheckFiled() {
        return Arrays.asList("payrollactgv", "taskrule", "taskrulev", "payrollactgv_id", "taskrule_id", "taskrulev_id", "taskarrange", "taskarrangev", "collarulev", "taskarrange_id", "taskarrangev_id", "collarulev_id");
    }

    private List<DynamicObject> getDataFromDataBase(long billId) {
        Map subCardResult = VerifyBillDataService.getInstance().queryVerifyBillBySummaryId(Long.valueOf(billId));
        if (!((Boolean)subCardResult.get("success")).booleanValue()) {
            return Collections.emptyList();
        }
        List subCardData = (List)subCardResult.get("data");
        if (CollectionUtils.isEmpty((Collection)subCardData)) {
            return Collections.emptyList();
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        for (DynamicObject subCardDatum : subCardData) {
            DynamicObjectCollection entryEntity;
            if (subCardDatum == null || CollectionUtils.isEmpty((Collection)(entryEntity = subCardDatum.getDynamicObjectCollection("entryentity")))) continue;
            result.addAll((Collection<DynamicObject>)entryEntity);
        }
        return result;
    }

    private List<DynamicObject> getDataFromRuleEngine(Map<String, Object> reData, long billId) {
        if (CollectionUtils.isEmpty(reData)) {
            return Collections.emptyList();
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        HashMap<Long, Map> ruleEngineResults = new HashMap<Long, Map>(16);
        ruleEngineResults.put(billId, (Map)reData.get("ruleEngineData"));
        Map billFieldValues = new HashMap(16);
        try {
            billFieldValues = CollaMsgVerifyBillHelper.getInstance().getBillFieldValues(ruleEngineResults);
        }
        catch (KDException exception) {
            LOGGER.info("[colla] getDataFromRuleEngine error. {}", (Object)exception.getMessage(), (Object)exception);
            throw new KDBizException(new ErrorCode("RELOAD_SUB_CARD_ERROR_0", exception.getMessage()), new Object[]{exception});
        }
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("billFieldValues", billFieldValues);
        map.put("summaryVerifyBill", new DynamicObject[]{this.getModel().getDataEntity()});
        RuleEngineConvertEvent ruleEngineConvertEvent = new RuleEngineConvertEvent(map);
        SumVerifyBillEventBus.getInstance().post((AbstractVerifyBillEvent)ruleEngineConvertEvent);
        Map outputData = ruleEngineConvertEvent.getOutputData();
        if (CollectionUtils.isEmpty((Map)outputData)) {
            return Collections.emptyList();
        }
        outputData.forEach((formId, formData) -> {
            Boolean success = (Boolean)formData.get("success");
            if (!success.booleanValue()) {
                return;
            }
            List dataList = (List)formData.get("data");
            List entries = dataList.stream().flatMap(object -> object.getDynamicObjectCollection("entryentity").stream()).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(entries)) {
                return;
            }
            result.addAll(entries);
        });
        return result;
    }

    private List<Long> getTriggerIdByTaskRuleId(String taskRuleClass, Long taskRuleId) {
        SWCDataServiceHelper taskRuleOrm = new SWCDataServiceHelper(taskRuleClass);
        DynamicObject taskRule = taskRuleOrm.queryOne("id,number,payrollactg,collarule,collaruletype", new QFilter[]{new QFilter("id", "in", (Object)taskRuleId)});
        if (taskRule == null) {
            return Collections.emptyList();
        }
        List payRollActGIds = taskRule.getDynamicObjectCollection("entryentity").stream().map(item -> item.getString("collaruletype") + PayRollActGrpConstants.COLLA_RULE_ID_SEPERATOR + item.getLong("collarule.id")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(payRollActGIds)) {
            return Collections.emptyList();
        }
        List payRollActGroupData = DataSyncMsgHelper.getInstance().queryCollaRuleData(payRollActGIds);
        if (CollectionUtils.isEmpty((Collection)payRollActGroupData)) {
            return Collections.emptyList();
        }
        Map payRollActGroupDataMap = payRollActGroupData.stream().collect(Collectors.toMap(item -> item.getDynamicObjectType().getName() + PayRollActGrpConstants.COLLA_RULE_ID_SEPERATOR + item.getLong("id"), Function.identity()));
        ArrayList<Long> result = new ArrayList<Long>(10);
        for (String payRollActGId : payRollActGIds) {
            List payRollActList;
            DynamicObject dynamicObject = (DynamicObject)payRollActGroupDataMap.get(payRollActGId);
            if (dynamicObject == null || CollectionUtils.isEmpty(payRollActList = this.getEntryEntityFiledValue(dynamicObject, "entryentity", "payrollact"))) continue;
            for (DynamicObject payRollAct : payRollActList) {
                List triggerCollaIds = this.getEntryEntityFiledValue(payRollAct, "entryentity", "triggercolla.id");
                if (CollectionUtils.isEmpty(triggerCollaIds)) continue;
                result.addAll(triggerCollaIds);
            }
        }
        return result;
    }

    private <T> List<T> getEntryEntityFiledValue(DynamicObject object, String entityName, String fieldNumber) {
        DynamicObjectCollection entryEntity = object.getDynamicObjectCollection(entityName);
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>(10);
        for (DynamicObject entry : entryEntity) {
            Object subObject = entry.get(fieldNumber);
            if (subObject == null) continue;
            result.add(subObject);
        }
        return result;
    }
}

