/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.verify;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.cloudcolla.HPDICloudCollaHelper;
import kd.swc.hpdi.business.msgreceive.CollaMsgVerifyBillHelper;
import kd.swc.hpdi.business.msgreceive.DataSyncMsgHelper;
import kd.swc.hpdi.business.msgreceive.HPDICollaMsgServiceHelper;
import kd.swc.hpdi.business.msgreceive.TaskCenterCreateAsyncHelper;
import kd.swc.hpdi.common.constants.PayRollActGrpConstants;
import kd.swc.hpdi.common.entity.CoreHRMessageContentEntity;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCCoreBaseBillEdit;
import org.apache.commons.collections.MapUtils;

public class SummaryVerifyBillViewReloadSubPage
extends SWCCoreBaseBillEdit
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(SummaryVerifyBillViewReloadSubPage.class);
    public static final String CACHE_TASK_RULE_CHANGED_FLAG = "CACHE_TASK_RULE_CHANGED_FLAG";
    public static final String CACHE_RULE_ENGINE_RESULT = "CACHE_RULE_ENGINE_RESULT";
    @Deprecated
    public static final String PARAM_TASK_RULE = "taskrule";
    public static final String PARAM_TASK_ARRANGE = "taskarrange";
    public static final String PARAM_TASK_ARRANGE_CLASS = "taskarrangeclass";
    public static final String PARAM_ORG = "org";
    public static final String PARAM_M_ORG = "morg";
    public static final String CACHE_ORG_CHANGED_VALUE = "CACHE_ORG_CHANGED_VALUE";
    @Deprecated
    public static final String PARAM_TASK_RULE_V = "taskrulev";
    public static final String PARAM_TASK_ARRANGE_V = "taskarrangev";
    @Deprecated
    public static final String PARAM_PAY_ROLLACTG_V = "payrollactgv";
    public static final String CALLBACK_ORG_CHANGED = "CALLBACK_ORG_CHANGED";
    public static final String CACHE_REFRESH_DATA = "CACHE_REFRESH_DATA";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
    }

    private void lockSubAppFlex() {
        Set tempIds;
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if (!"A".equalsIgnoreCase(billStatus) && !"G".equalsIgnoreCase(billStatus)) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection mulCollaTasks = dataEntity.getDynamicObjectCollection("mulcollatask");
        DynamicObjectCollection mulTaskCenters = dataEntity.getDynamicObjectCollection("multaskcenter");
        HashMap<String, Set> param = new HashMap<String, Set>(16);
        for (DynamicObject task : mulCollaTasks) {
            tempIds = param.computeIfAbsent("hpdi_collatask", item -> new HashSet(16));
            tempIds.add(task.getLong("fbasedataid_id"));
        }
        for (DynamicObject task : mulTaskCenters) {
            tempIds = param.computeIfAbsent("hpdi_taskcenter", item -> new HashSet(16));
            tempIds.add(task.getLong("fbasedataid_id"));
        }
        Table collaTaskTable = HPDICloudCollaHelper.getInstance().queryMultiClassObject(param);
        Map<Long, DynamicObject> collaTaskMap = collaTaskTable.values().stream().collect(Collectors.toMap(item -> item.getLong("id"), val -> val, (v1, v2) -> v1));
        DynamicObjectCollection payRollActgV = this.getModel().getDataEntity().getDynamicObjectCollection("collaruleventry");
        List collaRuleComboIds = payRollActgV.stream().map(item -> item.getString("collarulevclass") + PayRollActGrpConstants.COLLA_RULE_ID_SEPERATOR + item.getLong("collarulev.id")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collaRuleComboIds)) {
            return;
        }
        List payRollActGroupData = DataSyncMsgHelper.getInstance().queryCollaRuleData(collaRuleComboIds);
        if (CollectionUtils.isEmpty((Collection)payRollActGroupData)) {
            return;
        }
        Map<Long, Set<String>> collaRuleEntityMap = this.getCollaRuleEntityMap(payRollActGroupData);
        String trClass = dataEntity.getString(PARAM_TASK_ARRANGE_CLASS);
        long trVId = dataEntity.getLong("taskarrangev.id");
        if (SWCStringUtils.isEmpty((String)trClass) || trVId == 0L) {
            return;
        }
        Table trTable = HPDICloudCollaHelper.getInstance().queryMultiClassObject((Map)ImmutableMap.of((Object)trClass, Collections.singleton(trVId)));
        DynamicObject taskRuleV = (DynamicObject)trTable.get((Object)trClass, (Object)trVId);
        if (taskRuleV == null) {
            return;
        }
        DynamicObjectCollection taskRuleVEntryEntity = taskRuleV.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)taskRuleVEntryEntity)) {
            return;
        }
        this.setEnableForApp(mulCollaTasks, collaTaskMap, collaRuleEntityMap, taskRuleVEntryEntity);
        this.setEnableForApp(mulTaskCenters, collaTaskMap, collaRuleEntityMap, taskRuleVEntryEntity);
    }

    private Map<Long, Set<String>> getCollaRuleEntityMap(List<DynamicObject> collaRuleList) {
        DynamicObject[] triggetCollaDyobjs;
        if (CollectionUtils.isEmpty(collaRuleList)) {
            return Collections.emptyMap();
        }
        ArrayList<Long> triggerCollaIds = new ArrayList<Long>(10);
        HashMap<Long, Set> collaRuleTriggerMap = new HashMap<Long, Set>(16);
        for (DynamicObject collaRule : collaRuleList) {
            long crId2 = collaRule.getLong("id");
            DynamicObject[] collaRuleEntity = collaRule.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)collaRuleEntity)) continue;
            for (DynamicObject crRow : collaRuleEntity) {
                DynamicObjectCollection payRollActEntity;
                DynamicObject payRollAct = crRow.getDynamicObject("payrollact");
                if (payRollAct == null || CollectionUtils.isEmpty((Collection)(payRollActEntity = payRollAct.getDynamicObjectCollection("entryentity")))) continue;
                for (DynamicObject actRow : payRollActEntity) {
                    long trId = actRow.getLong("triggercolla.id");
                    triggerCollaIds.add(trId);
                    Set idSet = collaRuleTriggerMap.computeIfAbsent(crId2, item -> new HashSet(16));
                    idSet.add(trId);
                }
            }
        }
        HashMap<Long, String> triggerEntityMap = new HashMap<Long, String>(16);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsbs_triggercolla");
        QFilter qFilter = new QFilter("id", "in", triggerCollaIds);
        for (DynamicObject triggerCollaDyobj : triggetCollaDyobjs = serviceHelper.query("ismustfieldmapping, entityobject.number,entityobject.id", new QFilter[]{qFilter})) {
            String isFieldMap = triggerCollaDyobj.getString("ismustfieldmapping");
            if ("1".equals(isFieldMap)) continue;
            triggerEntityMap.put(triggerCollaDyobj.getLong("id"), triggerCollaDyobj.getString("entityobject.number"));
        }
        HashMap<Long, Set<String>> result = new HashMap<Long, Set<String>>(16);
        collaRuleTriggerMap.forEach((crId, trIds) -> {
            for (Long trId : trIds) {
                String entityNumber = MapUtils.getString((Map)triggerEntityMap, (Object)trId);
                if (SWCStringUtils.isEmpty((String)entityNumber)) continue;
                Set entityNumberSet = result.computeIfAbsent((Long)crId, item -> new HashSet(16));
                entityNumberSet.add(entityNumber);
            }
        });
        return result;
    }

    private void setEnableForApp(DynamicObjectCollection mulcollatasks, Map<Long, DynamicObject> collaTaskMap, Map<Long, Set<String>> collaRuleEntityMap, DynamicObjectCollection taskRuleVEntryEntity) {
        if (CollectionUtils.isEmpty((Collection)mulcollatasks)) {
            return;
        }
        for (DynamicObject mulcollatask : mulcollatasks) {
            DynamicObject taskCenter = collaTaskMap.get(mulcollatask.get("fbasedataid_id"));
            if (taskCenter == null) continue;
            Map<Long, String> actTaskStatusMap = taskCenter.getDynamicObjectCollection("entryentity").stream().collect(Collectors.toMap(item -> item.getLong("collarule.id"), item -> item.getString("taskexecutestatusent")));
            ArrayList<String> lockEntityNumbers = new ArrayList<String>(taskRuleVEntryEntity.size());
            for (DynamicObject object : taskRuleVEntryEntity) {
                Set entityNumberSet;
                long acgId;
                if (!object.getBoolean("ismanualverify") || !"D".equalsIgnoreCase(actTaskStatusMap.get(acgId = object.getLong("collarule.id"))) || CollectionUtils.isEmpty((Collection)(entityNumberSet = (Set)MapUtils.getObject(collaRuleEntityMap, (Object)acgId, Collections.emptySet())))) continue;
                for (String entityNumber : entityNumberSet) {
                    lockEntityNumbers.add("container-" + entityNumber);
                }
            }
            this.getView().setEnable(Boolean.FALSE, lockEntityNumbers.toArray(new String[0]));
        }
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        DynamicObject taskCenter = this.getModel().getDataEntity().getDynamicObject("collatask");
        this.getView().setEnable(Boolean.valueOf(taskCenter == null), new String[]{PARAM_ORG});
        this.getView().setEnable(Boolean.valueOf(taskCenter == null), new String[]{PARAM_M_ORG});
        this.setBillData();
        this.lockSubAppFlex();
    }

    private void setBillData() {
        String ruleEngineResult = this.getView().getPageCache().get(CACHE_RULE_ENGINE_RESULT);
        if (SWCStringUtils.isEmpty((String)ruleEngineResult)) {
            return;
        }
        Map reData = (Map)SerializationUtils.deSerializeFromBase64((String)ruleEngineResult);
        if (CollectionUtils.isEmpty((Map)reData)) {
            this.getModel().setValue(PARAM_TASK_ARRANGE_V, null);
            this.getModel().setDataChanged(false);
            return;
        }
        DynamicObject verifyBill = (DynamicObject)reData.get("verifyBill");
        if (!this.getLongValue(this.getModel().getValue(PARAM_TASK_ARRANGE)).equals(this.getLongValue(verifyBill.get(PARAM_TASK_ARRANGE)))) {
            new SWCPageCache(this.getView()).put(CACHE_TASK_RULE_CHANGED_FLAG, (Object)Boolean.TRUE);
        }
        this.getModel().setValue(PARAM_TASK_ARRANGE_CLASS, verifyBill.get(PARAM_TASK_ARRANGE_CLASS));
        this.getModel().setValue(PARAM_TASK_ARRANGE, verifyBill.get(PARAM_TASK_ARRANGE));
        this.refreshTaskV(reData);
        this.getModel().setValue(PARAM_ORG, verifyBill.get(PARAM_ORG));
        this.getModel().setValue(PARAM_M_ORG, verifyBill.get(PARAM_M_ORG));
    }

    private Long getLongValue(Object data) {
        if (data instanceof DynamicObject) {
            return ((DynamicObject)data).getLong("id");
        }
        return (Long)data;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    private boolean reloadSubPage(String taskRuleClass, Long taskRuleId) {
        String orgName;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject msgReceiveObject = dataEntity.getDynamicObject("orgmsgrecvcenter");
        SWCDataServiceHelper orm = new SWCDataServiceHelper(taskRuleClass);
        DynamicObject taskRule = orm.queryOne(SWCHisBaseDataHelper.getSelectProperties((String)taskRuleClass), (Object)taskRuleId);
        if (taskRule == null) {
            return false;
        }
        DynamicObject bu = taskRule.getDynamicObject("createorg");
        int executeSeq = dataEntity.getInt("executeseq");
        List msgs = HPDICollaMsgServiceHelper.getInstance().splitMsgReceiveLog(msgReceiveObject);
        Map tempResult = null;
        try {
            tempResult = CollaMsgVerifyBillHelper.getInstance().generateVerifyBill(taskRule, msgReceiveObject, (CoreHRMessageContentEntity)msgs.get(executeSeq - 1), bu, executeSeq);
        }
        catch (Exception ex) {
            LOGGER.info("[verifybill] CollaMsgVerifyBillHelper generateVerifyBill error", (Object)ex);
        }
        String string = orgName = "hpdi_taskrule".equalsIgnoreCase(taskRuleClass) ? this.getOrgName(PARAM_ORG) : this.getOrgName(PARAM_M_ORG);
        if (tempResult == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u89c4\u5219\u5f15\u64ce\u8c03\u7528\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u65b0\u9009\u62e9\u201c{0}\u201d\u3002", (String)"SummaryVerifyBillReloadSubPage_1", (String)"swc-hpdi-formplugin", (Object[])new Object[]{orgName}));
            this.getView().getPageCache().remove(CACHE_REFRESH_DATA);
            return false;
        }
        Boolean isSuccess = (Boolean)tempResult.get("success");
        Map dataResult = (Map)tempResult.get("data");
        ArrayList<String> msg = new ArrayList<String>(10);
        if (!isSuccess.booleanValue() && this.isExePreConditionError(dataResult, msg).booleanValue()) {
            this.getView().showTipNotification((String)msg.get(0));
            this.getView().getPageCache().remove(CACHE_REFRESH_DATA);
            return false;
        }
        if (!isSuccess.booleanValue()) {
            this.getView().showTipNotification((String)tempResult.get("msg"));
            this.getView().getPageCache().remove(CACHE_REFRESH_DATA);
            return false;
        }
        if ("DO_NOT_VERIFY".equalsIgnoreCase((String)tempResult.get("code"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5{0}\u7684\u534f\u4f5c\u4efb\u52a1\u7f16\u6392\u4e0d\u5b58\u5728\u9700\u8981\u624b\u5de5\u6838\u5b9a\u7684\u5185\u5bb9\u3002", (String)"SummaryVerifyBillReloadSubPage_3", (String)"swc-hpdi-formplugin", (Object[])new Object[]{orgName}));
        }
        this.getView().getPageCache().put(CACHE_RULE_ENGINE_RESULT, SerializationUtils.serializeToBase64((Object)dataResult));
        this.getView().invokeOperation("refresh");
        return true;
    }

    private Boolean isExePreConditionError(Map<String, Object> tempResult, List<String> msg) {
        if (CollectionUtils.isEmpty(tempResult)) {
            return Boolean.FALSE;
        }
        Map ruleEngineData = (Map)tempResult.get("ruleEngineData");
        if (CollectionUtils.isEmpty((Map)ruleEngineData)) {
            return Boolean.FALSE;
        }
        ArrayList errorActName = new ArrayList(10);
        ruleEngineData.forEach((payRollActGId, result) -> {
            Map actResult = (Map)result;
            if (((Boolean)actResult.get("success")).booleanValue()) {
                return;
            }
            Map tempErrorDataMap = (Map)actResult.get("errorDataList");
            if (CollectionUtils.isEmpty((Map)tempErrorDataMap)) {
                return;
            }
            List errorDataList = (List)tempErrorDataMap.get("errorData");
            if (CollectionUtils.isEmpty((Collection)errorDataList)) {
                return;
            }
            for (Map errorData : errorDataList) {
                String actName;
                if (!"COLLA_RULE_ERROR_001".equalsIgnoreCase((String)errorData.get("code")) || SWCStringUtils.isEmpty((String)(actName = (String)errorData.get("actName")))) continue;
                errorActName.add(actName);
            }
        });
        if (CollectionUtils.isEmpty(errorActName)) {
            return Boolean.FALSE;
        }
        String mergedActName = errorActName.stream().map(item -> "[" + item + "]").collect(Collectors.joining("\u3001"));
        msg.add(ResManager.loadKDString((String)"\u5f53\u524d\u4eba\u5458\u4e0d\u6ee1\u8db3\u8be5\u534f\u4f5c\u4efb\u52a1\u7f16\u6392{0}\u7684\u6267\u884c\u524d\u63d0\u6761\u4ef6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SummaryVerifyBillReloadSubPage_2", (String)"swc-hpdi-formplugin", (Object[])new Object[]{mergedActName}));
        return Boolean.TRUE;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        super.confirmCallBack(event);
        switch (callBackId = event.getCallBackId()) {
            case "CALLBACK_TASK_RULE_CHANGED": {
                break;
            }
            case "CALLBACK_ORG_CHANGED": {
                this.orgPropertyChangedCallBack(event);
                break;
            }
        }
    }

    private void orgPropertyChangedCallBack(MessageBoxClosedEvent event) {
        MessageBoxResult result = event.getResult();
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        String customVaule = event.getCustomVaule();
        String[] split = customVaule.split("#");
        if (split.length != 2) {
            return;
        }
        String orgFieldName = split[0];
        Long oldValue = Long.valueOf(split[1]);
        Long newValue = this.getModel().getDataEntity().getLong(orgFieldName + ".id");
        String orgName = this.getOrgName();
        IDataModel model = this.getModel();
        if (MessageBoxResult.Yes.equals((Object)result)) {
            DynamicObject matchRule = this.getMatchRule(newValue);
            model.beginInit();
            if (matchRule == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5{0}\u4e0d\u5b58\u5728\u5df2\u5ba1\u6838\u4e14\u53ef\u7528\u7684\u534f\u4f5c\u4efb\u52a1\u7f16\u6392\uff0c\u8bf7\u65b0\u589e\u540e\u518d\u8bd5\u3002", (String)"SummaryVerifyBillViewReloadSubPage_0", (String)"swc-hpdi-formplugin", (Object[])new Object[]{orgName}));
                model.setValue(orgFieldName, (Object)oldValue);
                model.setDataChanged(false);
            } else if (this.reloadSubPage(matchRule.getDynamicObjectType().getName(), matchRule.getLong("id"))) {
                this.getModel().setValue(PARAM_TASK_ARRANGE, (Object)matchRule);
            } else {
                this.getModel().setValue(orgFieldName, (Object)oldValue);
            }
            model.endInit();
        }
        if (MessageBoxResult.Cancel.equals((Object)result)) {
            model.beginInit();
            this.getModel().setValue(orgFieldName, (Object)oldValue);
            model.endInit();
            model.setDataChanged(false);
        }
        this.getView().updateView(PARAM_TASK_ARRANGE);
        this.getView().updateView(orgFieldName);
    }

    private Long parseValueId(String valueId) {
        if (SWCStringUtils.isEmpty((String)valueId) || "null".equalsIgnoreCase(valueId)) {
            return null;
        }
        return Long.valueOf(valueId);
    }

    private void refreshTaskV(Map<String, Object> reData) {
        IDataModel model = this.getModel();
        model.beginInit();
        DynamicObject taskRule = model.getDataEntity().getDynamicObject(PARAM_TASK_ARRANGE);
        if (taskRule == null) {
            this.getModel().setValue(PARAM_TASK_ARRANGE_V, null);
            this.getModel().deleteEntryData("collaruleventry");
        } else {
            this.getModel().setValue(PARAM_TASK_ARRANGE_CLASS, (Object)taskRule.getDataEntityType().getName());
            SWCDataServiceHelper orm = new SWCDataServiceHelper(taskRule.getDataEntityType().getName());
            DynamicObject query = orm.queryOriginalOne("id,sourcevid", new QFilter[]{new QFilter("id", "=", (Object)taskRule.getLong("id"))});
            if (query != null) {
                this.getModel().setValue(PARAM_TASK_ARRANGE_V, (Object)query.getLong("sourcevid"));
            }
            this.onTaskRuleVPropertyChanged(reData);
        }
        model.endInit();
        IFormView view = this.getView();
        view.updateView(PARAM_TASK_ARRANGE);
        view.updateView(PARAM_TASK_ARRANGE_V);
        view.updateView("collaruleventry");
    }

    public void propertyChanged(PropertyChangedArgs event) {
        String name;
        super.propertyChanged(event);
        switch (name = event.getProperty().getName()) {
            case "taskarrange": {
                this.onTaskRulePropertyChanged(event);
                this.refreshTaskV(null);
                break;
            }
            case "org": 
            case "morg": {
                this.onOrgPropertyChanged(event);
                break;
            }
        }
    }

    private void onOrgPropertyChanged(PropertyChangedArgs event) {
        String orgFieldName = event.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long orgId = dataEntity.getLong(orgFieldName + ".id");
        ChangeData[] changeSet = event.getChangeSet();
        ChangeData changeData = changeSet[0];
        DynamicObject oldValueObject = (DynamicObject)changeData.getOldValue();
        DynamicObject newValueObject = (DynamicObject)changeData.getNewValue();
        if (oldValueObject == null) {
            this.matchTaskRule(orgId);
            return;
        }
        String orgName = this.getOrgName(orgFieldName);
        IDataModel model = this.getModel();
        if (newValueObject == null) {
            model.beginInit();
            model.setValue(orgFieldName, (Object)oldValueObject);
            model.endInit();
            this.getView().showTipNotification(ResManager.loadKDString((String)"{0}\u4e0d\u5141\u8bb8\u6e05\u7a7a\u3002", (String)"SummaryVerifyBillViewReloadSubPage_2", (String)"swc-hpdi-formplugin", (Object[])new Object[]{orgName}));
            this.getView().updateView(orgFieldName);
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u201c{0}\u201d\uff0c\u5c06\u6e05\u9664\u5355\u636e\u4fe1\u606f\u3002\u786e\u8ba4\u5207\u6362\uff1f", (String)"SummaryVerifyBillReloadSubPage_0", (String)"swc-hpdi-formplugin", (Object[])new Object[]{orgName}), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(CALLBACK_ORG_CHANGED), null, orgFieldName + PayRollActGrpConstants.COLLA_RULE_ID_SEPERATOR + oldValueObject.getString("id"));
    }

    private void matchTaskRule(Long orgId) {
        this.getModel().setValue(PARAM_TASK_ARRANGE, (Object)this.getMatchRule(orgId));
    }

    private String getOrgName() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String trClass = dataEntity.getString(PARAM_TASK_ARRANGE_CLASS);
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        String orgName = ((IDataEntityProperty)properties.get((Object)PARAM_ORG)).getDisplayName().getLocaleValue();
        String mOrgName = ((IDataEntityProperty)properties.get((Object)PARAM_M_ORG)).getDisplayName().getLocaleValue();
        if (SWCStringUtils.isEmpty((String)trClass)) {
            return HPDICloudCollaHelper.getInstance().getCollaCtrFunctional() ? mOrgName : orgName;
        }
        return "hpdi_taskrule".equalsIgnoreCase(trClass) ? orgName : mOrgName;
    }

    private String getOrgName(String orgNumber) {
        if (SWCStringUtils.isEmpty((String)orgNumber)) {
            return this.getOrgName();
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        return ((IDataEntityProperty)properties.get((Object)orgNumber)).getDisplayName().getLocaleValue();
    }

    private DynamicObject getMatchRule(Long orgId) {
        LOGGER.info("[colla] getMatchRule orgId = {}", (Object)orgId);
        String msgSubNo = this.getModel().getDataEntity().getString("orgmsgrecvcenter.msgsubno");
        if (SWCStringUtils.isEmpty((String)msgSubNo) || orgId == null || orgId == 0L) {
            return null;
        }
        String taskArrangeClass = this.getModel().getDataEntity().getString(PARAM_TASK_ARRANGE_CLASS);
        DynamicObject dynamicObject = TaskCenterCreateAsyncHelper.getInstance().matchTaskRuleDyobj(msgSubNo, orgId, taskArrangeClass);
        LOGGER.info("[colla] getMatchRule dynamicObject = {}", (Object)dynamicObject);
        return dynamicObject;
    }

    private void onTaskRuleVPropertyChanged(Map<String, Object> reData) {
        Map ruleEngineData;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long taskRuleVId = dataEntity.getLong("taskarrangev.id");
        this.getModel().deleteEntryData("collaruleventry");
        if (taskRuleVId == 0L) {
            return;
        }
        String trClass = dataEntity.getString(PARAM_TASK_ARRANGE_CLASS);
        ImmutableMap param = ImmutableMap.of((Object)trClass, (Object)ImmutableSet.of((Object)taskRuleVId));
        Table trTable = HPDICloudCollaHelper.getInstance().queryMultiClassObject((Map)param, "id,collaruletype,collarule.id");
        if (trTable == null || CollectionUtils.isEmpty((Collection)trTable.values())) {
            return;
        }
        DynamicObject taskRuleV = trTable.values().stream().findFirst().orElse(null);
        if (taskRuleV == null) {
            return;
        }
        DynamicObjectCollection entry = taskRuleV.getDynamicObjectCollection("entryentity");
        ArrayList<String> comboIdList = new ArrayList<String>(10);
        for (DynamicObject dynamicObject : entry) {
            String crClass = dynamicObject.getString("collaruletype");
            long crId = dynamicObject.getLong("collarule.id");
            if (SWCStringUtils.isEmpty((String)crClass) || crId == 0L) continue;
            comboIdList.add(crClass + PayRollActGrpConstants.COLLA_RULE_ID_SEPERATOR + crId);
        }
        if (CollectionUtils.isEmpty(comboIdList)) {
            return;
        }
        List crObjectList = DataSyncMsgHelper.getInstance().queryCollaRuleData(comboIdList, "id, sourcevid");
        if (CollectionUtils.isEmpty((Collection)crObjectList)) {
            return;
        }
        Set<Object> rulePayRollActGIdSet = new HashSet(16);
        if (!CollectionUtils.isEmpty(reData) && !CollectionUtils.isEmpty((Map)(ruleEngineData = (Map)reData.get("ruleEngineData")))) {
            rulePayRollActGIdSet = ruleEngineData.entrySet().stream().map(item -> (String)item.getKey()).collect(Collectors.toSet());
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("collarulevclass", new Object[0]);
        setter.addField("collarulev", new Object[0]);
        for (DynamicObject object : crObjectList) {
            String tempCrType = object.getDataEntityType().getName();
            long sourceVid = object.getLong("sourcevid");
            long id = object.getLong("id");
            String tempKey = tempCrType + PayRollActGrpConstants.COLLA_RULE_ID_SEPERATOR + id;
            if (sourceVid == 0L || !rulePayRollActGIdSet.contains(tempKey)) continue;
            setter.addRow(new Object[]{tempCrType, sourceVid});
        }
        model.batchCreateNewEntryRow("collaruleventry", setter);
    }

    private void onTaskRulePropertyChanged(PropertyChangedArgs evt) {
        ChangeData changeSet = evt.getChangeSet()[0];
        DynamicObject newValueObject = (DynamicObject)changeSet.getNewValue();
        if (newValueObject == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"rootcontainer"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"rootcontainer"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        IDataEntityProperty property = event.getProperty();
        String name = property.getName();
    }

    private void beforeTaskRuleF7Select(BeforeF7SelectEvent event) {
        List customQFilters = event.getCustomQFilters();
        String msgSubNo = this.getModel().getDataEntity().getString("orgmsgrecvcenter.msgsubno");
        customQFilters.add(new QFilter("msgsubscriber.number", "=", (Object)msgSubNo).and(new QFilter("entryentity.ismanualverify", "=", (Object)"1")));
    }
}

