/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.verify;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPools;
import kd.swc.hpdi.business.msgreceive.CollaMsgVerifyBillHelper;
import kd.swc.hsbp.common.util.SWCMServiceUtils;

public class VerifyPersonInfoCardEdit
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(VerifyPersonInfoCardEdit.class);
    private static final ExecutorService VERIFY_PERSON_INFO_CARD_EDIT_POOL = ThreadPools.newExecutorService((String)"verifyPersonInfoCardEditPool", (int)2);
    private static final String PRAM_LABOR_REL_RECORD = "laborRelRecord";
    private static final String PARAM_PER_NON_TS_PROP = "perNonTsProp";
    private static final String PARAM_EMP_POS_ORG_REL = "empPosOrgRel";
    private static final String PARAM_EMP_JOB_REL = "empJobRel";
    private static final String PARAM_EMPLOYEE = "employee";
    private static final List<String> QUERY_PARAM = Arrays.asList("laborRelRecord", "perNonTsProp", "empPosOrgRel", "empJobRel", "employee");

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (CollectionUtils.isEmpty((Map)customParams)) {
            return;
        }
        RequestContext rc = RequestContext.get();
        ConcurrentHashMap<String, Map<String, Object>> personInfo = new ConcurrentHashMap<String, Map<String, Object>>(16);
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(10);
        for (String param : QUERY_PARAM) {
            futures.add(CompletableFuture.runAsync(() -> {
                RequestContext.copyAndSet((RequestContext)rc);
                Object[] inputParam = this.getInputParam(param, customParams);
                if (inputParam == null) {
                    return;
                }
                try {
                    Map<String, Object> currentVersion = this.getCurrentVersion((List)SWCMServiceUtils.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonSyncService", (String)"listInfo", (Object[])inputParam));
                    personInfo.put(param, currentVersion);
                }
                catch (Exception ex) {
                    LOGGER.info("[verify] request hrpi.IHRPIPersonSyncService.listInfo error, param = {}", (Object)inputParam, (Object)ex);
                }
            }, VERIFY_PERSON_INFO_CARD_EDIT_POOL));
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        futures.stream().map(CompletableFuture::join).collect(Collectors.toList());
        this.initShowData(personInfo);
    }

    private Object[] getInputParam(String param, Map<String, Object> customParams) {
        switch (param) {
            case "empJobRel": {
                return this.getEmpJobRelData(customParams);
            }
            case "employee": {
                return this.getEmployeeData(customParams);
            }
            case "perNonTsProp": {
                return this.getPersonNonTimeSeqData(customParams);
            }
            case "laborRelRecord": {
                return this.getLaborRelRecordData(customParams);
            }
            case "empPosOrgRel": {
                return this.getEmpPosOrgRelData(customParams);
            }
        }
        return null;
    }

    private Object[] getEmpJobRelData(Map<String, Object> customParams) {
        Long employeeId = this.parseToLong(customParams.get("employeeId"));
        if (employeeId == null || employeeId == 0L) {
            return null;
        }
        return new Object[]{"hrpi_empjobrel", null, null, employeeId};
    }

    private void initShowData(Map<String, Map<String, Object>> personInfo) {
        Map<String, Object> empJobRel;
        Map<String, Object> empPosOrgRel;
        Map<String, Object> perNonTsProp;
        IDataModel model = this.getModel();
        if (CollectionUtils.isEmpty(personInfo)) {
            return;
        }
        model.beginInit();
        Map<String, Object> employee = personInfo.get(PARAM_EMPLOYEE);
        Map<String, Object> laborRelRecord = personInfo.get(PRAM_LABOR_REL_RECORD);
        if (!CollectionUtils.isEmpty(laborRelRecord)) {
            model.setValue("lawentity", laborRelRecord.get("lawentity_id"));
        }
        if (!CollectionUtils.isEmpty(perNonTsProp = personInfo.get(PARAM_PER_NON_TS_PROP))) {
            model.setValue("nationality", perNonTsProp.get("nationality_id"));
        }
        if (!CollectionUtils.isEmpty(empPosOrgRel = personInfo.get(PARAM_EMP_POS_ORG_REL))) {
            model.setValue("job", empPosOrgRel.get("job_id"));
        }
        if (!CollectionUtils.isEmpty(empJobRel = personInfo.get(PARAM_EMP_JOB_REL))) {
            model.setValue("joblevel", empJobRel.get("joblevel_id"));
            model.setValue("jobgrade", empJobRel.get("jobgrade_id"));
        }
        if (!CollectionUtils.isEmpty(employee)) {
            model.setValue("enterprise", employee.get("enterprise_id"));
            this.getView().updateView("enterprise");
        }
        model.endInit();
    }

    private Object[] getEmpPosOrgRelData(Map<String, Object> customParams) {
        Long depEmpId = this.parseToLong(customParams.get("depEmpId"));
        if (depEmpId == null || depEmpId == 0L) {
            return null;
        }
        return new Object[]{"hrpi_empposorgrel", null, null, depEmpId};
    }

    private Map<String, Object> getCurrentVersion(List<Map<String, Object>> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return Collections.emptyMap();
        }
        for (Map<String, Object> objectMap : dataList) {
            Boolean isCurrentVersion = (Boolean)objectMap.get("iscurrentversion");
            if (!isCurrentVersion.booleanValue()) continue;
            return objectMap;
        }
        return dataList.get(0);
    }

    private Object[] getPersonNonTimeSeqData(Map<String, Object> customParams) {
        Long personId = this.parseToLong(customParams.get("personId"));
        if (personId == null || personId == 0L) {
            return null;
        }
        return new Object[]{"hrpi_pernontsprop", null, null, personId};
    }

    private Long parseToLong(Object data) {
        return CollaMsgVerifyBillHelper.getInstance().parseToLong(data);
    }

    private Object[] getLaborRelRecordData(Map<String, Object> customParams) {
        Long employeeId = this.parseToLong(customParams.get("employeeId"));
        if (employeeId == null || employeeId == 0L) {
            return null;
        }
        return new Object[]{"hrpi_laborrelrecord", null, null, employeeId};
    }

    private Object[] getEmployeeData(Map<String, Object> customParams) {
        Long employeeId = this.parseToLong(customParams.get("employeeVId"));
        if (employeeId == null || employeeId == 0L) {
            return null;
        }
        return new Object[]{"hrpi_employee", employeeId, null, null};
    }
}

