/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.basedata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.cloudcolla.HPDICloudCollaHelper;
import kd.swc.hpdi.common.entity.CoreHRMessageContentEntity;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCMServiceUtils;

public class BUValueHelper {
    private static final Log log = LogFactory.getLog(BUValueHelper.class);

    public static Map<String, Object> getBU(String msgSubNo, CoreHRMessageContentEntity msgEntity, Long businessField) {
        log.info("[colla],msgSubNo = {} ,msgEntity = {}", (Object)msgSubNo, (Object)msgEntity);
        List empPosInfos = (List)SWCMServiceUtils.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonSyncService", (String)"listInfo", (Object[])new Object[]{"hrpi_empposorgrel", 0L, 0L, msgEntity.getDepempId()});
        if (CollectionUtils.isEmpty((Collection)empPosInfos)) {
            return null;
        }
        Map empPosInfo = new HashMap();
        for (Map empPos : empPosInfos) {
            if (!((Boolean)empPos.get("iscurrentversion")).booleanValue()) continue;
            empPosInfo = empPos;
            break;
        }
        log.info("[colla],IHRPIDepempService.getEmpOrgrel = {}", empPosInfo);
        Long orgId = (Long)empPosInfo.get("adminorg_id");
        Long perGroupId = 0L;
        log.info("[colla],IHRCSStrategyService.getHrbuFromManageEmpStrategy pram= {},{},{},{}", new Object[]{orgId, msgEntity.getPersonId(), businessField, perGroupId});
        Map buMap = (Map)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSStrategyService", (String)"getHrbuFromManageEmpStrategy", (Object[])new Object[]{orgId, msgEntity.getPersonId(), businessField, perGroupId});
        log.info("[colla],IHRCSStrategyService.getHrbuFromManageEmpStrategy = {}", (Object)buMap);
        return buMap;
    }

    public static Map<String, Object> matchHrBu(String msgSubNo, CoreHRMessageContentEntity msgEntity) {
        log.info("[colla],msgSubNo = {} ,msgEntity = {}", (Object)msgSubNo, (Object)msgEntity);
        return HPDICloudCollaHelper.getInstance().getCollaCtrFunctional() ? BUValueHelper.matchCdmBu(msgSubNo, msgEntity) : BUValueHelper.matchPayRollBu(msgSubNo, msgEntity);
    }

    public static Map<String, Object> matchPayRollBu(String msgSubNo, CoreHRMessageContentEntity msgEntity) {
        log.info("[colla],matchPayRollBu msgSubNo = {} ,msgEntity = {}", (Object)msgSubNo, (Object)msgEntity);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put("employeeId", msgEntity.getEmployeeId());
        paramMap.put("depEmpId", msgEntity.getDepempId());
        paramMap.put("endDate", msgEntity.getEffectTime());
        ArrayList<HashMap<String, Object>> param = new ArrayList<HashMap<String, Object>>(1);
        param.add(paramMap);
        List result = (List)SWCMServiceUtils.invokeSWCService((String)"hsas", (String)"ISalaryFileService", (String)"matchSalaryFile", (Object[])new Object[]{param});
        DynamicObject queryResult = BUValueHelper.getQuerySalaryFileData(result, paramMap);
        if (queryResult == null) {
            return BUValueHelper.getBU(msgSubNo, msgEntity, 1020L);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        resultMap.put("hrbu", queryResult.get("org"));
        return resultMap;
    }

    public static Map<String, Object> matchCdmBu(String msgSubNo, CoreHRMessageContentEntity msgEntity) {
        log.info("[colla],matchPayRollBu msgSubNo = {} ,msgEntity = {}", (Object)msgSubNo, (Object)msgEntity);
        return BUValueHelper.getBU(msgSubNo, msgEntity, 1050L);
    }

    private static DynamicObject getQuerySalaryFileData(List<Map<String, Object>> result, Map<String, Object> paraMap) {
        if (CollectionUtils.isEmpty(result)) {
            return null;
        }
        Long employeeId = (Long)paraMap.get("employeeId");
        Long depEmpId = (Long)paraMap.get("depEmpId");
        if (employeeId == null || depEmpId == null) {
            return null;
        }
        Optional<Map> first = result.stream().filter(item -> employeeId.equals(item.get("employeeId")) && depEmpId.equals(item.get("depEmpId"))).findFirst();
        if (!first.isPresent()) {
            return null;
        }
        Map stringObjectMap = first.get();
        List datas = (List)stringObjectMap.get("matchSalaryFileVers");
        if (CollectionUtils.isEmpty((Collection)datas)) {
            return null;
        }
        Optional<DynamicObject> firstData = datas.stream().filter(item -> SWCHisBaseConstants.getValidStatus().contains(item.getString("datastatus"))).findFirst();
        if (first.isPresent()) {
            return firstData.get();
        }
        return null;
    }
}

