/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.basedata;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.msgreceive.HPDICollaMsgServiceHelper;
import kd.swc.hpdi.common.entity.ApiXmlData;
import kd.swc.hpdi.common.entity.ApiXmlParam;
import kd.swc.hpdi.common.entity.CoreHRMessageContentEntity;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class SubApiSettingHelper {
    private static final Log LOGGER = LogFactory.getLog(SubApiSettingHelper.class);
    public static final String ISV_KINGDEE = "kingdee";

    private SubApiSettingHelper() {
    }

    public static final SubApiSettingHelper getInstance() {
        return Load.subApiSettingHelper;
    }

    public List<Map<String, Object>> getAPIInfoByMsgSubNo(String msgSubNo) {
        return (List)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSMsgService", (String)"getAPIInfoByMsgSubNo", (Object[])new Object[]{msgSubNo});
    }

    public List<Map<String, Object>> getSubApiSettingApiInfos(String msgSubNo) {
        List<Map<String, Object>> apiInfoByMsgSubNo = this.getAPIInfoByMsgSubNo(msgSubNo);
        if (CollectionUtils.isEmpty(apiInfoByMsgSubNo)) {
            apiInfoByMsgSubNo = new ArrayList<Map<String, Object>>(10);
        }
        Set existNumber = apiInfoByMsgSubNo.stream().map(item -> Long.valueOf((String)item.get("id"))).collect(Collectors.toSet());
        SWCDataServiceHelper subApiSetOrm = new SWCDataServiceHelper("hpdi_subapiset");
        QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusQFilter = new QFilter("status", "=", (Object)"C");
        QFilter msgSubNoQFilter = new QFilter("msgsubscriber.number", "=", (Object)msgSubNo);
        DynamicObject subApiSetData = subApiSetOrm.queryOne("id,number,apideploy,apideploy.bizapp,apideploy.bizcloud", new QFilter[]{enableQFilter, statusQFilter, msgSubNoQFilter});
        DynamicObjectCollection dynamicObjectCollection = subApiSetData.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return apiInfoByMsgSubNo;
        }
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            Map<String, Object> apiInfo;
            long deployId = dynamicObject.getLong("apideploy.id");
            if (existNumber.contains(deployId) || CollectionUtils.isEmpty(apiInfo = this.getApiInfoByApiId(deployId, dynamicObject))) continue;
            apiInfoByMsgSubNo.add(apiInfo);
        }
        return apiInfoByMsgSubNo;
    }

    public ApiXmlData parse(String xmlData) {
        Document document;
        try (ByteArrayInputStream is = new ByteArrayInputStream(xmlData.getBytes("utf-8"));){
            SAXReader reader = new SAXReader();
            reader.setEncoding("utf-8");
            document = reader.read((InputStream)is);
        }
        catch (Exception e) {
            LOGGER.error("xml error -> {}", (Object)xmlData);
            throw new KDException((Throwable)e, BosErrorCode.openFileFailed, new Object[]{ResManager.loadKDString((String)"{0} XML\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef,{1}\u3002", (String)"SubApiSettingHelper_0", (String)"swc-hpdi-business", (Object[])new Object[]{e.getMessage()}), xmlData});
        }
        Element rootElement = document.getRootElement();
        ApiXmlData apiXmlData = this.parseApiMainData(rootElement);
        apiXmlData.setOutputParams(SubApiSettingHelper.parseOutputParams(rootElement, apiXmlData));
        apiXmlData.setInputParams(this.parseInputParams(rootElement, apiXmlData));
        return apiXmlData;
    }

    private ApiXmlData getApiXMLDescByApiId(Long apiId) {
        String apiData = (String)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSMsgService", (String)"getXMLDescById", (Object[])new Object[]{apiId});
        if (SWCStringUtils.isEmpty((String)apiData)) {
            return null;
        }
        return this.parse(apiData);
    }

    private Map<String, Object> getApiInfoByApiId(Long apiId, DynamicObject entry) {
        ApiXmlData data = this.getApiXMLDescByApiId(apiId);
        if (data == null || apiId == 0L) {
            return null;
        }
        String bizCloud = entry.getString("apideploy.bizcloud.number");
        String bizApp = entry.getString("apideploy.bizapp.number");
        HashMap<String, Object> result = new HashMap<String, Object>(13);
        result.put("apitype", data.getApiType());
        result.put("bizapp", bizApp);
        result.put("bizcloud", bizCloud);
        result.put("id", data.getId());
        result.put("inputparam", data.getInputParamStr());
        result.put("params", data.getParams());
        result.put("method", data.getMethod());
        result.put("name", data.getName());
        result.put("number", data.getNumber());
        result.put("isvid", data.getIsvId());
        result.put("outputparam", data.getOutputParamStr());
        result.put("service", data.getService());
        return result;
    }

    private List<ApiXmlParam> parseInputParams(Element rootElement, ApiXmlData apiXmlData) {
        apiXmlData.setInputParamStr(rootElement.elementText("InputParam"));
        apiXmlData.setParams(rootElement.elementText("Param"));
        return new ArrayList<ApiXmlParam>();
    }

    private ApiXmlData parseApiMainData(Element rootElement) {
        ApiXmlData apiXmlData = new ApiXmlData();
        apiXmlData.setApiType(rootElement.elementText("ApiType"));
        apiXmlData.setBizCloudId(rootElement.elementText("BizCloudId"));
        apiXmlData.setBizAppId(rootElement.elementText("BizAppId"));
        String id = rootElement.elementText("Id");
        if (!SWCStringUtils.isEmpty((String)id)) {
            apiXmlData.setId(Long.valueOf(id));
        }
        apiXmlData.setNumber(rootElement.elementText("Number"));
        apiXmlData.setKey(rootElement.elementText("Key"));
        apiXmlData.setName(rootElement.elementText("Name"));
        apiXmlData.setDescription(rootElement.elementText("Description"));
        apiXmlData.setService(rootElement.elementText("Service"));
        apiXmlData.setMethod(rootElement.elementText("Method"));
        apiXmlData.setIsvId(this.getIsvId(rootElement));
        return apiXmlData;
    }

    private String getIsvId(Element rootElement) {
        String isvId = rootElement.elementText("IsvId");
        if (SWCStringUtils.isEmpty((String)isvId)) {
            return ISV_KINGDEE;
        }
        return isvId;
    }

    private static List<ApiXmlParam> parseOutputParams(Element rootElement, ApiXmlData apiXmlData) {
        List apiEntityElement = Optional.ofNullable(rootElement.element("APIDataXml")).map(item -> item.elements("APIEntity")).orElseGet(Collections::emptyList);
        ArrayList<ApiXmlParam> resultList = new ArrayList<ApiXmlParam>();
        apiXmlData.setOutputParamStr(rootElement.elementText("OutputParam"));
        if (CollectionUtils.isEmpty((Collection)apiEntityElement)) {
            return resultList;
        }
        for (Element entity : apiEntityElement) {
            List<ApiXmlParam> params = SubApiSettingHelper.getDataEntityList(rootElement, entity);
            resultList.addAll(params);
        }
        return resultList;
    }

    private static List<ApiXmlParam> getDataEntityList(Element rootElement, Element entityElement) {
        List elements = entityElement.element("APIFields").elements("APIField");
        ArrayList result = Lists.newArrayListWithExpectedSize((int)elements.size());
        String apiName = rootElement.elementText("Name");
        String apiId = rootElement.elementText("Id");
        String apiNumber = rootElement.elementText("Number");
        String apiType = rootElement.elementText("ApiType");
        for (Object data : elements) {
            Element element = (Element)data;
            ApiXmlParam param = new ApiXmlParam();
            if ("2".equals(apiType)) {
                param.setEntityName(apiName);
                param.setEntityNumber(apiId);
            } else {
                param.setEntityName(entityElement.elementText("Description"));
                param.setEntityNumber(entityElement.elementText("Entity"));
            }
            param.setEntityType(apiType);
            param.setKey(element.elementText("Key"));
            param.setName(element.elementText("Name"));
            param.setType(element.elementText("Type"));
            param.setEnable(element.elementText("Enable"));
            param.setQueryField(element.elementText("QueryField"));
            param.setQueryFieldName(element.elementText("QueryFieldName"));
            param.setQueryFieldRelEntity(element.elementText("QueryFieldRelEntity"));
            param.setBaseEntityName(element.elementText("BaseEntityName"));
            result.add(param);
        }
        return result;
    }

    public Map<String, Object> getParamMapByMsgSubNo(String msgSubNo) {
        SWCDataServiceHelper subApiSetOrm = new SWCDataServiceHelper("hpdi_subapiset");
        QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusQfilter = new QFilter("status", "=", (Object)"C");
        QFilter msgSubNoQfilter = new QFilter("msgsubscriber.number", "=", (Object)msgSubNo);
        DynamicObject[] dynamicObjects = subApiSetOrm.query("id,number,msgsubscriber,msgsubscriber.name,apideploy,targetobject,isconvertobject,apifieldkey,entityname,apifieldname,apifieldtype,mapfieldkey,mapbasedata,fieldkey,fieldname,fieldtype,fieldsource", new QFilter[]{enableQFilter, statusQfilter, msgSubNoQfilter});
        if (dynamicObjects != null && dynamicObjects.length > 1) {
            DynamicObject temp = dynamicObjects[0];
            String msgSubName = temp.getString("msgsubscriber.name");
            throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u8ba2\u9605\u4e1a\u52a1\u4e8b\u4ef6\u201c{0}\u201d\u5b58\u5728\u591a\u4e2a\u53ef\u7528\u7684\u534f\u4f5cAPI\u53c2\u6570\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"SubApiSettingHelper_1", (String)"swc-hpdi-business", (Object[])new Object[]{msgSubName}));
        }
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u8ba2\u9605\u4e1a\u52a1\u4e8b\u4ef6\u201c{0}\u201d\u6ca1\u6709\u5339\u914d\u5230\u53ef\u7528\u7684\u534f\u4f5cAPI\u53c2\u6570\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"SubApiSettingHelper_2", (String)"swc-hpdi-business", (Object[])new Object[]{msgSubNo}));
        }
        DynamicObject dynamicObject = dynamicObjects[0];
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
        if (entryEntity == null || entryEntity.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>(entryEntity.size());
        result.put("msgSubNo", msgSubNo);
        HashMap<String, Map<String, Object>> apiDataMap = new HashMap<String, Map<String, Object>>(entryEntity.size());
        result.put("apiData", apiDataMap);
        HashMap<Long, String> apiIdNumberMap = new HashMap<Long, String>(entryEntity.size());
        result.put("apiIdNumberMap", apiIdNumberMap);
        for (DynamicObject entry : entryEntity) {
            DynamicObjectCollection inputSubEntryEntity = entry.getDynamicObjectCollection("inputsubentryentity");
            if (inputSubEntryEntity == null || inputSubEntryEntity.isEmpty()) continue;
            String apiNumber = entry.getString("apideploy.number");
            Long apiId = entry.getLong("apideploy.id");
            apiDataMap.put(apiNumber, this.getApiParamMap(entry));
            apiIdNumberMap.put(apiId, apiNumber);
        }
        return result;
    }

    private Map<String, Object> getApiParamMap(DynamicObject entryentity) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        DynamicObjectCollection inputSubEntryentity = entryentity.getDynamicObjectCollection("inputsubentryentity");
        DynamicObjectCollection outputSubEntryentity = entryentity.getDynamicObjectCollection("outputsubentryentity");
        result.put("inputParam", this.getInputParams(inputSubEntryentity));
        result.put("outputParam", this.getOutputParams(outputSubEntryentity));
        result.put("apiDeployId", entryentity.get("apideploy.id"));
        boolean isConvertObject = entryentity.getBoolean("isconvertobject");
        result.put("isConvertObject", isConvertObject);
        if (isConvertObject) {
            result.put("targetObject", entryentity.getString("targetobject.number"));
        }
        return result;
    }

    private Map<String, Object> getOutputParams(DynamicObjectCollection outputSubEntryentity) {
        if (outputSubEntryentity == null || outputSubEntryentity.isEmpty()) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(outputSubEntryentity.size());
        for (DynamicObject output : outputSubEntryentity) {
            HashMap<String, String> rowData = new HashMap<String, String>(6);
            String apiFieldKey = output.getString("apifieldkey");
            rowData.put("apiFieldKey", apiFieldKey);
            rowData.put("entityName", output.getString("entityname"));
            rowData.put("apiFieldName", output.getString("apifieldname"));
            rowData.put("apiFieldType", output.getString("apifieldtype"));
            rowData.put("mapFieldKey", output.getString("mapfieldkey"));
            rowData.put("mapBasedata", output.getString("mapbasedata.number"));
            result.put(apiFieldKey, rowData);
        }
        return result;
    }

    private Map<String, Object> getInputParams(DynamicObjectCollection inputSubEntryentity) {
        if (inputSubEntryentity == null || inputSubEntryentity.isEmpty()) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(inputSubEntryentity.size());
        for (DynamicObject output : inputSubEntryentity) {
            HashMap<String, String> rowData = new HashMap<String, String>(4);
            String fieldKey = output.getString("fieldkey");
            rowData.put("fieldKey", fieldKey);
            rowData.put("fieldName", output.getString("fieldname"));
            rowData.put("fieldType", output.getString("fieldtype"));
            rowData.put("fieldSource", output.getString("fieldsource"));
            result.put(fieldKey, rowData);
        }
        return result;
    }

    public Map<String, Object> executeSubApiSet(Map<String, Object> param) {
        if (CollectionUtils.isEmpty(param)) {
            return this.error("executeSubApiSet:the input map parameter can not be null.");
        }
        String msgSubNo = (String)param.get("msgSubNo");
        Map entityData = (Map)param.get("entityData");
        if (SWCStringUtils.isEmpty((String)msgSubNo) || CollectionUtils.isEmpty((Map)entityData)) {
            return this.error("executeSubApiSet:the input map parameter must contain 'msgSubNo' and 'entityData'.");
        }
        CoreHRMessageContentEntity msgEntity = this.getMsgEntity(entityData);
        if (msgEntity == null) {
            this.error("executeSubApiSet:the input map parameter must contain 'msgSubNo' and 'entityData'.");
        }
        Map<String, Object> paramMapByMsgSubNo = SubApiSettingHelper.getInstance().getParamMapByMsgSubNo(msgSubNo);
        HPDICollaMsgServiceHelper collaHelper = HPDICollaMsgServiceHelper.getInstance();
        Map<String, List<Map<String, Object>>> apiResultData = collaHelper.getSubMsgApiData(msgSubNo, msgEntity, paramMapByMsgSubNo);
        Map<String, Object> convertedApiResultData = collaHelper.convertResultData(apiResultData, paramMapByMsgSubNo);
        HashMap<String, Map<String, Object>> data = new HashMap<String, Map<String, Object>>(16);
        data.put("apiResult", apiResultData);
        data.put("convertedApiResult", convertedApiResultData);
        return this.success(data);
    }

    private CoreHRMessageContentEntity getMsgEntity(Map<String, Object> param) {
        if (CollectionUtils.isEmpty(param)) {
            return null;
        }
        CoreHRMessageContentEntity entity = new CoreHRMessageContentEntity();
        entity.setPersonId((Long)param.get("personId"));
        entity.setEmployeeId((Long)param.get("employeeId"));
        entity.setComempId((Long)param.get("comempId"));
        entity.setDepempId((Long)param.get("depempId"));
        entity.setBillId((Long)param.get("billId"));
        entity.setBillNo((String)param.get("billNo"));
        entity.setEffectTime((Date)param.get("effectTime"));
        if (this.isAnyNull(entity.getPersonId(), entity.getEmployeeId(), entity.getComempId(), entity.getDepempId())) {
            return null;
        }
        return entity;
    }

    private boolean isAnyNull(Long ... args) {
        if (args == null || args.length == 0) {
            return true;
        }
        for (Long arg : args) {
            if (arg != null && arg != 0L) continue;
            return true;
        }
        return false;
    }

    private Map<String, Object> success(Object data) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("success", Boolean.TRUE);
        result.put("data", data);
        return result;
    }

    private Map<String, Object> error(String errorMsg) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("success", Boolean.FALSE);
        result.put("msg", errorMsg);
        return result;
    }

    private static final class Load {
        private static SubApiSettingHelper subApiSettingHelper = new SubApiSettingHelper();

        private Load() {
        }
    }
}

