/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.basedata;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.ext.hr.ruleengine.enums.RuleOperatorEnum;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.util.OrgServiceUtil;
import kd.swc.hpdi.business.cloudcolla.HPDICloudCollaHelper;
import kd.swc.hpdi.business.msgreceive.DataSyncMsgHelper;
import kd.swc.hpdi.common.constants.PayRollActGrpConstants;
import kd.swc.hpdi.common.entity.HRPolicyEntity;
import kd.swc.hpdi.common.entity.HrRuleDesignEntity;
import kd.swc.hpdi.common.entity.HrUsableRangeEntity;
import kd.swc.hpdi.common.entity.ResponseDTO;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class TaskRuleHelper {
    public static final Long PAYROLL_MANAGE_BIZ_TYPE = 107010L;
    public static final String PAYROLL_BASEDATA_TYPE = "hpdi_collarulesal";
    public static final Long SALARY_MANAGE_BIZ_TYPE = 107020L;
    public static final String SALARY_BASEDATA_TYPE = "hpdi_collarulecdm";
    public static final Long TAX_MANAGE_BIZ_TYPE = 107030L;
    public static final String TAX_BASEDATA_TYPE = "hpdi_collaruletax";
    public static final Long SOCIAL_MANAGE_BIZ_TYPE = 107050L;
    public static final String SOCIAL_BASEDATA_TYPE = "hpdi_collarulecsi";
    private static final Log LOGGER = LogFactory.getLog(TaskRuleHelper.class);
    private static final String POLICY_FIELDS = "id,number,bizappid,createbu,description,enable,name,policymode,retrundefault,results,scene,entryrulelist.id,entryrulelist.filtercondition,entryrulelist.filterresult,entryrulelist.ruledescription,entryrulelist.ruleenable,entryrulelist.rulename,entryrulelist.rulenumber,entryrulelist.ruleorder,entrybulist.id,entrybulist.entitybu,entrybulist.containssub";

    private TaskRuleHelper() {
    }

    public static final TaskRuleHelper getInstance() {
        return Load.taskRuleHelper;
    }

    public static boolean isRuleExist(long createOrg, long msgsubscriberId, long selfId, String entityNumber) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityNumber);
        QFilter filter1 = new QFilter("msgsubscriber", "=", (Object)msgsubscriberId);
        QFilter filter2 = new QFilter("enable", "=", (Object)"1");
        QFilter filter3 = new QFilter("createorg", "=", (Object)createOrg);
        QFilter filter4 = new QFilter("id", "!=", (Object)selfId);
        QFilter filter5 = new QFilter("status", "=", (Object)"C");
        QFilter hisCurrFilter = BaseDataHisHelper.getHisCurrFilter();
        return helper.isExists(new QFilter[]{filter1, filter2, filter3, hisCurrFilter, filter4, filter5});
    }

    public static DynamicObject getTaskRuleById(Object ruleId, String entityNumber) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityNumber);
        return helper.queryOne("createorg,createorg.name,name,status,enable,msgsubscriber.id,msgsubscriber.number,msgsubscriber.name,entryentity.collarule", new QFilter[]{new QFilter("id", "=", ruleId)});
    }

    public static DynamicObject[] getTaskRuleByIds(List<Object> ruleIds, String entityNumber) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityNumber);
        return helper.query("createorg,createorg.name,name,status,enable,msgsubscriber.id,msgsubscriber.number,msgsubscriber.name,entryentity.collarule", new QFilter[]{new QFilter("id", "in", ruleIds)});
    }

    public static DynamicObject getAnotherData(SWCDataServiceHelper helper, DynamicObject dynamicObject, String enableStatus) {
        QFilter filter1 = new QFilter("id", "!=", (Object)dynamicObject.getLong("id"));
        QFilter filter2 = new QFilter("createorg", "=", dynamicObject.get("createorg.masterid"));
        QFilter filter3 = new QFilter("msgsubscriber.id", "=", dynamicObject.get("msgsubscriber.id"));
        QFilter filter4 = new QFilter("enable", "=", (Object)enableStatus);
        QFilter filter5 = new QFilter("status", "=", (Object)"C");
        QFilter hisCurrFilter = BaseDataHisHelper.getHisCurrFilter();
        DynamicObject anotherObject = helper.queryOne("name,enable,msgsubscriber.number,modifier,modifytime,disabler,disabledate,entryentity.collarule.id", new QFilter[]{filter1, filter2, filter3, filter4, filter5, hisCurrFilter});
        return anotherObject;
    }

    public static Map<Long, String> getCollaRuleAppMap(Set<String> collaRuleComboIdSet) {
        List<DynamicObject> payRollActGroupData = DataSyncMsgHelper.getInstance().queryCollaRuleData(new ArrayList<String>(collaRuleComboIdSet));
        if (CollectionUtils.isEmpty(payRollActGroupData)) {
            return Collections.emptyMap();
        }
        return payRollActGroupData.stream().collect(Collectors.toMap(item -> item.getLong("id"), item -> item.getString("payrollactgtpl.bizapp.id")));
    }

    private static Long getHrRootId(Long defaultOrgId) {
        return OrgServiceUtil.getHRRootOrgId();
    }

    public static HRPolicyEntity getExePreRulePolicy(DynamicObject object) {
        String policyName;
        DynamicObjectCollection entryEntity = object.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return null;
        }
        List<HrRuleDesignEntity> entryRuleList = TaskRuleHelper.getEntryRuleList(entryEntity);
        if (CollectionUtils.isEmpty(entryRuleList)) {
            return null;
        }
        HRPolicyEntity verifyRangePolicy = new HRPolicyEntity();
        String subName = policyName.substring(0, (policyName = object.getString("name")).length() > 20 ? 19 : policyName.length());
        verifyRangePolicy.setBizAppId(object.getString("scene.bizappid.id"));
        verifyRangePolicy.setScene(Long.valueOf(object.getLong("scene.id")));
        verifyRangePolicy.setCreateBu(TaskRuleHelper.getHrRootId(object.getLong("createorg.id")));
        verifyRangePolicy.setPolicyMode("FullMatch");
        verifyRangePolicy.setEnable(TaskRuleHelper.getCurrentEnable(object));
        Long policyId = object.getLong("policy.id");
        if (null != policyId && policyId > 0L) {
            verifyRangePolicy.setId(policyId);
            verifyRangePolicy.setNumber(object.getString("policy.number"));
        } else {
            verifyRangePolicy.setNumber(object.getString("policynumber"));
        }
        verifyRangePolicy.setName(ResManager.loadKDString((String)"{0}-\u4eba\u5458\u8303\u56f4-{1}", (String)"TaskRuleHelper_2", (String)"swc-hsas-business", (Object[])new Object[]{subName, verifyRangePolicy.getNumber().substring(5)}));
        List<HrUsableRangeEntity> defaultEntryBuList = TaskRuleHelper.getDefaultEntryBuList(object);
        verifyRangePolicy.setEntryRuleList(entryRuleList);
        verifyRangePolicy.setEntryBuList(defaultEntryBuList);
        return verifyRangePolicy;
    }

    public static Boolean getCurrentEnable(DynamicObject object) {
        return "C".equalsIgnoreCase(object.getString("status"));
    }

    public static String toJsonString(Object object) {
        try {
            return SWCJSONUtils.toString((Object)object);
        }
        catch (IOException e) {
            LOGGER.info("parse json error, data = {}", object);
            return "";
        }
    }

    private static List<HrRuleDesignEntity> getEntryRuleList(DynamicObjectCollection entryEntity) {
        ArrayList<HrRuleDesignEntity> entryRuleList = new ArrayList<HrRuleDesignEntity>(10);
        int index = 0;
        for (DynamicObject dynamicObject : entryEntity) {
            HrRuleDesignEntity rule;
            String ruleJson = dynamicObject.getString("rulejson");
            if (SWCStringUtils.isEmpty((String)ruleJson) || null == (rule = TaskRuleHelper.cast(ruleJson, HrRuleDesignEntity.class))) continue;
            String ruleNumber = dynamicObject.getString("rulenumber");
            rule.setRuleEnable(Boolean.TRUE);
            rule.setRuleOrder(Integer.valueOf(index++));
            rule.setModifyStatus("new");
            rule.setRuleNumber(ruleNumber);
            entryRuleList.add(rule);
        }
        return entryRuleList;
    }

    private static <T> T cast(String ruleJson, Class<T> clazz) {
        try {
            return (T)SWCJSONUtils.cast((String)ruleJson, clazz);
        }
        catch (IOException e) {
            LOGGER.info("cast json string to object erro. clazz = {},ruleJson = {}", clazz, (Object)ruleJson);
            return null;
        }
    }

    public static List<HrUsableRangeEntity> getDefaultEntryBuList(DynamicObject object) {
        ArrayList<HrUsableRangeEntity> entryBuList = new ArrayList<HrUsableRangeEntity>(10);
        HrUsableRangeEntity hrUsableRangeDTO = new HrUsableRangeEntity();
        hrUsableRangeDTO.setEntityBu(Long.valueOf(object.getLong("createorg.id")));
        hrUsableRangeDTO.setIsContainsSub(Boolean.TRUE);
        entryBuList.add(hrUsableRangeDTO);
        return entryBuList;
    }

    public static ResponseDTO<Map<String, Long>> batchInsertOrUpdateHrPolicy(List<HRPolicyEntity> policyList) {
        HashMap<String, Long> numberIdMap = new HashMap<String, Long>(16);
        if (CollectionUtils.isEmpty(policyList)) {
            return new ResponseDTO("200", numberIdMap, null);
        }
        ArrayList<HRPolicyEntity> insertList = new ArrayList<HRPolicyEntity>();
        ArrayList<HRPolicyEntity> updateList = new ArrayList<HRPolicyEntity>();
        List numbers = policyList.stream().map(HRPolicyEntity::getNumber).collect(Collectors.toList());
        SWCDataServiceHelper policyOrm = new SWCDataServiceHelper("brm_policy_edit");
        DynamicObject[] query = policyOrm.query("id,number", new QFilter[]{new QFilter("number", "in", numbers)});
        HashMap<String, Long> queryNumberIdMap = new HashMap<String, Long>(16);
        if (null != query && query.length > 0) {
            for (DynamicObject dynamicObject : query) {
                queryNumberIdMap.put(dynamicObject.getString("number"), dynamicObject.getLong("id"));
            }
        }
        for (HRPolicyEntity policy : policyList) {
            if (queryNumberIdMap.containsKey(policy.getNumber())) {
                policy.setId((Long)queryNumberIdMap.get(policy.getNumber()));
                updateList.add(policy);
                continue;
            }
            insertList.add(policy);
        }
        try {
            if (TaskRuleHelper.saveInsertList(numberIdMap, insertList).booleanValue() && TaskRuleHelper.saveUpdateList(numberIdMap, updateList).booleanValue()) {
                BusinessDataServiceHelper.removeCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"brm_ruledesign"));
                return new ResponseDTO("200", numberIdMap, null);
            }
        }
        catch (Exception e) {
            LOGGER.error("parse data error.", (Throwable)e);
            return new ResponseDTO("500", null, e.getMessage());
        }
        return new ResponseDTO("500", null, null);
    }

    private static Boolean saveUpdateList(Map<String, Long> numberIdMap, List<HRPolicyEntity> updateList) throws Exception {
        if (CollectionUtils.isEmpty(updateList)) {
            return Boolean.TRUE;
        }
        SWCDataServiceHelper policyOrm = new SWCDataServiceHelper("brm_policy_edit");
        List ids = updateList.stream().map(HRPolicyEntity::getId).collect(Collectors.toList());
        DynamicObject[] query = policyOrm.query("id,name,number,entryrulelist,entryrulelist.id,entryrulelist.rulenumber,entrybulist,entrybulist.id", new QFilter[]{new QFilter("id", "in", ids)});
        if (query != null && query.length > 0) {
            TaskRuleHelper.dispatcherUpdatePolicy(updateList, query);
            List<Map<String, Object>> updateMap = TaskRuleHelper.convertObjectToMap(updateList);
            LOGGER.info("\u5f00\u59cb\u8c03\u7528\u4e2d\u53f0\u5fae\u670d\u52a1IBRMPolicyService.batchModifyPolicy\u4fee\u6539\u6570\u636e,updateMap = {}", (Object)SWCJSONUtils.toString(updateMap));
            Map requestResult = (Map)SWCMServiceUtils.invokeHRMPService((String)"brm", (String)"IBRMPolicyService", (String)"batchModifyPolicy", (Object[])new Object[]{updateMap});
            if ("200".equals(String.valueOf(requestResult.get("resultCode")))) {
                if (null != numberIdMap) {
                    numberIdMap.putAll(TaskRuleHelper.getSuccessNumberIdMap(requestResult));
                }
                return Boolean.TRUE;
            }
            throw new Exception(requestResult.get("errorMsg").toString());
        }
        return Boolean.FALSE;
    }

    private static void dispatcherUpdatePolicy(List<HRPolicyEntity> updateList, DynamicObject[] query) {
        HashMap<Long, Map<String, Long>> ruleMap = new HashMap<Long, Map<String, Long>>(16);
        HashMap<Long, List<Long>> buIdMap = new HashMap<Long, List<Long>>(16);
        for (DynamicObject dy : query) {
            DynamicObjectCollection entryBuList;
            DynamicObjectCollection entryRuleList = dy.getDynamicObjectCollection("entryrulelist");
            if (!CollectionUtils.isEmpty((Collection)entryRuleList)) {
                HashMap<String, Long> tempMap = new HashMap<String, Long>(16);
                for (DynamicObject dynamicObject : entryRuleList) {
                    tempMap.put(dynamicObject.getString("rulenumber"), dynamicObject.getLong("id"));
                }
                ruleMap.put(dy.getLong("id"), tempMap);
            }
            if (CollectionUtils.isEmpty((Collection)(entryBuList = dy.getDynamicObjectCollection("entrybulist")))) continue;
            ArrayList<Long> buIdList = new ArrayList<Long>();
            for (DynamicObject dynamicObject : entryBuList) {
                buIdList.add(dynamicObject.getLong("id"));
            }
            buIdMap.put(dy.getLong("id"), buIdList);
        }
        for (HRPolicyEntity policy : updateList) {
            TaskRuleHelper.processRuleData(ruleMap, policy);
            TaskRuleHelper.processBuData(buIdMap, policy);
        }
    }

    private static void processBuData(Map<Long, List<Long>> buIdMap, HRPolicyEntity policy) {
        List<Long> buIds = buIdMap.get(policy.getId());
        List entryBuList = policy.getEntryBuList();
        if (CollectionUtils.isEmpty(buIds)) {
            for (HrUsableRangeEntity bu : entryBuList) {
                bu.setModifyStatus("new");
            }
            return;
        }
        ArrayList<Long> existBuIds = new ArrayList<Long>(10);
        Iterator<Object> iterator = entryBuList.iterator();
        while (iterator.hasNext()) {
            HrUsableRangeEntity bu;
            bu.setModifyStatus(buIds.contains((bu = (HrUsableRangeEntity)iterator.next()).getId()) ? "modify" : "new");
            existBuIds.add(bu.getId());
        }
        for (Long id : buIds) {
            if (existBuIds.contains(id)) continue;
            HrUsableRangeEntity tempRule = new HrUsableRangeEntity();
            tempRule.setId(id);
            tempRule.setModifyStatus("delete");
            entryBuList.add(tempRule);
        }
    }

    private static void processRuleData(Map<Long, Map<String, Long>> ruleIdMap, HRPolicyEntity policy) {
        List entryRuleList = policy.getEntryRuleList();
        if (CollectionUtils.isEmpty((Collection)entryRuleList)) {
            return;
        }
        Map<String, Long> ruleIds = ruleIdMap.get(policy.getId());
        if (CollectionUtils.isEmpty(ruleIds)) {
            for (HrRuleDesignEntity ruleDTO : entryRuleList) {
                ruleDTO.setModifyStatus("new");
            }
            return;
        }
        ArrayList<String> existRuleIds = new ArrayList<String>(10);
        for (HrRuleDesignEntity ruleDTO : entryRuleList) {
            String ruleNumber = ruleDTO.getRuleNumber();
            Long ruleId = ruleIds.get(ruleNumber);
            if (ruleId != null) {
                ruleDTO.setModifyStatus("modify");
                ruleDTO.setId(ruleId);
            } else {
                ruleDTO.setModifyStatus("new");
            }
            existRuleIds.add(ruleNumber);
        }
        Set<Map.Entry<String, Long>> entrySet = ruleIds.entrySet();
        for (Map.Entry<String, Long> entry : entrySet) {
            if (existRuleIds.contains(entry.getKey())) continue;
            HrRuleDesignEntity tempRule = new HrRuleDesignEntity();
            tempRule.setId(entry.getValue());
            tempRule.setModifyStatus("delete");
            entryRuleList.add(tempRule);
        }
    }

    private static Boolean saveInsertList(Map<String, Long> numberIdMap, List<HRPolicyEntity> insertList) throws Exception {
        if (CollectionUtils.isEmpty(insertList)) {
            return Boolean.TRUE;
        }
        List<Map<String, Object>> insertMap = TaskRuleHelper.convertObjectToMap(insertList);
        LOGGER.info("\u5f00\u59cb\u8c03\u7528\u4e2d\u53f0\u5fae\u670d\u52a1IBRMPolicyService.batchAddPolicy\u65b0\u589e\u6570\u636e,insertMap = {}", (Object)SWCJSONUtils.toString(insertMap));
        Map requestResult = (Map)SWCMServiceUtils.invokeHRMPService((String)"brm", (String)"IBRMPolicyService", (String)"batchAddPolicy", (Object[])new Object[]{insertMap});
        if ("200".equals(String.valueOf(requestResult.get("resultCode")))) {
            if (null != numberIdMap) {
                numberIdMap.putAll(TaskRuleHelper.getSuccessNumberIdMap(requestResult));
            }
            return Boolean.TRUE;
        }
        throw new Exception(requestResult.get("errorMsg").toString());
    }

    private static List<Map<String, Object>> convertObjectToMap(List<HRPolicyEntity> policyList) throws IOException {
        String updateStr = SWCJSONUtils.toString(policyList);
        List result = (List)SWCJSONUtils.cast((String)updateStr, List.class, (Class[])new Class[]{Map.class});
        for (Map map : result) {
            TaskRuleHelper.convertParamType(map, "id");
            TaskRuleHelper.convertParamType(map, "createbu");
            List ruleList = (List)map.get("entryrulelist");
            for (Map rule : ruleList) {
                TaskRuleHelper.convertParamType(rule, "id");
            }
            List buList = (List)map.get("entrybulist");
            for (Map bu : buList) {
                TaskRuleHelper.convertParamType(bu, "id");
                TaskRuleHelper.convertParamType(bu, "entitybu");
            }
        }
        return result;
    }

    private static void convertParamType(Map<String, Object> map, String paramName) {
        Object buId = map.get(paramName);
        if (null == buId) {
            return;
        }
        map.put(paramName, TaskRuleHelper.getLongValue(buId));
    }

    private static Long getLongValue(Object obj) {
        if (obj instanceof Integer) {
            if ((Integer)obj == 0) {
                return null;
            }
            return ((Integer)obj).longValue();
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        return null;
    }

    private static Map<String, Long> getSuccessNumberIdMap(Map<String, Object> requestResult) {
        HashMap<String, Long> map = new HashMap<String, Long>(16);
        List jsonArray = (List)requestResult.get("policyResults");
        for (Map object : jsonArray) {
            String number = (String)object.get("policyNumber");
            Long id = (Long)object.get("policyId");
            map.put(number, id);
        }
        return map;
    }

    public static String getResultData() {
        HashMap result = new HashMap(1);
        HashMap<String, Object> cell = new HashMap<String, Object>(16);
        cell.put("paramType", "string");
        cell.put("displayValue", "success");
        cell.put("param", "result_str");
        cell.put("displayParam", ResManager.loadKDString((String)"\u7ed3\u679c\u503c(\u5b57\u7b26\u4e32)", (String)"TaskRuleHelper_0", (String)"swc-hpdi-business", (Object[])new Object[0]));
        cell.put("operators", "==");
        cell.put("index", 0);
        cell.put("value", "success");
        ArrayList<HashMap<String, Object>> cellList = new ArrayList<HashMap<String, Object>>();
        cellList.add(cell);
        result.put("resultList", cellList);
        return TaskRuleHelper.toJsonString(result);
    }

    public static Map<String, Long> getRuleNumberIdMap(DynamicObject dataEntity) {
        DynamicObject policy = dataEntity.getDynamicObject("policy");
        DynamicObjectCollection entryRuleList = policy.getDynamicObjectCollection("entryrulelist");
        if (CollectionUtils.isEmpty((Collection)entryRuleList)) {
            return Collections.emptyMap();
        }
        HashMap<String, Long> result = new HashMap<String, Long>(16);
        for (DynamicObject dynamicObject : entryRuleList) {
            String ruleNumber = dynamicObject.getString("rulenumber");
            long ruleId = dynamicObject.getLong("id");
            result.put(ruleNumber, ruleId);
        }
        return result;
    }

    public static List<Long> getSceneIdByMsgSub(Long msgSubId) {
        Map result = (Map)SWCMServiceUtils.invokeSWCService((String)"hsas", (String)"IHSASService", (String)"getSceneIdByMsgSubId", (Object[])new Object[]{msgSubId});
        Boolean isSuccess = (Boolean)result.get("success");
        List data = (List)result.get("data");
        if (!isSuccess.booleanValue() || CollectionUtils.isEmpty((Collection)data)) {
            return Collections.emptyList();
        }
        return data;
    }

    public static ResponseDTO<Boolean> deleteHrPolicys(List<Long> ids) {
        int result = (Integer)SWCMServiceUtils.invokeHRMPService((String)"brm", (String)"IBRMPolicyService", (String)"deletePolicy", (Object[])new Object[]{ids});
        if (result < 0) {
            return new ResponseDTO("500", null, null);
        }
        return new ResponseDTO("200", null, null);
    }

    public static List<Long> getAllPolicyIds(DynamicObject[] objects) {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        if (objects == null || objects.length == 0) {
            return ids;
        }
        return Arrays.stream(objects).map(item -> item.getLong("policy.id")).filter(item -> item != 0L).collect(Collectors.toList());
    }

    public static ResponseDTO<Boolean> enableHrPolicys(List<Long> ids, List<Number> numbers) {
        try {
            return TaskRuleHelper.setHrPolicyEnableValue(ids, numbers, Boolean.TRUE);
        }
        catch (Exception e) {
            return new ResponseDTO("500", null, e.getMessage());
        }
    }

    public static ResponseDTO<Boolean> disableHrPolicys(List<Long> ids, List<Number> numbers) {
        try {
            return TaskRuleHelper.setHrPolicyEnableValue(ids, numbers, Boolean.FALSE);
        }
        catch (Exception e) {
            return new ResponseDTO("500", null, e.getMessage());
        }
    }

    private static ResponseDTO<Boolean> setHrPolicyEnableValue(List<Long> ids, List<Number> numbers, Boolean value) throws Exception {
        ResponseDTO<List<HRPolicyEntity>> response = TaskRuleHelper.getHrPolicyListByIdOrNumber(ids, numbers);
        if (!response.isSuccess()) {
            return new ResponseDTO("500", null, null);
        }
        List result = (List)response.getResult();
        if (CollectionUtils.isEmpty((Collection)result)) {
            return new ResponseDTO("200", null, null);
        }
        for (HRPolicyEntity hrPolicy : result) {
            List entryBuList;
            hrPolicy.setEnable(value);
            List entryRuleList = hrPolicy.getEntryRuleList();
            if (!CollectionUtils.isEmpty((Collection)entryRuleList)) {
                for (HrRuleDesignEntity hrRule : entryRuleList) {
                    hrRule.setModifyStatus("modify");
                    hrRule.setRuleEnable(value);
                }
            }
            if (CollectionUtils.isEmpty((Collection)(entryBuList = hrPolicy.getEntryBuList()))) continue;
            for (HrUsableRangeEntity hrBu : entryBuList) {
                hrBu.setModifyStatus("modify");
            }
        }
        List<Map<String, Object>> updateMap = TaskRuleHelper.convertObjectToMap(result);
        Map requestResult = (Map)SWCMServiceUtils.invokeHRMPService((String)"brm", (String)"IBRMPolicyService", (String)"batchModifyPolicy", (Object[])new Object[]{updateMap});
        if ("200".equals(String.valueOf(requestResult.get("resultCode")))) {
            return new ResponseDTO("200", null, null);
        }
        throw new Exception(requestResult.get("errorMsg").toString());
    }

    public static ResponseDTO<List<HRPolicyEntity>> getHrPolicyListByIdOrNumber(List<Long> ids, List<Number> numbers) {
        if (CollectionUtils.isEmpty(ids) && CollectionUtils.isEmpty(numbers)) {
            return new ResponseDTO("200", null, null);
        }
        SWCDataServiceHelper policyOrm = new SWCDataServiceHelper("brm_policy_edit");
        DynamicObject[] query = policyOrm.query(POLICY_FIELDS, new QFilter[]{new QFilter("id", "in", ids).or(new QFilter("number", "in", numbers))});
        List<HRPolicyEntity> result = TaskRuleHelper.convertBrmPolicyDynamicToHrPolicys(query);
        return new ResponseDTO("200", result, null);
    }

    public static List<HRPolicyEntity> convertBrmPolicyDynamicToHrPolicys(DynamicObject[] dataEntitys) {
        ArrayList<HRPolicyEntity> result = new ArrayList<HRPolicyEntity>();
        if (null == dataEntitys || dataEntitys.length < 1) {
            return result;
        }
        for (DynamicObject dynamicObject : dataEntitys) {
            HRPolicyEntity convertDy = TaskRuleHelper.convertBrmPolicyDynamicToHrPolicy(dynamicObject);
            if (null == convertDy) continue;
            result.add(convertDy);
        }
        return result;
    }

    public static HRPolicyEntity convertBrmPolicyDynamicToHrPolicy(DynamicObject policyDynamicObject) {
        if (null == policyDynamicObject) {
            return null;
        }
        if (!"brm_policy_edit".equals(policyDynamicObject.getDataEntityType().getName())) {
            return null;
        }
        HRPolicyEntity policy = new HRPolicyEntity();
        policy.setBizAppId(policyDynamicObject.getString("bizappid.id"));
        policy.setCreateBu(Long.valueOf(policyDynamicObject.getLong("createbu.id")));
        policy.setDescription(policyDynamicObject.getString("description"));
        policy.setEnable(policyDynamicObject.getString("enable"));
        Long policyId = policyDynamicObject.getLong("id");
        if (policyId != null && policyId > 0L) {
            policy.setId(policyId);
        }
        policy.setName(policyDynamicObject.getString("name"));
        policy.setNumber(policyDynamicObject.getString("number"));
        policy.setPolicyMode(policyDynamicObject.getString("policymode"));
        policy.setIsDefaultResult(Boolean.valueOf(policyDynamicObject.getBoolean("retrundefault")));
        if (null != policy.getIsDefaultResult() && policy.getIsDefaultResult().booleanValue()) {
            policy.setResults(policyDynamicObject.getString("results"));
        }
        policy.setScene(Long.valueOf(policyDynamicObject.getLong("scene.id")));
        policy.setEntryRuleList(TaskRuleHelper.getHrRuleFromEntity(policyDynamicObject));
        policy.setEntryBuList(TaskRuleHelper.getHrEnableRangeFromEntity(policyDynamicObject.getDynamicObjectCollection("entrybulist")));
        return policy;
    }

    private static List<HrUsableRangeEntity> getHrEnableRangeFromEntity(DynamicObjectCollection buList) {
        ArrayList<HrUsableRangeEntity> result = new ArrayList<HrUsableRangeEntity>();
        if (CollectionUtils.isEmpty((Collection)buList)) {
            return result;
        }
        for (DynamicObject dy : buList) {
            HrUsableRangeEntity usableRange = new HrUsableRangeEntity();
            usableRange.setEntityBu(Long.valueOf(dy.getLong("entitybu.id")));
            usableRange.setIsContainsSub(Boolean.valueOf(dy.getBoolean("containssub")));
            result.add(usableRange);
        }
        return result;
    }

    private static List<HrRuleDesignEntity> getHrRuleFromEntity(DynamicObject policyDynamincObject) {
        DynamicObjectCollection entryRuleList = policyDynamincObject.getDynamicObjectCollection("entryrulelist");
        return TaskRuleHelper.getHrRuleFromEntity(entryRuleList, policyDynamincObject.getBoolean("enable"));
    }

    private static List<HrRuleDesignEntity> getHrRuleFromEntity(DynamicObjectCollection entryRuleList, Boolean isRuleEnable) {
        ArrayList<HrRuleDesignEntity> result = new ArrayList<HrRuleDesignEntity>(10);
        if (CollectionUtils.isEmpty((Collection)entryRuleList)) {
            return result;
        }
        boolean isContainOrder = ((DynamicObject)entryRuleList.get(0)).getDataEntityType().getProperties().containsKey((Object)"ruleorder");
        for (int i = 0; i < entryRuleList.size(); ++i) {
            DynamicObject dy = (DynamicObject)entryRuleList.get(i);
            HrRuleDesignEntity hrRule = new HrRuleDesignEntity();
            hrRule.setFilterCondition(dy.getString("filtercondition"));
            hrRule.setFilterResult(dy.getString("filterresult"));
            hrRule.setRuleName(dy.getString("rulename"));
            hrRule.setRuleNumber(dy.getString("rulenumber"));
            if (isContainOrder) {
                hrRule.setRuleOrder(Integer.valueOf(dy.getInt("ruleorder")));
            } else {
                hrRule.setRuleOrder(Integer.valueOf(i + 1));
            }
            hrRule.setId(Long.valueOf(dy.getLong("id")));
            hrRule.setRuleEnable(isRuleEnable);
            result.add(hrRule);
        }
        return result.stream().sorted(Comparator.comparingInt(HrRuleDesignEntity::getRuleOrder)).collect(Collectors.toList());
    }

    public static ErrorCode getDefaultErrorCode() {
        return new ErrorCode("PayRollActGrpHelper.DefaultException", ResManager.loadKDString((String)"\u64cd\u4f5c\u51fa\u73b0\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"TaskRuleHelper_1", (String)"swc-hpdi-business", (Object[])new Object[0]));
    }

    public static HrRuleDesignEntity convertHrRuleDesignEntity(DynamicObject ruleDesign) {
        HrRuleDesignEntity hrRuleDesignEntity = new HrRuleDesignEntity();
        hrRuleDesignEntity.setRuleName(ruleDesign.getString("name"));
        hrRuleDesignEntity.setId(Long.valueOf(ruleDesign.getLong("id")));
        hrRuleDesignEntity.setRuleNumber(ruleDesign.getString("number"));
        hrRuleDesignEntity.setFilterResult(ruleDesign.getString("results"));
        hrRuleDesignEntity.setFilterCondition(ruleDesign.getString("conditions"));
        return hrRuleDesignEntity;
    }

    public static HrRuleDesignEntity convertHrRuleDesignWithNewId(DynamicObject ruleDesign) {
        HrRuleDesignEntity hrRuleDesignEntity = new HrRuleDesignEntity();
        hrRuleDesignEntity.setRuleName(ruleDesign.getString("name"));
        hrRuleDesignEntity.setId(TaskRuleHelper.newRuleId());
        hrRuleDesignEntity.setRuleNumber(TaskRuleHelper.newRuleNumber());
        hrRuleDesignEntity.setFilterResult(ruleDesign.getString("results"));
        hrRuleDesignEntity.setFilterCondition(ruleDesign.getString("conditions"));
        return hrRuleDesignEntity;
    }

    public static String newRuleNumber() {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"hpdi_verrange");
        return CodeRuleServiceHelper.getNumber((String)dynamicObject.getDataEntityType().getName(), (DynamicObject)dynamicObject, null);
    }

    public static Long newRuleId() {
        return DB.genLongId((String)"hpdi_taskrule");
    }

    public Map<String, Object> isAllVerifyAndExePreError(DynamicObject taskRule, Map<String, Object> ruleEngineResult, Map<String, Object> taskRuleVerifyRangeResult) {
        Map<String, String> taskRuleExeVerifyRangeMap;
        Map<String, Boolean> exePreRuleResultMap;
        if (!((Boolean)taskRuleVerifyRangeResult.get("success")).booleanValue()) {
            return this.error((String)taskRuleVerifyRangeResult.get("msg"));
        }
        if (!((Boolean)ruleEngineResult.get("success")).booleanValue()) {
            return this.error((String)ruleEngineResult.get("msg"));
        }
        if (taskRule == null) {
            return this.success("DO_NOT_VERIFY", null);
        }
        DynamicObjectCollection taskRuleEntryEntity = taskRule.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)taskRuleEntryEntity)) {
            return this.success("DO_NOT_VERIFY", null);
        }
        Map<String, Boolean> taskRuleManualVerifyMap = TaskRuleHelper.getTaskRuleManualVerifyMap(taskRuleEntryEntity);
        if (this.isAllVerifyAndExePreError(taskRuleManualVerifyMap, exePreRuleResultMap = this.getExePreRuleResult(ruleEngineResult, taskRuleEntryEntity), taskRuleExeVerifyRangeMap = this.getTaskRuleExeVerifyRangeMap(taskRuleVerifyRangeResult)).booleanValue()) {
            return this.error(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u201c{0}\u201d\u7684\u534f\u4f5c\u4efb\u52a1\u7f16\u6392\u4e2d\u6240\u6709\u534f\u4f5c\u89c4\u5219\u90fd\u9700\u8981\u6838\u5b9a\u4f46\u90fd\u4e0d\u6ee1\u8db3\u6267\u884c\u524d\u63d0\u6761\u4ef6\uff0c\u65e0\u6cd5\u751f\u6210\u85aa\u916c\u6838\u5b9a\u5355\u3002", (String)"TaskRuleHelper_3", (String)"swc-hpdi-business", (Object[])new Object[]{taskRule.getString("createorg.name")}));
        }
        HashSet result = new HashSet(16);
        taskRuleManualVerifyMap.forEach((id, taskRuleManualVerify) -> {
            boolean isVerify;
            Boolean exePreResult = (Boolean)exePreRuleResultMap.get(id);
            String taskRuleExeVerifyRange = (String)taskRuleExeVerifyRangeMap.get(id);
            boolean bl = isVerify = taskRuleManualVerify != false && exePreResult != false && ("VERIFY_PASSED".equalsIgnoreCase(taskRuleExeVerifyRange) || "VERIFY_ALL".equalsIgnoreCase(taskRuleExeVerifyRange));
            if (isVerify) {
                result.add(id);
            }
        });
        if (CollectionUtils.isEmpty(result)) {
            return this.success("DO_NOT_VERIFY", Collections.emptySet());
        }
        return this.success("MUST_VERIFY", result);
    }

    private Boolean isAllVerifyAndExePreError(Map<String, Boolean> taskRuleManualVerifyMap, Map<String, Boolean> exePreRuleResultMap, Map<String, String> taskRuleExeVerifyRangeMap) {
        if (taskRuleManualVerifyMap.entrySet().stream().anyMatch(item -> Boolean.FALSE.equals(item.getValue()))) {
            return Boolean.FALSE;
        }
        if (taskRuleExeVerifyRangeMap.entrySet().stream().anyMatch(item -> "VERIFY_NOT_PASS".equals(item.getValue()))) {
            return Boolean.FALSE;
        }
        if (exePreRuleResultMap.entrySet().stream().anyMatch(item -> Boolean.TRUE.equals(item.getValue()))) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Map<String, String> getTaskRuleExeVerifyRangeMap(Map<String, Object> taskRuleManualVerifyMap) {
        return (Map)taskRuleManualVerifyMap.get("data");
    }

    private Map<String, Boolean> getExePreRuleResult(Map<String, Object> ruleEngineResult, DynamicObjectCollection taskRuleEntryEntity) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(16);
        for (DynamicObject dynamicObject : taskRuleEntryEntity) {
            long collaRuleId = dynamicObject.getLong("collarule.id");
            String collaRuleClass = dynamicObject.getString("collaruletype");
            if (collaRuleId == 0L || SWCStringUtils.isEmpty((String)collaRuleClass)) continue;
            result.put(collaRuleClass + PayRollActGrpConstants.COLLA_RULE_ID_SEPERATOR + collaRuleId, Boolean.TRUE);
        }
        Map data = (Map)ruleEngineResult.get("data");
        if (CollectionUtils.isEmpty((Map)data)) {
            return result;
        }
        data.forEach((key, value) -> {
            Map tempData = (Map)value;
            Boolean dataResult = (Boolean)((Map)value).get("success");
            if (dataResult.booleanValue()) {
                return;
            }
            Map errorDataList = (Map)tempData.get("errorDataList");
            if (CollectionUtils.isEmpty((Map)errorDataList)) {
                return;
            }
            Boolean errorDataResult = (Boolean)errorDataList.get("success");
            if (errorDataResult.booleanValue()) {
                return;
            }
            List errorData = (List)errorDataList.get("errorData");
            if (CollectionUtils.isEmpty((Collection)errorData)) {
                return;
            }
            for (Map errorDatum : errorData) {
                if (!"COLLA_RULE_ERROR_001".equalsIgnoreCase((String)errorDatum.get("code"))) continue;
                result.put((String)key, Boolean.FALSE);
            }
        });
        return result;
    }

    private static Map<String, Boolean> getTaskRuleManualVerifyMap(DynamicObjectCollection taskRuleEntryEntity) {
        LinkedHashMap<String, Boolean> taskRuleManualVerifyMap = new LinkedHashMap<String, Boolean>(16);
        for (DynamicObject ruleEntryEntity : taskRuleEntryEntity) {
            long collaRuleId = ruleEntryEntity.getLong("collarule.id");
            String collaRuleClass = ruleEntryEntity.getString("collaruletype");
            if (collaRuleId == 0L && !SWCStringUtils.isNotEmpty((String)collaRuleClass)) continue;
            taskRuleManualVerifyMap.put(collaRuleClass + PayRollActGrpConstants.COLLA_RULE_ID_SEPERATOR + collaRuleId, ruleEntryEntity.getBoolean("ismanualverify"));
        }
        return taskRuleManualVerifyMap;
    }

    private Map<String, Object> success(String resultCode, Object data) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("success", Boolean.TRUE);
        result.put("data", data);
        result.put("code", resultCode);
        return result;
    }

    private Map<String, Object> error(String msg) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", Boolean.FALSE);
        result.put("msg", msg);
        return result;
    }

    public static String newPolicyNumber() {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"hpdi_verrangepolicy");
        return CodeRuleServiceHelper.getNumber((String)dynamicObject.getDataEntityType().getName(), (DynamicObject)dynamicObject, null);
    }

    public static String formatRuleConditionInfo(String ruleConditionJsonStr) {
        if (SWCStringUtils.isEmpty((String)ruleConditionJsonStr)) {
            return null;
        }
        JSONObject ruleObj = JSONObject.parseObject((String)ruleConditionJsonStr);
        if (null == ruleObj) {
            return null;
        }
        JSONArray conditionList = ruleObj.getJSONArray("conditionList");
        if (CollectionUtils.isEmpty((Collection)conditionList)) {
            return null;
        }
        HashMap<String, String> conditionMap = new HashMap<String, String>(16);
        for (Object condition : conditionList) {
            JSONObject conditionObj = (JSONObject)condition;
            String param = conditionObj.getString("displayParam");
            String name = conditionObj.getString("name");
            String operator = conditionObj.getString("operators");
            String value = conditionObj.getString("displayValue");
            operator = TaskRuleHelper.processOperatorStr(operator, value);
            conditionMap.put(name, param + ' ' + operator);
        }
        JSONArray conditionExpressList = ruleObj.getJSONArray("conditionExpressList");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < conditionExpressList.size(); ++i) {
            StringBuilder tmp = new StringBuilder();
            Object express = conditionExpressList.get(i);
            JSONObject expressObj = (JSONObject)express;
            String logical = expressObj.getString("logical");
            if (i == conditionExpressList.size() - 1) {
                logical = null;
            }
            String name = expressObj.getString("name");
            String leftBracket = expressObj.getString("leftBracket");
            String rightBracket = expressObj.getString("rightBracket");
            tmp.append(leftBracket == null ? "" : leftBracket).append((String)conditionMap.get(name)).append(rightBracket == null ? "" : rightBracket).append(logical == null ? "" : logical);
            result.append((CharSequence)tmp);
        }
        return result.toString();
    }

    private static String processOperatorStr(String operator, String value) {
        RuleOperatorEnum operatorEnum = RuleOperatorEnum.getEnum((String)operator);
        if (null == operatorEnum) {
            return operator + ' ' + value;
        }
        String name = operatorEnum.getName();
        if (name.contains("...")) {
            return name.replace("...", ' ' + value + ' ');
        }
        if (SWCStringUtils.isEmpty((String)value)) {
            return name;
        }
        return name + ' ' + value;
    }

    public static Map<String, Map<Long, DynamicObject>> queryCollaRuleInfo(DynamicObjectCollection entryEntity, String props) {
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return new HashMap<String, Map<Long, DynamicObject>>(16);
        }
        HashMap<String, List<Long>> idMap = new HashMap<String, List<Long>>(16);
        TaskRuleHelper.setCollaRuleIdByType(idMap, entryEntity);
        return TaskRuleHelper.queryCollaRuleInfo(idMap, props);
    }

    public static Map<String, Map<Long, DynamicObject>> queryCollaRuleInfo(Map<String, List<Long>> idMap, String props) {
        HashMap<String, Map<Long, DynamicObject>> collaRuleDyMap = new HashMap<String, Map<Long, DynamicObject>>(16);
        if (CollectionUtils.isEmpty(idMap)) {
            return collaRuleDyMap;
        }
        for (Map.Entry<String, List<Long>> entry : idMap.entrySet()) {
            if (!StringUtils.isNotEmpty((CharSequence)entry.getKey())) continue;
            SWCDataServiceHelper helper = new SWCDataServiceHelper(entry.getKey());
            DynamicObject[] collaRuleDys = helper.query(props, new QFilter("id", "in", entry.getValue()).toArray());
            Map collaRuleDyIn = Arrays.stream(collaRuleDys).collect(Collectors.toMap(collaRuleDy -> collaRuleDy.getLong("id"), collaRuleDy -> collaRuleDy, (a1, b1) -> b1, () -> new HashMap(16)));
            collaRuleDyMap.put(entry.getKey(), collaRuleDyIn);
        }
        return collaRuleDyMap;
    }

    public static Map<String, List<Long>> getCollaRuleIdByType(Map<String, List<Long>> idMap, DynamicObject data) {
        if (idMap == null) {
            idMap = new HashMap<String, List<Long>>(16);
        }
        if (data == null) {
            return idMap;
        }
        if (data.containsProperty("entryentity")) {
            TaskRuleHelper.setCollaRuleIdByType(idMap, data.getDynamicObjectCollection("entryentity"));
        }
        return idMap;
    }

    private static void setCollaRuleIdByType(Map<String, List<Long>> idMap, DynamicObjectCollection dataEntry) {
        for (DynamicObject entity : dataEntry) {
            String type = entity.getString("collaruletype");
            List collaRuleIds = idMap.computeIfAbsent(type, ids -> new ArrayList(10));
            collaRuleIds.add(entity.getLong("collarule.id"));
        }
    }

    public static String getCollaRuleType(long bizTypeId) {
        if (bizTypeId == PAYROLL_MANAGE_BIZ_TYPE) {
            return PAYROLL_BASEDATA_TYPE;
        }
        if (bizTypeId == SALARY_MANAGE_BIZ_TYPE) {
            return SALARY_BASEDATA_TYPE;
        }
        if (bizTypeId == TAX_MANAGE_BIZ_TYPE) {
            return TAX_BASEDATA_TYPE;
        }
        if (bizTypeId == SOCIAL_MANAGE_BIZ_TYPE) {
            return SOCIAL_BASEDATA_TYPE;
        }
        return "";
    }

    public static Table<String, Long, List<Boolean>> queryIsStopWhenError(Map<String, Set<Long>> queryMap) {
        HashBasedTable result = HashBasedTable.create();
        if (CollectionUtils.isEmpty(queryMap)) {
            return result;
        }
        Table<String, Long, DynamicObject> queryTable = HPDICloudCollaHelper.getInstance().queryMultiClassObject(queryMap, "id,boid,entryentity.stopexecafterfail");
        if (queryTable.isEmpty()) {
            return result;
        }
        for (DynamicObject dynamicObject : queryTable.values()) {
            String trClass = dynamicObject.getDynamicObjectType().getName();
            long trId = dynamicObject.getLong("id");
            List isStopWhenError = dynamicObject.getDynamicObjectCollection("entryentity").stream().map(item -> item.getBoolean("stopexecafterfail")).collect(Collectors.toList());
            result.put((Object)trClass, (Object)trId, isStopWhenError);
        }
        return result;
    }

    public static Table<String, Long, Boolean> queryMergeIsStopWhenError(Map<String, Set<Long>> queryMap) {
        Table<String, Long, List<Boolean>> queryResult = TaskRuleHelper.queryIsStopWhenError(queryMap);
        Set keySet = queryResult.rowKeySet();
        HashBasedTable result = HashBasedTable.create();
        for (String key : keySet) {
            Map row = queryResult.row((Object)key);
            row.forEach((arg_0, arg_1) -> TaskRuleHelper.lambda$queryMergeIsStopWhenError$16((Table)result, key, arg_0, arg_1));
        }
        return result;
    }

    private static /* synthetic */ void lambda$queryMergeIsStopWhenError$16(Table result, String key, Long trId, List dataList) {
        Boolean cfr_ignored_0 = (Boolean)result.put((Object)key, (Object)trId, (Object)dataList.stream().anyMatch(item -> item));
    }

    private static final class Load {
        private static TaskRuleHelper taskRuleHelper = new TaskRuleHelper();

        private Load() {
        }
    }
}

