/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.bizdata.export;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class BizDataExportDataHelper {
    private static final String EXCEL_SUFFIX = ".xlsx";
    private static final Object DATATYPE = "dataType";
    private static Log logger = LogFactory.getLog(BizDataExportDataHelper.class);
    private static List<String> hideField = new ArrayList<String>();

    private BizDataExportDataHelper() {
    }

    public static List<Map<String, String>> HeadMapToListMap(Map<String, String> headData) {
        LinkedList<Map<String, String>> list = new LinkedList<Map<String, String>>();
        for (Map.Entry<String, String> entry : headData.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (hideField.indexOf(key) >= 0) continue;
            HashMap<String, String> temp = new HashMap<String, String>();
            temp.put("key", key);
            temp.put("value", value);
            list.add(temp);
        }
        return list;
    }

    private static void getDateCellStyle(SXSSFWorkbook wb, CellStyle cellStyle, String formatStr) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        DataFormat format = wb.createDataFormat();
        cellStyle.setDataFormat(format.getFormat(formatStr));
    }

    private static void getStringCellStyle(SXSSFWorkbook wb, CellStyle cellStyle) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        DataFormat format = wb.createDataFormat();
        String styleStr = "@";
        cellStyle.setDataFormat(format.getFormat(styleStr));
    }

    private static void getNumberCellStyle(SXSSFWorkbook wb, CellStyle cellStyle, int scale) {
        DataFormat format = wb.createDataFormat();
        String styleStr = "#,##0";
        StringBuilder sb = new StringBuilder(styleStr);
        if (scale > 0) {
            sb.append('.');
            for (int i = 0; i < scale; ++i) {
                sb.append('0');
            }
        }
        cellStyle.setDataFormat(format.getFormat(sb.toString()));
    }

    private static void getAmountCellStyle(SXSSFWorkbook wb, CellStyle cellStyle, String sign, int scale) {
        if (SWCStringUtils.isEmpty((String)sign)) {
            sign = "";
        }
        DataFormat format = wb.createDataFormat();
        String styleStr = sign + "#,##0";
        StringBuilder sb = new StringBuilder(styleStr);
        if (scale > 0) {
            sb.append('.');
            for (int i = 0; i < scale; ++i) {
                sb.append('0');
            }
        }
        cellStyle.setDataFormat(format.getFormat(sb.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeFile(SXSSFWorkbook wb, String fileName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            fileName = fileName + EXCEL_SUFFIX;
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
            return string;
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            String string = "";
            return string;
        }
        finally {
            if (null != outStream) {
                outStream.close();
            }
            if (null != inStream) {
                inStream.close();
            }
        }
    }

    static {
        hideField.add("oricurrency");
        hideField.add("calcurrency");
        hideField.add("payrollcurrency");
    }
}

