/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.bizdata.filter;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.swc.hpdi.business.bizdata.enums.PresentErrorEnum;
import kd.swc.hpdi.business.bizdata.filter.IBizDataFilter;
import kd.swc.hsbp.common.util.SWCObjectUtils;

public class BizDataBeforeDateFilter
implements IBizDataFilter {
    @Override
    public void doFilter(Map<String, Object> queryMap, List<DynamicObject> bizDataList, IBizDataFilter filter, Map<String, Map<String, Object>> responses) {
        this.doFilterCore(queryMap, bizDataList, responses);
        filter.doFilter(queryMap, bizDataList, filter, responses);
    }

    private void doFilterCore(Map<String, Object> queryMap, List<DynamicObject> bizDataList, Map<String, Map<String, Object>> responses) {
        Map relationDataMap = (Map)queryMap.get("relationDataMap");
        if (SWCObjectUtils.isEmpty((Object)relationDataMap)) {
            return;
        }
        String msg = ResManager.loadKDString((String)"\u201c\u751f\u6548\u65e5\u671f\u201d\u9700\u5927\u4e8e\u7b49\u4e8e\u5bf9\u5e94\u9879\u76ee\u5df2\u63a8\u9001\u7b97\u85aa\u7684\u4e1a\u52a1\u6570\u636e\u751f\u6548\u65e5\u671f\u3002", (String)"BizDataBeforeDateFilter_0", (String)"swc-hpdi-business", (Object[])new Object[0]);
        for (DynamicObject bizData : bizDataList) {
            String key = bizData.getLong("bizitem.id") + "_" + bizData.getLong("empposorgrel.id");
            DynamicObject relationData = (DynamicObject)relationDataMap.get(key);
            if (SWCObjectUtils.isEmpty((Object)relationData)) continue;
            Date effectiveDate = bizData.getDate("effectivedate");
            Date relationEffectiveDate = relationData.getDate("effectivedate");
            if (effectiveDate == null || relationEffectiveDate == null || !effectiveDate.before(relationEffectiveDate)) continue;
            String bizDataCode = bizData.getString("bizdatacode");
            HashMap<String, String> responseMap = new HashMap<String, String>(4);
            responseMap.put("key_result_error_msg", msg);
            responseMap.put("key_present_error_msg", PresentErrorEnum.OTHER.getCode());
            responses.put(bizDataCode, responseMap);
        }
    }
}

