/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.bizdata.filter;

import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.swc.hpdi.business.bizdata.filter.IBizDataFilter;
import kd.swc.hsbp.common.util.SWCInteDateTimeUtil;

public class BizDataCalPeriodFilter
implements IBizDataFilter {
    @Override
    public void doFilter(Map<String, Object> queryMap, List<DynamicObject> bizDataBillEntries, IBizDataFilter filter, Map<String, Map<String, Object>> responses) {
        this.doFilterCore(queryMap, bizDataBillEntries, responses);
        filter.doFilter(queryMap, bizDataBillEntries, filter, responses);
    }

    private void doFilterCore(Map<String, Object> queryMap, List<DynamicObject> bizDataBillEntries, Map<String, Map<String, Object>> responses) {
        for (int i = 0; i < bizDataBillEntries.size(); ++i) {
            DynamicObject bizDataBillEntry = bizDataBillEntries.get(i);
            String bizDataCode = bizDataBillEntry.getString("bizdatacode");
            Date startDate = (Date)queryMap.get("periodStartDate");
            Date endDate = (Date)queryMap.get("periodEndDate");
            Date effectiveDate = bizDataBillEntry.getDate("effectivedateent");
            DynamicObjectCollection details = bizDataBillEntry.getDynamicObjectCollection("entryentity");
            if (details == null || details.size() == 0) continue;
            DynamicObject detail = (DynamicObject)details.get(0);
            boolean cycle = detail.getBoolean("bizitem.cycle");
            if (startDate == null || endDate == null || (cycle || !effectiveDate.before(startDate)) && !effectiveDate.after(endDate)) continue;
            String errorMsg = ResManager.loadKDString((String)"\u201c\u751f\u6548\u65e5\u671f\u201d\u9700\u5728\u85aa\u8d44\u671f\u95f4\u5185\u201c[{0}~{1}]\u201d\u3002", (String)"BizDataBillEntryCheckingHelper_6", (String)"swc-hpdi-business", (Object[])new Object[0]);
            if (cycle) {
                errorMsg = ResManager.loadKDString((String)"\u201c\u751f\u6548\u65e5\u671f\u201d\u9700\u5c0f\u4e8e\u7b49\u4e8e\u201c\u85aa\u8d44\u671f\u95f4\u7ed3\u675f\u65e5\u671f\uff1a{1}\u201d\u3002", (String)"BizDataBillEntryCheckingHelper_21", (String)"swc-hpdi-business", (Object[])new Object[0]);
            }
            HashMap<String, String> responseMap = new HashMap<String, String>(4);
            responseMap.put("key_result_error_msg", MessageFormat.format(errorMsg, SWCInteDateTimeUtil.formatDate((String)"hsbs_calperiod", (String)"startdate", (Date)startDate), SWCInteDateTimeUtil.formatDate((String)"hsbs_calperiod", (String)"enddate", (Date)endDate)));
            responses.putIfAbsent(bizDataCode, responseMap);
        }
    }
}

