/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.bizdata.filter;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hpdi.business.bizdata.enums.PresentErrorEnum;
import kd.swc.hpdi.business.bizdata.filter.IBizDataFilter;
import kd.swc.hpdi.business.bizdata.filter.IBizDataFilterRequest;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import org.apache.commons.collections.MapUtils;

public class BizDataCaledFilter
implements IBizDataFilter,
IBizDataFilterRequest {
    private static final Log logger = LogFactory.getLog(BizDataCaledFilter.class);
    private static final String BIZ_DATA_SOURCE = "bizDataSource";

    @Override
    public void doFilter(Map<String, Object> queryMap, List<DynamicObject> bizDataList, IBizDataFilter filter, Map<String, Map<String, Object>> responses) {
        Map bizDataSourceMap = (Map)queryMap.get(BIZ_DATA_SOURCE);
        if (MapUtils.isNotEmpty((Map)bizDataSourceMap)) {
            for (DynamicObject bizData : bizDataList) {
                String bizDataCode = bizData.getString("bizdatacode");
                DynamicObject sourceBizData = (DynamicObject)bizDataSourceMap.get(bizDataCode);
                if (!SWCObjectUtils.isEmpty((Object)sourceBizData)) continue;
                HashMap<String, String> responseMap = new HashMap<String, String>(4);
                responseMap.put("key_result_error_msg", ResManager.loadKDString((String)"\u539f\u4e1a\u52a1\u6570\u636e\u4e0d\u662f\u201c\u5df2\u63a8\u9001\u7b97\u85aa\u201d\u72b6\u6001\uff0c\u65e0\u6cd5\u66f4\u65b0\u3002\u8bf7\u5148\u5e9f\u5f03\u539f\u4e1a\u52a1\u6570\u636e\uff0c\u7136\u540e\u91cd\u65b0\u63d0\u62a5\u3002", (String)"BizDataCaledFilter_0", (String)"swc-hpdi-business", (Object[])new Object[0]));
                responseMap.put("key_present_error_msg", PresentErrorEnum.OUT_INPUT_TIME.getCode());
                responses.put(bizDataCode, responseMap);
            }
        }
        filter.doFilter(queryMap, bizDataList, filter, responses);
    }

    @Override
    public Map<String, Object> getQueryMap(List<DynamicObject> bizDataList) {
        QFilter typeFilter;
        QFilter pushedFilter;
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)1);
        Object[] bizCodes = bizDataList.stream().map(obj -> obj.getString("bizdatacode")).toArray();
        QFilter bizDataCodeFilter = new QFilter("bizdatacode", "in", (Object)bizCodes);
        QFilter[] filters = new QFilter[]{bizDataCodeFilter, pushedFilter = new QFilter("bizdatastatus", "=", (Object)"3"), typeFilter = new QFilter("billtype", "=", (Object)"1")};
        Object[] pushedBizData = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.query("bizdatacode,bizdatastatus", filters);
        if (SWCArrayUtils.isEmpty((Object[])pushedBizData)) {
            logger.info("BizDataCaledFilter-getQueryMap queryBizDataByBizDataCodeAndBillTypeAndBizDataStatus isEmpty");
            resultMap.put(BIZ_DATA_SOURCE, null);
            return resultMap;
        }
        Map bizDataSource = Arrays.stream(pushedBizData).collect(Collectors.toMap(obj -> obj.getString("bizdatacode"), Function.identity()));
        resultMap.put(BIZ_DATA_SOURCE, bizDataSource);
        if (bizDataSource == null || bizDataSource.isEmpty()) {
            logger.info("BizDataCaledFilter-getQueryMap bizDataSource isEmpty");
        }
        return resultMap;
    }
}

