/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.bizdata.filter;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.inte.api.IInteService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.swc.hpdi.business.HPDIResMgrBusiness;
import kd.swc.hpdi.business.bizdata.enums.PresentErrorEnum;
import kd.swc.hpdi.business.helper.BizDataBillEntryHelper;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hpdi.business.util.HPDIServiceUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCInteDateTimeUtil;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;

public class BizDataCommonFilter {
    public static final String KEY_START_DATE = "startdate";
    public static final String KEY_SYS_END_DATE = "enddate";
    public static final String KEY_COD_START_TIME = "starttime";
    public static final String KEY_COD_END_TIME = "endtime";
    private static final Log logger = LogFactory.getLog(BizDataCommonFilter.class);

    public static void validatePermission(Map<String, Map<String, Object>> responses, List<DynamicObject> bizDataBillEntries) {
        String msg = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u4e0d\u5728\u60a8\u7684\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"BizDataCommonFilter_5", (String)"swc-hpdi-business", (Object[])new Object[0]);
        String adminOrgKey = BizDataBillEntryHelper.checkEntryPermByAdminorgvid() ? "adminorgvid" : "adminorg";
        Map<Long, Boolean> authorizedAdminOrg = BizDataCommonFilter.getAuthorizedAdminOrg(bizDataBillEntries, adminOrgKey);
        for (DynamicObject bizDataBillEntry : bizDataBillEntries) {
            long adminOrgId = bizDataBillEntry.getLong("empposorgrel.".concat(adminOrgKey).concat(".id"));
            Boolean isAuthorized = authorizedAdminOrg.get(adminOrgId);
            if (isAuthorized.booleanValue()) continue;
            String bizDataCode = bizDataBillEntry.getString("bizdatacode");
            HashMap<String, String> responseMap = new HashMap<String, String>(3);
            responseMap.put("key_result_error_msg", msg);
            responses.putIfAbsent(bizDataCode, responseMap);
        }
    }

    private static Map<Long, Boolean> getAuthorizedAdminOrg(List<DynamicObject> bizDataBillEntries, String adminOrgKey) {
        String fullAdminOrgIdKey = "empposorgrel.".concat(adminOrgKey).concat(".id");
        Map<Long, List<DynamicObject>> groupedData = bizDataBillEntries.stream().filter(bizDataBillEntry -> bizDataBillEntry.getLong(fullAdminOrgIdKey) != 0L).collect(Collectors.groupingBy(bizDataBillEntry -> bizDataBillEntry.getLong(fullAdminOrgIdKey)));
        Set<Long> adminOrgIds = groupedData.keySet();
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(adminOrgIds.size());
        Long userId = RequestContext.get().getCurrUserId();
        Set hasPermAdminOrgIds = SWCPermissionServiceHelper.getAdminOrgSetByPermItem((Long)userId, (String)"0NXW1VOPH+QV", (String)"hpdi_bizdatabillent", (String)"47156aff000000ac", (String)"empposorgrel.".concat(adminOrgKey));
        for (Long adminOrgId : adminOrgIds) {
            if (null == hasPermAdminOrgIds) {
                result.put(adminOrgId, Boolean.TRUE);
                continue;
            }
            boolean isContain = hasPermAdminOrgIds.contains(adminOrgId);
            if (isContain) {
                result.put(adminOrgId, Boolean.TRUE);
                continue;
            }
            result.put(adminOrgId, Boolean.FALSE);
        }
        return result;
    }

    public static List<DynamicObject> sortingBizData(DynamicObject bizDataBillEntry, List<DynamicObject> bizDataList) {
        long empPosOrgRelId = bizDataBillEntry.getLong("empposorgrel.id");
        long bizItemId = bizDataBillEntry.getLong("bizitem.id");
        List<DynamicObject> matchedBizDataList = bizDataList.stream().filter(bizData -> {
            long matchedEmpPosOrgRelId = bizData.getLong("empposorgrel.id");
            long matchedBizItemId = bizData.getLong("bizitem.id");
            return empPosOrgRelId == matchedEmpPosOrgRelId && bizItemId == matchedBizItemId;
        }).collect(Collectors.toList());
        matchedBizDataList.sort((bizData1, bizData2) -> {
            if (SWCObjectUtils.isEmpty((Object)bizData1) || SWCObjectUtils.isEmpty((Object)bizData2)) {
                return 1;
            }
            Date effectiveDate1 = bizData1.getDate("effectivedate");
            Date effectiveDate2 = bizData2.getDate("effectivedate");
            if (effectiveDate1 == null || effectiveDate2 == null) {
                return 1;
            }
            return -effectiveDate1.compareTo(effectiveDate2);
        });
        return matchedBizDataList;
    }

    public static List<Map<String, Object>> initParamsOfQueryPayNodeTimes(List<Map<String, Object>> params, Map<String, Map<String, Object>> calPeriodMap, DynamicObject bizItemGroup) {
        ArrayList<Map<String, Object>> arrayList = params = !Objects.isNull(params) ? params : new ArrayList<Map<String, Object>>(16);
        if (org.apache.commons.collections4.MapUtils.isEmpty(calPeriodMap)) {
            return params;
        }
        long calPeriodTypeId = bizItemGroup.getLong("calperiodtype.id");
        if (calPeriodTypeId == 0L) {
            return params;
        }
        for (Map.Entry<String, Map<String, Object>> entry : calPeriodMap.entrySet()) {
            String bizDataCode = entry.getKey();
            Map<String, Object> calPeriod = entry.getValue();
            if (calPeriod.get("periodnumber") == null) continue;
            HashMap<String, Object> paramMap = new HashMap<String, Object>(7);
            paramMap.put("calperiodtype", calPeriodTypeId);
            paramMap.put("bizitemgroupid", bizItemGroup.getLong("id"));
            String periodNum = String.valueOf(calPeriod.get("periodnumber"));
            paramMap.put("periodnumber", periodNum);
            paramMap.put("id", bizDataCode);
            paramMap.put("orgId", bizItemGroup.getLong("createorg.id"));
            params.add(paramMap);
        }
        return params;
    }

    public static void setErrorMsgWhenQuerySalaryPeriodException(List<DynamicObject> toBeProcessedData, Map<String, Map<String, Object>> responses) {
        toBeProcessedData.forEach(bizDataBillEntry -> {
            String bizDataCode = bizDataBillEntry.getString("bizdatacode");
            HashMap<String, String> responseMap = new HashMap<String, String>(3);
            responseMap.put("key_result_error_msg", HPDIResMgrBusiness.getMsgOfQuerySalaryPeriodException());
            responses.put(bizDataCode, responseMap);
        });
    }

    public static void validateCOD(Map<String, Object> queryMap, List<DynamicObject> bizDataList, Map<String, Map<String, Object>> responses) {
        Object bizItemGroup = queryMap.get("bizitemgroup");
        if (bizItemGroup == null || !(bizItemGroup instanceof DynamicObject)) {
            return;
        }
        Map<String, Map<String, Object>> calPeriodMap = BizDataHelper.getMoneyPeriodFormBizItemGroup(queryMap, bizDataList);
        BizDataCommonFilter.validateCODWithCalPeriodMap(bizDataList, responses, (DynamicObject)bizItemGroup, calPeriodMap);
    }

    public static void validateCODWithCalPeriodMap(List<DynamicObject> bizDataList, Map<String, Map<String, Object>> responses, DynamicObject bizItemGroup, Map<String, Map<String, Object>> calPeriodMap) {
        Map<String, Object> payNodeTimes = BizDataCommonFilter.queryPayNodeTimes(bizItemGroup, calPeriodMap);
        if (payNodeTimes == null) {
            return;
        }
        boolean isSuccess = (Boolean)payNodeTimes.get("success");
        if (isSuccess) {
            BizDataCommonFilter.validatePayNodeTimes(calPeriodMap, payNodeTimes, bizDataList, responses);
        } else {
            BizDataCommonFilter.setAllQueryPayNodeTimeException(bizDataList, responses, payNodeTimes);
        }
    }

    private static void setAllQueryPayNodeTimeException(List<DynamicObject> bizDataList, Map<String, Map<String, Object>> responses, Map<String, Object> payNodeTimes) {
        logger.error(MessageFormat.format("BizDataCommonFilter-getPayNodeTimes.queryPayNodeTimes() exception:{0}", payNodeTimes.get("message")));
        bizDataList.forEach(bizDataBillEntry -> {
            String bizDataCode = bizDataBillEntry.getString("bizdatacode");
            HashMap<String, String> responseMap = new HashMap<String, String>(4);
            responseMap.put("key_result_error_msg", HPDIResMgrBusiness.getMsgOfQueryPayNodeTimeException());
            responseMap.put("key_present_error_msg", PresentErrorEnum.NOT_IN_PERIOD.getCode());
            responses.put(bizDataCode, responseMap);
        });
    }

    public static Map<String, Object> queryPayNodeTimes(DynamicObject bizItemGroup, Map<String, Map<String, Object>> calPeriodMap) {
        List<Map<String, Object>> payNodeTimesParams = BizDataCommonFilter.initParamsOfQueryPayNodeTimes(null, calPeriodMap, bizItemGroup);
        if (payNodeTimesParams == null || payNodeTimesParams.size() == 0) {
            return null;
        }
        return HPDIServiceUtils.queryPayNodeTimes(payNodeTimesParams);
    }

    private static void validatePayNodeTimes(Map<String, Map<String, Object>> calPeriodMap, Map<String, Object> payNodeTimes, List<DynamicObject> bizDataEntries, Map<String, Map<String, Object>> responses) {
        Object dataObj = payNodeTimes.get("data");
        if (dataObj == null) {
            return;
        }
        JSONArray result = (JSONArray)payNodeTimes.get("data");
        if (result == null || result.isEmpty()) {
            return;
        }
        Map<String, JSONObject> resultMap = BizDataCommonFilter.convertPayNodeTimeDataToMap(result);
        Date nowDate = new Date();
        for (int i = 0; i < bizDataEntries.size(); ++i) {
            DynamicObject bizDataBillEntry = bizDataEntries.get(i);
            String bizDataCode = bizDataBillEntry.getString("bizdatacode");
            JSONObject jsonObject = resultMap.get(bizDataCode);
            if (jsonObject == null) continue;
            Object endTimeObj = jsonObject.get((Object)KEY_COD_END_TIME);
            if (!(endTimeObj instanceof Date)) {
                logger.info(MessageFormat.format("BizDataCommonFilter-handle:There is no corresponding COD. bizDataCode={0}", bizDataCode));
                continue;
            }
            Date codEndTime = (Date)endTimeObj;
            if (!nowDate.after(codEndTime)) continue;
            Map<String, Object> calPeriod = calPeriodMap.get(bizDataCode);
            Object periodNameObj = calPeriod.get("periodname");
            String periodName = periodNameObj == null ? "" : (String)periodNameObj;
            BizDataCommonFilter.setErrorMsg(periodName, bizDataCode, responses, codEndTime);
        }
    }

    private static Map<String, JSONObject> convertPayNodeTimeDataToMap(JSONArray result) {
        HashMap<String, JSONObject> resultMap = new HashMap<String, JSONObject>(16);
        for (int j = 0; j < result.size(); ++j) {
            JSONObject jsonObject = result.getJSONObject(j);
            String returnedBizDataCode = (String)jsonObject.get((Object)"id");
            resultMap.put(returnedBizDataCode, jsonObject);
        }
        return resultMap;
    }

    private static void setErrorMsg(String periodName, String bizDataCode, Map<String, Map<String, Object>> responses, Date codEndTime) {
        String response = String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u540e\u5931\u6548\u65e5\u671f\u5f71\u54cd\u671f\u95f4 %1$s\uff0c\u4e14\u5df2\u8fc7\u8be5\u671f\u95f4\u7684\u7a97\u53e3\u7ed3\u675f\u65f6\u95f4 %2$s\u3002", (String)"UEDDataCODFilter_1", (String)"swc-hpdi-business", (Object[])new Object[0]), periodName, SWCDateTimeUtils.format((Date)codEndTime));
        HashMap<String, String> responseMap = new HashMap<String, String>(3);
        responseMap.put("key_result_error_msg", response);
        responses.put(bizDataCode, responseMap);
    }

    public static Map<String, List<DynamicObject>> classifyBizData(List<DynamicObject> bizDataList) {
        ArrayList billNumbers = new ArrayList(bizDataList.size());
        bizDataList.forEach(bizData -> billNumbers.add(bizData.getString("applyno")));
        SWCDataServiceHelper bizDataBillHelper = HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER;
        QFilter qFilter = new QFilter("billno", "in", billNumbers);
        DynamicObject[] bizDataBills = bizDataBillHelper.query("id,billno,handletype", new QFilter[]{qFilter});
        Map<String, String> bizDataBillMap = Arrays.stream(bizDataBills).collect(Collectors.toMap(bill -> bill.getString("billno"), bill -> bill.getString("handletype"), (key1, key2) -> key1));
        ArrayList<DynamicObject> normalBizDataList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> nonNormalBizDataList = new ArrayList<DynamicObject>(10);
        for (int i = 0; i < bizDataList.size(); ++i) {
            DynamicObject bizData2 = bizDataList.get(i);
            String billNo = bizData2.getString("applyno");
            String handleType = bizDataBillMap.get(billNo);
            if (SWCStringUtils.isEmpty((String)handleType)) continue;
            if (SWCStringUtils.equals((String)handleType, (String)"A")) {
                normalBizDataList.add(bizData2);
                continue;
            }
            if (!SWCStringUtils.equals((String)handleType, (String)"B")) continue;
            nonNormalBizDataList.add(bizData2);
        }
        HashMap<String, List<DynamicObject>> result = new HashMap<String, List<DynamicObject>>(4);
        result.put("A", normalBizDataList);
        result.put("B", nonNormalBizDataList);
        return result;
    }

    public static void transSalaryCODValidate(Map<String, Object> queryMap, List<DynamicObject> normalBizDataList, Map<String, Map<String, Object>> responses) {
        Map<Long, List<DynamicObject>> classifyNormalBizDataMap = normalBizDataList.stream().collect(Collectors.groupingBy(normalBizData -> normalBizData.getLong("bizitemgroup.id")));
        for (List<DynamicObject> classifyNormalBizData : classifyNormalBizDataMap.values()) {
            ArrayList<Map<String, Object>> payNodeTimesParams;
            Map<String, Object> payNodeTimes = BizDataCommonFilter.getPayNodeTimes(queryMap, classifyNormalBizData, responses, payNodeTimesParams = new ArrayList<Map<String, Object>>(10));
            if (org.apache.commons.collections4.MapUtils.isEmpty(payNodeTimes)) continue;
            boolean isSuccess = (Boolean)payNodeTimes.get("success");
            if (isSuccess) {
                BizDataCommonFilter.validateCOD(payNodeTimes, payNodeTimesParams, classifyNormalBizData, responses);
                continue;
            }
            logger.error(MessageFormat.format("transSalaryCODValidate getPayNodeTimes() exception:{0}", payNodeTimes.get("message")));
            BizDataCommonFilter.setErrorMsgOfQueryPayNodeTimeException(classifyNormalBizData, responses);
        }
    }

    public static Map<String, Object> getPayNodeTimes(Map<String, Object> queryMap, List<DynamicObject> bizDataList, Map<String, Map<String, Object>> responses, List<Map<String, Object>> payNodeTimesParams) {
        DynamicObject bizItemGroup = bizDataList.get(0).getDynamicObject("bizitemgroup");
        queryMap.put("bizitemgroup", bizItemGroup);
        Map<String, Map<String, Object>> calPeriodMap = BizDataHelper.getBizDataPeriod(bizDataList);
        if (MapUtils.isEmpty(calPeriodMap)) {
            bizDataList.forEach(bizData -> {
                String bizDataCode = bizData.getString("bizdatacode");
                HashMap<String, String> responseMap = new HashMap<String, String>(4);
                String response = ResManager.loadKDString((String)"\u9879\u76ee\u751f\u6548\u65e5\u671f\u65e0\u6cd5\u5339\u914d\u5230\u85aa\u8d44\u671f\u95f4\u3002", (String)"BizDataCODFilter_3", (String)"swc-hpdi-business", (Object[])new Object[0]);
                responseMap.put("key_result_error_msg", response);
                responseMap.put("key_present_error_msg", PresentErrorEnum.NOT_IN_PERIOD.getCode());
                responses.put(bizDataCode, responseMap);
            });
            return new HashMap<String, Object>(1);
        }
        BizDataCommonFilter.initParamsOfQueryPayNodeTimes(payNodeTimesParams, calPeriodMap, bizItemGroup);
        if (SWCListUtils.isEmpty(payNodeTimesParams)) {
            return new HashMap<String, Object>(1);
        }
        return HPDIServiceUtils.queryPayNodeTimes(payNodeTimesParams);
    }

    private static void validateCOD(Map<String, Object> payNodeTimes, List<Map<String, Object>> periodNumbers, List<DynamicObject> classifyNormalBizData, Map<String, Map<String, Object>> responses) {
        Object dataObj = payNodeTimes.get("data");
        if (dataObj == null || SWCListUtils.isEmpty(periodNumbers)) {
            return;
        }
        JSONArray result = (JSONArray)payNodeTimes.get("data");
        if (result == null || result.isEmpty()) {
            return;
        }
        Map<String, String> bizDataCodeAndPeriodNumMap = periodNumbers.stream().collect(Collectors.toMap(periodMap -> (String)periodMap.get("id"), periodMap -> (String)periodMap.get("periodnumber"), (key1, key2) -> key2));
        Date nowDate = new Date();
        block0: for (int i = 0; i < classifyNormalBizData.size(); ++i) {
            DynamicObject bizData = classifyNormalBizData.get(i);
            String bizDataCode = bizData.getString("bizdatacode");
            for (int j = 0; j < result.size(); ++j) {
                JSONObject jsonObject = result.getJSONObject(j);
                String returnedBizDataCode = (String)jsonObject.get((Object)"id");
                Object endTimeObj = jsonObject.get((Object)KEY_COD_END_TIME);
                if (!SWCStringUtils.equals((String)bizDataCode, (String)returnedBizDataCode)) continue;
                String periodNum = bizDataCodeAndPeriodNumMap.get(bizDataCode);
                if (!(endTimeObj instanceof Date) || SWCStringUtils.isEmpty((String)periodNum)) continue block0;
                Object startTimeObj = jsonObject.get((Object)KEY_COD_START_TIME);
                Date codEndTime = (Date)endTimeObj;
                if (startTimeObj == null) {
                    if (!nowDate.after(codEndTime)) continue;
                    Map<String, Object> responseMap = BizDataCommonFilter.setErrorMsgOfNotInTheWindowOfTime("", codEndTime, periodNum);
                    responses.put(bizDataCode, responseMap);
                    continue;
                }
                Date codStartTime = (Date)startTimeObj;
                if (!nowDate.after(codEndTime) && !nowDate.before(codStartTime)) continue;
                Map<String, Object> responseMap = BizDataCommonFilter.setErrorMsgOfNotInTheWindowOfTime(SWCDateTimeUtils.format((Date)codStartTime), codEndTime, periodNum);
                responses.put(bizDataCode, responseMap);
            }
        }
    }

    private static Map<String, Object> setErrorMsgOfNotInTheWindowOfTime(String codStartTime, Date codEndTime, String periodNum) {
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        DynamicObject timeZone = service.getSysTimezone();
        String response = MessageFormat.format(ResManager.loadKDString((String)"\u4e0d\u5728\u85aa\u8d44\u671f\u95f4{0}\u7684\u65f6\u95f4\u7a97\u53e3\u5185{1}~{2}\uff08{3}\uff09", (String)"BizDataCODFilter_2", (String)"swc-hpdi-business", (Object[])new Object[0]), periodNum, codStartTime, SWCInteDateTimeUtil.formatTimeWithSystemZone((Date)codEndTime), timeZone.getString("number"));
        HashMap<String, Object> responseMap = new HashMap<String, Object>(4);
        responseMap.put("key_result_error_msg", response);
        responseMap.put("key_present_error_msg", PresentErrorEnum.TRANSALARY_NOT_IN_PERIOD.getCode());
        return responseMap;
    }

    public static void setErrorMsgOfQueryPayNodeTimeException(List<DynamicObject> bizDataList, Map<String, Map<String, Object>> responses) {
        bizDataList.forEach(bizDataEntry -> {
            String bizDataCode = bizDataEntry.getString("bizdatacode");
            HashMap<String, String> responseMap = new HashMap<String, String>(4);
            responseMap.put("key_result_error_msg", HPDIResMgrBusiness.getMsgOfQueryPayNodeTimeException());
            responseMap.put("key_present_error_msg", PresentErrorEnum.NOT_IN_PERIOD.getCode());
            responses.put(bizDataCode, responseMap);
        });
    }
}

