/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.bizdata.filter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.swc.hpdi.business.HPDIResMgrBusiness;
import kd.swc.hpdi.business.bizdata.enums.PresentErrorEnum;
import kd.swc.hpdi.business.bizdata.filter.IBizDataFilter;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;

public class BizDataDimFilter
implements IBizDataFilter {
    @Override
    public void doFilter(Map<String, Object> queryMap, List<DynamicObject> bizDataBillEntries, IBizDataFilter filter, Map<String, Map<String, Object>> responses) {
        this.doFilterCore(queryMap, bizDataBillEntries, responses);
        filter.doFilter(queryMap, bizDataBillEntries, filter, responses);
    }

    private void doFilterCore(Map<String, Object> queryMap, List<DynamicObject> bizDataBillEntries, Map<String, Map<String, Object>> responses) {
        if (queryMap == null || SWCListUtils.isEmpty(bizDataBillEntries)) {
            return;
        }
        this.validateBizDataDimOrg(queryMap, bizDataBillEntries, responses);
        this.validateBizDataDimPerm(bizDataBillEntries, responses);
    }

    private void validateBizDataDimOrg(Map<String, Object> queryMap, List<DynamicObject> billDataBillEntries, Map<String, Map<String, Object>> responses) {
        Long orgId = (Long)queryMap.get("org");
        if (null == orgId) {
            return;
        }
        for (DynamicObject entry : billDataBillEntries) {
            DynamicObject bizDataDim = entry.getDynamicObject("bizdatadim");
            if (SWCObjectUtils.isEmpty((Object)bizDataDim)) continue;
            HashMap<String, String> responseMap = new HashMap<String, String>(16);
            if (orgId.equals(bizDataDim.getLong("org.id"))) continue;
            responseMap.put("key_result_error_msg", HPDIResMgrBusiness.getMsgOfBizDataDimDiffOrg());
            responseMap.put("key_present_error_msg", PresentErrorEnum.OTHER.getCode());
            responses.put(entry.getString("bizdatacode"), responseMap);
        }
    }

    private void validateBizDataDimPerm(List<DynamicObject> billDataBillEntries, Map<String, Map<String, Object>> responses) {
        Set bizDataDimIds = SWCPermissionServiceHelper.getBizDataDimSetByPermItem((String)"0NXW1VOPH+QV", (String)"hpdi_bizdatabillent", (String)"47150e89000000ac");
        if (null == bizDataDimIds) {
            return;
        }
        for (DynamicObject entry : billDataBillEntries) {
            DynamicObject bizDataDim = entry.getDynamicObject("bizdatadim");
            if (SWCObjectUtils.isEmpty((Object)bizDataDim)) continue;
            HashMap<String, String> responseMap = new HashMap<String, String>(16);
            if (bizDataDimIds.contains(bizDataDim.getLong("id"))) continue;
            responseMap.put("key_result_error_msg", HPDIResMgrBusiness.getMsgOfBizDataDimNoPerm());
            responseMap.put("key_present_error_msg", PresentErrorEnum.OTHER.getCode());
            responses.put(entry.getString("bizdatacode"), responseMap);
        }
    }
}

