/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.bizdata.filter;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hpdi.business.bizdata.enums.PresentErrorEnum;
import kd.swc.hpdi.business.bizdata.filter.BizDataCommonFilter;
import kd.swc.hpdi.business.bizdata.filter.IBizDataFilter;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import org.apache.commons.collections.MapUtils;

public class BizDataEffectiveDataUseFilter
implements IBizDataFilter {
    private static final Log logger = LogFactory.getLog(BizDataEffectiveDataUseFilter.class);

    @Override
    public void doFilter(Map<String, Object> queryMap, List<DynamicObject> bizDataList, IBizDataFilter filter, Map<String, Map<String, Object>> responses) {
        this.doFilterCore(queryMap, bizDataList, responses);
        filter.doFilter(queryMap, bizDataList, filter, responses);
    }

    private void doFilterCore(Map<String, Object> queryMap, List<DynamicObject> bizDataList, Map<String, Map<String, Object>> responses) {
        Map relationDataMap = (Map)queryMap.get("relationDataMap");
        if (SWCObjectUtils.isEmpty((Object)relationDataMap)) {
            return;
        }
        ArrayList<Map<String, Object>> bizDataCodeList = new ArrayList<Map<String, Object>>(10);
        for (DynamicObject bizData : bizDataList) {
            String key = bizData.getLong("bizitem.id") + "_" + bizData.getLong("empposorgrel.id");
            DynamicObject relationData = (DynamicObject)relationDataMap.get(key);
            if (SWCObjectUtils.isEmpty((Object)relationData)) continue;
            HashMap<String, Object> bizDataCodeMap = new HashMap<String, Object>(4);
            bizDataCodeMap.put("bizdatacode", relationData.getString("bizdatacode"));
            bizDataCodeMap.put("bizitemid", bizData.getLong("bizitem.id"));
            bizDataCodeList.add(bizDataCodeMap);
        }
        boolean isSkip = false;
        Map<String, Object> salaryPeriodMap = null;
        try {
            salaryPeriodMap = BizDataHelper.getSalaryPeriod(bizDataCodeList);
        }
        catch (KDBizException exception) {
            logger.error("BizDataEffectiveDataUseFilter-doFilter:getSalaryPeriod exception. Exception:", (Throwable)exception);
            BizDataCommonFilter.setErrorMsgWhenQuerySalaryPeriodException(bizDataList, responses);
            isSkip = true;
        }
        if (!isSkip) {
            this.validatePeriod(salaryPeriodMap, bizDataList, responses);
        }
    }

    private void validatePeriod(Map<String, Object> salaryPeriodMap, List<DynamicObject> bizDataList, Map<String, Map<String, Object>> responses) {
        if (MapUtils.isNotEmpty(salaryPeriodMap) && salaryPeriodMap.get("periodResult") instanceof Map) {
            Map bizDataCodePeriod = (Map)salaryPeriodMap.get("periodResult");
            logger.info(MessageFormat.format("BizDataEffectiveDataUseFilter-validatePeriod:bizDataCodePeriod is", bizDataCodePeriod.keySet()));
            if (MapUtils.isEmpty((Map)bizDataCodePeriod)) {
                return;
            }
            String response = ResManager.loadKDString((String)"\u5173\u8054\u539f\u4e1a\u52a1\u6570\u636e\u85aa\u8d44\u671f\u95f4\u5df2\u88ab\u4f7f\u7528", (String)"BizDataEffectiveDataUseFilter_0", (String)"swc-hpdi-business", (Object[])new Object[0]);
            for (DynamicObject bizData : bizDataList) {
                Date periodEndDate;
                Date effectiveDate;
                String bizDataCode = bizData.getString("bizdatacode");
                DynamicObject period = (DynamicObject)bizDataCodePeriod.get(bizDataCode);
                if (SWCObjectUtils.isEmpty((Object)period) || (effectiveDate = bizData.getDate("effectivedate")).after(periodEndDate = period.getDate("enddate"))) continue;
                HashMap<String, String> responseMap = new HashMap<String, String>(4);
                responseMap.put("key_result_error_msg", response);
                responseMap.put("key_present_error_msg", PresentErrorEnum.OTHER.getCode());
                responses.put(bizDataCode, responseMap);
            }
        }
    }
}

