/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.bizdata.filter;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.bizdata.filter.IBizDataFilter;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import org.apache.commons.collections.MapUtils;

public class BizDataFilterChain
implements IBizDataFilter {
    private static Log logger = LogFactory.getLog(BizDataFilterChain.class);
    private int index = 0;
    private List<IBizDataFilter> filterList = new ArrayList<IBizDataFilter>();

    @Override
    public void doFilter(Map<String, Object> queryMap, List<DynamicObject> bizDataList, IBizDataFilter filter, Map<String, Map<String, Object>> responses) {
        if (CollectionUtils.isEmpty(this.filterList) || this.index >= this.filterList.size()) {
            return;
        }
        Iterator<DynamicObject> bizDataBillEntriesIterator = bizDataList.iterator();
        while (bizDataBillEntriesIterator.hasNext()) {
            DynamicObject bizDataBillEntry = bizDataBillEntriesIterator.next();
            String bizDataCode = bizDataBillEntry.getString("bizdatacode");
            Map<String, Object> responseMap = responses.get(bizDataCode);
            if (!MapUtils.isNotEmpty(responseMap) || responseMap.get("key_result_error_msg") == null) continue;
            bizDataBillEntriesIterator.remove();
        }
        if (SWCListUtils.isEmpty(bizDataList)) {
            return;
        }
        IBizDataFilter filterNext = this.filterList.get(this.index++);
        Date beginTime = new Date();
        filterNext.doFilter(queryMap, bizDataList, filter, responses);
        Date endTime = new Date();
        long diff = endTime.getTime() - beginTime.getTime();
        if (diff >= 200L) {
            logger.info("{}...longdealtime...diff={}...begin={}...end={}", new Object[]{filterNext.getClass().getName(), diff, SWCDateTimeUtils.format((Date)beginTime, (String)"yyyy-MM-dd HH:mm:ss:SSSS"), SWCDateTimeUtils.format((Date)endTime, (String)"yyyy-MM-dd HH:mm:ss:SSSS")});
        }
    }

    public void addFilter(IBizDataFilter filter) {
        this.filterList.add(filter);
    }
}

