/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.bizdata.filter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.swc.hpdi.business.HPDIResMgrBusiness;
import kd.swc.hpdi.business.bizdata.enums.PresentErrorEnum;
import kd.swc.hpdi.business.bizdata.filter.IBizDataFilter;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hsbp.common.enums.BizDataOperateEnum;
import kd.swc.hsbp.common.util.SWCArrayUtils;

public class BizDataOperateFilter
implements IBizDataFilter {
    @Override
    public void doFilter(Map<String, Object> queryMap, List<DynamicObject> bizDataList, IBizDataFilter filter, Map<String, Map<String, Object>> responses) {
        List bizDataCodes = bizDataList.stream().map(bizData -> bizData.getString("bizdatacode")).collect(Collectors.toList());
        QFilter logFilter = new QFilter("bizdatacode", "in", bizDataCodes);
        logFilter.and("operatetype", "=", (Object)BizDataOperateEnum.OPERATE_TRANS_SALARYFILE.getCode());
        Object[] bizDataOperateLogArr = HPDIDataServiceHelper.HPDI_BIZDATAOPERATELOG_HELPER.query("id, bizdatacode", new QFilter[]{logFilter});
        if (!SWCArrayUtils.isEmpty((Object[])bizDataOperateLogArr)) {
            Set bizDataCodeSet = Arrays.stream(bizDataOperateLogArr).map(dy -> dy.getString("bizdatacode")).collect(Collectors.toSet());
            for (DynamicObject bizData2 : bizDataList) {
                if (!bizDataCodeSet.contains(bizData2.getString("bizdatacode"))) continue;
                HashMap<String, String> responseMap = new HashMap<String, String>(16);
                responseMap.put("key_result_error_msg", HPDIResMgrBusiness.getMsgOfBizDataHasModified());
                responseMap.put("key_present_error_msg", PresentErrorEnum.OTHER.getCode());
                responses.put(bizData2.getString("bizdatacode"), responseMap);
            }
        }
        filter.doFilter(queryMap, bizDataList, filter, responses);
    }
}

