/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.bizdata.filter;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hpdi.business.bizdata.filter.BizDataCommonFilter;
import kd.swc.hpdi.business.bizdata.filter.IBizDataFilter;
import kd.swc.hpdi.common.constants.BizDataConstants;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;

public class BizDataTransSalaryCODFilter
implements IBizDataFilter {
    private static Log logger = LogFactory.getLog(BizDataTransSalaryCODFilter.class);

    @Override
    public void doFilter(Map<String, Object> queryMap, List<DynamicObject> bizDataEntries, IBizDataFilter filter, Map<String, Map<String, Object>> responses) {
        List<DynamicObject> notNormalBizDataList;
        Map<String, List<DynamicObject>> classifiedBizData;
        List<DynamicObject> normalBizDataList;
        Map paramMap = SWCSalaryParameterServiceHelper.getSalaryParam((long)BizDataConstants.CFG_ID);
        String paramVal = "";
        if (MapUtils.isNotEmpty((Map)paramMap) && paramMap.get("controltypegroup") != null) {
            paramVal = (String)paramMap.get("controltypegroup");
        }
        if (!SWCListUtils.isEmpty(normalBizDataList = (classifiedBizData = BizDataCommonFilter.classifyBizData(bizDataEntries)).get("A"))) {
            if ("0".equals(paramVal)) {
                this.doOverDue(queryMap, normalBizDataList, responses, "A");
            } else {
                BizDataCommonFilter.transSalaryCODValidate(queryMap, normalBizDataList, responses);
            }
        }
        if (!SWCListUtils.isEmpty(notNormalBizDataList = classifiedBizData.get("B"))) {
            this.doOverDue(queryMap, notNormalBizDataList, responses, "B");
        }
        filter.doFilter(queryMap, bizDataEntries, filter, responses);
    }

    private void doOverDue(Map<String, Object> queryMap, List<DynamicObject> classifiedBizData, Map<String, Map<String, Object>> responses, String type) {
        ArrayList<Map<String, Object>> payNodeTimesParams = new ArrayList<Map<String, Object>>(10);
        Map<String, Object> payNodeTimes = BizDataCommonFilter.getPayNodeTimes(queryMap, classifiedBizData, responses, payNodeTimesParams);
        if (MapUtils.isEmpty(payNodeTimes)) {
            return;
        }
        boolean isSuccess = (Boolean)payNodeTimes.get("success");
        if (!isSuccess) {
            logger.error(MessageFormat.format("BizDataTransSalaryCODFilter getPayNodeTimes() exception:{0}", payNodeTimes.get("message")));
            BizDataCommonFilter.setErrorMsgOfQueryPayNodeTimeException(classifiedBizData, responses);
            return;
        }
        Object dataObj = payNodeTimes.get("data");
        if (dataObj == null) {
            return;
        }
        JSONArray result = (JSONArray)payNodeTimes.get("data");
        if (result == null || result.isEmpty()) {
            return;
        }
        Date nowDate = new Date();
        for (DynamicObject bizData : classifiedBizData) {
            String bizDataCode = bizData.getString("bizdatacode");
            block9: for (int j = 0; j < result.size(); ++j) {
                JSONObject jsonObject = result.getJSONObject(j);
                String returnedBizDataCode = (String)jsonObject.get((Object)"id");
                if (!SWCStringUtils.equals((String)bizDataCode, (String)returnedBizDataCode)) continue;
                Object startTimeObj = jsonObject.get((Object)"starttime");
                Object endTimeObj = jsonObject.get((Object)"endtime");
                switch (type) {
                    case "A": {
                        if (!(endTimeObj instanceof Date) || !nowDate.after((Date)endTimeObj)) continue block9;
                        bizData.set("overdue", (Object)"C");
                        continue block9;
                    }
                    case "B": {
                        if (startTimeObj instanceof Date && nowDate.before((Date)startTimeObj)) {
                            bizData.set("overdue", (Object)"B");
                        }
                        if (!(endTimeObj instanceof Date)) continue block9;
                        if (bizData.getDate("createtime").after((Date)endTimeObj)) {
                            bizData.set("overdue", (Object)"A");
                            continue block9;
                        }
                        if (!nowDate.after((Date)endTimeObj)) continue block9;
                        bizData.set("overdue", (Object)"C");
                        continue block9;
                    }
                }
            }
        }
    }
}

