/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.bizdata.filter;

import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.swc.hpdi.business.bizdata.filter.BizDataCommonFilter;
import kd.swc.hpdi.business.bizdata.filter.IBizDataFilter;
import kd.swc.hpdi.business.bizdata.filter.IBizDataFilterRequest;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class BizDataUpdateCODFilter
implements IBizDataFilter,
IBizDataFilterRequest {
    private static final Log logger = LogFactory.getLog(BizDataUpdateCODFilter.class);

    @Override
    public void doFilter(Map<String, Object> queryMap, List<DynamicObject> bizDataList, IBizDataFilter filter, Map<String, Map<String, Object>> responses) {
        Map<Long, List<DynamicObject>> bizItemGroupMap = bizDataList.stream().collect(Collectors.groupingBy(bizData -> bizData.getLong("bizitemgroup.id")));
        for (List<DynamicObject> classifiedBizDataList : bizItemGroupMap.values()) {
            DynamicObject bizItemGroup = classifiedBizDataList.get(0).getDynamicObject("bizitemgroup");
            logger.info(MessageFormat.format("BizDataUpdateCODFilter bizItemGroupId is:{0}", bizItemGroup == null ? "null" : Long.valueOf(bizItemGroup.getLong("id"))));
            queryMap.put("bizitemgroup", bizItemGroup);
            queryMap.put("BizDataUpdateCODFilter_expirydate", this.getDateByUpdateType(classifiedBizDataList));
            BizDataCommonFilter.validateCOD(queryMap, bizDataList, responses);
        }
        filter.doFilter(queryMap, bizDataList, filter, responses);
    }

    @Override
    public Map<String, Object> getQueryMap(List<DynamicObject> bizDataList) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>(1);
        queryMap.put("billtype", "2");
        return queryMap;
    }

    private Map<String, Date> getDateByUpdateType(List<DynamicObject> bizDataList) {
        ArrayList bizDataCodes = new ArrayList(bizDataList.size());
        bizDataList.forEach(bizData -> bizDataCodes.add(bizData.getString("bizdatacode")));
        QFilter bizDataCodeFilter = new QFilter("bizdatacode", "in", bizDataCodes);
        QFilter typeFilter = new QFilter("billtype", "=", (Object)"1");
        DynamicObjectCollection bizDataListFromDB = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.queryOriginalCollection("id,bizdatacode,expirydate", new QFilter[]{bizDataCodeFilter, typeFilter});
        if (CollectionUtils.isEmpty((Collection)bizDataListFromDB)) {
            return new HashMap<String, Date>(1);
        }
        Map bizDataMap = bizDataListFromDB.stream().collect(Collectors.toMap(bizData -> bizData.getString("bizdatacode"), Function.identity(), (key1, key2) -> key1));
        HashMap bizDataCodeAndDateMap = Maps.newHashMapWithExpectedSize((int)bizDataList.size());
        for (DynamicObject bizData2 : bizDataList) {
            String bizDataCode = bizData2.getString("bizdatacode");
            DynamicObject bizDataFromDB = (DynamicObject)bizDataMap.get(bizDataCode);
            Date expiryDateFromDB = bizDataFromDB.getDate("expirydate");
            Date expiryDate = bizData2.getDate("expirydate");
            Date newExpiryDate = expiryDate == null ? null : (expiryDateFromDB == null || expiryDate.before(expiryDateFromDB) ? SWCDateTimeUtils.addDay((Date)expiryDate, (long)1L) : SWCDateTimeUtils.addDay((Date)expiryDateFromDB, (long)1L));
            bizDataCodeAndDateMap.put(bizDataCode, newExpiryDate);
        }
        return bizDataCodeAndDateMap;
    }
}

