/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.bizdata.filter;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hpdi.business.bizdata.filter.IBizDataFilter;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hpdi.business.util.HPDIServiceUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import org.apache.commons.collections.MapUtils;

public class BizDataUsedFilter
implements IBizDataFilter {
    private static final Log logger = LogFactory.getLog(BizDataUsedFilter.class);

    @Override
    public void doFilter(Map<String, Object> queryMap, List<DynamicObject> bizDataList, IBizDataFilter filter, Map<String, Map<String, Object>> responses) {
        List resultList;
        List haveUsagePeriodList;
        Map<String, Object> responseMap;
        ArrayList bizDataIds = new ArrayList(bizDataList.size());
        bizDataList.forEach(bizData -> bizDataIds.add(bizData.getLong("id")));
        QFilter qFilter = new QFilter("id", "in", bizDataIds);
        DynamicObject[] rollBackBizDataArray = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.query("bizdatacode,bizitem", new QFilter[]{qFilter});
        ArrayList<HashMap> paramList = new ArrayList<HashMap>(rollBackBizDataArray.length);
        for (DynamicObject rollBackBizData : rollBackBizDataArray) {
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)2);
            paramMap.put("bizdatacode", rollBackBizData.getString("bizdatacode"));
            paramMap.put("bizitemid", rollBackBizData.getLong("bizitem.id"));
            paramList.add(paramMap);
        }
        HashMap reqMap = Maps.newHashMapWithExpectedSize((int)2);
        reqMap.put("opsystem", "hpdi");
        reqMap.put("data", paramList);
        try {
            responseMap = HPDIServiceUtils.queryUsageCount(reqMap);
        }
        catch (KDBizException exception) {
            logger.error("BizDataUsedFilter queryUsageCount() exception:", (Throwable)exception);
            throw new KDBizException((Throwable)exception, new ErrorCode("", exception.getMessage()), new Object[0]);
        }
        logger.info("hpdi-BizDataUsedFilter queryUsageCount result is {}", (Object)JSON.toJSONString(responseMap));
        if (MapUtils.isNotEmpty(responseMap) && responseMap.get("result") != null && !SWCListUtils.isEmpty(haveUsagePeriodList = (resultList = (List)responseMap.get("result")).stream().filter(map -> {
            Object usagePeriod = map.get("usageperiod");
            return !(usagePeriod instanceof Integer) || (Integer)usagePeriod != -1;
        }).collect(Collectors.toList()))) {
            Map<Object, Object> usageCountMap = haveUsagePeriodList.stream().collect(Collectors.toMap(map -> map.get("bizdatacode"), map -> map.get("usagecount"), (key1, key2) -> key2));
            for (DynamicObject rollBackBizData : rollBackBizDataArray) {
                Object usageCount = usageCountMap.get(rollBackBizData.get("bizdatacode"));
                if (usageCount == null || (Integer)usageCount <= 0) continue;
                responseMap.put("key_result_error_msg", ResManager.loadKDString((String)"\u64a4\u56de\u5931\u8d25\uff1a\u53ea\u80fd\u64a4\u56de\u672a\u4f7f\u7528\u7684\u5df2\u63a8\u9001\u7b97\u85aa\u7684\u6570\u636e\u3002", (String)"BizDataUsedFilter_1", (String)"swc-hpdi-business", (Object[])new Object[0]));
                responses.put(rollBackBizData.getString("bizdatacode"), responseMap);
            }
        }
        filter.doFilter(queryMap, bizDataList, filter, responses);
    }
}

