/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.bizdata.filter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hpdi.business.bizdata.filter.IBizDataFilter;
import kd.swc.hpdi.business.helper.BizDataBillEntryHelper;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hpdi.business.helper.BizDataRelationHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import org.apache.commons.collections.CollectionUtils;

public class BizItemConflictFilter
implements IBizDataFilter {
    private static Log logger = LogFactory.getLog(BizItemConflictFilter.class);

    @Override
    public void doFilter(Map<String, Object> queryMap, List<DynamicObject> bizDataBillEntries, IBizDataFilter filter, Map<String, Map<String, Object>> responses) {
        this.doFilterCore(queryMap, bizDataBillEntries);
        filter.doFilter(queryMap, bizDataBillEntries, filter, responses);
    }

    private void doFilterCore(Map<String, Object> queryMap, List<DynamicObject> bizDataBillEntries) {
        logger.info("repeatFilte_step_1");
        Map<Long, DynamicObject> bizItemObjFromItemGroupMap = BizDataHelper.getBizItemFormBizItemGroup(queryMap, bizDataBillEntries);
        if (bizItemObjFromItemGroupMap.isEmpty()) {
            return;
        }
        DynamicObject bizDataObjRule = BizDataBillEntryHelper.getBizDataObjRuleByItemGroup((DynamicObject)queryMap.get("bizitemgroup"));
        if (SWCObjectUtils.isEmpty((Object)bizDataObjRule)) {
            return;
        }
        String matchRule = bizDataObjRule.getString("matchrule");
        ArrayList<String> waitDelRelCodes = new ArrayList<String>(10);
        ArrayList<DynamicObject> waitSaveRels = new ArrayList<DynamicObject>(10);
        if ("2".equals(matchRule)) {
            this.dealRelationDataByDim(waitDelRelCodes, waitSaveRels, queryMap, bizDataBillEntries, bizItemObjFromItemGroupMap);
        } else {
            this.dealRelationDataByEmp(waitDelRelCodes, waitSaveRels, queryMap, bizDataBillEntries, bizItemObjFromItemGroupMap);
        }
        HPDIDataServiceHelper.HPDI_BIZDATARELATION_HELPER.deleteByFilter(new QFilter[]{new QFilter("bizdatacode", "in", waitDelRelCodes)});
        HPDIDataServiceHelper.HPDI_BIZDATARELATION_HELPER.save(waitSaveRels.toArray(new DynamicObject[0]));
    }

    private void dealRelationDataByEmp(List<String> waitDelRelCodes, List<DynamicObject> waitSaveRels, Map<String, Object> queryMap, List<DynamicObject> bizDataBillEntries, Map<Long, DynamicObject> bizItemObjFromItemGroupMap) {
        HashSet<Long> empRelIds = new HashSet<Long>(16);
        HashSet<Long> itemIds = new HashSet<Long>(16);
        BizDataRelationHelper.getEmpRelsAndItems(bizDataBillEntries, empRelIds, itemIds);
        Set<String> bizDataCodes = bizDataBillEntries.stream().map(dy -> dy.getString("bizdatacode")).collect(Collectors.toSet());
        Map<String, List<DynamicObject>> submitBizDataMap = BizDataRelationHelper.getSubmitBizData(empRelIds, itemIds, null, bizDataCodes, true);
        for (int i = 0; i < bizDataBillEntries.size(); ++i) {
            DynamicObject bizDataBillEntry = bizDataBillEntries.get(i);
            String bizDataCode = bizDataBillEntry.getString("bizdatacode");
            waitDelRelCodes.add(bizDataCode);
            String empPosId = bizDataBillEntry.getString("empposorgrel.id");
            DynamicObjectCollection details = bizDataBillEntry.getDynamicObjectCollection("entryentity");
            for (DynamicObject bizItem : details) {
                DynamicObject relationDy;
                DynamicObject transformSalaryData;
                String key;
                List<DynamicObject> submitItems;
                String bizitemId = bizItem.getString("bizitem.id");
                DynamicObject bizItemObjFromItemGroup = bizItemObjFromItemGroupMap.get(bizItem.getLong("bizitem.id"));
                boolean isCycle = bizItemObjFromItemGroup.getBoolean("bizitem.cycle");
                if (!isCycle || (submitItems = submitBizDataMap.get(key = empPosId + bizitemId)) == null || submitItems.size() == 0 || SWCObjectUtils.isEmpty((Object)(transformSalaryData = submitItems.get(0))) || (relationDy = BizDataRelationHelper.setRelationShip(queryMap, transformSalaryData, bizDataBillEntry)) == null) continue;
                waitSaveRels.add(relationDy);
            }
        }
    }

    private void dealRelationDataByDim(List<String> waitDelRelCodes, List<DynamicObject> waitSaveRels, Map<String, Object> queryMap, List<DynamicObject> bizDataBillEntries, Map<Long, DynamicObject> bizItemObjFromItemGroupMap) {
        HashSet<Long> personIds = new HashSet<Long>(16);
        HashSet<Long> payrollGrpIds = new HashSet<Long>(16);
        HashSet<Long> bizItemIds = new HashSet<Long>(16);
        HashSet<String> bizDataCodes = new HashSet<String>(bizDataBillEntries.size());
        this.getEntryInfo(bizDataBillEntries, personIds, payrollGrpIds, bizItemIds, bizDataCodes);
        if (CollectionUtils.isEmpty(payrollGrpIds)) {
            waitDelRelCodes.addAll(bizDataCodes);
            return;
        }
        Map<String, List<DynamicObject>> submitBizDataMap = BizDataRelationHelper.getSubmitBizDataByDim(personIds, payrollGrpIds, bizItemIds, bizDataCodes);
        for (DynamicObject bizDataBillEnt : bizDataBillEntries) {
            String bizDataCode = bizDataBillEnt.getString("bizdatacode");
            waitDelRelCodes.add(bizDataCode);
            DynamicObject bizDataDim = bizDataBillEnt.getDynamicObject("bizdatadim");
            if (SWCObjectUtils.isEmpty((Object)bizDataDim)) continue;
            String payrollGrpId = bizDataDim.getString("payrollgroup.id");
            String personId = bizDataBillEnt.getString("empposorgrel.person.id");
            DynamicObjectCollection details = bizDataBillEnt.getDynamicObjectCollection("entryentity");
            for (DynamicObject bizItem : details) {
                DynamicObject relationDy;
                DynamicObject transformSalaryData;
                String key;
                List<DynamicObject> submitItems;
                String bizitemId = bizItem.getString("bizitem.id");
                DynamicObject bizItemObjFromItemGroup = bizItemObjFromItemGroupMap.get(bizItem.getLong("bizitem.id"));
                boolean isCycle = bizItemObjFromItemGroup.getBoolean("bizitem.cycle");
                if (!isCycle || (submitItems = submitBizDataMap.get(key = personId + payrollGrpId + bizitemId)) == null || submitItems.size() == 0 || SWCObjectUtils.isEmpty((Object)(transformSalaryData = submitItems.get(0))) || (relationDy = BizDataRelationHelper.setRelationShip(queryMap, transformSalaryData, bizDataBillEnt)) == null) continue;
                waitSaveRels.add(relationDy);
            }
        }
    }

    private void getEntryInfo(List<DynamicObject> bizDataBillEntries, Set<Long> personIds, Set<Long> payrollGrpIds, Set<Long> bizItemIds, Set<String> bizDataCodes) {
        for (DynamicObject entryEntity : bizDataBillEntries) {
            personIds.add(entryEntity.getLong("empposorgrel.person.id"));
            bizDataCodes.add(entryEntity.getString("bizdatacode"));
            DynamicObject bizDataItem = entryEntity.getDynamicObject("bizdatadim");
            if (!SWCObjectUtils.isEmpty((Object)bizDataItem)) {
                payrollGrpIds.add(bizDataItem.getLong("payrollgroup.id"));
            }
            DynamicObjectCollection bizDataDetails = entryEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject bizDataDetail : bizDataDetails) {
                bizItemIds.add(bizDataDetail.getLong("bizitem.id"));
            }
        }
    }
}

