/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.bizdata.filter;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.HPDIResMgrBusiness;
import kd.swc.hpdi.business.bizdata.enums.PresentErrorEnum;
import kd.swc.hpdi.business.bizdata.filter.IBizDataFilter;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hsbp.business.datagrade.enums.DataGradeValueTypeEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class BizItemFilter
implements IBizDataFilter {
    private static Log logger = LogFactory.getLog(BizItemFilter.class);

    @Override
    public void doFilter(Map<String, Object> queryMap, List<DynamicObject> bizDataBillEntries, IBizDataFilter filter, Map<String, Map<String, Object>> responses) {
        this.doFilterCore(queryMap, bizDataBillEntries, responses);
        filter.doFilter(queryMap, bizDataBillEntries, filter, responses);
    }

    private void doFilterCore(Map<String, Object> queryMap, List<DynamicObject> bizDataBillEntries, Map<String, Map<String, Object>> responses) {
        if (queryMap == null || SWCListUtils.isEmpty(bizDataBillEntries)) {
            return;
        }
        Map<Long, DynamicObject> bizItemObjFromItemGroupMap = BizDataHelper.getBizItemFormBizItemGroup(queryMap, bizDataBillEntries);
        DynamicObject[] bizItemObjArrayFromDB = this.getBizItemObj(bizDataBillEntries);
        Map<Long, DynamicObject> bizItemObjMap = BizItemFilter.convertBizItemsToMap(bizItemObjArrayFromDB);
        Set<Long> hasPermBizItemIds = BizDataHelper.getBizItemIdsHasPerm((Long)queryMap.get("org"), bizItemObjFromItemGroupMap.keySet());
        for (int i = 0; i < bizDataBillEntries.size(); ++i) {
            DynamicObject bizDataBillEntry = bizDataBillEntries.get(i);
            String bizDataCode = bizDataBillEntry.getString("bizdatacode");
            DynamicObjectCollection bizDataEntrys = bizDataBillEntry.getDynamicObjectCollection("entryentity");
            HashMap<String, Object> responseMap = new HashMap<String, Object>(4);
            DynamicObject currencyDyExcel = bizDataBillEntry.getDynamicObject("currency");
            this.validateIsExistsAmountItemForCurrency(currencyDyExcel, bizDataEntrys, bizItemObjMap, responseMap);
            for (DynamicObject bizDataEntry : bizDataEntrys) {
                long bizItemIdFromBillEntry = bizDataEntry.getLong("bizitem.id");
                DynamicObject bizItemObjFromDB = bizItemObjMap.get(bizItemIdFromBillEntry);
                if (bizItemObjFromDB == null) continue;
                DynamicObject bizItemObjFromItemGroup = bizItemObjFromItemGroupMap.get(bizItemIdFromBillEntry);
                if (SWCObjectUtils.isEmpty((Object)bizItemObjFromItemGroup)) {
                    logger.info("bizItemObjFromItemGroup item_not_exits");
                    responseMap.put("key_result_error_msg", HPDIResMgrBusiness.getMsgOfItemNotExist());
                    responseMap.put("key_present_error_msg", PresentErrorEnum.OTHER.getCode());
                    responses.putIfAbsent(bizDataCode, responseMap);
                    continue;
                }
                if (!hasPermBizItemIds.contains(bizItemIdFromBillEntry)) {
                    responseMap.put("key_result_error_msg", HPDIResMgrBusiness.getMsgOfBizItemNoPerm());
                    responseMap.put("key_present_error_msg", PresentErrorEnum.OTHER.getCode());
                    responses.putIfAbsent(bizDataCode, responseMap);
                    continue;
                }
                if ("1".equals(bizItemObjFromItemGroup.getString("bizitem.enable")) && "C".equals(bizItemObjFromItemGroup.getString("bizitem.status"))) {
                    this.validateExpiryDate(bizDataEntry.getString("expirydate"), responseMap, bizItemObjFromDB);
                    this.validateCurrency(currencyDyExcel, responseMap, bizItemObjFromDB);
                    this.validateValue(bizItemObjFromItemGroup, bizDataEntry, responseMap, bizItemObjFromDB, currencyDyExcel);
                    continue;
                }
                responseMap.put("key_result_error_msg", HPDIResMgrBusiness.getMsgOfBizItemNotValid(bizItemObjFromItemGroup.getString("bizitem.name")));
                responseMap.put("key_present_error_msg", PresentErrorEnum.OTHER.getCode());
            }
            if (responseMap.isEmpty()) continue;
            responses.putIfAbsent(bizDataCode, responseMap);
        }
    }

    private void validateIsExistsAmountItemForCurrency(DynamicObject currencyDyExcel, DynamicObjectCollection bizDataEntrys, Map<Long, DynamicObject> bizItemObjMap, Map<String, Object> responseMap) {
        if (SWCObjectUtils.isEmpty((Object)currencyDyExcel)) {
            return;
        }
        boolean isHasAmount = false;
        for (DynamicObject bizDataEntry : bizDataEntrys) {
            boolean isAmount;
            long bizItemIdFromBillEntry = bizDataEntry.getLong("bizitem.id");
            DynamicObject bizItemObjFromDB = bizItemObjMap.get(bizItemIdFromBillEntry);
            if (bizItemObjFromDB == null || !(isAmount = DataGradeValueTypeEnum.AMOUNT.getCode().equals(bizItemObjFromDB.getString("datatype.number")))) continue;
            isHasAmount = true;
            break;
        }
        if (!isHasAmount) {
            responseMap.put("key_result_error_msg", ResManager.loadKDString((String)"\u975e\u91d1\u989d\u7c7b\u7684\u9879\u76ee\uff0c\u4e0d\u80fd\u6307\u5b9a\u5e01\u79cd", (String)"BizItemFilter_14", (String)"swc-hpdi-business", (Object[])new Object[0]));
            responseMap.put("key_present_error_msg", PresentErrorEnum.OTHER.getCode());
        }
    }

    private static Map<Long, DynamicObject> convertBizItemsToMap(DynamicObject[] bizItems) {
        return Arrays.asList(bizItems).stream().collect(Collectors.toMap(bu -> bu.getLong("id"), bu -> bu, (k1, k2) -> k1));
    }

    private void validateCurrency(DynamicObject currencyDyExcel, Map<String, Object> responseMap, DynamicObject bizItemObjFromDB) {
        if (!responseMap.isEmpty() || SWCObjectUtils.isEmpty((Object)bizItemObjFromDB)) {
            return;
        }
        boolean isAmount = DataGradeValueTypeEnum.AMOUNT.getCode().equals(bizItemObjFromDB.getString("datatype.number"));
        if (!isAmount) {
            return;
        }
        DynamicObjectCollection currencyObjs = bizItemObjFromDB.getDynamicObjectCollection("currency");
        if (!CollectionUtils.isEmpty((Collection)currencyObjs)) {
            ArrayList currencyList = new ArrayList();
            currencyObjs.stream().forEach(currencyObj -> currencyList.add((Long)currencyObj.get("fbasedataid_id")));
            if (!SWCObjectUtils.isEmpty((Object)currencyDyExcel)) {
                Long currencyId = currencyDyExcel.getLong("id");
                if (!currencyList.contains(currencyId)) {
                    responseMap.put("key_result_error_msg", ResManager.loadKDString((String)"\u9879\u76ee\u5e01\u79cd\u4e0d\u7b26\u5408\u53ef\u8f93\u5165\u5e01\u79cd\u8981\u6c42", (String)"BizItemFilter_12", (String)"swc-hpdi-business", (Object[])new Object[0]));
                    responseMap.put("key_present_error_msg", PresentErrorEnum.OTHER.getCode());
                }
            } else {
                responseMap.put("key_result_error_msg", ResManager.loadKDString((String)"\u91d1\u989d\u7c7b\u7684\u4e1a\u52a1\u9879\u76ee\uff0c\u5e01\u79cd\u5fc5\u586b", (String)"BizItemFilter_13", (String)"swc-hpdi-business", (Object[])new Object[0]));
                responseMap.put("key_present_error_msg", PresentErrorEnum.OTHER.getCode());
            }
        } else if (SWCObjectUtils.isEmpty((Object)currencyDyExcel)) {
            responseMap.put("key_result_error_msg", ResManager.loadKDString((String)"\u91d1\u989d\u7c7b\u7684\u4e1a\u52a1\u9879\u76ee\uff0c\u5e01\u79cd\u5fc5\u586b", (String)"BizItemFilter_13", (String)"swc-hpdi-business", (Object[])new Object[0]));
            responseMap.put("key_present_error_msg", PresentErrorEnum.OTHER.getCode());
        }
    }

    private DynamicObject[] getBizItemObj(List<DynamicObject> bizDataBillEntries) {
        ArrayList bizItemIds = new ArrayList(bizDataBillEntries.size());
        bizDataBillEntries.forEach(data -> {
            DynamicObjectCollection bizDataEntrys = data.getDynamicObjectCollection("entryentity");
            for (DynamicObject bizDataEntry : bizDataEntrys) {
                bizItemIds.add(bizDataEntry.getLong("bizitem.id"));
            }
        });
        DynamicObject[] queryBizItems = HPDIDataServiceHelper.HSBS_BIZITEM_HELPER.query("id,currency,datatype,scalelimit,isminvalnull,ismaxvalnull,minvalue,maxvalue,earliestdate,lastdate,cycle", new QFilter[]{new QFilter("id", "in", bizItemIds)});
        return queryBizItems;
    }

    private void validateValue(DynamicObject bizItemObjFromItemGroup, DynamicObject bizDataBillEntry, Map<String, Object> responseMap, DynamicObject bizItemObjFromDB, DynamicObject currencyObj) {
        if (!responseMap.isEmpty() || SWCStringUtils.isEmpty((String)bizDataBillEntry.getString("value")) || SWCObjectUtils.isEmpty((Object)bizItemObjFromItemGroup)) {
            return;
        }
        List<String> numberTypesList = Arrays.asList(DataGradeValueTypeEnum.AMOUNT.getCode(), DataGradeValueTypeEnum.DECIMAL.getCode(), DataGradeValueTypeEnum.INTEGER.getCode());
        List<String> notMoneyTypeList = Arrays.asList(DataGradeValueTypeEnum.DECIMAL.getCode(), DataGradeValueTypeEnum.INTEGER.getCode());
        if (bizItemObjFromDB == null || bizItemObjFromDB.getString("datatype.number") == null) {
            return;
        }
        String dataType = bizItemObjFromDB.getString("datatype.number");
        if (numberTypesList.contains(dataType)) {
            BigDecimal value = this.parseValueToDecimal(bizDataBillEntry, responseMap);
            if (value == null) {
                return;
            }
            if (notMoneyTypeList.contains(dataType) && this.validateMaxMin(bizItemObjFromItemGroup, responseMap, bizItemObjFromDB, value)) {
                return;
            }
            this.validateAccuracy(bizDataBillEntry, bizItemObjFromDB, responseMap, currencyObj);
        } else if (DataGradeValueTypeEnum.DATE.getCode().equals(dataType)) {
            this.validateValueOfDate(bizItemObjFromItemGroup, bizDataBillEntry, responseMap, bizItemObjFromDB);
        } else if (DataGradeValueTypeEnum.TEXT.getCode().equals(dataType)) {
            String value = bizDataBillEntry.getString("value");
            int size = value.length();
            logger.info(MessageFormat.format("size is {0}", size));
            Integer dataLength = bizItemObjFromItemGroup.getInt("bizitem.datalength");
            logger.info(MessageFormat.format("dataLength is {0}", dataLength));
            if (dataLength != null && size > dataLength) {
                responseMap.put("key_result_error_msg", ResManager.loadKDString((String)"\u9879\u76ee\u8d85\u8fc7\u6570\u636e\u957f\u5ea6\u3002", (String)"BizItemFilter_5", (String)"swc-hpdi-business", (Object[])new Object[0]));
                responseMap.put("key_present_error_msg", PresentErrorEnum.OTHER.getCode());
            }
        }
    }

    private BigDecimal parseValueToDecimal(DynamicObject bizDataBillEntry, Map<String, Object> responseMap) {
        BigDecimal value;
        try {
            value = new BigDecimal(bizDataBillEntry.getString("value"));
        }
        catch (Exception exception) {
            responseMap.put("key_result_error_msg", ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u7b26\u5408\u4e1a\u52a1\u9879\u76ee\u201c\u6570\u636e\u7c7b\u578b\u201d\u8981\u6c42\u3002", (String)"BizItemFilter_4", (String)"swc-hpdi-business", (Object[])new Object[0]));
            responseMap.put("key_present_error_msg", PresentErrorEnum.OTHER.getCode());
            return null;
        }
        return value;
    }

    private boolean validateMaxMin(DynamicObject bizItemObjFromItemGroup, Map<String, Object> responseMap, DynamicObject bizItemObjFromDB, BigDecimal value) {
        BigDecimal maxVal;
        Boolean isMinValNull = bizItemObjFromDB.getBoolean("isminvalnull");
        Boolean isMaxValNull = bizItemObjFromDB.getBoolean("ismaxvalnull");
        BigDecimal minVal = isMinValNull != false ? null : bizItemObjFromDB.getBigDecimal("minvalue");
        BigDecimal bigDecimal = maxVal = isMaxValNull != false ? null : bizItemObjFromDB.getBigDecimal("maxvalue");
        if (!SWCObjectUtils.isEmpty((Object)bizItemObjFromItemGroup)) {
            BigDecimal submitMaxValue = bizItemObjFromItemGroup.getBigDecimal("submitmaxvalue");
            BigDecimal submitMinValue = bizItemObjFromItemGroup.getBigDecimal("submitminvalue");
            if (null != submitMinValue) {
                BigDecimal bigDecimal2 = minVal = isMinValNull != false ? submitMinValue : submitMinValue.max(minVal);
            }
            if (null != submitMaxValue) {
                BigDecimal bigDecimal3 = maxVal = isMaxValNull != false ? submitMaxValue : submitMaxValue.min(maxVal);
            }
        }
        if (!SWCObjectUtils.isEmpty((Object)minVal) && value.compareTo(minVal) < 0 || !SWCObjectUtils.isEmpty((Object)maxVal) && value.compareTo(maxVal) > 0) {
            responseMap.put("key_result_error_msg", ResManager.loadKDString((String)"\u9879\u76ee\u503c\u5e94\u7b26\u5408\u6700\u5c0f\u6700\u5927\u8f93\u5165\u503c\u8981\u6c42\u3002", (String)"BizItemFilter_2", (String)"swc-hpdi-business", (Object[])new Object[0]));
            responseMap.put("key_present_error_msg", PresentErrorEnum.OTHER.getCode());
            return true;
        }
        return false;
    }

    private void validateAccuracy(DynamicObject bizDataBillEntry, DynamicObject bizItemObjFromDB, Map<String, Object> responseMap, DynamicObject currencyObj) {
        BigDecimal value = new BigDecimal(bizDataBillEntry.getString("value"));
        int excelScale = value.stripTrailingZeros().scale();
        String dataType = bizItemObjFromDB.getString("datatype.number");
        if (DataGradeValueTypeEnum.DECIMAL.getCode().equals(dataType)) {
            int scale = this.getScale(bizItemObjFromDB);
            if (excelScale > scale) {
                responseMap.put("key_result_error_msg", MessageFormat.format(ResManager.loadKDString((String)"\u9879\u76ee\u503c\u5c0f\u6570\u4f4d\u6570\u9700\u63a7\u5236\u5728\u201c{0}\u201d\u5185\u3002", (String)"BizItemFilter_9", (String)"swc-hpdi-business", (Object[])new Object[0]), scale));
                responseMap.put("key_present_error_msg", PresentErrorEnum.OTHER.getCode());
            } else {
                String newValue = value.setScale(scale, RoundingMode.HALF_UP).toPlainString();
                bizDataBillEntry.set("value", (Object)newValue);
            }
        } else if (DataGradeValueTypeEnum.AMOUNT.getCode().equals(dataType)) {
            int scale = currencyObj.getInt("amtprecision");
            if (scale < excelScale) {
                responseMap.put("key_result_error_msg", MessageFormat.format(ResManager.loadKDString((String)"\u9879\u76ee\u503c\u9700\u63a7\u5236\u5728\u5bf9\u5e94\u5e01\u79cd\u7684\u5e01\u79cd\u7cbe\u5ea6\u8303\u56f4{0}\u5185", (String)"BizItemFilter_15", (String)"swc-hpdi-business", (Object[])new Object[0]), scale));
                responseMap.put("key_present_error_msg", PresentErrorEnum.OTHER.getCode());
            } else {
                String newValue = value.setScale(scale, RoundingMode.HALF_UP).toPlainString();
                bizDataBillEntry.set("value", (Object)newValue);
            }
        }
    }

    private int getScale(DynamicObject bizItem) {
        String scalelimit = bizItem.getString("scalelimit");
        int scale = 10;
        if (!SWCObjectUtils.isEmpty((Object)scalelimit)) {
            scale = Integer.parseInt(scalelimit);
        }
        return scale;
    }

    private void validateValueOfDate(DynamicObject bizItemObjFromItemGroup, DynamicObject bizDataBillEntry, Map<String, Object> responseMap, DynamicObject bizItemObjFromDB) {
        Date valueDate;
        String value = bizDataBillEntry.getString("value");
        try {
            valueDate = SWCDateTimeUtils.parseDate((String)value, (String)"yyyy-MM-dd");
        }
        catch (Exception exception) {
            try {
                valueDate = SWCDateTimeUtils.parseDate((String)value, (String)"yyyy/MM/dd");
            }
            catch (Exception exception2) {
                logger.info("parse_date_is_error");
                responseMap.put("key_result_error_msg", ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u7b26\u5408\u4e1a\u52a1\u9879\u76ee\u201c\u6570\u636e\u7c7b\u578b\u201d\u8981\u6c42\u3002", (String)"BizItemFilter_4", (String)"swc-hpdi-business", (Object[])new Object[0]));
                responseMap.put("key_present_error_msg", PresentErrorEnum.OTHER.getCode());
                return;
            }
        }
        if (valueDate == null) {
            return;
        }
        String valueStr = SWCDateTimeUtils.format((Date)valueDate, (String)"yyyy-MM-dd");
        bizDataBillEntry.set("value", (Object)valueStr);
        Date itemMinDate = bizItemObjFromDB.getDate("earliestdate");
        Date itemMaxDate = bizItemObjFromDB.getDate("lastdate");
        if (!SWCObjectUtils.isEmpty((Object)bizItemObjFromItemGroup)) {
            Date submitStartDate = bizItemObjFromItemGroup.getDate("submitstartdate");
            Date submitEndDate = bizItemObjFromItemGroup.getDate("submitenddate");
            itemMinDate = BizDataHelper.getMaxDate(itemMinDate, submitStartDate);
            itemMaxDate = BizDataHelper.getMinDate(itemMaxDate, submitEndDate);
        }
        if (!SWCObjectUtils.isEmpty((Object)itemMinDate) && valueDate.before(itemMinDate)) {
            responseMap.put("key_result_error_msg", ResManager.loadKDString((String)"\u9879\u76ee\u503c\u5e94\u7b26\u5408\u6700\u65e9\u6700\u665a\u65e5\u671f\u8981\u6c42\u3002", (String)"BizItemFilter_3", (String)"swc-hpdi-business", (Object[])new Object[0]));
            responseMap.put("key_present_error_msg", PresentErrorEnum.OTHER.getCode());
            return;
        }
        if (!SWCObjectUtils.isEmpty((Object)itemMaxDate) && valueDate.after(itemMaxDate)) {
            responseMap.put("key_result_error_msg", ResManager.loadKDString((String)"\u9879\u76ee\u503c\u5e94\u7b26\u5408\u6700\u65e9\u6700\u665a\u65e5\u671f\u8981\u6c42\u3002", (String)"BizItemFilter_3", (String)"swc-hpdi-business", (Object[])new Object[0]));
            responseMap.put("key_present_error_msg", PresentErrorEnum.OTHER.getCode());
        }
    }

    private void validateExpiryDate(String expiryDateExcel, Map<String, Object> responseMap, DynamicObject bizItemObjFromDB) {
        if (SWCStringUtils.isEmpty((String)expiryDateExcel)) {
            return;
        }
        if (!responseMap.isEmpty() || SWCObjectUtils.isEmpty((Object)bizItemObjFromDB)) {
            return;
        }
        boolean isCycle = "1".equals(bizItemObjFromDB.getString("cycle"));
        if (!isCycle) {
            responseMap.put("key_result_error_msg", ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u8f93\u5165\u5931\u8d25\uff1a\u975e\u5faa\u73af\u4e1a\u52a1\u9879\u76ee\u3002", (String)"BizItemFilter_11", (String)"swc-hpdi-business", (Object[])new Object[0]));
            responseMap.put("key_present_error_msg", PresentErrorEnum.OTHER.getCode());
        }
    }
}

