/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.bizdata.filter;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hpdi.business.bizdata.enums.PresentErrorEnum;
import kd.swc.hpdi.business.bizdata.filter.IBizDataFilter;
import kd.swc.hpdi.business.helper.BizDataBillEntryHelper;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hpdi.business.helper.BizDataRelationHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;

public class BizItemRepeatFilter
implements IBizDataFilter {
    private static final String[] EXCLUDE_BILL_STATUS_ARR = new String[]{"C", "E", "F"};
    private static final String[] EXCLUDE_BIZ_DATA_STATUS_ARR = new String[]{"5", "6"};
    private static Log logger = LogFactory.getLog(BizItemRepeatFilter.class);

    @Override
    public void doFilter(Map<String, Object> queryMap, List<DynamicObject> bizDataBillEntries, IBizDataFilter filter, Map<String, Map<String, Object>> responses) {
        this.doFilterCore(queryMap, bizDataBillEntries, responses);
        filter.doFilter(queryMap, bizDataBillEntries, filter, responses);
    }

    private void doFilterCore(Map<String, Object> queryMap, List<DynamicObject> bizDataBillEntries, Map<String, Map<String, Object>> responses) {
        logger.info("BizItemRepeatFilter_step_1");
        Map<Long, DynamicObject> bizItemObjFromItemGroupMap = BizDataHelper.getBizItemFormBizItemGroup(queryMap, bizDataBillEntries);
        if (bizItemObjFromItemGroupMap.isEmpty()) {
            return;
        }
        DynamicObject bizDataBill = BizDataBillEntryHelper.getBizDataBillById(bizDataBillEntries.get(0).getLong("bizdatabillid"));
        HashSet<Long> empRelIds = new HashSet<Long>(16);
        HashSet<Long> itemIds = new HashSet<Long>(16);
        BizDataRelationHelper.getEmpRelsAndItems(bizDataBillEntries, empRelIds, itemIds);
        HashSet<Long> calperiodIds = new HashSet<Long>(16);
        Object calperiodDy = queryMap.get("calperiod");
        if (calperiodDy instanceof DynamicObject) {
            calperiodIds.add(((DynamicObject)queryMap.get("calperiod")).getLong("id"));
        } else {
            logger.error("BizItemRepeatFilter_step_1 queryMap has not calperiod.");
        }
        Set<String> bizDataCodes = bizDataBillEntries.stream().map(dy -> dy.getString("bizdatacode")).collect(Collectors.toSet());
        Map<String, Object> unSubmitBizDataResult = this.getUnSubmitBizData(empRelIds, itemIds);
        Map unSubmitBizDataMap = (Map)unSubmitBizDataResult.get("unSubmitBizDataMap");
        Map unSubmitBizDataBillMap = (Map)unSubmitBizDataResult.get("unSubmitBizDataBillMap");
        Map<String, List<DynamicObject>> submitBizDataMap = BizDataRelationHelper.getSubmitBizData(empRelIds, itemIds, calperiodIds, bizDataCodes, false);
        HashMap<String, Integer> itemBatchNumMap = new HashMap<String, Integer>(16);
        for (int i = 0; i < bizDataBillEntries.size(); ++i) {
            DynamicObject bizDataBillEntry = bizDataBillEntries.get(i);
            String bizDataCode = bizDataBillEntry.getString("bizdatacode");
            DynamicObjectCollection details = bizDataBillEntry.getDynamicObjectCollection("entryentity");
            String empPosId = bizDataBillEntry.getString("empposorgrel.id");
            for (DynamicObject bizItem : details) {
                String bizitemId = bizItem.getString("bizitem.id");
                String key = empPosId + bizitemId;
                Integer itemNum = (Integer)itemBatchNumMap.get(key);
                if (itemNum == null) {
                    itemNum = 1;
                } else {
                    Integer n = itemNum;
                    Integer n2 = itemNum = Integer.valueOf(itemNum + 1);
                }
                itemBatchNumMap.put(key, itemNum);
                DynamicObject bizItemObjFromItemGroup = bizItemObjFromItemGroupMap.get(bizItem.getLong("bizitem.id"));
                boolean isCycle = bizItemObjFromItemGroup.getBoolean("bizitem.cycle");
                boolean isMultiInput = bizItemObjFromItemGroup.getBoolean("bizitem.multipleinput");
                List unSubmitItems = (List)unSubmitBizDataMap.get(key);
                List<DynamicObject> submitItems = submitBizDataMap.get(key);
                HashMap<String, Object> responseMap = new HashMap<String, Object>(4);
                if (!isCycle && !isMultiInput) {
                    this.validateNotCycleNotMultiInput(responseMap, bizDataBill, unSubmitItems, submitItems, unSubmitBizDataBillMap, itemNum);
                }
                if (!isCycle && isMultiInput) {
                    this.validateNotCycleMultiInput(responseMap, bizDataBill, unSubmitItems, submitItems, unSubmitBizDataBillMap, bizItemObjFromItemGroup, itemNum);
                }
                if (isCycle) {
                    this.validateCycle(bizItem, responseMap, unSubmitItems, submitItems);
                }
                if (responseMap.isEmpty()) continue;
                responses.putIfAbsent(bizDataCode, responseMap);
            }
        }
    }

    private void validateCycle(DynamicObject bizItem, Map<String, Object> responseMap, List<DynamicObject> unSubmitItems, List<DynamicObject> submitItems) {
        String bizDataBillErrorMsg = ResManager.loadKDString((String)"\u9488\u5bf9\u540c\u4e00\u4eba\u5458\u4efb\u804c\u540c\u4e00\u5faa\u73af\u9879\u7684\u4e1a\u52a1\u6570\u636e\uff0c\u4e0d\u80fd\u5728\u6700\u65b0\u4e1a\u52a1\u6570\u636e\u7684\u751f\u6548\u65e5\u671f\u524d\uff0c\u6216\u751f\u5931\u6548\u65e5\u671f\u4e2d\u95f4\u63d2\u5165\u3002\u4e1a\u52a1\u6570\u636e\u8bc6\u522b\u53f7\uff1a{0}\u3002", (String)"BizItemRepeatFilter_3", (String)"swc-hpdi-business", (Object[])new Object[0]);
        Map<String, Object> newItemMap = this.getNewItem(bizItem, unSubmitItems, submitItems);
        if (newItemMap == null || newItemMap.isEmpty()) {
            return;
        }
        Date excelEffectDate = bizItem.getDate("effectivedate");
        Date excelExpiryDate = bizItem.getDate("expirydate");
        Date newEffectDate = (Date)newItemMap.get("effectivedate");
        Date newExpiryDate = (Date)newItemMap.get("expirydate");
        if (excelEffectDate.compareTo(newEffectDate) <= 0) {
            responseMap.put("key_result_error_msg", MessageFormat.format(bizDataBillErrorMsg, newItemMap.get("bizdatacode")));
            responseMap.put("key_present_error_msg", PresentErrorEnum.OTHER.getCode());
        }
        if (excelEffectDate.compareTo(newEffectDate) > 0 && (newExpiryDate == null && excelExpiryDate != null || newExpiryDate != null && excelExpiryDate != null && excelExpiryDate.before(newExpiryDate))) {
            logger.info("excelEffectDate_after_transSalaryDate_and_contain");
            responseMap.put("key_result_error_msg", MessageFormat.format(bizDataBillErrorMsg, newItemMap.get("bizdatacode")));
            responseMap.put("key_present_error_msg", PresentErrorEnum.OTHER.getCode());
        }
    }

    private Map<String, Object> getNewItem(DynamicObject bizItem, List<DynamicObject> unSubmitItems, List<DynamicObject> submitItems) {
        HashMap<String, Object> newItemMap = new HashMap<String, Object>(4);
        DynamicObject unSubmitNewItem = null;
        DynamicObject submitNewItem = null;
        if (unSubmitItems != null && unSubmitItems.size() >= 1) {
            unSubmitNewItem = unSubmitItems.get(0);
        }
        if (submitItems != null && submitItems.size() >= 1) {
            submitNewItem = submitItems.get(0);
        }
        if (unSubmitNewItem != null && submitNewItem == null) {
            this.getEffectiveDateForUnSubmit(newItemMap, unSubmitNewItem, bizItem);
        }
        if (unSubmitNewItem == null && submitNewItem != null) {
            this.getEffectiveDateForSubmit(newItemMap, submitNewItem);
        }
        if (unSubmitNewItem != null && submitNewItem != null) {
            DynamicObject bizDataEntItem = this.getBizDataEntItem(unSubmitNewItem, bizItem.getLong("bizitem.id"));
            if (bizDataEntItem != null && bizDataEntItem.getDate("effectivedate").compareTo(submitNewItem.getDate("effectivedate")) > 0) {
                this.getEffectiveDateForUnSubmit(newItemMap, unSubmitNewItem, bizItem);
            } else {
                this.getEffectiveDateForSubmit(newItemMap, submitNewItem);
            }
        }
        return newItemMap;
    }

    private void getEffectiveDateForSubmit(Map<String, Object> newItemMap, DynamicObject submitNewItem) {
        newItemMap.put("bizdatacode", submitNewItem.get("bizdatacode"));
        newItemMap.put("effectivedate", submitNewItem.get("effectivedate"));
        newItemMap.put("expirydate", submitNewItem.get("expirydate"));
    }

    private void getEffectiveDateForUnSubmit(Map<String, Object> newItemMap, DynamicObject unSubmitNewItem, DynamicObject bizItem) {
        DynamicObject bizDataEntItem = this.getBizDataEntItem(unSubmitNewItem, bizItem.getLong("bizitem.id"));
        if (bizDataEntItem != null) {
            newItemMap.put("bizdatacode", unSubmitNewItem.get("bizdatacode"));
            newItemMap.put("effectivedate", bizDataEntItem.get("effectivedate"));
            newItemMap.put("expirydate", bizDataEntItem.get("expirydate"));
        }
    }

    private DynamicObject getBizDataEntItem(DynamicObject bizDataEnt, Long bizItemId) {
        DynamicObjectCollection bizDataDetails = bizDataEnt.getDynamicObjectCollection("entryentity");
        for (DynamicObject bizDataDetail : bizDataDetails) {
            Long bizItemIdTmp = bizDataDetail.getLong("bizitem.id");
            if (bizItemIdTmp.compareTo(bizItemId) != 0) continue;
            return bizDataDetail;
        }
        return null;
    }

    private void validateNotCycleMultiInput(Map<String, Object> responseMap, DynamicObject bizDataBill, List<DynamicObject> unSubmitItems, List<DynamicObject> submitItems, Map<Long, DynamicObject> unSubmitBizDataBillMap, DynamicObject bizItemObj, Integer itemNum) {
        String bizDataErrorMsgBatch = ResManager.loadKDString((String)"\u5728\u4e1a\u52a1\u6570\u636e\u751f\u6548\u65e5\u671f\u6240\u5728\u85aa\u8d44\u671f\u95f4\u5185\uff0c\u8be5\u4eba\u5458\u540c\u4e00\u4efb\u804c\u540c\u4e00\u4e1a\u52a1\u9879\u76ee\u7684\u4e1a\u52a1\u6570\u636e\u5df2\u8fbe\u5230\u63d0\u62a5\u6b21\u6570\u4e0a\u9650\uff1a{0}\u3002", (String)"BizItemRepeatFilter_6", (String)"swc-hpdi-business", (Object[])new Object[0]);
        String bizDataErrorMsg = ResManager.loadKDString((String)"\u63d0\u62a5\u5931\u8d25\uff1a\u5728\u4e1a\u52a1\u6570\u636e\u751f\u6548\u65e5\u671f\u6240\u5728\u85aa\u8d44\u671f\u95f4\u5185\uff0c\u8be5\u4eba\u5458\u540c\u4e00\u4efb\u804c\u540c\u4e00\u9879\u76ee\u7684\u4e1a\u52a1\u6570\u636e\u63d0\u62a5\u6b21\u6570\u3002\u5df2\u8fbe\u4e0a\u9650\uff08{0}\uff09\uff0c\u8bc6\u522b\u53f7{1}\u3002", (String)"BizItemRepeatFilter_1", (String)"swc-hpdi-business", (Object[])new Object[0]);
        Long billCalperiod = bizDataBill.getLong("calperiod.id");
        int fieldSize = bizItemObj.getInt("bizitem.maxinputtime");
        HashSet<String> bizDataCodes = new HashSet<String>(16);
        this.findSamePeriodUnSubmitItemData(unSubmitItems, unSubmitBizDataBillMap, billCalperiod, bizDataCodes);
        this.findSamePeriodSubmitItemData(submitItems, billCalperiod, bizDataCodes);
        int existsNum = bizDataCodes.size();
        if (existsNum + itemNum > fieldSize) {
            if (existsNum >= 1) {
                responseMap.put("key_result_error_msg", MessageFormat.format(bizDataErrorMsg, fieldSize, this.getStrs(bizDataCodes)));
                responseMap.put("key_present_error_msg", PresentErrorEnum.OUT_INPUT_TIME.getCode());
            } else {
                responseMap.put("key_result_error_msg", MessageFormat.format(bizDataErrorMsgBatch, fieldSize));
                responseMap.put("key_present_error_msg", PresentErrorEnum.OUT_INPUT_TIME.getCode());
            }
        }
    }

    private void findSamePeriodSubmitItemData(List<DynamicObject> submitItems, Long billCalperiod, Set<String> bizDataCodes) {
        if (submitItems == null) {
            return;
        }
        for (DynamicObject submitItem : submitItems) {
            Long calperiod = submitItem.getLong("calperiod.id");
            if (billCalperiod.compareTo(calperiod) != 0) continue;
            bizDataCodes.add(submitItem.getString("bizdatacode"));
        }
    }

    private void findSamePeriodUnSubmitItemData(List<DynamicObject> unSubmitItems, Map<Long, DynamicObject> unSubmitBizDataBillMap, Long billCalperiod, Set<String> bizDataCodes) {
        if (unSubmitItems == null) {
            return;
        }
        for (DynamicObject unSubmitItem : unSubmitItems) {
            Long calperiod;
            DynamicObject billDy = unSubmitBizDataBillMap.get(unSubmitItem.getLong("bizdatabillid"));
            if (billDy == null || billCalperiod.compareTo(calperiod = Long.valueOf(billDy.getLong("calperiod.id"))) != 0) continue;
            bizDataCodes.add(unSubmitItem.getString("bizdatacode"));
        }
    }

    private void validateNotCycleNotMultiInput(Map<String, Object> responseMap, DynamicObject bizDataBill, List<DynamicObject> unSubmitItems, List<DynamicObject> submitItems, Map<Long, DynamicObject> unSubmitBizDataBillMap, Integer itemNum) {
        String bizDataErrorMsgOneBatch = ResManager.loadKDString((String)"\u63d0\u62a5\u5931\u8d25\uff1a\u5728\u4e1a\u52a1\u6570\u636e\u751f\u6548\u65e5\u671f\u6240\u5728\u85aa\u8d44\u671f\u95f4\u5185\uff0c\u8be5\u4eba\u5458\u540c\u4e00\u4efb\u804c\u540c\u4e00\u9879\u76ee\u7684\u4e1a\u52a1\u6570\u636e\u5df2\u5b58\u5728\u4e14\u4e0d\u652f\u6301\u591a\u6b21\u63d0\u62a5\u3002", (String)"BizItemRepeatFilter_5", (String)"swc-hpdi-business", (Object[])new Object[0]);
        if (itemNum >= 2) {
            responseMap.put("key_result_error_msg", bizDataErrorMsgOneBatch);
            responseMap.put("key_present_error_msg", PresentErrorEnum.OUT_INPUT_TIME.getCode());
            return;
        }
        String bizDataErrorMsg = ResManager.loadKDString((String)"\u63d0\u62a5\u5931\u8d25\uff1a\u5728\u4e1a\u52a1\u6570\u636e\u751f\u6548\u65e5\u671f\u6240\u5728\u85aa\u8d44\u671f\u95f4\u5185\uff0c\u8be5\u4eba\u5458\u540c\u4e00\u4efb\u804c\u540c\u4e00\u9879\u76ee\u7684\u4e1a\u52a1\u6570\u636e\u5df2\u5b58\u5728\u4e14\u4e0d\u652f\u6301\u591a\u6b21\u63d0\u62a5\uff0c\u8bc6\u522b\u53f7{0}\u3002", (String)"BizItemRepeatFilter_7", (String)"swc-hpdi-business", (Object[])new Object[0]);
        Long billCalperiod = bizDataBill.getLong("calperiod.id");
        HashSet<String> bizDataCodes = new HashSet<String>(16);
        this.findSamePeriodUnSubmitItemData(unSubmitItems, unSubmitBizDataBillMap, billCalperiod, bizDataCodes);
        this.findSamePeriodSubmitItemData(submitItems, billCalperiod, bizDataCodes);
        if (bizDataCodes.size() >= 1) {
            responseMap.put("key_result_error_msg", MessageFormat.format(bizDataErrorMsg, this.getStrs(bizDataCodes)));
            responseMap.put("key_present_error_msg", PresentErrorEnum.OUT_INPUT_TIME.getCode());
        }
    }

    private Map<String, Object> getUnSubmitBizData(Set<Long> empRelIds, Set<Long> itemIds) {
        DynamicObject[] bizDataEnts = this.getBizDataEnts(empRelIds, itemIds);
        DynamicObject[] bizDataBillsFromDB = this.getUnSubmitBizDataBills(bizDataEnts);
        Map<Long, DynamicObject> unSubmitBizDataBillMap = Arrays.asList(bizDataBillsFromDB).stream().collect(Collectors.toMap(bu -> bu.getLong("id"), bu -> bu, (k1, k2) -> k1));
        List unSubmitbillIds = Arrays.asList(bizDataBillsFromDB).stream().map(field -> field.getLong("id")).collect(Collectors.toList());
        HashMap<String, List<DynamicObject>> unSubmitBizDataMap = new HashMap<String, List<DynamicObject>>(16);
        for (DynamicObject bizDataEnt : bizDataEnts) {
            if (!unSubmitbillIds.contains(bizDataEnt.getLong("bizdatabillid"))) continue;
            String empPosId = bizDataEnt.getString("empposorgrel.id");
            DynamicObjectCollection bizDataDetails = bizDataEnt.getDynamicObjectCollection("entryentity");
            for (DynamicObject bizDataDetail : bizDataDetails) {
                String bizitemId = bizDataDetail.getString("bizitem.id");
                String empItemKey = empPosId + bizitemId;
                this.putValueToListValueMap(unSubmitBizDataMap, bizDataEnt, empItemKey);
            }
        }
        HashMap<String, Object> unSubmitBizDataResult = new HashMap<String, Object>(2);
        unSubmitBizDataResult.put("unSubmitBizDataMap", unSubmitBizDataMap);
        unSubmitBizDataResult.put("unSubmitBizDataBillMap", unSubmitBizDataBillMap);
        return unSubmitBizDataResult;
    }

    private void putValueToListValueMap(Map<String, List<DynamicObject>> map, DynamicObject value, String mKey) {
        List<DynamicObject> valueList = map.get(mKey);
        if (valueList == null) {
            valueList = new ArrayList<DynamicObject>(10);
            map.put(mKey, valueList);
        }
        valueList.add(value);
    }

    private DynamicObject[] getUnSubmitBizDataBills(DynamicObject[] bizDataEnts) {
        Set billIds = Arrays.asList(bizDataEnts).stream().map(field -> field.getLong("bizdatabillid")).collect(Collectors.toSet());
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        qFilters.add(new QFilter("billstatus", "!=", (Object)"F"));
        qFilters.add(new QFilter("billstatus", "not in", (Object)EXCLUDE_BILL_STATUS_ARR));
        qFilters.add(new QFilter("billtype", "=", (Object)"1"));
        qFilters.add(new QFilter("id", "in", billIds));
        DynamicObject[] bizDataBillsFromDB = HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER.query("billno,calperiod,entryentity.bizitem,entryentity.effectivedate,entryentity.expirydate,entryentity.empposorgrel,entryentity.bizdatacode", qFilters.toArray(new QFilter[qFilters.size()]));
        return bizDataBillsFromDB;
    }

    private DynamicObject[] getBizDataEnts(Set<Long> empRelIds, Set<Long> itemIds) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("empposorgrel", "in", empRelIds));
        qFilters.add(new QFilter("entryentity.bizitem", "in", itemIds));
        return HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER.query(SWCHisBaseDataHelper.getSelectProperties((String)"hpdi_bizdatabillent"), qFilters.toArray(new QFilter[qFilters.size()]), "entryentity.effectivedate desc");
    }

    public String getStrs(Set<String> strs) {
        StringBuilder sb = new StringBuilder();
        for (String str : strs) {
            sb.append(str);
            sb.append(',');
        }
        return sb.substring(0, sb.length() - 1);
    }
}

