/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.bizdata.filter;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.swc.hpdi.business.HPDIResMgrBusiness;
import kd.swc.hpdi.business.bizdata.filter.IBizDataFilter;
import kd.swc.hsbp.common.util.SWCObjectUtils;

public class EffectiveDateFilter
implements IBizDataFilter {
    @Override
    public void doFilter(Map<String, Object> queryMap, List<DynamicObject> bizDataBillEntries, IBizDataFilter filter, Map<String, Map<String, Object>> responses) {
        this.doFilterCore(bizDataBillEntries, responses);
        filter.doFilter(queryMap, bizDataBillEntries, filter, responses);
    }

    private void doFilterCore(List<DynamicObject> bizDataBillEntries, Map<String, Map<String, Object>> responses) {
        for (int i = 0; i < bizDataBillEntries.size(); ++i) {
            HashMap<String, Object> responseMap;
            DynamicObject bizDataBillEntry = bizDataBillEntries.get(i);
            String bizDataCode = bizDataBillEntry.getString("bizdatacode");
            Date expiryDate = bizDataBillEntry.getDate("expirydateent");
            Date effectiveDate = bizDataBillEntry.getDate("effectivedateent");
            if (SWCObjectUtils.isEmpty((Object)effectiveDate)) {
                responseMap = new HashMap<String, Object>(4);
                responseMap.put("key_result_error_msg", HPDIResMgrBusiness.getMsgOfMustInput(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f", (String)"BizDataHorizonListExportService_21", (String)"swc-hpdi-business", (Object[])new Object[0])));
                responseMap.put("key_present_error_msg", 1);
                responses.putIfAbsent(bizDataCode, responseMap);
                continue;
            }
            if (SWCObjectUtils.isEmpty((Object)expiryDate) || SWCObjectUtils.isEmpty((Object)effectiveDate) || !effectiveDate.after(expiryDate)) continue;
            responseMap = new HashMap(4);
            responseMap.put("key_result_error_msg", ResManager.loadKDString((String)"\u201c\u751f\u6548\u65e5\u671f\u201d\u9700\u5c0f\u4e8e\u7b49\u4e8e\u201c\u5931\u6548\u65e5\u671f\u201d\u3002", (String)"EffectiveDateFilter_0", (String)"swc-hpdi-business", (Object[])new Object[0]));
            responseMap.put("key_present_error_msg", 1);
            responses.putIfAbsent(bizDataCode, responseMap);
        }
    }
}

