/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.bizdata.filter;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.bizdata.enums.PresentErrorEnum;
import kd.swc.hpdi.business.bizdata.filter.IBizDataFilter;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class ExpiryDateFilter
implements IBizDataFilter {
    @Override
    public void doFilter(Map<String, Object> queryMap, List<DynamicObject> bizDataEntries, IBizDataFilter filter, Map<String, Map<String, Object>> responses) {
        this.doFilterCore(bizDataEntries, responses);
        filter.doFilter(queryMap, bizDataEntries, filter, responses);
    }

    private void doFilterCore(List<DynamicObject> bizDataEntries, Map<String, Map<String, Object>> responses) {
        Object[] bizDataFromDB = this.getBizDataFromDB(bizDataEntries);
        if (SWCArrayUtils.isEmpty((Object[])bizDataFromDB)) {
            return;
        }
        String errorMsg = ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u6548\u65e5\u671f\u540e\uff0c\u4e0d\u80fd\u4e0e\u5df2\u63a8\u9001\u7684\u7b97\u85aa\u4e1a\u52a1\u6570\u636e\u91cd\u53e0\u3002\u4e1a\u52a1\u6570\u636e\u8bc6\u522b\u53f7\uff1a{0}\uff0c\u751f\u6548\u65e5\u671f\uff1a{1}\uff0c\u5931\u6548\u65e5\u671f\uff1a{2}\u3002", (String)"ExpiryDateFilter_0", (String)"swc-hpdi-business", (Object[])new Object[0]);
        Map<String, List<DynamicObject>> bizDataGroupingMap = this.getBizDataGroupingMap((DynamicObject[])bizDataFromDB);
        block0: for (DynamicObject bizDataEntry : bizDataEntries) {
            String bizDataCode = bizDataEntry.getString("bizdatacode");
            long empPosOrgRelId = bizDataEntry.getLong("empposorgrel.id");
            long bizItemId = bizDataEntry.getLong("bizitem.id");
            Date effectiveDate = bizDataEntry.getDate("effectivedate");
            Date expiryDate = bizDataEntry.getDate("expirydate");
            List<DynamicObject> bizDatas = bizDataGroupingMap.get(empPosOrgRelId + "" + bizItemId);
            if (CollectionUtils.isEmpty(bizDatas)) continue;
            for (DynamicObject bizData : bizDatas) {
                String bizDataCodeFromDB = bizData.getString("bizdatacode");
                Date effectiveDateFromDB = bizData.getDate("effectivedate");
                Date expiryDateFromDBOrg = bizData.getDate("expirydate");
                Date expiryDateFromDB = bizData.getDate("expirydate");
                if (expiryDateFromDB == null) {
                    expiryDateFromDB = this.getMaxDate();
                }
                if (expiryDate == null || effectiveDateFromDB.after(expiryDate) || effectiveDate.after(expiryDateFromDB)) continue;
                String response = MessageFormat.format(errorMsg, bizDataCodeFromDB, SWCDateTimeUtils.formatDate((Date)effectiveDateFromDB), expiryDateFromDBOrg == null ? "" : SWCDateTimeUtils.formatDate((Date)expiryDateFromDBOrg));
                HashMap<String, String> responseMap = new HashMap<String, String>(4);
                responseMap.put("key_result_error_msg", response);
                responseMap.put("key_present_error_msg", PresentErrorEnum.OUT_INPUT_TIME.getCode());
                responses.put(bizDataCode, responseMap);
                continue block0;
            }
        }
    }

    private Date getMaxDate() {
        Calendar ca = Calendar.getInstance();
        ca.set(2999, 11, 31, 0, 0, 0);
        return ca.getTime();
    }

    private Map<String, List<DynamicObject>> getBizDataGroupingMap(DynamicObject[] bizDataFromDB) {
        HashMap<String, List<DynamicObject>> bizDataGroupingMap = new HashMap<String, List<DynamicObject>>(16);
        for (DynamicObject bizData : bizDataFromDB) {
            String empKey = bizData.getString("empposorgrel.id") + bizData.getString("bizitem.id");
            ArrayList<DynamicObject> bizs = (ArrayList<DynamicObject>)bizDataGroupingMap.get(empKey);
            if (bizs == null) {
                bizs = new ArrayList<DynamicObject>(10);
                bizDataGroupingMap.put(empKey, bizs);
            }
            bizs.add(bizData);
        }
        return bizDataGroupingMap;
    }

    private DynamicObject[] getBizDataFromDB(List<DynamicObject> bizDataEntries) {
        HashSet empPosOrgRelIds = new HashSet(16);
        HashSet bizItemIds = new HashSet(16);
        HashSet bizDataCodes = new HashSet(16);
        bizDataEntries.forEach(bizDataEntry -> {
            empPosOrgRelIds.add(bizDataEntry.getLong("empposorgrel.id"));
            bizItemIds.add(bizDataEntry.getLong("bizitem.id"));
            bizDataCodes.add(bizDataEntry.getString("bizdatacode"));
        });
        QFilter qFilter = new QFilter("bizdatastatus", "=", (Object)"3");
        qFilter.and("billtype", "=", (Object)"1");
        qFilter.and("empposorgrel", "in", empPosOrgRelIds);
        qFilter.and("bizitem", "in", bizItemIds);
        DynamicObject[] bizDataArr = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.query("empposorgrel.id,bizitem.id,effectivedate,bizdatacode,expirydate", new QFilter[]{qFilter}, "effectivedate");
        List<DynamicObject> filterList = Arrays.stream(bizDataArr).filter(dy -> !bizDataCodes.contains(dy.getString("bizdatacode"))).collect(Collectors.toList());
        return filterList.toArray(new DynamicObject[0]);
    }
}

