/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.bizdata.filter;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.swc.hpdi.business.HPDIResMgrBusiness;
import kd.swc.hpdi.business.bizdata.enums.PresentErrorEnum;
import kd.swc.hpdi.business.bizdata.filter.IBizDataFilter;
import kd.swc.hpdi.business.bizdata.filter.IBizDataFilterRequest;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import org.apache.commons.collections4.MapUtils;

public class PeriodDateFilter
implements IBizDataFilter,
IBizDataFilterRequest {
    @Override
    public void doFilter(Map<String, Object> queryMap, List<DynamicObject> bizDataEntries, IBizDataFilter filter, Map<String, Map<String, Object>> responses) {
        Map bizDataCodePeriod;
        if (MapUtils.isNotEmpty(queryMap) && !MapUtils.isEmpty((Map)(bizDataCodePeriod = (Map)queryMap.get("periodResult")))) {
            for (int i = 0; i < bizDataEntries.size(); ++i) {
                DynamicObject bizDataBillEntry = bizDataEntries.get(i);
                String bizDataCode = bizDataBillEntry.getString("bizdatacode");
                DynamicObject period = (DynamicObject)bizDataCodePeriod.get(bizDataCode);
                if (SWCObjectUtils.isEmpty((Object)period)) continue;
                Date endDate = period.getDate("enddate");
                Date expiryDate = bizDataBillEntry.getDate("expirydate");
                if (endDate == null || expiryDate == null || expiryDate.after(endDate)) continue;
                String response = HPDIResMgrBusiness.getMsgOfUpdateExpiryDateLaterThanPeriod(period.getString("name"), SWCDateTimeUtils.formatDate((Date)endDate));
                HashMap<String, String> responseMap = new HashMap<String, String>(4);
                responseMap.put("key_result_error_msg", response);
                responseMap.put("key_present_error_msg", PresentErrorEnum.OUT_INPUT_TIME.getCode());
                responses.put(bizDataCode, responseMap);
            }
        }
        filter.doFilter(queryMap, bizDataEntries, filter, responses);
    }

    @Override
    public Map<String, Object> getQueryMap(List<DynamicObject> bizDataList) {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>(bizDataList.size());
        for (DynamicObject bizData : bizDataList) {
            HashMap bizDataCodeMap = Maps.newHashMapWithExpectedSize((int)2);
            bizDataCodeMap.put("bizdatacode", bizData.getString("bizdatacode"));
            bizDataCodeMap.put("bizitemid", bizData.getLong("bizitem.id"));
            data.add(bizDataCodeMap);
        }
        return BizDataHelper.getSalaryPeriod(data);
    }
}

