/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.bizdata.filter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hpdi.business.bizdata.filter.IBizDataFilter;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class UEDBizDataCodeFilter
implements IBizDataFilter {
    private static final Log logger = LogFactory.getLog(UEDBizDataCodeFilter.class);

    @Override
    public void doFilter(Map<String, Object> queryMap, List<DynamicObject> bizDataBillEntries, IBizDataFilter filter, Map<String, Map<String, Object>> responses) {
        this.doFilterCore(queryMap, bizDataBillEntries, responses);
        filter.doFilter(queryMap, bizDataBillEntries, filter, responses);
    }

    private void doFilterCore(Map<String, Object> queryMap, List<DynamicObject> bizDataBillEntries, Map<String, Map<String, Object>> responses) {
        String noDataMatchMsg = ResManager.loadKDString((String)"\u65e0\u6cd5\u5339\u914d\u5230\u9700\u8981\u66f4\u65b0\u7684\u4e1a\u52a1\u6570\u636e\u3002", (String)"UEDBizDataCodeFilter_1", (String)"swc-hpdi-business", (Object[])new Object[0]);
        String msg = ResManager.loadKDString((String)"\u539f\u4e1a\u52a1\u6570\u636e\u8bc6\u522b\u53f7\u4e0e\u5bfc\u5165\u7684\u4eba\u5458\u6216\u4e1a\u52a1\u9879\u76ee\u6700\u65b0\u751f\u6548\u65e5\u671f\u6570\u636e\u4e0d\u4e00\u81f4\u3002", (String)"UEDBizDataCodeFilter_2", (String)"swc-hpdi-business", (Object[])new Object[0]);
        Map bizDataNewMap = (Map)queryMap.get("bizDataNewMap");
        for (int i = 0; i < bizDataBillEntries.size(); ++i) {
            DynamicObject bizDataBillEntry = bizDataBillEntries.get(i);
            String bizDataCode = bizDataBillEntry.getString("bizdatacode");
            String originalBizDataCode = bizDataBillEntry.getString("originalbizdatacode");
            String empPosId = bizDataBillEntry.getString("empposorgrel.id");
            DynamicObjectCollection details = bizDataBillEntry.getDynamicObjectCollection("entryentity");
            for (DynamicObject bizItem : details) {
                String bizitemId = bizItem.getString("bizitem.id");
                String ebkey = empPosId + bizitemId;
                DynamicObject newBizData = (DynamicObject)bizDataNewMap.get(ebkey);
                if (newBizData == null) {
                    HashMap<String, String> responseMap = new HashMap<String, String>(3);
                    responseMap.put("key_result_error_msg", noDataMatchMsg);
                    responses.put(bizDataCode, responseMap);
                    continue;
                }
                String newBizDataCode = newBizData.getString("bizdatacode");
                if (!SWCStringUtils.isEmpty((String)originalBizDataCode) && !newBizDataCode.equals(originalBizDataCode)) {
                    HashMap<String, String> responseMap = new HashMap<String, String>(3);
                    responseMap.put("key_result_error_msg", msg);
                    responses.put(bizDataCode, responseMap);
                    continue;
                }
                this.setBizDataEntry(bizDataBillEntry, bizItem, newBizData);
            }
        }
    }

    private void setBizDataEntry(DynamicObject bizDataBillEntry, DynamicObject bizItem, DynamicObject matchedBizData) {
        bizDataBillEntry.set("effectivedateent", (Object)matchedBizData.getDate("effectivedate"));
        bizDataBillEntry.set("expirydateent", (Object)matchedBizData.getDate("expirydate"));
        bizDataBillEntry.set("currency", (Object)matchedBizData.getDynamicObject("currency"));
        bizDataBillEntry.set("remark", (Object)matchedBizData.getString("description"));
        bizDataBillEntry.set("originalbizdatacode", (Object)matchedBizData.getString("bizdatacode"));
        bizItem.set("effectivedate", (Object)matchedBizData.getDate("effectivedate"));
        bizItem.set("expirydate", (Object)matchedBizData.getDate("expirydate"));
        bizItem.set("value", (Object)matchedBizData.getString("value"));
    }
}

