/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.bizdata.filter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.swc.hpdi.business.bizdata.filter.IBizDataFilter;
import kd.swc.hpdi.business.helper.BizDataRelationHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class UEDCommPreDataFilter
implements IBizDataFilter {
    @Override
    public void doFilter(Map<String, Object> queryMap, List<DynamicObject> bizDataBillEntries, IBizDataFilter filter, Map<String, Map<String, Object>> responses) {
        this.doFilterCore(queryMap, bizDataBillEntries);
        filter.doFilter(queryMap, bizDataBillEntries, filter, responses);
    }

    private void doFilterCore(Map<String, Object> queryMap, List<DynamicObject> bizDataBillEntries) {
        DynamicObject[] bizDataArr = this.getBizData(bizDataBillEntries);
        queryMap.put("bizDataDynamicArray", bizDataArr);
        List bizDataList = Arrays.stream(bizDataArr).filter(bizData -> SWCStringUtils.equals((String)bizData.getString("bizdatastatus"), (String)"3")).collect(Collectors.toList());
        queryMap.put("bizDataDynamicList", bizDataList);
        Map<String, DynamicObject> bizDataNewMap = bizDataList.stream().collect(Collectors.toMap(it -> it.getString("empposorgrel.id") + it.getString("bizitem.id"), it -> it, (oldValue, newValue) -> oldValue));
        queryMap.put("bizDataNewMap", bizDataNewMap);
    }

    private DynamicObject[] getBizData(List<DynamicObject> bizDataBillEntries) {
        HashSet<Long> empRelIds = new HashSet<Long>(16);
        HashSet<Long> itemIds = new HashSet<Long>(16);
        BizDataRelationHelper.getEmpRelsAndItems(bizDataBillEntries, empRelIds, itemIds);
        SWCDataServiceHelper bizDataHelper = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER;
        QFilter qFilter = new QFilter("empposorgrel", "in", empRelIds);
        qFilter.and("bizitem", "in", itemIds);
        qFilter.and("bizitem.cycle", "=", (Object)"1");
        qFilter.and("bizitem.status", "=", (Object)"C");
        qFilter.and("bizitem.enable", "=", (Object)"1");
        QFilter[] qFilters = new QFilter[]{qFilter};
        return bizDataHelper.query("id,empposorgrel,bizitem,bizdatastatus,bizdatacode,effectivedate,expirydate,payrollgrp.id,salaryfile.id,currency,value,description,billtype", qFilters, "effectivedate desc");
    }
}

