/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.bizdata.filter;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hpdi.business.bizdata.filter.BizDataCommonFilter;
import kd.swc.hpdi.business.bizdata.filter.IBizDataFilter;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;

public class UEDDataCODFilter
implements IBizDataFilter {
    private static final Log logger = LogFactory.getLog(UEDDataCODFilter.class);

    @Override
    public void doFilter(Map<String, Object> queryMap, List<DynamicObject> bizDataBillEntries, IBizDataFilter filter, Map<String, Map<String, Object>> responses) {
        this.handle(queryMap, bizDataBillEntries, responses);
        filter.doFilter(queryMap, bizDataBillEntries, filter, responses);
    }

    private void handle(Map<String, Object> queryMap, List<DynamicObject> bizDataBillEntries, Map<String, Map<String, Object>> responses) {
        Object expiryDate = queryMap.get("UEDDataCODFilter_expirydate");
        if (expiryDate == null || MapUtils.isEmpty((Map)((Map)expiryDate))) {
            queryMap.put("UEDDataCODFilter_expirydate", this.getExpiryDate(queryMap, bizDataBillEntries));
        }
        queryMap.put("billtype", "3");
        BizDataCommonFilter.validateCOD(queryMap, bizDataBillEntries, responses);
    }

    private Map<String, Date> getExpiryDate(Map<String, Object> queryMap, List<DynamicObject> bizDataBillEntries) {
        HashMap<String, Date> bizDataCodeAndDateMap = new HashMap<String, Date>(16);
        List matchedBizDataList = (List)queryMap.get("bizDataDynamicList");
        if (CollectionUtils.isEmpty((Collection)matchedBizDataList)) {
            return bizDataCodeAndDateMap;
        }
        for (int i = 0; i < bizDataBillEntries.size(); ++i) {
            DynamicObject bizDataBillEntry = bizDataBillEntries.get(i);
            String bizDataCode = bizDataBillEntry.getString("bizdatacode");
            Date expiryDate = bizDataBillEntry.getDate("updateexpirydate");
            if (expiryDate != null) {
                List<DynamicObject> sortedBizDataList = BizDataCommonFilter.sortingBizData(bizDataBillEntry, matchedBizDataList);
                Date originalExpiryDate = sortedBizDataList.get(0).getDate("expirydate");
                Date newExpiryDate = DateUtils.addDays((Date)expiryDate, (int)1);
                if (originalExpiryDate != null) {
                    int truncatedCompareTo = DateUtils.truncatedCompareTo((Date)expiryDate, (Date)originalExpiryDate, (int)11);
                    if (truncatedCompareTo == -1) {
                        bizDataCodeAndDateMap.put(bizDataCode, newExpiryDate);
                        continue;
                    }
                    if (truncatedCompareTo != 1) continue;
                    newExpiryDate = DateUtils.addDays((Date)originalExpiryDate, (int)1);
                    bizDataCodeAndDateMap.put(bizDataCode, newExpiryDate);
                    continue;
                }
                bizDataCodeAndDateMap.put(bizDataCode, newExpiryDate);
                continue;
            }
            logger.info(MessageFormat.format("UEDDataCODFilter-getExpiryDate bizDataCode is:{0} ,expiryDate is null", bizDataCode));
        }
        return bizDataCodeAndDateMap;
    }
}

