/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.bizdata.filter;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.swc.hpdi.business.bizdata.filter.BizDataCommonFilter;
import kd.swc.hpdi.business.bizdata.filter.IBizDataFilter;
import kd.swc.hpdi.business.helper.BizDataHelper;
import org.apache.commons.lang3.time.DateUtils;

public class UEDDataCODImpFilter
implements IBizDataFilter {
    @Override
    public void doFilter(Map<String, Object> queryMap, List<DynamicObject> bizDataBillEntries, IBizDataFilter filter, Map<String, Map<String, Object>> responses) {
        this.doFilterCore(queryMap, bizDataBillEntries, responses);
        filter.doFilter(queryMap, bizDataBillEntries, filter, responses);
    }

    private void doFilterCore(Map<String, Object> queryMap, List<DynamicObject> bizDataBillEntries, Map<String, Map<String, Object>> responses) {
        DynamicObjectCollection calPeriods = BizDataHelper.getCalPeriods(queryMap);
        Map<String, Date> expiryDateMap = this.getExpiryDateMap(queryMap, bizDataBillEntries);
        HashMap<String, Map<String, Object>> bizDataPeriodMap = new HashMap<String, Map<String, Object>>(16);
        for (Map.Entry<String, Date> entry : expiryDateMap.entrySet()) {
            BizDataHelper.getCalPeriodInfo(calPeriods, bizDataPeriodMap, entry.getValue(), entry.getKey());
        }
        Object bizItemGroup = queryMap.get("bizitemgroup");
        if (!(bizItemGroup instanceof DynamicObject)) {
            return;
        }
        BizDataCommonFilter.validateCODWithCalPeriodMap(bizDataBillEntries, responses, (DynamicObject)bizItemGroup, bizDataPeriodMap);
    }

    private Map<String, Date> getExpiryDateMap(Map<String, Object> queryMap, List<DynamicObject> bizDataBillEntries) {
        HashMap<String, Date> bizDataCodeAndDateMap = new HashMap<String, Date>(16);
        Map bizDataNewMap = (Map)queryMap.get("bizDataNewMap");
        if (bizDataNewMap == null) {
            return bizDataCodeAndDateMap;
        }
        for (int i = 0; i < bizDataBillEntries.size(); ++i) {
            DynamicObject bizDataBillEntry = bizDataBillEntries.get(i);
            String bizDataCode = bizDataBillEntry.getString("bizdatacode");
            String empPosId = bizDataBillEntry.getString("empposorgrel.id");
            Date expiryDate = bizDataBillEntry.getDate("updateexpirydate");
            if (expiryDate == null) continue;
            DynamicObjectCollection details = bizDataBillEntry.getDynamicObjectCollection("entryentity");
            for (DynamicObject detail : details) {
                String bizitemId = detail.getString("bizitem.id");
                String ebkey = empPosId + bizitemId;
                DynamicObject newBizData = (DynamicObject)bizDataNewMap.get(ebkey);
                Date originalExpiryDate = newBizData.getDate("expirydate");
                Date newExpiryDate = DateUtils.addDays((Date)expiryDate, (int)1);
                if (originalExpiryDate != null) {
                    int truncatedCompareTo = DateUtils.truncatedCompareTo((Date)expiryDate, (Date)originalExpiryDate, (int)11);
                    if (truncatedCompareTo == -1) {
                        bizDataCodeAndDateMap.put(bizDataCode, newExpiryDate);
                        continue;
                    }
                    if (truncatedCompareTo != 1) continue;
                    newExpiryDate = DateUtils.addDays((Date)originalExpiryDate, (int)1);
                    bizDataCodeAndDateMap.put(bizDataCode, newExpiryDate);
                    continue;
                }
                bizDataCodeAndDateMap.put(bizDataCode, newExpiryDate);
            }
        }
        return bizDataCodeAndDateMap;
    }
}

