/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.bizdata.filter;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.swc.hpdi.business.bizdata.filter.IBizDataFilter;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.CollectionUtils;

public class UEDDataReliabilityFilter
implements IBizDataFilter {
    private static final String[] BIZ_DATA_STATUS_ARR = new String[]{"1", "2", "4"};
    private static final String[] BILL_STATUS_ARR = new String[]{"C", "E", "F"};

    private static void putValueToListValueMap(Map<String, List<String>> map, String value, String mKey) {
        List<String> valueList = map.get(mKey);
        if (valueList == null) {
            valueList = new ArrayList<String>(10);
            map.put(mKey, valueList);
        }
        valueList.add(value);
    }

    @Override
    public void doFilter(Map<String, Object> queryMap, List<DynamicObject> bizDataBillEntries, IBizDataFilter filter, Map<String, Map<String, Object>> responses) {
        this.doFilterCore(queryMap, bizDataBillEntries, responses);
        filter.doFilter(queryMap, bizDataBillEntries, filter, responses);
    }

    private void doFilterCore(Map<String, Object> queryMap, List<DynamicObject> bizDataBillEntries, Map<String, Map<String, Object>> responses) {
        if (queryMap == null) {
            return;
        }
        this.validateSubmitWaitTransSalary(queryMap, bizDataBillEntries, responses);
        this.validateNotSubmit(bizDataBillEntries, responses);
    }

    private void validateSubmitWaitTransSalary(Map<String, Object> queryMap, List<DynamicObject> bizDataBillEntries, Map<String, Map<String, Object>> responses) {
        String existsWaitMsg = ResManager.loadKDString((String)"\u539f\u4e1a\u52a1\u6570\u636e\u5df2\u5b58\u5728\u66f4\u65b0\u5931\u6548\u65e5\u671f\u4e1a\u52a1\u6570\u636e\uff08{0}\uff09\u3002", (String)"UEDDataReliabilityFilter_0", (String)"swc-hpdi-business", (Object[])new Object[0]);
        List<String> waitTransSalaryBizCodes = this.getWaitTransSalaryBizCodes(queryMap);
        if (CollectionUtils.isEmpty(waitTransSalaryBizCodes)) {
            return;
        }
        for (int i = 0; i < bizDataBillEntries.size(); ++i) {
            DynamicObject bizDataBillEntry = bizDataBillEntries.get(i);
            String bizDataCode = bizDataBillEntry.getString("bizdatacode");
            String originalBizDataCode = bizDataBillEntry.getString("originalbizdatacode");
            if (SWCStringUtils.isEmpty((String)originalBizDataCode)) {
                originalBizDataCode = bizDataCode;
            }
            ArrayList<String> matchedBizDataCodes = new ArrayList<String>(10);
            for (String matchedBizDataCode : waitTransSalaryBizCodes) {
                if (!SWCStringUtils.equals((String)originalBizDataCode, (String)matchedBizDataCode)) continue;
                matchedBizDataCodes.add(matchedBizDataCode);
            }
            if (SWCListUtils.isEmpty(matchedBizDataCodes)) continue;
            HashMap<String, String> responseMap = new HashMap<String, String>(3);
            responseMap.put("key_result_error_msg", MessageFormat.format(existsWaitMsg, String.join((CharSequence)",", matchedBizDataCodes)));
            responses.put(bizDataCode, responseMap);
        }
    }

    private List<String> getWaitTransSalaryBizCodes(Map<String, Object> queryMap) {
        Object bizDataObj = queryMap.get("bizDataDynamicArray");
        ArrayList<String> waitTransSalaryBizCodes = new ArrayList<String>(10);
        if (SWCObjectUtils.isEmpty((Object)bizDataObj) || SWCArrayUtils.isEmpty((Object[])((DynamicObject[])bizDataObj))) {
            return waitTransSalaryBizCodes;
        }
        DynamicObject[] bizDataObjArr = (DynamicObject[])bizDataObj;
        Arrays.stream(bizDataObjArr).filter(bizData -> {
            boolean isContains;
            boolean bl = isContains = Arrays.asList(BIZ_DATA_STATUS_ARR).contains(bizData.getString("bizdatastatus")) && SWCStringUtils.equals((String)bizData.getString("billtype"), (String)"2");
            if (isContains) {
                waitTransSalaryBizCodes.add(bizData.getString("bizdatacode"));
            }
            return isContains;
        }).collect(Collectors.toList());
        return waitTransSalaryBizCodes;
    }

    private void validateNotSubmit(List<DynamicObject> bizDataBillEntries, Map<String, Map<String, Object>> responses) {
        String existsNotSubmitMsg = ResManager.loadKDString((String)"\u539f\u4e1a\u52a1\u6570\u636e\u5df2\u5b58\u5728\u66f4\u65b0\u5931\u6548\u65e5\u671f\u7684\u4e1a\u52a1\u6570\u636e\uff0c\u5355\u636e\u7f16\u53f7\uff1a{0}\u3002", (String)"UEDDataReliabilityFilter_1", (String)"swc-hpdi-business", (Object[])new Object[0]);
        String batchExistsMsg = ResManager.loadKDString((String)"\u540c\u6279\u6b21\u4e0b\u4eba\u5458\u5df2\u5b58\u5728\u8be5\u4e1a\u52a1\u9879\u76ee\u201c\u66f4\u65b0\u5931\u6548\u65e5\u671f\u201d\u7684\u4e1a\u52a1\u6570\u636e\u3002", (String)"UEDDataReliabilityFilter_2", (String)"swc-hpdi-business", (Object[])new Object[0]);
        ArrayList<String> bizDataCodes = new ArrayList<String>(bizDataBillEntries.size());
        ArrayList<Long> bizDataEntIds = new ArrayList<Long>(bizDataBillEntries.size());
        for (DynamicObject entry : bizDataBillEntries) {
            String obizDataCode = entry.getString("originalbizdatacode");
            if (SWCStringUtils.isEmpty((String)obizDataCode)) {
                obizDataCode = entry.getString("bizdatacode");
            }
            bizDataCodes.add(obizDataCode);
            bizDataEntIds.add(entry.getLong("id"));
        }
        DynamicObject[] bizDataEntities = this.getBizDataEntity(bizDataCodes, bizDataEntIds);
        if (SWCObjectUtils.isEmpty((Object)bizDataEntities)) {
            return;
        }
        ArrayList<Long> bizDataBillIds = new ArrayList<Long>(bizDataEntities.length);
        Arrays.asList(bizDataEntities).forEach(bizDataEntry -> bizDataBillIds.add(bizDataEntry.getLong("bizdatabillid")));
        DynamicObject[] bizDataBills = this.getBizDataBill(bizDataBillIds);
        if (SWCObjectUtils.isEmpty((Object)bizDataBills)) {
            return;
        }
        Map<Long, DynamicObject> billMap = Arrays.asList(bizDataBills).stream().collect(Collectors.toMap(it -> it.getLong("id"), it -> it, (oldValue, newValue) -> oldValue));
        HashMap<String, List<String>> oBizDataCodeHasNotSubmitMap = new HashMap<String, List<String>>(16);
        HashSet<String> oBizDataCodeBatch = new HashSet<String>(16);
        for (int j = 0; j < bizDataEntities.length; ++j) {
            DynamicObject bizDataEntity = bizDataEntities[j];
            long bizDataBillId = bizDataEntity.getLong("bizdatabillid");
            String oBizDataCode = bizDataEntity.getString("bizdatacode");
            DynamicObject bizDataBill = billMap.get(bizDataBillId);
            if (bizDataBill == null) continue;
            String billNo = bizDataBill.getString("billno");
            UEDDataReliabilityFilter.putValueToListValueMap(oBizDataCodeHasNotSubmitMap, billNo, oBizDataCode);
        }
        for (int i = 0; i < bizDataBillEntries.size(); ++i) {
            DynamicObject bizDataBillEntry = bizDataBillEntries.get(i);
            String bizDataCode = bizDataBillEntry.getString("bizdatacode");
            String oBizDataCode = bizDataBillEntry.getString("originalbizdatacode");
            if (SWCStringUtils.isEmpty((String)oBizDataCode)) {
                oBizDataCode = bizDataCode;
            }
            if (oBizDataCodeBatch.contains(oBizDataCode)) {
                HashMap<String, String> responseMap = new HashMap<String, String>(3);
                responseMap.put("key_result_error_msg", batchExistsMsg);
                responses.put(bizDataCode, responseMap);
                continue;
            }
            List codeAndBillNo = (List)oBizDataCodeHasNotSubmitMap.get(oBizDataCode);
            if (SWCListUtils.isEmpty((List)codeAndBillNo)) {
                oBizDataCodeBatch.add(oBizDataCode);
                continue;
            }
            HashMap<String, String> responseMap = new HashMap<String, String>(3);
            responseMap.put("key_result_error_msg", MessageFormat.format(existsNotSubmitMsg, String.join((CharSequence)",", codeAndBillNo)));
            responses.put(bizDataCode, responseMap);
        }
    }

    private DynamicObject[] getBizDataBill(List<Long> bizDataBillIds) {
        SWCDataServiceHelper bizDataBillHelper = HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER;
        QFilter qFilter = new QFilter("billstatus", "not in", (Object)BILL_STATUS_ARR);
        qFilter.and("id", "in", bizDataBillIds);
        return bizDataBillHelper.query("id,billno", new QFilter[]{qFilter});
    }

    private DynamicObject[] getBizDataEntity(List<String> bizDataCodes, List<Long> bizDataEntIds) {
        SWCDataServiceHelper bizDataBillHelper = HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER;
        QFilter qFilter = new QFilter("bizdatacode", "in", bizDataCodes);
        QFilter idFilter = new QFilter("id", "not in", bizDataEntIds);
        return bizDataBillHelper.query("id,bizdatabillid,bizdatacode", new QFilter[]{qFilter, idFilter});
    }
}

