/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.bizdata.filter;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.swc.hpdi.business.bizdata.filter.IBizDataFilter;
import org.apache.commons.lang3.time.DateUtils;

public class UEDExpiryDateFilter
implements IBizDataFilter {
    @Override
    public void doFilter(Map<String, Object> queryMap, List<DynamicObject> bizDataBillEntries, IBizDataFilter filter, Map<String, Map<String, Object>> responses) {
        this.doFilterCore(queryMap, bizDataBillEntries, responses);
        filter.doFilter(queryMap, bizDataBillEntries, filter, responses);
    }

    private void doFilterCore(Map<String, Object> queryMap, List<DynamicObject> bizDataBillEntries, Map<String, Map<String, Object>> responses) {
        String equalExpiryDateMsg = ResManager.loadKDString((String)"\u201c\u5931\u6548\u65e5\u671f\u201d\u65e0\u53d8\u5316\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"UEDExpiryDateFilter_0", (String)"swc-hpdi-business", (Object[])new Object[0]);
        String beforeEffectiveDateMsg = ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u6548\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u751f\u6548\u65e5\u671f\u3002", (String)"UEDExpiryDateFilter_1", (String)"swc-hpdi-business", (Object[])new Object[0]);
        String updateExpiryDatenNullMsg = ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u6548\u65e5\u671f\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"UEDExpiryDateFilter_2", (String)"swc-hpdi-business", (Object[])new Object[0]);
        for (int i = 0; i < bizDataBillEntries.size(); ++i) {
            DynamicObject bizDataBillEntry = bizDataBillEntries.get(i);
            String bizDataCode = bizDataBillEntry.getString("bizdatacode");
            Date expiryDate = bizDataBillEntry.getDate("updateexpirydate");
            if (expiryDate == null) {
                HashMap<String, String> responseMap = new HashMap<String, String>(3);
                responseMap.put("key_result_error_msg", updateExpiryDatenNullMsg);
                responses.put(bizDataCode, responseMap);
                continue;
            }
            DynamicObjectCollection details = bizDataBillEntry.getDynamicObjectCollection("entryentity");
            for (DynamicObject bizItem : details) {
                boolean isBefore;
                HashMap<String, String> responseMap;
                Date oExpiryDate = bizItem.getDate("expirydate");
                Date oEffectiveDate = bizItem.getDate("effectivedate");
                if (oExpiryDate != null) {
                    boolean isEqualExpiryDate;
                    boolean bl = isEqualExpiryDate = DateUtils.truncatedCompareTo((Date)expiryDate, (Date)oExpiryDate, (int)11) == 0;
                    if (isEqualExpiryDate) {
                        responseMap = new HashMap<String, String>(3);
                        responseMap.put("key_result_error_msg", equalExpiryDateMsg);
                        responses.put(bizDataCode, responseMap);
                        continue;
                    }
                }
                if (oEffectiveDate == null || !(isBefore = DateUtils.truncatedCompareTo((Date)expiryDate, (Date)oEffectiveDate, (int)11) == -1)) continue;
                responseMap = new HashMap(3);
                responseMap.put("key_result_error_msg", beforeEffectiveDateMsg);
                responses.put(bizDataCode, responseMap);
            }
        }
    }
}

