/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.bizdata.filter;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hpdi.business.HPDIResMgrBusiness;
import kd.swc.hpdi.business.bizdata.filter.BizDataCommonFilter;
import kd.swc.hpdi.business.bizdata.filter.IBizDataFilter;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.MapUtils;

public class UEDSalaryPeriodFilter
implements IBizDataFilter {
    private static final Log logger = LogFactory.getLog(UEDSalaryPeriodFilter.class);

    @Override
    public void doFilter(Map<String, Object> queryMap, List<DynamicObject> bizDataBillEntries, IBizDataFilter filter, Map<String, Map<String, Object>> responses) {
        this.doFilterCore(bizDataBillEntries, responses);
        filter.doFilter(queryMap, bizDataBillEntries, filter, responses);
    }

    private void doFilterCore(List<DynamicObject> bizDataBillEntries, Map<String, Map<String, Object>> responses) {
        try {
            List<Map<String, Object>> bizDataCodeList = this.getSalaryPeriodParam(bizDataBillEntries);
            Map<String, Object> salaryPeriodMap = BizDataHelper.getSalaryPeriod(bizDataCodeList);
            this.validatePeriod(salaryPeriodMap, bizDataBillEntries, responses);
        }
        catch (KDBizException exception) {
            logger.error("UEDSalaryPeriodFilter-doFilter:getSalaryPeriod exception. Exception:", (Throwable)exception);
            BizDataCommonFilter.setErrorMsgWhenQuerySalaryPeriodException(bizDataBillEntries, responses);
        }
    }

    private List<Map<String, Object>> getSalaryPeriodParam(List<DynamicObject> bizDataBillEntries) {
        ArrayList<Map<String, Object>> bizDataCodeList = new ArrayList<Map<String, Object>>(1);
        for (DynamicObject bizDataBillEntry : bizDataBillEntries) {
            String dataEntityName;
            String oBizDataCode = bizDataBillEntry.getString("originalbizdatacode");
            if (SWCStringUtils.isEmpty((String)oBizDataCode)) {
                oBizDataCode = bizDataBillEntry.getString("bizdatacode");
            }
            if (SWCStringUtils.equals((String)(dataEntityName = bizDataBillEntry.getDataEntityType().getName()), (String)"hpdi_bizdatabillent")) {
                DynamicObjectCollection details = bizDataBillEntry.getDynamicObjectCollection("entryentity");
                for (DynamicObject detail : details) {
                    long bizItemId = detail.getLong("bizitem.id");
                    HashMap<String, Object> bizDataCodeMap = new HashMap<String, Object>(4);
                    bizDataCodeMap.put("bizdatacode", oBizDataCode);
                    bizDataCodeMap.put("bizitemid", bizItemId);
                    bizDataCodeList.add(bizDataCodeMap);
                }
                continue;
            }
            long bizItemId = bizDataBillEntry.getLong("bizitem.id");
            HashMap<String, Object> bizDataCodeMap = new HashMap<String, Object>(4);
            bizDataCodeMap.put("bizdatacode", oBizDataCode);
            bizDataCodeMap.put("bizitemid", bizItemId);
            bizDataCodeList.add(bizDataCodeMap);
        }
        return bizDataCodeList;
    }

    private void validatePeriod(Map<String, Object> salaryPeriodMap, List<DynamicObject> bizDataBillEntries, Map<String, Map<String, Object>> responses) {
        if (MapUtils.isEmpty(salaryPeriodMap)) {
            return;
        }
        Object periodResult = salaryPeriodMap.get("periodResult");
        if (!(periodResult instanceof Map)) {
            return;
        }
        Map bizDataCodePeriod = (Map)periodResult;
        if (MapUtils.isEmpty((Map)bizDataCodePeriod)) {
            return;
        }
        logger.info(MessageFormat.format("UEDSalaryPeriodFilter-validatePeriod:bizDataCodePeriod is", bizDataCodePeriod.keySet()));
        for (int i = 0; i < bizDataBillEntries.size(); ++i) {
            DynamicObject period;
            DynamicObject bizDataBillEntry = bizDataBillEntries.get(i);
            String bizDataCode = bizDataBillEntry.getString("bizdatacode");
            String obizDataCode = bizDataBillEntry.getString("originalbizdatacode");
            if (SWCStringUtils.isEmpty((String)obizDataCode)) {
                obizDataCode = bizDataCode;
            }
            if (SWCObjectUtils.isEmpty((Object)(period = (DynamicObject)bizDataCodePeriod.get(obizDataCode)))) continue;
            Date endDate = period.getDate("enddate");
            Date updateExpiryDate = bizDataBillEntry.getDate("updateexpirydate");
            if (endDate == null || updateExpiryDate.after(endDate)) continue;
            String response = HPDIResMgrBusiness.getMsgOfUpdateExpiryDateLaterThanPeriod(period.getString("name"), SWCDateTimeUtils.formatDate((Date)endDate));
            HashMap<String, String> responseMap = new HashMap<String, String>(3);
            responseMap.put("key_result_error_msg", response);
            responses.put(bizDataCode, responseMap);
        }
    }
}

