/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.bizdata.herizonlist;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.swc.hpdi.business.bizdata.herizonlist.BizDataHorizonRecordHelper;
import kd.swc.hpdi.common.constants.BillTypeEnum;
import kd.swc.hpdi.common.constants.BizDataOverDueEnum;
import kd.swc.hpdi.common.constants.BizDataSubmissionEnum;
import kd.swc.hsbp.common.enums.BizDataStatusEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class BizDataHorizonListExportService {
    private static final Object DATATYPE = "dataType";

    public List<Map<String, Object>> getExportData(QFilter[] filters, Long bizItemGroupId, int currentPage, int pageSize, Map<String, Object> param) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(10);
        HashSet<Long> bizDataRecordIdSet = new HashSet<Long>(16);
        boolean isRollBackPage = (Boolean)param.get("isRollBackPage");
        Map usMap = (Map)param.get("usageStatusMap");
        String fields = this.buildExportQuerySql();
        DynamicObject[] coll = BusinessDataServiceHelper.load((String)"hpdi_bizdatarecord", (String)fields, (QFilter[])filters, (String)"id desc", (int)currentPage, (int)pageSize);
        int size = coll.length;
        int seq = currentPage * pageSize + 1;
        for (int i = 0; i < size; ++i) {
            DynamicObject bizDataRecordObj = coll[i];
            bizDataRecordIdSet.add(bizDataRecordObj.getLong("id"));
            HashMap<String, Object> valueMap = new HashMap<String, Object>(30);
            this.buildBizDataRecordData(valueMap, bizDataRecordObj);
            valueMap.put("fseq", seq);
            valueMap.put("id", bizDataRecordObj.getLong("id"));
            ++seq;
            if (isRollBackPage) {
                valueMap.put("usagestatus", usMap.get(bizDataRecordObj.getString("bizdatacode")));
            }
            dataList.add(valueMap);
        }
        BizDataHorizonRecordHelper bizDataRecordListHelper = new BizDataHorizonRecordHelper();
        DynamicObject[] nonBizDatas = bizDataRecordListHelper.getNonBizDataRecordDatasByIds(bizDataRecordIdSet);
        if (nonBizDatas != null && nonBizDatas.length > 0) {
            this.buildBizItemData(dataList, nonBizDatas);
        }
        return dataList;
    }

    private void buildBizItemData(List<Map<String, Object>> dataList, DynamicObject[] nonBizDatas) {
        HashMap<Long, HashMap<String, String>> cacheNonBizDataMap = new HashMap<Long, HashMap<String, String>>(16);
        for (DynamicObject nonBizDataObj : nonBizDatas) {
            DynamicObject bizItemObj = nonBizDataObj.getDynamicObject("bizitem");
            if (SWCObjectUtils.isEmpty((Object)bizItemObj)) continue;
            String bizItemNumber = bizItemObj.getString("number");
            long bizDataRecordId = nonBizDataObj.getLong("bizdatarecord.id");
            String bizItemVal = nonBizDataObj.getString("value");
            HashMap<String, String> valMap = (HashMap<String, String>)cacheNonBizDataMap.get(bizDataRecordId);
            if (valMap == null || valMap.size() == 0) {
                valMap = new HashMap<String, String>(1);
            }
            valMap.put(bizItemNumber, bizItemVal);
            cacheNonBizDataMap.put(bizDataRecordId, valMap);
        }
        for (Map map : dataList) {
            Map valMap;
            Long bizDataRecordId = (Long)map.get("id");
            if (bizDataRecordId == null || (valMap = (Map)cacheNonBizDataMap.get(bizDataRecordId)) == null || valMap.size() == 0) continue;
            for (Map.Entry entry : valMap.entrySet()) {
                String bizItemNumber = (String)entry.getKey();
                String bizItemVal = (String)entry.getValue();
                map.put(bizItemNumber.toLowerCase(), bizItemVal);
            }
        }
    }

    private void buildBizDataRecordData(Map<String, Object> valueMap, DynamicObject bizDataRecordObj) {
        String empposorgrelPersonNumber = bizDataRecordObj.getString("empposorgrel.person.number");
        valueMap.put("empposorgrel.person.number", empposorgrelPersonNumber);
        String empposorgrelPersonName = bizDataRecordObj.getString("empposorgrel.person.name");
        valueMap.put("empposorgrel.person.name", empposorgrelPersonName);
        String adminorgName = bizDataRecordObj.getString("adminorg.name");
        valueMap.put("adminorg.name", adminorgName);
        String payrollgrpName = bizDataRecordObj.getString("payrollgrp.name");
        valueMap.put("payrollgrp.name", payrollgrpName);
        String empposorgrelJobName = bizDataRecordObj.getString("empposorgrel.job.name");
        valueMap.put("empposorgrel.job.name", empposorgrelJobName);
        String empposorgrelIsprimary = bizDataRecordObj.getString("empposorgrel.isprimary");
        valueMap.put("empposorgrel.isprimary", this.empposorgrelIsprimarySwitch(empposorgrelIsprimary));
        String empposorgrelPostypeName = bizDataRecordObj.getString("empposorgrel.postype.name");
        valueMap.put("empposorgrel.postype.name", empposorgrelPostypeName);
        String empposorgrelPosstatusName = bizDataRecordObj.getString("empposorgrel.posstatus.name");
        valueMap.put("empposorgrel.posstatus.name", empposorgrelPosstatusName);
        Object empposorgrelStartdate = bizDataRecordObj.get("empposorgrel.startdate");
        if (null != empposorgrelStartdate && empposorgrelStartdate instanceof Date) {
            empposorgrelStartdate = SWCDateTimeUtils.format((Date)((Date)empposorgrelStartdate), (String)"yyyy-MM-dd");
        }
        valueMap.put("empposorgrel.startdate", empposorgrelStartdate);
        Object empposorgrelSysenddate = bizDataRecordObj.get("empposorgrel.sysenddate");
        if (null != empposorgrelSysenddate && empposorgrelSysenddate instanceof Date) {
            empposorgrelSysenddate = SWCDateTimeUtils.format((Date)((Date)empposorgrelSysenddate), (String)"yyyy-MM-dd");
        }
        valueMap.put("empposorgrel.sysenddate", empposorgrelSysenddate);
        String empposorgrelCompanyName = bizDataRecordObj.getString("empposorgrel.company.name");
        valueMap.put("empposorgrel.company.name", empposorgrelCompanyName);
        String empposorgrelPositionName = bizDataRecordObj.getString("empposorgrel.position.name");
        valueMap.put("empposorgrel.position.name", empposorgrelPositionName);
        String empposorgrelVariationtypeName = bizDataRecordObj.getString("empposorgrel.variationtype.name");
        valueMap.put("empposorgrel.variationtype.name", empposorgrelVariationtypeName);
        Object empposorgrelStartprobation = bizDataRecordObj.get("empposorgrel.startprobation");
        if (null != empposorgrelStartprobation && empposorgrelStartprobation instanceof Date) {
            empposorgrelStartprobation = SWCDateTimeUtils.format((Date)((Date)empposorgrelStartprobation), (String)"yyyy-MM-dd");
        }
        valueMap.put("empposorgrel.startprobation", empposorgrelStartprobation);
        Object empposorgrelEndprobation = bizDataRecordObj.get("empposorgrel.endprobation");
        if (null != empposorgrelEndprobation && empposorgrelEndprobation instanceof Date) {
            empposorgrelEndprobation = SWCDateTimeUtils.format((Date)((Date)empposorgrelEndprobation), (String)"yyyy-MM-dd");
        }
        valueMap.put("empposorgrel.endprobation", empposorgrelEndprobation);
        String empposorgrelWorkplaceName = bizDataRecordObj.getString("empposorgrel.workplace.name");
        valueMap.put("empposorgrel.workplace.name", empposorgrelWorkplaceName);
        String salaryfileNumber = bizDataRecordObj.getString("salaryfile.number");
        valueMap.put("salaryfile.number", salaryfileNumber);
        String billtype = bizDataRecordObj.getString("billtype");
        valueMap.put("billtype", BillTypeEnum.getDesc((String)billtype));
        String bizdatastatus = bizDataRecordObj.getString("bizdatastatus");
        valueMap.put("bizdatastatus", BizDataStatusEnum.getDesc((String)bizdatastatus));
        String errormsg = bizDataRecordObj.getString("errormsg");
        valueMap.put("errormsg", errormsg);
        Object effectivedate = bizDataRecordObj.get("effectivedate");
        if (null != effectivedate && effectivedate instanceof Date) {
            effectivedate = SWCDateTimeUtils.format((Date)((Date)effectivedate), (String)"yyyy-MM-dd");
        }
        valueMap.put("effectivedate", effectivedate);
        Object expirydate = bizDataRecordObj.get("expirydate");
        if (null != expirydate && expirydate instanceof Date) {
            expirydate = SWCDateTimeUtils.format((Date)((Date)expirydate), (String)"yyyy-MM-dd");
        }
        valueMap.put("expirydate", expirydate);
        String currencyName = bizDataRecordObj.getString("currency.name");
        valueMap.put("currency.name", currencyName);
        String calfrequencyName = bizDataRecordObj.getString("calfrequency.name");
        valueMap.put("calfrequency.name", calfrequencyName);
        String description = bizDataRecordObj.getString("description");
        valueMap.put("description", description);
        Object bizdate = bizDataRecordObj.get("bizdate");
        if (null != bizdate && bizdate instanceof Date) {
            bizdate = SWCDateTimeUtils.format((Date)((Date)bizdate));
        }
        valueMap.put("bizdate", bizdate);
        Object submitdate = bizDataRecordObj.get("submitdate");
        if (null != submitdate && submitdate instanceof Date) {
            submitdate = SWCDateTimeUtils.format((Date)((Date)submitdate));
        }
        valueMap.put("submitdate", submitdate);
        Object calsalarydate = bizDataRecordObj.get("calsalarydate");
        if (null != calsalarydate && calsalarydate instanceof Date) {
            calsalarydate = SWCDateTimeUtils.format((Date)((Date)calsalarydate));
        }
        valueMap.put("calsalarydate", calsalarydate);
        String calperiodName = bizDataRecordObj.getString("calperiod.name");
        valueMap.put("calperiod.name", calperiodName);
        Object calperiodStartdate = bizDataRecordObj.get("calperiod.startdate");
        if (null != calperiodStartdate && calperiodStartdate instanceof Date) {
            calperiodStartdate = SWCDateTimeUtils.format((Date)((Date)calperiodStartdate), (String)"yyyy-MM-dd");
        }
        valueMap.put("calperiod.startdate", calperiodStartdate);
        Object calperiodEnddate = bizDataRecordObj.get("calperiod.enddate");
        if (null != calperiodEnddate && calperiodEnddate instanceof Date) {
            calperiodEnddate = SWCDateTimeUtils.format((Date)((Date)calperiodEnddate), (String)"yyyy-MM-dd");
        }
        valueMap.put("calperiod.enddate", calperiodEnddate);
        String bizdatacode = bizDataRecordObj.getString("bizdatacode");
        valueMap.put("bizdatacode", bizdatacode);
        String bizitemgroupName = bizDataRecordObj.getString("bizitemgroup.name");
        valueMap.put("bizitemgroup.name", bizitemgroupName);
        String submission = bizDataRecordObj.getString("submission");
        valueMap.put("submission", BizDataSubmissionEnum.getDesc((String)submission));
        String updateddesc = bizDataRecordObj.getString("updateddesc");
        valueMap.put("updateddesc", updateddesc);
        String applyno = bizDataRecordObj.getString("applyno");
        valueMap.put("applyno", applyno);
        Object createtime = bizDataRecordObj.get("createtime");
        if (null != createtime && createtime instanceof Date) {
            createtime = SWCDateTimeUtils.format((Date)((Date)createtime));
        }
        valueMap.put("createtime", createtime);
        Object modifytime = bizDataRecordObj.get("modifytime");
        if (null != modifytime && modifytime instanceof Date) {
            modifytime = SWCDateTimeUtils.format((Date)((Date)modifytime));
        }
        valueMap.put("modifytime", modifytime);
        String overdue = bizDataRecordObj.getString("overdue");
        valueMap.put("overdue", BizDataOverDueEnum.getDesc((String)overdue));
    }

    private String empposorgrelIsprimarySwitch(String empposorgrelIsprimary) {
        if (SWCStringUtils.equals((String)"0", (String)empposorgrelIsprimary)) {
            return ResManager.loadKDString((String)"\u5426", (String)"BizDataHorizonListExportService_41", (String)"swc-hpdi-business", (Object[])new Object[0]);
        }
        if (SWCStringUtils.equals((String)"1", (String)empposorgrelIsprimary)) {
            return ResManager.loadKDString((String)"\u662f", (String)"BizDataHorizonListExportService_42", (String)"swc-hpdi-business", (Object[])new Object[0]);
        }
        return "";
    }

    private String buildExportQuerySql() {
        String fields = "empposorgrel,adminorg,payrollgrp,salaryfile,bizdatastatus,errormsg,effectivedate,expirydate,currency,calfrequency,description,bizdate,submitdate,calsalarydate,calperiod,bizdatacode,bizitemgroup,submission,billtype,updateddesc,applyno,createtime,modifytime,overdue";
        return fields;
    }

    public Map<String, String> getExportHeaders(DynamicObjectCollection bizItemColl, boolean isRollBackPage) {
        LinkedHashMap<String, String> headerMap = new LinkedHashMap<String, String>(50);
        headerMap.put("fseq", ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"BizDataHorizonListExportService_0", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("empposorgrel.person.number", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"BizDataHorizonListExportService_1", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("empposorgrel.person.name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"BizDataHorizonListExportService_2", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("adminorg.name", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7", (String)"BizDataHorizonListExportService_3", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("payrollgrp.name", ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u7ec4", (String)"BizDataHorizonListExportService_4", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("empposorgrel.job.name", ResManager.loadKDString((String)"\u804c\u4f4d", (String)"BizDataHorizonListExportService_5", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("empposorgrel.isprimary", ResManager.loadKDString((String)"\u662f\u5426\u4e3b\u4efb\u804c", (String)"BizDataHorizonListExportService_6", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("empposorgrel.postype.name", ResManager.loadKDString((String)"\u4efb\u804c\u7c7b\u578b", (String)"BizDataHorizonListExportService_7", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("empposorgrel.posstatus.name", ResManager.loadKDString((String)"\u4efb\u804c\u72b6\u6001", (String)"BizDataHorizonListExportService_8", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("empposorgrel.startdate", ResManager.loadKDString((String)"\u4efb\u804c\u5f00\u59cb\u65e5\u671f", (String)"BizDataHorizonListExportService_9", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("empposorgrel.sysenddate", ResManager.loadKDString((String)"\u4efb\u671f\u7ed3\u675f\u65e5\u671f", (String)"BizDataHorizonListExportService_10", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("empposorgrel.company.name", ResManager.loadKDString((String)"\u6240\u5c5e\u516c\u53f8", (String)"BizDataHorizonListExportService_11", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("empposorgrel.position.name", ResManager.loadKDString((String)"\u5c97\u4f4d\u540d\u79f0", (String)"BizDataHorizonListExportService_12", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("empposorgrel.variationtype.name", ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578b", (String)"BizDataHorizonListExportService_13", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("empposorgrel.startprobation", ResManager.loadKDString((String)"\u8003\u5bdf\u5f00\u59cb\u65e5\u671f", (String)"BizDataHorizonListExportService_14", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("empposorgrel.endprobation", ResManager.loadKDString((String)"\u8003\u5bdf\u7ed3\u675f\u65e5\u671f", (String)"BizDataHorizonListExportService_15", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("empposorgrel.workplace.name", ResManager.loadKDString((String)"\u5e38\u9a7b\u5de5\u4f5c\u5730", (String)"BizDataHorizonListExportService_16", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("salaryfile.number", ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848", (String)"BizDataHorizonListExportService_17", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("billtype", ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b", (String)"BizDataHorizonListExportService_18", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("bizdatastatus", ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u72b6\u6001", (String)"BizDataHorizonListExportService_19", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("errormsg", ResManager.loadKDString((String)"\u5f02\u5e38\u539f\u56e0", (String)"BizDataHorizonListExportService_20", (String)"swc-hpdi-business", (Object[])new Object[0]));
        for (DynamicObject bizItemObj : bizItemColl) {
            DynamicObject bizItemInfo = bizItemObj.getDynamicObject("bizitem");
            if (SWCObjectUtils.isEmpty((Object)bizItemInfo)) continue;
            String bizItemNumber = bizItemInfo.getString("number");
            String bizItemName = bizItemInfo.getString("name");
            headerMap.put(bizItemNumber.toLowerCase(), bizItemName);
        }
        headerMap.put("effectivedate", ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f", (String)"BizDataHorizonListExportService_21", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("expirydate", ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f", (String)"BizDataHorizonListExportService_22", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("currency.name", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"BizDataHorizonListExportService_44", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("calfrequency.name", ResManager.loadKDString((String)"\u9891\u5ea6", (String)"BizDataHorizonListExportService_24", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("description", ResManager.loadKDString((String)"\u5907\u6ce8", (String)"BizDataHorizonListExportService_25", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("bizdate", ResManager.loadKDString((String)"\u4e1a\u52a1\u5f52\u5c5e\u65e5\u671f", (String)"BizDataHorizonListExportService_26", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("submitdate", ResManager.loadKDString((String)"\u63d0\u62a5\u65f6\u95f4", (String)"BizDataHorizonListExportService_27", (String)"swc-hpdi-business", (Object[])new Object[0]));
        if (isRollBackPage) {
            headerMap.put("usagestatus", ResManager.loadKDString((String)"\u7b97\u85aa\u4f7f\u7528\u72b6\u6001", (String)"BizDataHorizonListExportService_43", (String)"swc-hpdi-business", (Object[])new Object[0]));
        }
        headerMap.put("calsalarydate", ResManager.loadKDString((String)"\u63a8\u9001\u7b97\u85aa\u65f6\u95f4", (String)"BizDataHorizonListExportService_28", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("calperiod.name", ResManager.loadKDString((String)"\u6240\u5728\u85aa\u8d44\u671f\u95f4", (String)"BizDataHorizonListExportService_29", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("calperiod.startdate", ResManager.loadKDString((String)"\u671f\u95f4\u5f00\u59cb\u65e5\u671f", (String)"BizDataHorizonListExportService_30", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("calperiod.enddate", ResManager.loadKDString((String)"\u671f\u95f4\u7ed3\u675f\u65e5\u671f", (String)"BizDataHorizonListExportService_31", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("bizdatacode", ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u8bc6\u522b\u53f7", (String)"BizDataHorizonListExportService_32", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("bizitemgroup.name", ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u6a21\u677f", (String)"BizDataHorizonListExportService_33", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("submission", ResManager.loadKDString((String)"\u63d0\u62a5\u65b9\u5f0f", (String)"BizDataHorizonListExportService_34", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("applyno", ResManager.loadKDString((String)"\u5173\u8054\u5355\u636e", (String)"BizDataHorizonListExportService_37", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("createtime", ResManager.loadKDString((String)"\u521b\u5efa\u65f6\u95f4", (String)"BizDataHorizonListExportService_38", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("modifytime", ResManager.loadKDString((String)"\u4fee\u6539\u65f6\u95f4", (String)"BizDataHorizonListExportService_39", (String)"swc-hpdi-business", (Object[])new Object[0]));
        headerMap.put("overdue", ResManager.loadKDString((String)"\u8d85\u671f\u6807\u8bc6", (String)"BizDataHorizonListExportService_40", (String)"swc-hpdi-business", (Object[])new Object[0]));
        return headerMap;
    }

    public Sheet write2ExportHead(SXSSFSheet sheet, Map<String, String> headerMap) {
        List<Map<String, String>> headList = this.HeadMapToListMap(headerMap);
        this.createHeadColumn(sheet.getWorkbook(), sheet, headList);
        return sheet;
    }

    public List<Map<String, String>> HeadMapToListMap(Map<String, String> headData) {
        LinkedList<Map<String, String>> list = new LinkedList<Map<String, String>>();
        for (Map.Entry<String, String> entry : headData.entrySet()) {
            HashMap<String, String> itemMap = new HashMap<String, String>(2);
            itemMap.put("key", entry.getKey());
            itemMap.put("value", entry.getValue());
            list.add(itemMap);
        }
        return list;
    }

    private void createHeadColumn(SXSSFWorkbook wb, SXSSFSheet sheet, List<Map<String, String>> headList) {
        int row = 0;
        SXSSFRow headRow = sheet.createRow(row);
        int headSize = headList.size();
        for (int i = 0; i < headSize; ++i) {
            if (null == headList.get(i)) continue;
            SXSSFCell cell = headRow.createCell(i);
            String headString = headList.get(i).get("value");
            cell.setCellValue(headString);
            CellStyle headColumnStyle = this.getHeadColumnStyle(wb);
            cell.setCellStyle(headColumnStyle);
        }
    }

    private CellStyle getHeadColumnStyle(SXSSFWorkbook wb) {
        CellStyle headColumnStyle = wb.createCellStyle();
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderTop(BorderStyle.THIN);
        headColumnStyle.setBorderLeft(BorderStyle.THIN);
        headColumnStyle.setBorderRight(BorderStyle.THIN);
        headColumnStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
        headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headColumnStyle.setAlignment(HorizontalAlignment.LEFT);
        headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headColumnStyle.setHidden(true);
        return headColumnStyle;
    }

    public Sheet write2ExportContent(SXSSFSheet sheet, Integer beginIndex, List<Map<String, Object>> exportDataList, Map<String, String> headerMap) {
        List<Map<String, String>> headList = this.HeadMapToListMap(headerMap);
        this.createContentColumn(sheet.getWorkbook(), sheet, beginIndex, exportDataList, headList);
        return sheet;
    }

    private void createContentColumn(SXSSFWorkbook wb, SXSSFSheet sheet, Integer beginIndex, List<Map<String, Object>> exportDataList, List<Map<String, String>> headList) {
        if (exportDataList.isEmpty()) {
            return;
        }
        HashMap<String, CellStyle> cellStyleMap = new HashMap<String, CellStyle>(16);
        for (int rowIndex = beginIndex.intValue(); rowIndex < exportDataList.size() + beginIndex; ++rowIndex) {
            SXSSFRow contentRow = sheet.createRow(rowIndex);
            Map<String, Object> exportDataMap = null;
            exportDataMap = exportDataList.get(rowIndex - beginIndex);
            for (int columnIndex = 0; columnIndex < headList.size(); ++columnIndex) {
                Object value;
                SXSSFCell columnCell = contentRow.createCell(columnIndex);
                String key = headList.get(columnIndex).get("key");
                if (null == key || null == (value = exportDataMap.get(key)) || SWCStringUtils.isEmpty((String)value.toString())) continue;
                Map<String, Object> itemInfo = this.getItemInfo(null, key);
                String cellStyleKey = BizDataHorizonListExportService.getCellStyleKey(itemInfo);
                CellStyle defaultStyle = (CellStyle)cellStyleMap.get(cellStyleKey);
                if (defaultStyle == null) {
                    defaultStyle = this.getDefaultCellStyle(itemInfo, wb);
                    cellStyleMap.put(cellStyleKey, defaultStyle);
                }
                String dataType = "";
                if (null == itemInfo) {
                    if (value instanceof String) {
                        dataType = "text";
                    } else if (value instanceof Date) {
                        dataType = "date";
                    } else if (value instanceof BigDecimal) {
                        dataType = "num";
                    }
                }
                this.parseCellValue(columnCell, value, dataType);
                columnCell.setCellType(BizDataHorizonListExportService.getCellType(dataType));
                columnCell.setCellStyle(defaultStyle);
            }
        }
    }

    public static CellType getCellType(String dataType) {
        if (SWCStringUtils.isEmpty((String)dataType)) {
            return CellType.STRING;
        }
        if (SWCStringUtils.equals((String)dataType, (String)"num")) {
            return CellType.NUMERIC;
        }
        if (SWCStringUtils.equals((String)dataType, (String)"date")) {
            return CellType.STRING;
        }
        if (SWCStringUtils.equals((String)dataType, (String)"amount")) {
            return CellType.NUMERIC;
        }
        return CellType.STRING;
    }

    private void parseCellValue(SXSSFCell cell, Object value, String dataType) {
        if (SWCStringUtils.equals((String)dataType, (String)"text")) {
            cell.setCellValue(value.toString());
        } else if (SWCStringUtils.equals((String)dataType, (String)"date")) {
            String fmt = "yyyy-MM-dd";
            if (value instanceof Date) {
                String dateStr = SWCDateTimeUtils.format((Date)((Date)value), (String)fmt);
                cell.setCellValue(dateStr);
            } else if (value instanceof Number) {
                long dataLong = Long.parseLong(value.toString());
                Date dateValue = new Date(dataLong);
                String dateStr = SWCDateTimeUtils.format((Date)dateValue, (String)fmt);
                cell.setCellValue(dateStr);
            } else if (value instanceof String) {
                String valueStr = (String)value;
                cell.setCellValue(valueStr);
            } else {
                cell.setCellValue(value.toString());
            }
        } else if (SWCStringUtils.equals((String)dataType, (String)"num") || SWCStringUtils.equals((String)dataType, (String)"amount")) {
            cell.setCellValue(Double.parseDouble(value.toString()));
        } else {
            cell.setCellValue(String.valueOf(value));
        }
    }

    public CellStyle getDefaultCellStyle(Map<String, Object> itemInfoMap, SXSSFWorkbook wb) {
        String dataType = "";
        Integer scale = 0;
        CellStyle cellStyle = wb.createCellStyle();
        if (null == itemInfoMap) {
            dataType = "text";
        } else {
            dataType = (String)itemInfoMap.get(DATATYPE);
            scale = (Integer)itemInfoMap.get("scale");
        }
        if (SWCStringUtils.isEmpty((String)dataType)) {
            dataType = "text";
        }
        if (SWCStringUtils.equals((String)dataType, (String)"num")) {
            this.getNumberCellStyle(wb, cellStyle, scale);
        } else if (SWCStringUtils.equals((String)dataType, (String)"date")) {
            BizDataHorizonListExportService.getDateCellStyle(wb, cellStyle);
        } else if (SWCStringUtils.equals((String)dataType, (String)"amount")) {
            this.getAmountCellStyle(wb, cellStyle, scale);
        } else {
            BizDataHorizonListExportService.getStringCellStyle(wb, cellStyle);
        }
        return cellStyle;
    }

    private static void getStringCellStyle(SXSSFWorkbook wb, CellStyle cellStyle) {
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        DataFormat format = wb.createDataFormat();
        String styleStr = "@";
        cellStyle.setDataFormat(format.getFormat(styleStr));
    }

    private void getAmountCellStyle(SXSSFWorkbook wb, CellStyle cellStyle, int scale) {
        DataFormat format = wb.createDataFormat();
        String styleStr = "#,##0";
        StringBuilder sb = new StringBuilder(styleStr);
        if (scale > 0) {
            sb.append('.');
            for (int i = 0; i < scale; ++i) {
                sb.append('0');
            }
        }
        cellStyle.setDataFormat(format.getFormat(sb.toString()));
    }

    private static void getDateCellStyle(SXSSFWorkbook wb, CellStyle cellStyle) {
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        DataFormat format = wb.createDataFormat();
        String styleStr = "yyyy-MM-dd";
        cellStyle.setDataFormat(format.getFormat(styleStr));
    }

    private void getNumberCellStyle(SXSSFWorkbook wb, CellStyle cellStyle, int scale) {
        DataFormat format = wb.createDataFormat();
        String styleStr = "#,##0";
        StringBuilder sb = new StringBuilder(styleStr);
        if (scale > 0) {
            sb.append('.');
            for (int i = 0; i < scale; ++i) {
                sb.append('0');
            }
        }
        cellStyle.setDataFormat(format.getFormat(sb.toString()));
    }

    private Map<String, Object> getItemInfo(Map<String, Map<String, Object>> itemInfo, String key) {
        if (itemInfo == null || itemInfo.size() == 0) {
            return null;
        }
        for (Map.Entry<String, Map<String, Object>> entry : itemInfo.entrySet()) {
            String itemKey = entry.getKey();
            if (!SWCStringUtils.equals((String)key, (String)itemKey)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static String getCellStyleKey(Map<String, Object> itemInfoMap) {
        StringBuilder keyBuilder = new StringBuilder();
        String dataType = "";
        Integer scale = 0;
        if (null == itemInfoMap) {
            dataType = "text";
        } else {
            dataType = (String)itemInfoMap.get(DATATYPE);
            scale = (Integer)itemInfoMap.get("scale");
        }
        if (SWCStringUtils.isEmpty((String)dataType)) {
            dataType = "text";
        }
        keyBuilder.append(dataType);
        keyBuilder.append('#');
        keyBuilder.append(scale);
        return keyBuilder.toString();
    }
}

