/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.bizdata.herizonlist;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.bizdata.herizonlist.BizDataHorizonRecordHelper;
import kd.swc.hsbp.common.enums.SWCShowType;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class BizDataHorizonRecordService {
    public final Log log = LogFactory.getLog(BizDataHorizonRecordService.class);
    public final int bitchSize = 1000;
    private final int bizDataQuerySize = 500;

    public void getBizDataRecordDatas(DynamicObjectCollection bizDataRecordDatas, Map<Long, String> dataTypeMap) {
        DynamicObject[] nonRecurBizDatas;
        BizDataHorizonRecordHelper helper = new BizDataHorizonRecordHelper();
        ArrayList<Object> nonBizDataRecordDataList = new ArrayList<Object>(10);
        long startTime = System.currentTimeMillis();
        HashSet<Long> bizDataRecordIdSet = new HashSet<Long>(bizDataRecordDatas.size());
        for (DynamicObject bizDataRecordObj : bizDataRecordDatas) {
            if (!SWCObjectUtils.isEmpty((Object)bizDataRecordObj)) {
                bizDataRecordIdSet.add(bizDataRecordObj.getLong("id"));
            }
            if (bizDataRecordIdSet.size() != 500) continue;
            DynamicObject[] dynamicObjectArray = helper.batchQueryNonBizDataRecordDatas(bizDataRecordIdSet, 1000);
            if (dynamicObjectArray != null && dynamicObjectArray.length > 0) {
                for (DynamicObject nonRecurBizObj : dynamicObjectArray) {
                    nonBizDataRecordDataList.add(nonRecurBizObj);
                }
            }
            bizDataRecordIdSet.clear();
        }
        if (bizDataRecordIdSet != null && bizDataRecordIdSet.size() > 0 && (nonRecurBizDatas = helper.batchQueryNonBizDataRecordDatas(bizDataRecordIdSet, 1000)) != null && nonRecurBizDatas.length > 0) {
            for (DynamicObject nonRecurBizObj : nonRecurBizDatas) {
                nonBizDataRecordDataList.add(nonRecurBizObj);
            }
        }
        this.log.info("BizDataHorizonRecordService query data use time:{}", (Object)(System.currentTimeMillis() - startTime));
        if (nonBizDataRecordDataList == null || nonBizDataRecordDataList.size() == 0) {
            return;
        }
        HashMap<Long, DynamicObject> bizDataRecordMap = new HashMap<Long, DynamicObject>(bizDataRecordDatas.size());
        for (DynamicObject dynamicObject : bizDataRecordDatas) {
            Long bizDataRecordId = dynamicObject.getLong("id");
            bizDataRecordMap.put(bizDataRecordId, dynamicObject);
        }
        for (DynamicObject dynamicObject : nonBizDataRecordDataList) {
            Long bizDataRecordId = dynamicObject.getLong("bizdatarecord.id");
            DynamicObject bizDataRecordObj = (DynamicObject)bizDataRecordMap.get(bizDataRecordId);
            if (bizDataRecordObj == null) continue;
            this.buildBizDataRecordDatas(dynamicObject, bizDataRecordObj, dataTypeMap);
        }
    }

    private void buildBizDataRecordDatas(DynamicObject nonRecurBizDataObj, DynamicObject bizDataRecordObj, Map<Long, String> dataTypeMap) {
        DynamicObject bizItemObj = nonRecurBizDataObj.getDynamicObject("bizitem");
        String bizItemNumber = bizItemObj.getString("number");
        String columnKey = bizItemNumber.toLowerCase();
        String bizItemVal = nonRecurBizDataObj.getString("value");
        DynamicObject dataTypeObj = bizItemObj.getDynamicObject("datatype");
        String dataType = dataTypeMap.get(dataTypeObj.getLong("id"));
        if (SWCStringUtils.isEmpty((String)dataType)) {
            return;
        }
        if (SWCShowType.TEXT.getCode().equals(dataType)) {
            bizDataRecordObj.set(columnKey, (Object)bizItemVal);
        } else if (SWCShowType.NUM.getCode().equals(dataType)) {
            bizDataRecordObj.set(columnKey, (Object)new BigDecimal(bizItemVal));
        } else if (SWCShowType.DATE.getCode().equals(dataType)) {
            try {
                bizDataRecordObj.set(columnKey, (Object)SWCDateTimeUtils.parseDate((String)bizItemVal, (String)"yyy-MM-dd"));
            }
            catch (ParseException e) {
                this.log.error(e.getMessage());
            }
        } else if (SWCShowType.AMOUNT.getCode().equals(dataType)) {
            DynamicObject currencyObj = nonRecurBizDataObj.getDynamicObject("currency");
            if (SWCObjectUtils.isEmpty((Object)currencyObj)) {
                return;
            }
            int amtprecision = currencyObj.getInt("amtprecision");
            bizDataRecordObj.set(columnKey, (Object)this.getAmountValueByAmtprecision(amtprecision, bizItemVal));
        }
    }

    private String getAmountValueByAmtprecision(int amtprecision, String dataValue) {
        String amtStr = this.getAmtprecision(amtprecision);
        DecimalFormat format = new DecimalFormat(amtStr);
        return format.format(new BigDecimal(dataValue));
    }

    private String getAmtprecision(int amtprecision) {
        switch (amtprecision) {
            case 0: {
                return "0";
            }
            case 1: {
                return "0.0";
            }
            case 2: {
                return "0.00";
            }
            case 3: {
                return "0.000";
            }
            case 4: {
                return "0.0000";
            }
            case 5: {
                return "0.00000";
            }
            case 6: {
                return "0.000000";
            }
            case 7: {
                return "0.0000000";
            }
            case 8: {
                return "0.00000000";
            }
            case 9: {
                return "0.000000000";
            }
            case 10: {
                return "0.0000000000";
            }
        }
        return "0.0000";
    }

    public void setBizDataRecordUsageStatus(DynamicObjectCollection bizDataRecordDatas, Map<String, String> usageStatusMap) {
        if (CollectionUtils.isEmpty(usageStatusMap)) {
            return;
        }
        for (DynamicObject bizDataRecord : bizDataRecordDatas) {
            bizDataRecord.set("usagestatus", (Object)usageStatusMap.get(bizDataRecord.getString("bizdatacode")));
        }
    }
}

