/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.cloudcolla;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hpdi.common.constants.PayRollActGrpConstants;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CollaRuleNodeIdHelper {
    private static final Log LOGGER = LogFactory.getLog(CollaRuleNodeIdHelper.class);

    private CollaRuleNodeIdHelper() {
    }

    public static CollaRuleNodeIdHelper getInstance() {
        return Load.INSTANCE;
    }

    public String genActionNodeId(Long actionId) {
        return this.generateNodeId("L1", "01", String.valueOf(actionId));
    }

    public String genKeyFieldNodeId(Long actionId, Long operateId, String objectNumber) {
        return this.generateNodeId("L3", "10", String.valueOf(actionId), String.valueOf(operateId), objectNumber);
    }

    public String genNormalFieldNodeId(Long actionId, Long operateId, String objectNumber) {
        return this.generateNodeId("L3", "11", String.valueOf(actionId), String.valueOf(operateId), objectNumber);
    }

    public String genOperateObjectNodeId(Long actionId, Long operateId, String objectNumber) {
        return this.generateNodeId("L2", "02", String.valueOf(actionId), String.valueOf(operateId), objectNumber);
    }

    public String genExeParamNodeId(Long actionId, Long operateId, String objectNumber, String exeParam, Boolean isMustInput) {
        return this.generateNodeId("L3", "03", String.valueOf(actionId), String.valueOf(operateId), objectNumber, exeParam, String.valueOf(isMustInput));
    }

    public String genObjectFieldNodeId(String level, Long actionId, Long operateId, String objectNumber, String fieldNumber, Boolean isMustInput) {
        return this.generateNodeId(level, "04", String.valueOf(actionId), String.valueOf(operateId), objectNumber, fieldNumber, String.valueOf(isMustInput));
    }

    public String generateNodeId(String level, String type, String ... data) {
        StringJoiner joiner = new StringJoiner("#");
        if (!SWCStringUtils.isEmpty((String)level)) {
            joiner.add(level);
        }
        if (!SWCStringUtils.isEmpty((String)type)) {
            joiner.add(type);
        }
        for (String cs : data) {
            joiner.add(cs);
        }
        return joiner.toString();
    }

    public Map<String, Object> parseNodeId(String nodeId) {
        if (SWCStringUtils.isEmpty((String)nodeId)) {
            return Collections.emptyMap();
        }
        String[] split = nodeId.split("#");
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        if (split.length >= 1) {
            result.put("level", split[0]);
        }
        if (split.length >= 2) {
            result.put("type", split[1]);
        }
        if (split.length >= 3) {
            result.put("actionId", split[2]);
        }
        if (split.length >= 4) {
            result.put("operateId", split[3]);
        }
        if (split.length >= 5) {
            result.put("entityNumber", split[4]);
        }
        if (split.length >= 6) {
            result.put("fieldNumber", split[5]);
        }
        if (split.length >= 7) {
            result.put("isMustInput", split[6]);
        }
        return result;
    }

    public Optional<String> parseLevel(String nodeId) {
        return this.parseData(nodeId, 1);
    }

    public Optional<String> parseType(String nodeId) {
        return this.parseData(nodeId, 2);
    }

    public Optional<String> parseActionId(String nodeId) {
        return this.parseData(nodeId, 3);
    }

    public Optional<String> parseOperateId(String nodeId) {
        return this.parseData(nodeId, 4);
    }

    public Optional<String> parseEntityNumber(String nodeId) {
        return this.parseData(nodeId, 5);
    }

    public Optional<String> parseFieldNumber(String nodeId) {
        return this.parseData(nodeId, 6);
    }

    public Optional<String> parseIsMustInput(String nodeId) {
        return this.parseData(nodeId, 7);
    }

    public Optional<String> reGen(String nodeId, String level) {
        if (SWCStringUtils.isEmpty((String)nodeId)) {
            return Optional.empty();
        }
        return Optional.of(nodeId.replaceFirst("^L\\d#]", level + PayRollActGrpConstants.COLLA_RULE_ID_SEPERATOR));
    }

    private Optional<String> parseData(String nodeId, int pos) {
        if (SWCStringUtils.isEmpty((String)nodeId)) {
            return Optional.empty();
        }
        String[] split = nodeId.split("#");
        if (split.length >= pos) {
            return Optional.of(split[pos - 1]);
        }
        return Optional.empty();
    }

    public String parseCoreInfoStr(String nodeId) {
        if (SWCStringUtils.isEmpty((String)nodeId)) {
            return nodeId;
        }
        String replace = nodeId.replaceAll("(#true|#false)$", "");
        return replace.replaceAll("^L\\d#\\d{2}#", "");
    }

    public boolean isField(String nodeId) {
        return this.parseType(nodeId).filter(item -> "03".equalsIgnoreCase((String)item) || "04".equalsIgnoreCase((String)item)).isPresent();
    }

    private static class Load {
        private static final CollaRuleNodeIdHelper INSTANCE = new CollaRuleNodeIdHelper();

        private Load() {
        }
    }
}

