/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.cloudcolla;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.factory.CloudCollaExecuteServiceFactory;
import kd.swc.hpdi.business.msgreceive.DataSyncMsgHelper;
import kd.swc.hpdi.business.msgreceive.HPDICollaMsgServiceHelper;
import kd.swc.hpdi.business.msgreceive.TaskCenterDataHelper;
import kd.swc.hpdi.business.service.ICloudCollaExecuteService;
import kd.swc.hpdi.common.entity.ResponseDTO;
import kd.swc.hsbp.business.cloudcolla.StandardCloudCollaTaskExecuteHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.CollaActContext;
import kd.swc.hsbp.common.vo.CollaRuleExecuteContext;
import org.apache.commons.collections4.MapUtils;

public class HPDICloudCollaHelper {
    private static final Log LOGGER = LogFactory.getLog(HPDICloudCollaHelper.class);
    private static final String CLOUD_SWC = "/U+QDTL900//";
    private static final String CLOUD_SIT = "17+ZA9TOOB66";

    private HPDICloudCollaHelper() {
    }

    public static HPDICloudCollaHelper getInstance() {
        return Load.INSTANCE;
    }

    public void setEntryIsSysPreset(ChangeData changeData, IFormView view, String presetFieldKey) {
        Object object = changeData.getNewValue();
        if (object instanceof DynamicObject) {
            int entryIndex = changeData.getRowIndex();
            DynamicObject dyobj = (DynamicObject)object;
            view.getModel().setValue(presetFieldKey, (Object)(dyobj.getBoolean("issyspreset") ? "1" : "0"), entryIndex);
        }
    }

    public void initEntryIsSysPreset(IFormView view, String fieldKey, String presetFieldKey) {
        DynamicObject dyobj = view.getModel().getDataEntity();
        DynamicObjectCollection entryentities = dyobj.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryentity : entryentities) {
            DynamicObject triggerCollaDyobj = entryentity.getDynamicObject(fieldKey);
            if (null == triggerCollaDyobj) continue;
            entryentity.set(presetFieldKey, (Object)(triggerCollaDyobj.getBoolean("issyspreset") ? "1" : "0"));
        }
    }

    public Map<String, Boolean> getPayRollActGrpIsMustFieldMap(DynamicObjectCollection entryentities) {
        Map<String, Boolean> payRollActIsMustFieldMapRel = new HashMap<String, Boolean>(16);
        if (!entryentities.isEmpty()) {
            List<Long> payRollActIds = entryentities.stream().map(tplEntryentity -> tplEntryentity.getLong("payrollact.id")).collect(Collectors.toList());
            List<DynamicObject> payRollActDyobjs = DataSyncMsgHelper.getInstance().queryPayRollActData(payRollActIds);
            if (!CollectionUtils.isEmpty(payRollActDyobjs)) {
                Map<String, Boolean> triggerCollaIsMustFieldMaps = this.getTriggerCollaIsMustFieldMap(payRollActDyobjs);
                payRollActIsMustFieldMapRel = this.getPayRollActIsMustFieldMapRel(payRollActDyobjs, triggerCollaIsMustFieldMaps);
            }
        }
        return payRollActIsMustFieldMapRel;
    }

    private Map<String, Boolean> getPayRollActIsMustFieldMapRel(List<DynamicObject> payRollActDyobjs, Map<String, Boolean> triggerCollaIsMustFieldMaps) {
        HashMap<String, Boolean> payRollActIsMustFieldMapRel = new HashMap<String, Boolean>(16);
        for (DynamicObject payRollActDyobj : payRollActDyobjs) {
            Boolean isMust = Boolean.FALSE;
            DynamicObjectCollection triggerCollas = payRollActDyobj.getDynamicObjectCollection("entryentity");
            for (DynamicObject triggerColla : triggerCollas) {
                if (isMust.booleanValue()) break;
                Boolean isMustFieldMap = triggerCollaIsMustFieldMaps.getOrDefault(triggerColla.getString("triggercolla.id"), Boolean.FALSE);
                isMust = isMust | isMustFieldMap;
            }
            payRollActIsMustFieldMapRel.put(payRollActDyobj.getString("id"), isMust);
        }
        return payRollActIsMustFieldMapRel;
    }

    private Map<String, Boolean> getTriggerCollaIsMustFieldMap(List<DynamicObject> payRollActDyobjs) {
        DynamicObject[] triggetCollaDyobjs;
        ArrayList triggerCollaIds = new ArrayList(10);
        payRollActDyobjs.forEach(payRollActDyobj -> {
            DynamicObjectCollection triggerCollaDyobjs = payRollActDyobj.getDynamicObjectCollection("entryentity");
            triggerCollaDyobjs.forEach(triggerCollaDyobj -> triggerCollaIds.add(triggerCollaDyobj.getLong("triggercolla.id")));
        });
        HashMap<String, Boolean> triggerCollaIsMustFieldMapRel = new HashMap<String, Boolean>(16);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsbs_triggercolla");
        QFilter qFilter = new QFilter("id", "in", triggerCollaIds);
        for (DynamicObject triggerCollaDyobj : triggetCollaDyobjs = serviceHelper.query("ismustfieldmapping", new QFilter[]{qFilter})) {
            triggerCollaIsMustFieldMapRel.put(triggerCollaDyobj.getString("id"), "1".equals(triggerCollaDyobj.getString("ismustfieldmapping")));
        }
        return triggerCollaIsMustFieldMapRel;
    }

    public Map<String, Object> isLaborRelRecordExpired(Long employeeId, Date effectTime) {
        HashMap<String, Object> result = new HashMap<String, Object>(1);
        String resultKey = "isLaborRelRecordExpired";
        result.put(resultKey, Boolean.FALSE);
        if (employeeId == null || employeeId == 0L || effectTime == null) {
            LOGGER.info("[colla] call isLaborRelRecordExpired condition = (employeeId == null || employeeId == 0L || effectTime == null),employeeId = {} ,effectTime = {}", (Object)employeeId, (Object)effectTime);
            return result;
        }
        LOGGER.info("[colla] call isLaborRelRecordExpired,employeeId = {} ,effectTime = {}", (Object)employeeId, (Object)effectTime.getTime());
        List invokeResult = (List)SWCMServiceUtils.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonSyncService", (String)"listInfo", (Object[])new Object[]{"hrpi_laborrelrecord", null, null, employeeId});
        if (CollectionUtils.isEmpty((Collection)invokeResult)) {
            LOGGER.info("[colla] call isLaborRelRecordExpired condition = CollectionUtils.isEmpty(invokeResult)");
            return result;
        }
        Optional<Map> first = invokeResult.stream().filter(item -> (Boolean)item.get("iscurrentversion")).findFirst();
        if (!first.isPresent()) {
            LOGGER.info("[colla] call isLaborRelRecordExpired condition = !first.isPresent()");
            return result;
        }
        Map laborRecord = first.get();
        Date enddate = (Date)laborRecord.get("enddate");
        if (enddate == null) {
            LOGGER.info("[colla] call isLaborRelRecordExpired condition = enddate == null");
            return result;
        }
        LOGGER.info("[colla] call isLaborRelRecordExpired enddate = {}", (Object)enddate.getTime());
        result.put(resultKey, !SWCDateTimeUtils.dayBefore((Date)effectTime, (Date)enddate));
        LOGGER.info("[colla] call isLaborRelRecordExpired success,resultKey = {} ,value = {}", (Object)resultKey, (Object)(!SWCDateTimeUtils.dayBefore((Date)effectTime, (Date)enddate) ? 1 : 0));
        return result;
    }

    private List<DynamicObject> getCollaRuleByIds(List<Map<String, Object>> collaRuleMap) {
        try {
            LOGGER.info("[colla] getCollaRuleByIds , collaRuleMap ={}", (Object)SWCJSONUtils.toString(collaRuleMap));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (CollectionUtils.isEmpty(collaRuleMap)) {
            return Collections.emptyList();
        }
        HashMap<String, Set<Long>> param = new HashMap<String, Set<Long>>(16);
        for (Map<String, Object> objectMap : collaRuleMap) {
            String crClass = MapUtils.getString(objectMap, (Object)"collaRuleClass");
            Long crId = MapUtils.getLong(objectMap, (Object)"collaRuleId", (Long)0L);
            if (SWCStringUtils.isEmpty((String)crClass) || crId == 0L) continue;
            Set ids = param.computeIfAbsent(crClass, item -> new HashSet(16));
            ids.add(crId);
        }
        Table<String, Long, DynamicObject> result = this.queryMultiClassObject(param);
        try {
            LOGGER.info("[colla] getCollaRuleByIds , result ={}", (Object)SWCJSONUtils.toString((Object)result.rowMap()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new ArrayList<DynamicObject>(result.values());
    }

    public Map<String, Object> callCollaRule(Map<String, Object> param) {
        if (CollectionUtils.isEmpty(param)) {
            return this.getResponseResultTips("param");
        }
        Map convertedApiResult = (Map)param.get("convertedApiResult");
        Map paramMap = (Map)param.get("paramMap");
        List collaRuleMaps = (List)param.get("collaRuleMap");
        if (CollectionUtils.isEmpty((Map)convertedApiResult)) {
            return this.getResponseResultTips("convertedApiResult");
        }
        if (CollectionUtils.isEmpty((Map)paramMap)) {
            return this.getResponseResultTips("paramMap");
        }
        if (CollectionUtils.isEmpty((Collection)collaRuleMaps)) {
            return this.getResponseResultTips("collaRuleMap");
        }
        List<DynamicObject> collaRules = this.getCollaRuleByIds(collaRuleMaps);
        if (CollectionUtils.isEmpty(collaRules)) {
            return this.getResponseResult(true, null, null);
        }
        Long orgId = (Long)paramMap.get("orgId");
        Date effectTime = (Date)paramMap.get("effectTime");
        String flowType = (String)paramMap.get("flowType");
        String buNumber = (String)paramMap.get("buNumber");
        Map msgEntity = paramMap.getOrDefault("msgEntity", Collections.emptyMap());
        HashMap<String, Map<String, Object>> originalDataMap = new HashMap<String, Map<String, Object>>(collaRules.size());
        HashMap<String, Map<String, String>> exePreRule = new HashMap<String, Map<String, String>>(16);
        for (DynamicObject collaRule : collaRules) {
            CollaRuleExecuteContext executeInfo = new CollaRuleExecuteContext();
            executeInfo.setConvertedApiDatas(convertedApiResult);
            executeInfo.setOrgId(orgId);
            executeInfo.setEffectTime(effectTime);
            executeInfo.setFlowType(flowType);
            executeInfo.setOrgNumber(buNumber);
            executeInfo.setMsgEntity(msgEntity);
            String crClass = collaRule.getDynamicObjectType().getName();
            long collaRuleId = collaRule.getLong("id");
            long policyId = collaRule.getLong("policy.id");
            String sceneNumber = collaRule.getString("scene.number");
            long sceneId = collaRule.getLong("scene.id");
            String sceneAppNumber = collaRule.getString("scene.bizappid.number");
            DynamicObjectCollection entryEntity = collaRule.getDynamicObjectCollection("entryentity");
            for (DynamicObject actionEntryEntity : entryEntity) {
                CollaActContext collaActContext = new CollaActContext();
                long payRollActId = actionEntryEntity.getLong("payrollact.id");
                long ruleDesignId = actionEntryEntity.getLong("ruledesign.id");
                Map exePreRuleSet = exePreRule.getOrDefault(crClass + "#" + collaRuleId, new HashMap(16));
                if (ruleDesignId != 0L) {
                    exePreRuleSet.put(policyId + "#" + ruleDesignId, actionEntryEntity.getString("payrollact.name"));
                }
                exePreRule.put(crClass + "#" + collaRuleId, exePreRuleSet);
                DynamicObjectCollection fieldRuleSubEntry = actionEntryEntity.getDynamicObjectCollection("fieldrulesubentryentity");
                collaActContext.setRuleId(Long.valueOf(ruleDesignId));
                collaActContext.setPolicyId(Long.valueOf(policyId));
                collaActContext.setPayRollActId(Long.valueOf(payRollActId));
                collaActContext.setSceneNumber(sceneNumber);
                collaActContext.setSceneAppNumber(sceneAppNumber);
                collaActContext.setSceneId(Long.valueOf(sceneId));
                if (CollectionUtils.isEmpty((Collection)fieldRuleSubEntry)) continue;
                List policyIds = fieldRuleSubEntry.stream().map(item -> item.getLong("frfieldrule.policy.id")).filter(item -> item != 0L).collect(Collectors.toList());
                LOGGER.info("[colla] policyIds = {}", policyIds);
                collaActContext.setPolicyIds(policyIds);
                executeInfo.getCollaActContext().add(collaActContext);
            }
            StandardCloudCollaTaskExecuteHelper helper = new StandardCloudCollaTaskExecuteHelper(executeInfo);
            try {
                Map original = helper.callRuleEngineOriginal(executeInfo);
                if (!"200".equals(MapUtils.getString((Map)original, (Object)"responseCode", (String)"200"))) {
                    LOGGER.info("[colla] call rule engine error: {}", (Object)MapUtils.getString((Map)original, (Object)"errorMsg"));
                    return this.getResponseResult(false, ResManager.loadKDString((String)"\u6267\u884c\u89c4\u5219\u5f15\u64ce\u51fa\u73b0\u9519\u8bef\uff1a\u201c{0}\u201d\u3002\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"HPDICloudCollaHelper_1", (String)"swc-hpdi-business", (Object[])new Object[]{MapUtils.getString((Map)original, (Object)"errorMsg")}), null);
                }
                originalDataMap.put(crClass + "#" + collaRuleId, original);
            }
            catch (Exception ex) {
                LOGGER.info("[colla] call rule engine error.", (Object)ex);
                return this.getResponseResult(false, ResManager.loadKDString((String)"\u6267\u884c\u89c4\u5219\u5f15\u64ce\u51fa\u73b0\u9519\u8bef\uff1a\u201c{0}\u201d\u3002\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"HPDICloudCollaHelper_1", (String)"swc-hpdi-business", (Object[])new Object[]{ex.getMessage()}), null);
            }
        }
        if (CollectionUtils.isEmpty(originalDataMap)) {
            return this.getResponseResult(true, null, null);
        }
        return this.getResponseResult(true, null, this.convertRuleEngineData(originalDataMap, exePreRule));
    }

    private Map<String, Object> convertRuleEngineData(Map<String, Map<String, Object>> originalDataMap, Map<String, Map<String, String>> exePreRule) {
        HashMap<String, Object> result = new HashMap<String, Object>(originalDataMap.size());
        originalDataMap.forEach((ruleComboId, collaRuleResult) -> {
            String responseCode = (String)collaRuleResult.get("responseCode");
            String responseDesc = (String)collaRuleResult.get("responseDesc");
            String errorMsg = (String)collaRuleResult.get("errorMsg");
            if (!"200".equals(responseCode)) {
                result.put(String.valueOf(ruleComboId), this.getResponseResult(false, errorMsg, null));
                return;
            }
            List policyResults = (List)collaRuleResult.get("policyResults");
            if (CollectionUtils.isEmpty((Collection)policyResults)) {
                result.put(String.valueOf(ruleComboId), this.getResponseResult(true, responseDesc, null));
                return;
            }
            HashMap<String, Object> ruleDataResult = new HashMap<String, Object>(policyResults.size());
            HashMap<String, Object> exePreConditionResult = new HashMap<String, Object>(policyResults.size());
            Map exePreSet = (Map)exePreRule.get(ruleComboId);
            for (Map policyResult : policyResults) {
                Map<String, Object> fieldValue;
                Map<String, Object> ruleResult = HPDICloudCollaHelper.getRuleResult(exePreConditionResult, exePreSet, policyResult);
                if (ruleResult == null || CollectionUtils.isEmpty(fieldValue = this.getFieldValue(ruleResult, ruleDataResult))) continue;
                ruleDataResult.putAll(fieldValue);
            }
            Map<String, Object> checkResult = this.checkExePreConditionResult(exePreConditionResult, exePreSet);
            boolean success = (Boolean)checkResult.get("success");
            String msg = (String)checkResult.get("msg");
            result.put(String.valueOf(ruleComboId), this.getResponseResult(success, SWCStringUtils.isEmpty((String)msg) ? null : msg, ruleDataResult, success ? null : checkResult));
        });
        return result;
    }

    private Map<String, Object> checkExePreConditionResult(Map<String, Object> exePreConditionResult, Map<String, String> exePreSet) {
        HashMap<String, Object> result = new HashMap<String, Object>(exePreSet.size());
        result.put("success", Boolean.TRUE);
        ArrayList<String> resultMsg = new ArrayList<String>(exePreSet.size());
        ArrayList errorData = new ArrayList(exePreSet.size());
        for (Map.Entry<String, String> dataEntry : exePreSet.entrySet()) {
            String key = dataEntry.getKey();
            String name = dataEntry.getValue();
            Object value = exePreConditionResult.get(key);
            if (value != null && "success".equalsIgnoreCase(String.valueOf(exePreConditionResult.get(key)))) continue;
            resultMsg.add(ResManager.loadKDString((String)"[{0}]\u6267\u884c\u524d\u63d0\u6761\u4ef6\u4e0d\u6ee1\u8db3\u3002", (String)"HPDICloudCollaHelper_2", (String)"swc-hpdi-business", (Object[])new Object[]{name}));
            result.put("success", Boolean.FALSE);
            HashMap<String, String> errorDataMap = new HashMap<String, String>(16);
            errorDataMap.put("code", "COLLA_RULE_ERROR_001");
            errorDataMap.put("actName", name);
            errorData.add(errorDataMap);
        }
        if (!CollectionUtils.isEmpty(errorData)) {
            result.put("errorData", errorData);
        }
        if (!CollectionUtils.isEmpty(resultMsg)) {
            result.put("msg", resultMsg.stream().collect(Collectors.joining(System.lineSeparator())));
        }
        return result;
    }

    private Map<String, Object> getFieldValue(Map<String, Object> ruleResult, Map<String, Object> ruleDataResult) {
        Object value = ruleResult.get("value");
        if (value == null) {
            return null;
        }
        String field = (String)ruleResult.get("field");
        String entityType = (String)ruleResult.get("entityType");
        String fieldType = (String)ruleResult.get("fieldType");
        String key = field;
        Object fieldValue = value;
        if (SWCStringUtils.isNotEmpty((String)entityType)) {
            DynamicObject object = (DynamicObject)ruleDataResult.getOrDefault(entityType, new SWCDataServiceHelper(entityType).generateEmptyDynamicObject(entityType));
            key = entityType;
            String[] split = field.split("\\.");
            if (split.length < 2) {
                return null;
            }
            String formId = split[1];
            object.set(formId, HPDICloudCollaHelper.parseRuleEngineResult(value, entityType, fieldType, formId));
            fieldValue = object;
        } else if ("date".equals(fieldType)) {
            try {
                fieldValue = SWCDateTimeUtils.parseDate((String)String.valueOf(value));
            }
            catch (ParseException ex) {
                LOGGER.info("[colla] parse datetime error.", (Object)ex);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(key, fieldValue);
        return result;
    }

    private static Object parseRuleEngineResult(Object value, String entityType, String fieldType, String formId) {
        if (value == null || "null".equalsIgnoreCase(String.valueOf(value))) {
            return null;
        }
        Object result = value;
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityType);
        DynamicProperty property = dataEntityType.getProperty(formId);
        if ("dynamicObject".equalsIgnoreCase(fieldType)) {
            String baseEntityId = ((BasedataProp)property).getBaseEntityId();
            result = new SWCDataServiceHelper(baseEntityId).generateDynamicObject(value, SWCHisBaseDataHelper.getSelectProperties((String)baseEntityId));
        } else if ("date".equalsIgnoreCase(fieldType)) {
            try {
                result = SWCDateTimeUtils.parseDate((String)String.valueOf(value));
            }
            catch (ParseException ex) {
                LOGGER.info("[colla] parse datetime error.", (Object)ex);
                result = null;
            }
        } else if ("boolean".equalsIgnoreCase(fieldType)) {
            result = Boolean.parseBoolean(String.valueOf(value));
        } else if ("number".equalsIgnoreCase(fieldType)) {
            try {
                Long tempData;
                BigDecimal tempValue = new BigDecimal(String.valueOf(value));
                result = property instanceof DecimalProp ? tempValue : (0L == (tempData = Long.valueOf(tempValue.longValue())) ? null : tempData);
            }
            catch (Exception ex) {
                LOGGER.info("[colla] parse number error.", (Object)ex);
                result = null;
            }
        }
        return result;
    }

    private static Map<String, Object> getRuleResult(Map<String, Object> exePreConditionResult, Map<String, String> exePreSet, Map<String, Object> policyResult) {
        Map ruleResult = null;
        List ruleResults = (List)policyResult.get("ruleResults");
        String policyId = (String)policyResult.get("policyId");
        if (CollectionUtils.isEmpty((Collection)ruleResults)) {
            List defaultResults = (List)policyResult.get("defaultResults");
            ruleResult = defaultResults != null && defaultResults.size() > 0 ? (Map)defaultResults.get(0) : null;
        } else {
            for (Map ruleData : ruleResults) {
                String ruleDesignId = (String)ruleData.get("ruleDesignId");
                String key = policyId + "#" + ruleDesignId;
                if (exePreSet.containsKey(key)) {
                    exePreConditionResult.put(key, ((Map)((List)ruleData.get("matchResults")).get(0)).get("value"));
                    continue;
                }
                List matchResults = (List)ruleData.get("matchResults");
                ruleResult = (Map)matchResults.get(0);
            }
        }
        return ruleResult;
    }

    private Map<String, Object> getResponseResultTips(String paramName) {
        return this.getResponseResult(false, ResManager.loadKDString((String)"\u53c2\u6570 {0} \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HPDICloudCollaHelper_0", (String)"swc-hpdi-business", (Object[])new Object[]{paramName}), null);
    }

    private Map<String, Object> getResponseResult(boolean isSuccess, String msg, Object data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", isSuccess);
        result.put("msg", msg);
        result.put("data", data);
        return result;
    }

    private Map<String, Object> getResponseResult(boolean isSuccess, String msg, Object data, Object errorData) {
        Map<String, Object> responseResult = this.getResponseResult(isSuccess, msg, data);
        if (errorData != null) {
            responseResult.put("errorDataList", errorData);
        }
        return responseResult;
    }

    public static List<String> getDefaultCloudIds() {
        ArrayList<String> cloudIds = new ArrayList<String>(2);
        cloudIds.add(CLOUD_SWC);
        cloudIds.add(CLOUD_SIT);
        return cloudIds;
    }

    public boolean getCollaCtrFunctional() {
        Map paramMap = SWCSalaryParameterServiceHelper.getSalaryParam((long)1886397164888897536L);
        if (paramMap == null || paramMap.size() == 0) {
            return false;
        }
        String collaManageRole = MapUtils.getString((Map)paramMap, (Object)"collamanagerole");
        return StringUtils.equals((CharSequence)collaManageRole, (CharSequence)"swcmanage");
    }

    public String getCurrentTaskArrangeNumber() {
        return this.getCollaCtrFunctional() ? "hpdi_taskarrange" : "hpdi_taskrule";
    }

    public String getCurrentCollaTaskNumber() {
        return this.getCollaCtrFunctional() ? "hpdi_collatask" : "hpdi_taskcenter";
    }

    private String getCurrentTaskArrange(boolean isCollaCtrFunctionalTrue) {
        return isCollaCtrFunctionalTrue ? "hpdi_taskarrange" : "hpdi_taskrule";
    }

    private String getCurrentCollaTask(boolean isCollaCtrFunctionalTrue) {
        return isCollaCtrFunctionalTrue ? "hpdi_collatask" : "hpdi_taskcenter";
    }

    public String matchCollaTaskNumber(String taskRuleNumber) {
        return this.getCurrentCollaTask(!"hpdi_taskrule".equalsIgnoreCase(taskRuleNumber));
    }

    public String matchTaskArrangeNumber(String collaTaskNumber) {
        return this.getCurrentTaskArrange(!"hpdi_taskcenter".equalsIgnoreCase(collaTaskNumber));
    }

    public Table<String, Long, DynamicObject> queryMultiClassObject(Map<String, Set<Long>> param, String properties) {
        HashBasedTable result = HashBasedTable.create();
        if (CollectionUtils.isEmpty(param)) {
            return result;
        }
        boolean isQueryProperties = SWCStringUtils.isEmpty((String)properties);
        param.forEach((objClass, idSet) -> {
            SWCDataServiceHelper orm = new SWCDataServiceHelper(objClass);
            DynamicObject[] query = orm.query(isQueryProperties ? SWCHisBaseDataHelper.getSelectProperties((String)objClass) : properties, new QFilter[]{new QFilter("id", "in", idSet)});
            if (query != null && query.length > 0) {
                for (DynamicObject obj : query) {
                    result.put(objClass, (Object)obj.getLong("id"), (Object)obj);
                }
            }
        });
        return result;
    }

    public Table<String, Long, DynamicObject> queryMultiClassObject(Map<String, Set<Long>> param) {
        return this.queryMultiClassObject(param, null);
    }

    public Map<Long, Map<String, Object>> executeCloudCollaTask(Map<String, Object> param) {
        List taskCenterEntryData = (List)MapUtils.getObject(param, (Object)"taskCenterEntryData", Collections.emptyList());
        LOGGER.info("[colla] before validateDependencyData taskCenterEntryData, taskCenterEntryData.size = {}", (Object)taskCenterEntryData.size());
        LOGGER.info("[colla] after validateDependencyData taskCenterEntryData, taskCenterEntryData.size = {}", (Object)taskCenterEntryData.size());
        HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>(16);
        HashMap preExeResult = new HashMap(16);
        for (Map taskCenterEntryDatum : taskCenterEntryData) {
            String payRollActGrpClass = MapUtils.getString((Map)taskCenterEntryDatum, (Object)"payRollActGrpClass");
            Boolean stopAfterFail = MapUtils.getBoolean((Map)taskCenterEntryDatum, (Object)"stopAfterFail", (Boolean)Boolean.FALSE);
            ICloudCollaExecuteService service = CloudCollaExecuteServiceFactory.getService(payRollActGrpClass);
            HashMap<String, Object> executeParam = new HashMap<String, Object>(param);
            executeParam.put("taskCenterEntryData", Collections.singletonList(taskCenterEntryDatum));
            executeParam.put("preExeResult", preExeResult);
            ResponseDTO<Map<Long, Map<String, Object>>> executeResult = service.execute(executeParam);
            LOGGER.info("[colla] executeCloudCollaTask service.execute executeResult.isSuccess() = {},  stopAfterFail = {}", (Object)executeResult.isSuccess(), (Object)stopAfterFail);
            if (!executeResult.isSuccess() && stopAfterFail.booleanValue()) {
                LOGGER.info("[colla] after call biz app rpc service falure, taskCenterEntryDatum.centerEntId = {}", (Object)MapUtils.getLong((Map)taskCenterEntryDatum, (Object)"centerEntId"));
                return result;
            }
            LOGGER.info("[colla] after call biz app rpc service success, taskCenterEntryDatum.centerEntId = {}", (Object)MapUtils.getLong((Map)taskCenterEntryDatum, (Object)"centerEntId"));
            Map tempResult = (Map)executeResult.getResult();
            if (CollectionUtils.isEmpty((Map)tempResult)) continue;
            result.putAll((Map)executeResult.getResult());
            tempResult.forEach((crId, crResult) -> {
                Map data = (Map)MapUtils.getObject((Map)crResult, (Object)"data", Collections.emptyMap());
                preExeResult.putAll(data);
            });
        }
        return result;
    }

    private List<Map<String, Object>> validateDependencyData(List<Map<String, Object>> taskCenterEntryData, Map<String, Object> param) {
        if (CollectionUtils.isEmpty(taskCenterEntryData)) {
            return taskCenterEntryData;
        }
        String flowType = MapUtils.getString(param, (Object)"flowType");
        if (SWCStringUtils.isEmpty((String)flowType) || "0".equalsIgnoreCase(flowType) || "2".equalsIgnoreCase(flowType)) {
            return taskCenterEntryData;
        }
        Map<String, List<DynamicObject>> dependencyTaskMap = this.getMsgDependencyData(MapUtils.getLong(param, (Object)"orgMsgRecvCenterId"), MapUtils.getString(param, (Object)"taskCenterClass"));
        ArrayList canExcuTaskEntryList = Lists.newArrayListWithCapacity((int)taskCenterEntryData.size());
        HashMap<Long, Map<String, Object>> taskResult = new HashMap<Long, Map<String, Object>>(16);
        long currUserId = RequestContext.get().getCurrUserId();
        long currentTimeMillis = System.currentTimeMillis();
        for (Map<String, Object> taskCenterEntryDatum : taskCenterEntryData) {
            Boolean stopAfterFail = MapUtils.getBoolean(taskCenterEntryDatum, (Object)"stopAfterFail", (Boolean)Boolean.FALSE);
            String msg = this.validateDependencyData(dependencyTaskMap, taskCenterEntryDatum);
            if (!StringUtils.isEmpty((CharSequence)msg)) {
                Long entryId = MapUtils.getLong(taskCenterEntryDatum, (Object)"centerEntId");
                HashMap<String, Object> entryResult = new HashMap<String, Object>(16);
                entryResult.put("entryentity.id", entryId);
                entryResult.put("entryentity.taskexecutestatusent", "E");
                entryResult.put("entryentity.taskexecmanner", MapUtils.getString(param, (Object)"taskExecManner"));
                entryResult.put("entryentity.executefailmsgent", msg);
                entryResult.put("id", MapUtils.getLong(param, (Object)"taskCenterId"));
                entryResult.put("entryentity.taskexecutetime", currentTimeMillis);
                entryResult.put("entryentity.taskexecuser", currUserId);
                taskResult.put(entryId, entryResult);
                if (!stopAfterFail.booleanValue()) continue;
                break;
            }
            canExcuTaskEntryList.add(taskCenterEntryDatum);
        }
        if (!CollectionUtils.isEmpty(taskResult)) {
            this.updateTaskStatus(taskResult, param);
        }
        return canExcuTaskEntryList;
    }

    private void updateTaskStatus(Map<Long, Map<String, Object>> result, Map<String, Object> param) {
        Long taskCenterId = MapUtils.getLong(param, (Object)"taskCenterId");
        String taskCenterClass = MapUtils.getString(param, (Object)"taskCenterClass");
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(taskCenterClass);
        DynamicObject dyobj = serviceHelper.queryOne((Object)taskCenterId);
        if (null == dyobj) {
            return;
        }
        HPDICloudCollaHelper.dealTaskCenter(dyobj, result, serviceHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBackTaskCenter(Map<String, Object> messageData, String entityId) {
        Map syncData = (Map)messageData.get("data");
        Object id = syncData.get("id");
        String key = "colla_" + entityId + "_" + id;
        DLock lock = DLock.create((String)key);
        try {
            SWCDataServiceHelper serviceHelper;
            DynamicObject dyobj;
            if (!lock.tryLock(10000L)) {
                DLock.forceUnlock((String[])new String[]{key});
                lock.lock();
            }
            if (null == (dyobj = (serviceHelper = new SWCDataServiceHelper(entityId)).queryOne(id))) {
                return;
            }
            if ("hpdi_taskcenter".equals(entityId) || "hpdi_collatask".equals(entityId)) {
                Object entryId = syncData.get("entryentity.id");
                if (entryId == null) {
                    HPDICloudCollaHelper.dealCommon(dyobj, syncData, serviceHelper);
                } else {
                    HashMap syncDataMap = Maps.newHashMapWithExpectedSize((int)1);
                    syncDataMap.put((Long)entryId, syncData);
                    HPDICloudCollaHelper.dealTaskCenter(dyobj, syncDataMap, serviceHelper);
                }
            } else {
                HPDICloudCollaHelper.dealCommon(dyobj, syncData, serviceHelper);
            }
        }
        finally {
            lock.unlock();
            lock.close();
        }
    }

    public static void dealTaskCenter(DynamicObject dyobj, Map<Long, Map<String, Object>> syncDataMap, SWCDataServiceHelper serviceHelper) {
        if (CollectionUtils.isEmpty(syncDataMap)) {
            return;
        }
        DynamicObjectCollection entryentities = dyobj.getDynamicObjectCollection("entryentity");
        int success = 0;
        int fail = 0;
        StringBuffer msgSb = new StringBuffer();
        for (DynamicObject entryent : entryentities) {
            String failMsg;
            String status;
            long entryId = entryent.getLong("id");
            Map<String, Object> syncData = syncDataMap.get(entryId);
            if (!CollectionUtils.isEmpty(syncData)) {
                for (Map.Entry<String, Object> syncDataEntry : syncData.entrySet()) {
                    if (!syncDataEntry.getKey().contains("entryentity")) continue;
                    Object value = syncDataEntry.getValue();
                    if (syncDataEntry.getKey().contains("executefailmsgent")) {
                        String msg = String.valueOf(value);
                        value = msg.length() > 2000 ? msg.subSequence(0, 1999) : msg;
                    }
                    entryent.set(syncDataEntry.getKey().replace("entryentity.", ""), value);
                }
            }
            if ("D".equals(status = entryent.getString("taskexecutestatusent"))) {
                ++success;
            } else if ("E".equals(status)) {
                ++fail;
            } else if ("G".equalsIgnoreCase(status)) {
                ++success;
            }
            if (SWCStringUtils.isEmpty((String)(failMsg = entryent.getString("executefailmsgent")))) continue;
            if (msgSb.length() > 0) {
                msgSb.append(System.lineSeparator());
            }
            msgSb.append(failMsg);
        }
        int size = entryentities.size();
        String status = null;
        if (success == 0 && fail > 0) {
            status = "E";
        } else if (success == size) {
            status = "D";
        } else if (0 < success && success < size) {
            status = "F";
        }
        if (status != null) {
            dyobj.set("taskexecutestatus", (Object)status);
        }
        dyobj.set("executefailmsg", (Object)(msgSb.length() > 2000 ? msgSb.subSequence(0, 1999) : msgSb));
        serviceHelper.updateOne(dyobj);
        HPDICollaMsgServiceHelper instance = HPDICollaMsgServiceHelper.getInstance();
        instance.executeOtherFlowInTasks(new DynamicObject[]{dyobj});
        instance.callBackHrmpMsgCenter(dyobj, String.valueOf(msgSb));
    }

    public static void dealCommon(DynamicObject dyobj, Map<String, Object> syncData, SWCDataServiceHelper serviceHelper) {
        for (Map.Entry<String, Object> syncDataEntry : syncData.entrySet()) {
            dyobj.set(syncDataEntry.getKey(), syncDataEntry.getValue());
        }
        serviceHelper.updateOne(dyobj);
    }

    private String validateDependencyData(Map<String, List<DynamicObject>> dependencyTaskMap, Map<String, Object> taskCenterEntryDatum) {
        if (CollectionUtils.isEmpty(dependencyTaskMap)) {
            return null;
        }
        String collaRuleClass = MapUtils.getString(taskCenterEntryDatum, (Object)"payRollActGrpClass");
        List<DynamicObject> preTaskEntrys = dependencyTaskMap.get(collaRuleClass);
        if (CollectionUtils.isEmpty(preTaskEntrys)) {
            return null;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)collaRuleClass);
        if (entityType == null) {
            LOGGER.info("[colla] HPDICloudCollaHelper validateDependencyData entityType is null collaRuleClass={}", (Object)collaRuleClass);
            entityType = new MainEntityType();
        }
        DynamicObject preTaskEntry = preTaskEntrys.get(0);
        DynamicObject preTaskDyn = (DynamicObject)preTaskEntry.getParent();
        return ResManager.loadKDString((String)"\u534f\u4f5c\u89c4\u5219\u6267\u884c\u5931\u8d25\uff1a\u4f9d\u8d56\u7684\u534f\u4f5c\u4efb\u52a1\u201c{0}\u201d\u7684{1}\u672a\u6267\u884c\u6210\u529f\u3002", (String)"HPDICloudCollaHelper_3", (String)"swc-hpdi-business", (Object[])new Object[]{preTaskDyn.getString("number"), entityType.getDisplayName()});
    }

    public Map<String, Object> queryCollaDataByIds(String entityNumber, List<Long> ids, Boolean isUseBoid) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        try {
            SWCDataServiceHelper entityOrm = new SWCDataServiceHelper(entityNumber);
            if (isUseBoid == null) {
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                isUseBoid = dataEntityType.getProperties().containsKey((Object)"boid");
            }
            QFilter idFilter = new QFilter(isUseBoid != false ? "boid" : "id", "in", ids);
            DynamicObject[] query = entityOrm.query(SWCHisBaseDataHelper.getSelectProperties((String)entityNumber), new QFilter[]{idFilter});
            List result = Arrays.stream(query).collect(Collectors.toList());
            resultMap.put("success", Boolean.TRUE);
            resultMap.put("data", result);
            return resultMap;
        }
        catch (Exception ex) {
            resultMap.put("success", Boolean.FALSE);
            resultMap.put("message", ex.getMessage());
            return resultMap;
        }
    }

    public Map<String, Object> parseCollaRule(String comboCrId) {
        if (SWCStringUtils.isEmpty((String)comboCrId)) {
            return Collections.emptyMap();
        }
        String[] split = comboCrId.split("#");
        if (split.length != 2) {
            return Collections.emptyMap();
        }
        String crClass = split[0];
        String crId = split[1];
        if (SWCStringUtils.isEmpty((String)crClass) || SWCStringUtils.isEmpty((String)crId)) {
            return Collections.emptyMap();
        }
        return ImmutableMap.of((Object)"collaRuleClass", (Object)crClass.toLowerCase(Locale.ROOT), (Object)"collaRuleId", (Object)Long.valueOf(crId));
    }

    private Map<String, List<DynamicObject>> getMsgDependencyData(Long orgMsgRecvCenterId, String taskCenterClass) {
        if (orgMsgRecvCenterId == null || orgMsgRecvCenterId == 0L || StringUtils.isEmpty((CharSequence)taskCenterClass)) {
            return Collections.emptyMap();
        }
        TaskCenterDataHelper taskCenterDataHelper = new TaskCenterDataHelper(taskCenterClass);
        DynamicObject[] taskCenters = taskCenterDataHelper.getTaskCenterByMsgReceiveIds(Lists.newArrayList((Object[])new Long[]{orgMsgRecvCenterId}));
        if (taskCenters == null || taskCenters.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, List<DynamicObject>> result = new HashMap<String, List<DynamicObject>>(16);
        for (DynamicObject taskCenter : taskCenters) {
            DynamicObjectCollection taskEntry;
            String flowtype;
            String executeStatus = taskCenter.getString("taskexecutestatus");
            if ("D".equals(executeStatus) || !"2".equalsIgnoreCase(flowtype = taskCenter.getString("flowtype")) || (taskEntry = taskCenter.getDynamicObjectCollection("entryentity")) == null || taskEntry.size() == 0) continue;
            for (DynamicObject entry : taskEntry) {
                String taskExecuteStatusEnt = entry.getString("taskexecutestatusent");
                if (StringUtils.equals((CharSequence)taskExecuteStatusEnt, (CharSequence)"D") || StringUtils.equals((CharSequence)taskExecuteStatusEnt, (CharSequence)"G")) continue;
                List preTaskEntry = result.computeIfAbsent(entry.getString("collaruleclass"), k -> Lists.newArrayListWithExpectedSize((int)10));
                preTaskEntry.add(entry);
            }
        }
        return result;
    }

    public List<DynamicObject> getBizAppList(String flowType, Long actionType, List<DynamicObject> bizAppObjectList) {
        if (CollectionUtils.isEmpty(bizAppObjectList)) {
            return bizAppObjectList;
        }
        ImmutableSet actionTypeSet = ImmutableSet.of((Object)101130L, (Object)101140L, (Object)101050L, (Object)101060L);
        Set appSet = bizAppObjectList.stream().map(item -> item.getString("number")).collect(Collectors.toSet());
        if ("2".equals(flowType) && actionTypeSet.contains((Object)actionType) && appSet.contains("hcdm")) {
            if (appSet.size() == 1) {
                return Collections.emptyList();
            }
            return bizAppObjectList.stream().filter(item -> !"hcdm".equals(item.getString("number"))).collect(Collectors.toList());
        }
        return bizAppObjectList;
    }

    private static class Load {
        private static final HPDICloudCollaHelper INSTANCE = new HPDICloudCollaHelper();

        private Load() {
        }
    }
}

