/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.cloudcolla;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.ext.hr.ruleengine.controls.ResultControl;
import kd.bos.ext.hr.ruleengine.utils.ParamsUtil;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hpdi.business.extpoint.collarule.ICollaRuleExtService;
import kd.sdk.swc.hpdi.common.events.collarule.AfterGetCustomResultEvent;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;

public class ResultControlHelper {
    private ResultControlHelper() {
    }

    public static ResultControlHelper getInstance() {
        return Load.INSTANCE;
    }

    public List<Map<String, String>> getFilterResult(Long sceneId, String entityNumber, String fieldNumber, String type) {
        Optional<String> refResultStr = this.genRefResultStr(entityNumber, fieldNumber, type);
        if (!refResultStr.isPresent()) {
            return Collections.emptyList();
        }
        List outputParamData = ParamsUtil.getOutputParamData((Long)sceneId);
        HashSet<String> resultStr = new HashSet<String>(16);
        resultStr.add(refResultStr.get());
        if (this.getCustomEntity().contains(entityNumber) && "04".equalsIgnoreCase(type)) {
            resultStr.add("result_customize");
        }
        return outputParamData.stream().filter(item -> resultStr.contains(MapUtils.getString((Map)item, (Object)"number"))).peek(item -> {
            item.put("level", "1");
            item.put("text", MapUtils.getString((Map)item, (Object)"name"));
        }).collect(Collectors.toList());
    }

    private Set<String> getCustomEntity() {
        HashSet result = Sets.newHashSet((Object[])new String[]{"hsas_salaryfile", "hcdm_adjfileinfo", "hcsi_sinsurfile", "itc_taxfile", "itc_employment"});
        AfterGetCustomResultEvent event = new AfterGetCustomResultEvent();
        event.setEntitySet((Set)result);
        HRPluginProxy proxy = HRPlugInProxyFactory.create((Object)new ICollaRuleExtService(){

            public void afterGetCustomResult(AfterGetCustomResultEvent event) {
                super.afterGetCustomResult(event);
            }
        }, ICollaRuleExtService.class, (String)"kd.sdk.swc.hpdi.business.extpoint.collarule.ICollaRuleExtService#afterGetCustomResult", null);
        proxy.callReplaceIfPresent(ext -> {
            ext.afterGetCustomResult(event);
            return null;
        });
        return result;
    }

    public Optional<String> genRefResultStr(String entityNumber, String field, String type) {
        if (SWCStringUtils.isEmpty((String)entityNumber) && SWCStringUtils.isEmpty((String)field)) {
            return Optional.empty();
        }
        if (SWCStringUtils.isEmpty((String)entityNumber)) {
            return Optional.of(field);
        }
        if ("03".equalsIgnoreCase(type)) {
            return Optional.of(String.join((CharSequence)"_", entityNumber, field));
        }
        if ("04".equalsIgnoreCase(type)) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            IDataEntityProperty property = (IDataEntityProperty)dataEntityType.getProperties().get((Object)field);
            if (Optional.ofNullable(property).orElseGet(TextProp::new) instanceof BasedataProp) {
                ISimpleProperty primaryKey = EntityMetadataCache.getDataEntityType((String)((BasedataProp)property).getBaseEntityId()).getPrimaryKey();
                return Optional.of(String.join((CharSequence)".", entityNumber, entityNumber, field, Optional.ofNullable(primaryKey).map(IMetadata::getName).orElse("id")));
            }
            return Optional.of(String.join((CharSequence)".", entityNumber, entityNumber, field));
        }
        return Optional.of(String.join((CharSequence)".", entityNumber, entityNumber, field));
    }

    public void initControlStatus(IFormView view, String control, Boolean paramChange) {
        if (view == null || SWCStringUtils.isEmpty((String)control)) {
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("initing", "true");
        data.put("paramChange", paramChange);
        data.put("defaultRows", 1);
        data.put("showDeleteOnlyOneRow", false);
        data.put("hideButton", true);
        IClientViewProxy service = (IClientViewProxy)view.getService(IClientViewProxy.class);
        Optional.ofNullable(service).ifPresent(item -> item.invokeControlMethod(control, "updateData", new Object[]{data}));
    }

    public void updateResultControlData(IFormView view, String control, Object schemeParam, Object schemeParamValue, String value, String pageState) {
        if (view == null || SWCStringUtils.isEmpty((String)control) || schemeParam == null) {
            return;
        }
        ResultControl defaultResult = (ResultControl)view.getControl(control);
        Optional.ofNullable(pageState).filter(item -> "edit".equalsIgnoreCase(pageState)).ifPresent(arg_0 -> ((ResultControl)defaultResult).setPageState(arg_0));
        HashMap<String, String> data = new HashMap<String, String>(16);
        Optional.ofNullable(schemeParam).ifPresent(item -> {
            data.put("param", (String)schemeParam);
            data.put("initing", "true");
            data.put("paramChange", (String)(schemeParam instanceof List && ((List)schemeParam).size() > 1 ? 1 : 0));
            data.put("defaultRows", (String)1);
            data.put("showDeleteOnlyOneRow", (String)false);
            data.put("hideButton", (String)true);
        });
        Optional.ofNullable(schemeParamValue).ifPresent(item -> data.put("valueParam", (String)schemeParamValue));
        Optional.ofNullable(value).ifPresent(item -> data.put("value", value));
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        data.put("_#source_", this.getClass().getName());
        IClientViewProxy service = (IClientViewProxy)view.getService(IClientViewProxy.class);
        Optional.ofNullable(service).ifPresent(item -> item.invokeControlMethod(control, "updateData", new Object[]{data}));
        Optional.ofNullable(pageState).filter(item -> "view".equalsIgnoreCase(pageState)).ifPresent(arg_0 -> ((ResultControl)defaultResult).setPageState(arg_0));
    }

    public Map<String, List<Map<String, String>>> getSchemeParamValue(Long sceneId) {
        return ParamsUtil.getInputValueParamMap((Long)sceneId);
    }

    private static class Load {
        private static final ResultControlHelper INSTANCE = new ResultControlHelper();

        private Load() {
        }
    }
}

