/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.cloudcolla.fieldrule;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.OrgServiceUtil;
import kd.swc.hpdi.business.cloudcolla.PayRollActGrpHelper;
import kd.swc.hpdi.common.entity.HRPolicyEntity;
import kd.swc.hpdi.common.entity.HrRuleDesignEntity;
import kd.swc.hpdi.common.entity.HrUsableRangeEntity;
import kd.swc.hpdi.common.entity.ResponseDTO;

public class FieldRuleHelper {
    private static final Log LOGGER = LogFactory.getLog(FieldRuleHelper.class);

    private static Long getHrRootId(Long defaultOrgId) {
        return OrgServiceUtil.getHRRootOrgId();
    }

    public static String savePolicyEntity(DynamicObject fieldRuleDyn, String defaultValue, String operateKey) {
        try {
            HRPolicyEntity policyEntity = FieldRuleHelper.fieldRuleDynToPolicyEntity(fieldRuleDyn, defaultValue, operateKey);
            if (policyEntity == null) {
                LOGGER.error("FieldRuleHelper savePolicyEntity error: policyEntity is null.");
                return PayRollActGrpHelper.getDefaultErrorCode().getMessage();
            }
            ResponseDTO<Map<String, Long>> response = PayRollActGrpHelper.batchInsertOrUpdateHrPolicy(Lists.newArrayList((Object[])new HRPolicyEntity[]{policyEntity}));
            if (response == null) {
                LOGGER.error("FieldRuleHelper savePolicyEntity error: response is null.");
                return PayRollActGrpHelper.getDefaultErrorCode().getMessage();
            }
            if (!response.isSuccess()) {
                LOGGER.error("FieldRuleHelper savePolicyEntity error response is fail: ", (Object)response.getErrorMsg());
                return PayRollActGrpHelper.getDefaultErrorCode().getMessage();
            }
            Map result = (Map)response.getResult();
            if (CollectionUtils.isEmpty((Map)result)) {
                LOGGER.error("FieldRuleHelper savePolicyEntity error: result is null ");
                return PayRollActGrpHelper.getDefaultErrorCode().getMessage();
            }
            DynamicObject policyDyn = new HRBaseServiceHelper("brm_policy_edit").loadSingle(result.get(policyEntity.getNumber()));
            if (policyDyn == null) {
                LOGGER.error("FieldRuleHelper savePolicyEntity error: policyDyn is null ");
                return PayRollActGrpHelper.getDefaultErrorCode().getMessage();
            }
            fieldRuleDyn.set("policy", (Object)policyDyn);
        }
        catch (Exception e) {
            LOGGER.error("FieldRuleHelper savePolicyEntity error:", (Throwable)e);
            return PayRollActGrpHelper.getDefaultErrorCode().getMessage();
        }
        return null;
    }

    public static boolean isSetValidFieldRule(DynamicObject fieldRuleDyn, String defaultValue) {
        if (fieldRuleDyn == null) {
            return false;
        }
        DynamicObjectCollection ruleList = fieldRuleDyn.getDynamicObjectCollection("entryrulelist");
        return PayRollActGrpHelper.validResultValues(defaultValue) != false || !CollectionUtils.isEmpty((Collection)ruleList);
    }

    public static boolean isEditPolicyRule(DynamicObject fieldRuleDyn) {
        if (fieldRuleDyn == null) {
            return false;
        }
        DynamicObjectCollection ruleList = fieldRuleDyn.getDynamicObjectCollection("entryrulelist");
        return fieldRuleDyn.getBoolean("retrundefault") || !CollectionUtils.isEmpty((Collection)ruleList);
    }

    public static boolean isCanEditFieldRule(DynamicObject fieldRuleDyn) {
        if (fieldRuleDyn == null) {
            return false;
        }
        String fieldKey = fieldRuleDyn.getString("fieldkey");
        String fieldName = fieldRuleDyn.getString("showfieldname");
        DynamicObject sceneDyn = fieldRuleDyn.getDynamicObject("scene");
        return !StringUtils.isEmpty((CharSequence)fieldKey) && !StringUtils.isEmpty((CharSequence)fieldName) && sceneDyn != null;
    }

    public static HRPolicyEntity fieldRuleDynToPolicyEntity(DynamicObject fieldRuleDyn, String defaultValue, String operateKey) {
        if (!FieldRuleHelper.isSetValidFieldRule(fieldRuleDyn, defaultValue)) {
            return null;
        }
        Long createOrgId = fieldRuleDyn.getLong("createorg.id");
        Long policyId = fieldRuleDyn.getLong("policy.id");
        Boolean isNew = Boolean.TRUE;
        Boolean enable = FieldRuleHelper.getEnable(operateKey);
        Long fieldRuleId = fieldRuleDyn.getLong("id");
        HRPolicyEntity policy = new HRPolicyEntity();
        if (fieldRuleId != null && fieldRuleId != 0L && policyId != null && policyId != 0L) {
            policy.setId(policyId);
            policy.setName(fieldRuleDyn.getString("policy.name"));
            policy.setNumber(fieldRuleDyn.getString("policy.number"));
            isNew = Boolean.FALSE;
        } else {
            String policyNumber = PayRollActGrpHelper.newPolicyNumber();
            StringBuilder builder = new StringBuilder();
            builder = builder.append(fieldRuleDyn.getString("name")).append('-').append(fieldRuleDyn.getString("showfieldname")).append('-').append(policyNumber.substring(4));
            policy.setName(builder.toString());
            policy.setNumber(policyNumber);
        }
        boolean returnDefault = fieldRuleDyn.getBoolean("retrundefault");
        if (returnDefault) {
            policy.setResults(defaultValue);
        }
        policy.setIsDefaultResult(Boolean.valueOf(returnDefault));
        policy.setScene(Long.valueOf(fieldRuleDyn.getLong("scene.id")));
        policy.setBizAppId(fieldRuleDyn.getString("scene.bizappid.id"));
        policy.setCreateBu(createOrgId);
        policy.setPolicyMode("FirstMatch");
        policy.setEnable(enable);
        policy.setEntryBuList(FieldRuleHelper.getHrUsableRangeEntityList(createOrgId));
        DynamicObjectCollection ruleList = fieldRuleDyn.getDynamicObjectCollection("entryrulelist");
        ArrayList hrRuleList = Lists.newArrayListWithCapacity((int)10);
        policy.setEntryRuleList((List)hrRuleList);
        if (!CollectionUtils.isEmpty((Collection)ruleList)) {
            for (int i = 0; i < ruleList.size(); ++i) {
                DynamicObject ruleEntry = (DynamicObject)ruleList.get(i);
                HrRuleDesignEntity hrRule = new HrRuleDesignEntity();
                if (!isNew.booleanValue()) {
                    hrRule.setId(Long.valueOf(ruleEntry.getLong("id")));
                }
                hrRule.setFilterCondition(ruleEntry.getString("filtercondition"));
                hrRule.setFilterResult(ruleEntry.getString("filterresult"));
                hrRule.setRuleName(ruleEntry.getString("rulename"));
                hrRule.setRuleNumber(ruleEntry.getString("rulenumber"));
                hrRule.setRuleOrder(Integer.valueOf(i + 1));
                hrRule.setRuleEnable(enable);
                hrRuleList.add(hrRule);
            }
        }
        return policy;
    }

    private static boolean getEnable(String operateKey) {
        switch (operateKey) {
            case "audit": {
                return true;
            }
        }
        return false;
    }

    private static List<HrUsableRangeEntity> getHrUsableRangeEntityList(Long createOrgId) {
        if (createOrgId == null || createOrgId == 0L) {
            return null;
        }
        ArrayList<HrUsableRangeEntity> entryBuList = new ArrayList<HrUsableRangeEntity>(10);
        HrUsableRangeEntity hrUsableRangeDTO = new HrUsableRangeEntity();
        hrUsableRangeDTO.setEntityBu(FieldRuleHelper.getHrRootId(createOrgId));
        hrUsableRangeDTO.setIsContainsSub(Boolean.TRUE);
        entryBuList.add(hrUsableRangeDTO);
        return entryBuList;
    }

    public static String validPolicyEntity(DynamicObject fieldRuleDyn, String defaultValue) {
        CodeRuleInfo codeRule;
        if (fieldRuleDyn == null) {
            return ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b57\u6bb5\u89c4\u5219\u3002", (String)"FieldRuleHelper_1", (String)"swc-hpdi-business", (Object[])new Object[0]);
        }
        DynamicObject policyDyn = fieldRuleDyn.getDynamicObject("policy");
        if (policyDyn == null && (codeRule = CodeRuleServiceHelper.getCodeRule((String)"hpdi_policyconfig", (DynamicObject)new HRBaseServiceHelper("hpdi_policyconfig").generateEmptyDynamicObject(), null)) == null) {
            return ResManager.loadKDString((String)"\u7b56\u7565\u914d\u7f6e\u65e0\u53ef\u7528\u7684\u7f16\u7801\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u201c\u7f16\u7801\u89c4\u5219\u914d\u7f6e\u201d\u3002", (String)"FieldRuleHelper_0", (String)"swc-hpdi-business", (Object[])new Object[0]);
        }
        if (!FieldRuleHelper.isSetValidFieldRule(fieldRuleDyn, defaultValue)) {
            return ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b57\u6bb5\u89c4\u5219\u3002", (String)"FieldRuleHelper_1", (String)"swc-hpdi-business", (Object[])new Object[0]);
        }
        if (fieldRuleDyn.getBoolean("retrundefault") && !PayRollActGrpHelper.validResultValues(defaultValue).booleanValue()) {
            return ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u9ed8\u8ba4\u7ed3\u679c\u201d\u503c\uff0c\u7136\u540e\u518d\u8bd5\u3002", (String)"FieldRuleHelper_2", (String)"swc-hpdi-business", (Object[])new Object[0]);
        }
        return "";
    }

    public static String deletePolicy(Long policyId) {
        try {
            if (policyId == null || policyId == 0L) {
                return null;
            }
            ResponseDTO<Boolean> response = PayRollActGrpHelper.deleteHrPolicys(Lists.newArrayList((Object[])new Long[]{policyId}));
            if (response == null) {
                LOGGER.error("FieldRuleHelper deletePolicy error: response is null, policyId = {}", (Object)policyId);
                return PayRollActGrpHelper.getDefaultErrorCode().getMessage();
            }
            if (!response.isSuccess()) {
                LOGGER.error("FieldRuleHelper deletePolicy error: policyId = {} , {}", (Object)policyId, (Object)response.getErrorMsg());
                return PayRollActGrpHelper.getDefaultErrorCode().getMessage();
            }
        }
        catch (Exception e) {
            LOGGER.error("FieldRuleHelper deletePolicy error: policyId = {} , {}", (Object)policyId, (Object)e);
            return PayRollActGrpHelper.getDefaultErrorCode().getMessage();
        }
        return null;
    }

    public static String validCiteInfo(DynamicObject fieldRuleDyn) {
        long fieldRuleId = fieldRuleDyn.getLong("id");
        if (fieldRuleId == 0L) {
            return "";
        }
        HashSet entityCodes = Sets.newHashSet((Object[])new String[]{"hpdi_collarulesal", "hpdi_collarulecdm", "hpdi_collaruletax", "hpdi_collarulecsi"});
        HashSet collaRuleNumbers = Sets.newHashSetWithExpectedSize((int)16);
        for (String entityCode : entityCodes) {
            DynamicObject[] query = FieldRuleHelper.queryCollaRule(entityCode, fieldRuleId);
            if (query == null || query.length == 0) continue;
            Arrays.stream(query).forEach(obj -> collaRuleNumbers.add(obj.getString("number")));
        }
        if (CollectionUtils.isEmpty((Collection)collaRuleNumbers)) {
            return "";
        }
        return ResManager.loadKDString((String)"\u4fee\u6539\u5b57\u6bb5\u89c4\u5219\u540e\uff0c\u5c06\u5f71\u54cd\u5f15\u7528\u8be5\u6570\u636e\u7684\u534f\u4f5c\u89c4\u5219\u201c{0}\u201d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FieldRuleHelper_3", (String)"swc-hpdi-business", (Object[])new Object[]{String.join((CharSequence)"\u201d\u3001\u201c", collaRuleNumbers)});
    }

    private static DynamicObject[] queryCollaRule(String entityCode, long fieldRuleId) {
        QFilter filter = new QFilter("entryentity.fieldrulesubentryentity.frfieldrule.id", "=", (Object)fieldRuleId);
        filter.and("enable", "=", (Object)"1");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityCode);
        return serviceHelper.query("number", new QFilter[]{filter});
    }
}

