/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.cloudcolla.fieldrule;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.ext.hr.ruleengine.controls.RuleControl;
import kd.bos.ext.hr.ruleengine.infos.ResultInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleResultInfo;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hpdi.common.constants.PayRollActGrpConstants;
import kd.swc.hpdi.common.entity.HrRuleDesignEntity;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang3.StringUtils;

public class PolicyHelper
implements PayRollActGrpConstants {
    private static final Log LOGGER = LogFactory.getLog(PolicyHelper.class);
    public static final String CTRL_STRATEGY_PRIVATE = "7";

    public static void updateRuleDate(IFormView view, Date date, RuleControl ... controls) {
        if (controls == null || controls.length < 1 || null == date) {
            return;
        }
        String dateFormat = view.getPageCache().get("ruleDateFormat");
        String value = SWCStringUtils.isEmpty((String)dateFormat) ? SWCDateTimeUtils.formatDate((Date)date) : SWCDateTimeUtils.format((Date)date, (String)dateFormat);
        for (RuleControl ruleControl : controls) {
            ruleControl.setDate(value);
        }
    }

    public static String addFilterToResult(String customParam, DynamicObject dataEntity) {
        if (SWCStringUtils.isEmpty((String)customParam)) {
            return customParam;
        }
        try {
            RuleResultInfo cast = (RuleResultInfo)SWCJSONUtils.cast((String)customParam, RuleResultInfo.class, (boolean)true);
            List resultList = cast.getResultList();
            if (CollectionUtils.isEmpty((Collection)resultList)) {
                return customParam;
            }
            for (ResultInfo resultInfo : resultList) {
                List<QFilter> qFilterByResultInfo = PolicyHelper.getQFilterByResultInfo(resultInfo, dataEntity);
                if (CollectionUtils.isEmpty(qFilterByResultInfo)) continue;
                resultInfo.setFilters(SWCJSONUtils.toString(qFilterByResultInfo));
            }
            return SWCJSONUtils.toString((Object)cast);
        }
        catch (IOException e) {
            LOGGER.info("[payrollacttpl] parse json error.", (Object)e);
            return customParam;
        }
    }

    public static List<QFilter> getQFilterByResultInfo(ResultInfo resultInfo, DynamicObject dataEntity) {
        String param = resultInfo.getParam();
        if (SWCStringUtils.isEmpty((String)param)) {
            return Collections.emptyList();
        }
        Long orgId = PolicyHelper.getOrgId(dataEntity);
        String ctrlStrategy = PolicyHelper.getCtrlStrategy(dataEntity);
        List<QFilter> result = CTRL_STRATEGY_PRIVATE.equals(ctrlStrategy) ? PolicyHelper.getPrivateFilter(param, orgId) : PolicyHelper.getNonPrivateFilter(param, orgId);
        return result;
    }

    public static String getCtrlStrategy(DynamicObject dataEntity) {
        return dataEntity.getString("ctrlstrategy");
    }

    public static Long getOrgId(DynamicObject dataEntity) {
        return dataEntity.getLong("createOrg.id");
    }

    public static String getResultParamValue(DynamicObject fieldRuleDyn) {
        DynamicObject dynamicObject = fieldRuleDyn.getDynamicObject("scene");
        String objectName = fieldRuleDyn.getString("triggercolla.entityobject.number");
        String propertyName = fieldRuleDyn.getString("fieldkey");
        String entryType = fieldRuleDyn.getString("entrytype");
        if (StringUtils.equals((CharSequence)entryType, (CharSequence)"2")) {
            return PolicyHelper.generateExeParamResult(objectName, propertyName);
        }
        return PolicyHelper.generateResult(objectName, propertyName);
    }

    public static String generateExeParamResult(String objectName, String propertyName) {
        String param = objectName + "_" + propertyName;
        try {
            return PolicyHelper.getResultJson(objectName + "_" + propertyName, param);
        }
        catch (IOException e) {
            LOGGER.info("[payrollactg] parse json erro", (Object)e);
            return null;
        }
    }

    public static String getResultJson(String displayParam, String param) throws IOException {
        RuleResultInfo ruleResultInfo = new RuleResultInfo();
        ResultInfo resultInfo = new ResultInfo();
        resultInfo.setDisplayParam(displayParam);
        resultInfo.setParam(param);
        resultInfo.setOperators("==");
        resultInfo.setValueType("2");
        resultInfo.setIndex(0);
        ArrayList<ResultInfo> resultDataList = new ArrayList<ResultInfo>();
        resultDataList.add(resultInfo);
        ruleResultInfo.setResultList(resultDataList);
        return SWCJSONUtils.toString((Object)ruleResultInfo);
    }

    public static String generateResult(String objectName, String propertyName) {
        try {
            LOGGER.info("PolicyHelper generateResult objectName={0},propertyName={1}", (Object)objectName, (Object)propertyName);
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)objectName);
            DynamicProperty property = dataEntityType.getProperty(propertyName);
            String displayParam = dataEntityType.getDisplayName().getLocaleValue() + "." + property.getDisplayName().getLocaleValue();
            String param = objectName + "." + objectName + "." + propertyName;
            if (property.getPropertyType().equals(DynamicObject.class)) {
                ISimpleProperty primaryKey = dataEntityType.getPrimaryKey();
                if (primaryKey == null) {
                    throw new KDBizException(MessageFormat.format("PolicyHelper generateResult objectName({0}) ,propertyName({1}) primaryKey is null.", objectName, propertyName));
                }
                param = param + "." + primaryKey.getName();
            }
            return PolicyHelper.getResultJson(displayParam, param);
        }
        catch (Exception e) {
            LOGGER.error("\u8bbe\u7f6e\u9ed8\u8ba4\u7ed3\u679c\u5b57\u6bb5\u51fa\u9519.", (Throwable)e);
            return null;
        }
    }

    public static HrRuleDesignEntity getRule(DynamicObject mainDyn, DynamicObject entryRowEntity) {
        HrRuleDesignEntity HrRuleDesignEntity2 = new HrRuleDesignEntity();
        if (null != entryRowEntity) {
            HrRuleDesignEntity2.setRuleNumber(entryRowEntity.getString("rulenumber"));
            HrRuleDesignEntity2.setRuleName(entryRowEntity.getString("rulename"));
            HrRuleDesignEntity2.setFilterCondition(entryRowEntity.getString("filtercondition"));
            HrRuleDesignEntity2.setFilterResult(PolicyHelper.addFilterToResult(entryRowEntity.getString("filterresult"), mainDyn));
        }
        return HrRuleDesignEntity2;
    }

    public static List<QFilter> getPrivateFilter(String param, Long orgId) {
        LOGGER.info("[payrollactg] policy page get createOrg = {} ", (Object)orgId);
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"hpdi", (String)"hpdi_fieldrule");
        boolean isAllOrgPermission = permOrgs.hasAllOrgPerm();
        QFilter all = new QFilter("1", "=", (Object)1);
        switch (param.toLowerCase(Locale.ROOT)) {
            case "hsas_salaryfile.hsas_salaryfile.payrollgroup.id": {
                return Arrays.asList(new QFilter("org", "=", (Object)orgId), PolicyHelper.getEnableQFilter(), PolicyHelper.getStatusQFilter());
            }
            case "hsas_salaryfile.hsas_salaryfile.empgroup.id": {
                return Collections.singletonList(PolicyHelper.getEmpGroupQfilter("hsas"));
            }
            case "hsas_salaryfile.hsas_salaryfile.salarycalcstyle.id": {
                SWCDataServiceHelper orm = new SWCDataServiceHelper("hsas_salarycalcstyle");
                DynamicObject[] dynamicObjects = orm.queryOriginalArray("id", new QFilter[]{SWCPermissionServiceHelper.getBaseDataFilter((String)"hsas_salarycalcstyle", (Long)orgId), PolicyHelper.getEnableQFilter(), PolicyHelper.getStatusQFilter()});
                if (dynamicObjects == null) {
                    return Collections.singletonList(new QFilter("1", "=", (Object)2));
                }
                return Collections.singletonList(new QFilter("id", "in", Arrays.stream(dynamicObjects).map(item -> item.getLong("id")).collect(Collectors.toList())));
            }
            case "itc_taxfile.itc_taxfile.empgroup.id": {
                return Collections.singletonList(PolicyHelper.getEmpGroupQfilter("itc"));
            }
            case "itc_taxfile.itc_taxfile.taxunit.id": {
                return Arrays.asList(PolicyHelper.getEnableQFilter(), PolicyHelper.getStatusQFilter());
            }
            case "itc_taxfile.itc_taxfile.org.id": {
                return Arrays.asList(new QFilter("fishrtax", "=", (Object)"1"), isAllOrgPermission ? all : new QFilter("id", "in", (Object)permOrgs.getHasPermOrgs()));
            }
            case "hcsi_sinsurfile.hcsi_sinsurfile.empgroup.id": {
                return Collections.singletonList(PolicyHelper.getEmpGroupQfilter("hcsi"));
            }
            case "hcsi_sinsurfile.hcsi_sinsurfile.welfarepayer.id": {
                return Arrays.asList(PolicyHelper.getEnableQFilter(), PolicyHelper.getStatusQFilter(), isAllOrgPermission ? all : new QFilter("org", "in", (Object)permOrgs.getHasPermOrgs()));
            }
            case "hcsi_sinsurfile.hcsi_sinsurfile.welfarepayertheory.id": {
                return Arrays.asList(PolicyHelper.getEnableQFilter(), PolicyHelper.getStatusQFilter(), isAllOrgPermission ? all : new QFilter("org", "in", (Object)permOrgs.getHasPermOrgs()));
            }
            case "hsas_personchange.hsas_personchange.changereason.id": {
                return Arrays.asList(PolicyHelper.getEnableQFilter(), PolicyHelper.getStatusQFilter(), new QFilter("bussinessfield.id", "!=", (Object)107010L));
            }
            case "hcdm_adjfileinfo.hcdm_adjfileinfo.empgroup.id": {
                return Collections.singletonList(PolicyHelper.getEmpGroupQfilter("hcdm"));
            }
        }
        return Collections.emptyList();
    }

    public static List<QFilter> getNonPrivateFilter(String param, Long orgId) {
        LOGGER.info("[payrollactg] policy page get createOrg = {} ", (Object)orgId);
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"hpdi", (String)"hpdi_fieldrule");
        boolean isAllOrgPermission = permOrgs.hasAllOrgPerm();
        QFilter all = new QFilter("1", "=", (Object)1);
        switch (param.toLowerCase(Locale.ROOT)) {
            case "hsas_salaryfile.hsas_salaryfile.payrollgroup.id": {
                isAllOrgPermission = permOrgs.hasAllOrgPerm();
                return Arrays.asList(isAllOrgPermission ? all : new QFilter("org", "in", (Object)permOrgs.getHasPermOrgs()), PolicyHelper.getEnableQFilter(), PolicyHelper.getStatusQFilter());
            }
            case "hsas_salaryfile.hsas_salaryfile.empgroup.id": {
                return Arrays.asList(new QFilter("bussinessfield", "=", (Object)107010L), PolicyHelper.getEnableQFilter(), PolicyHelper.getStatusQFilter());
            }
            case "hsas_salaryfile.hsas_salaryfile.salarycalcstyle.id": {
                SWCDataServiceHelper orm = new SWCDataServiceHelper("hsas_salarycalcstyle");
                DynamicObject[] dynamicObjects = orm.queryOriginalArray("id", new QFilter[]{isAllOrgPermission ? all : SWCPermissionServiceHelper.getBaseDataFilter((String)"hsas_salarycalcstyle", (List)permOrgs.getHasPermOrgs(), (boolean)true), PolicyHelper.getEnableQFilter(), PolicyHelper.getStatusQFilter()});
                if (dynamicObjects == null) {
                    return Collections.singletonList(new QFilter("1", "=", (Object)2));
                }
                return Collections.singletonList(new QFilter("id", "in", Arrays.stream(dynamicObjects).map(item -> item.getLong("id")).collect(Collectors.toList())));
            }
            case "itc_taxfile.itc_taxfile.empgroup.id": {
                return Arrays.asList(new QFilter("bussinessfield", "=", (Object)107030L), PolicyHelper.getEnableQFilter(), PolicyHelper.getStatusQFilter());
            }
            case "itc_taxfile.itc_taxfile.taxunit.id": {
                return Arrays.asList(PolicyHelper.getEnableQFilter(), PolicyHelper.getStatusQFilter());
            }
            case "itc_taxfile.itc_taxfile.org.id": {
                return Arrays.asList(new QFilter("fishrtax", "=", (Object)"1"), isAllOrgPermission ? all : new QFilter("id", "in", (Object)permOrgs.getHasPermOrgs()));
            }
            case "hcsi_sinsurfile.hcsi_sinsurfile.empgroup.id": {
                return Arrays.asList(new QFilter("bussinessfield", "=", (Object)107050L), PolicyHelper.getEnableQFilter(), PolicyHelper.getStatusQFilter());
            }
            case "hcsi_sinsurfile.hcsi_sinsurfile.welfarepayer.id": {
                return Arrays.asList(PolicyHelper.getEnableQFilter(), PolicyHelper.getStatusQFilter(), isAllOrgPermission ? all : new QFilter("org", "in", (Object)permOrgs.getHasPermOrgs()));
            }
            case "hcsi_sinsurfile.hcsi_sinsurfile.welfarepayertheory.id": {
                return Arrays.asList(PolicyHelper.getEnableQFilter(), PolicyHelper.getStatusQFilter(), isAllOrgPermission ? all : new QFilter("org", "in", (Object)permOrgs.getHasPermOrgs()));
            }
            case "hsas_personchange.hsas_personchange.changereason.id": {
                return Arrays.asList(PolicyHelper.getEnableQFilter(), PolicyHelper.getStatusQFilter(), new QFilter("bussinessfield.id", "!=", (Object)107010L));
            }
            case "hcdm_adjfileinfo.hcdm_adjfileinfo.empgroup.id": {
                return Collections.singletonList(PolicyHelper.getEmpGroupQfilter("hcdm"));
            }
        }
        return Collections.emptyList();
    }

    public static QFilter getEnableQFilter() {
        return new QFilter("enable", "=", (Object)"1");
    }

    public static QFilter getStatusQFilter() {
        return new QFilter("status", "=", (Object)"C");
    }

    public static QFilter getEmpGroupQfilter(String appNumber) {
        List empGroupByAppNumber = SWCPermissionServiceHelper.getEmpgroupByAppNumber((String)appNumber);
        if (CollectionUtils.isEmpty((Collection)empGroupByAppNumber)) {
            return new QFilter("id", "in", Collections.emptyList());
        }
        return new QFilter("id", "in", (Object)empGroupByAppNumber);
    }

    public static String buildDefaultResultValue(DynamicObject fieldRuleDyn) {
        String controlValue = PolicyHelper.getResultParamValue(fieldRuleDyn);
        if (!SWCStringUtils.isEmpty((String)controlValue)) {
            controlValue = PolicyHelper.addFilterToResult(controlValue, fieldRuleDyn);
        }
        return controlValue;
    }
}

