/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.consumer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.swc.hpdi.business.cloudcolla.HPDICloudCollaHelper;
import kd.swc.hpdi.business.msgreceive.DataSyncMsgHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class OpSyncConsumer
implements MessageConsumer {
    private static final Log log = LogFactory.getLog(OpSyncConsumer.class);
    private static final String OP_SYNC_CACHE = "opsynccache";

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        try {
            Map messageData = (Map)message;
            if (null != messageData && !messageData.isEmpty()) {
                String collaTag = (String)messageData.get("tag");
                log.info("OpSyncConsumer.onMessage,collaTag ={}", (Object)collaTag);
                if (!SWCStringUtils.isEmpty((String)collaTag)) {
                    String entityId = (String)messageData.get("entity");
                    switch (collaTag) {
                        case "addnew": {
                            this.addNewSync(messageData, entityId);
                            break;
                        }
                        case "update": {
                            this.updateSync(messageData, entityId);
                            break;
                        }
                        case "delete": {
                            this.deleteSync(messageData, entityId);
                            break;
                        }
                        case "statuschange": {
                            this.updateStatusOrEnableSync(messageData, "status", entityId);
                            this.processAuditMessage(messageData, entityId);
                            break;
                        }
                        case "enablechange": {
                            this.updateStatusOrEnableSync(messageData, "enable", entityId);
                            break;
                        }
                        case "writebacktaskcenter": {
                            HPDICloudCollaHelper.writeBackTaskCenter(messageData, entityId);
                            break;
                        }
                        case "his_confirmchange": {
                            this.processConfirmChangeMessage(messageData, entityId);
                            break;
                        }
                        case "his_save": {
                            this.processSaveHisMessage(messageData, entityId);
                            break;
                        }
                        case "his_delete": {
                            this.processDeleteMessage(messageData, entityId);
                            break;
                        }
                        case "SYNC_PAYROLLACTG_DATA": {
                            DataSyncMsgHelper.getInstance().syncData(messageData);
                            break;
                        }
                    }
                }
            }
            acker.ack(messageId);
        }
        catch (KDBizException e) {
            acker.deny(messageId);
        }
    }

    private void processConfirmChangeMessage(Map<String, Object> messageData, String entityName) {
        List ids = (List)messageData.get("data");
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return;
        }
        log.info("OpSyncConsumer.processConfirmChangeMessage,ids={}", (Object)ids);
        this.saveSyncData(ids, "boid", entityName);
        String currEntityName = entityName;
        this.saveSyncData(ids, "id", currEntityName);
    }

    private void processAuditMessage(Map<String, Object> messageData, String entityId) {
        Map updateIdFieldRels = (Map)messageData.get("data");
        List<Long> ids = updateIdFieldRels.entrySet().stream().map(obj -> (Long)obj.getKey()).collect(Collectors.toList());
        String hisEntityByCurr = entityId;
        if (!SWCStringUtils.isEmpty((String)hisEntityByCurr)) {
            this.saveSyncData(ids, "boid", hisEntityByCurr);
        }
    }

    private void processDeleteMessage(Map<String, Object> messageData, String entityName) {
        List ids = (List)messageData.get("data");
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return;
        }
        SWCDataServiceHelper sourceDataHelper = new SWCDataServiceHelper(entityName);
        sourceDataHelper.delete((Object[])ids.toArray(new Long[0]));
    }

    private String getHsasEntityName(String entityName) {
        return entityName.replace("hpdi", "hsas");
    }

    private void processSaveHisMessage(Map<String, Object> messageData, String entityName) {
        List ids = (List)messageData.get("data");
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return;
        }
        log.info("OpSyncConsumer.processSaveHisMessage,ids={}", (Object)ids);
        this.saveSyncData(ids, "boid", entityName);
    }

    private void saveSyncData(List<Long> ids, String fieldKey, String entityName) {
        DynamicObject[] sourceData = this.queryDataByIds(this.getHsasEntityName(entityName), fieldKey, ids);
        DynamicObject[] targetData = this.queryDataByIds(entityName, fieldKey, ids);
        ArrayList<DynamicObject> insertList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
        this.assembleSaveData(sourceData, targetData, entityName, insertList, updateList);
        SWCDataServiceHelper targetDataOrm = new SWCDataServiceHelper(entityName);
        if (!CollectionUtils.isEmpty(insertList)) {
            targetDataOrm.save(insertList.toArray(new DynamicObject[0]));
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            targetDataOrm.save(updateList.toArray(new DynamicObject[0]));
        }
    }

    private DynamicObject[] queryDataByIds(String entityName, String fieldKey, List<Long> ids) {
        SWCDataServiceHelper sourceDataHelper = new SWCDataServiceHelper(entityName);
        QFilter idFilter = new QFilter(fieldKey, "in", ids);
        log.info("OpSyncConsumer.queryDataByIds,ids = {}", ids);
        if ("boid".equals(fieldKey)) {
            BaseDataHisHelper.addHisVerFilter((QFilter)idFilter);
        }
        QFilter[] filters = new QFilter[]{idFilter};
        return sourceDataHelper.query(SWCHisBaseDataHelper.getSelectProperties((String)this.getHsasEntityName(entityName)), filters);
    }

    private void assembleSaveData(DynamicObject[] sourceData, DynamicObject[] targetData, String targetEntityName, List<DynamicObject> insertList, List<DynamicObject> updateList) {
        Map<Long, DynamicObject> targetDataMap = this.convertDataToMap(targetData);
        SWCDataServiceHelper swcDataServiceHelper = new SWCDataServiceHelper(targetEntityName);
        for (int i = 0; i < sourceData.length; ++i) {
            DynamicObject sourceObject = sourceData[i];
            long sourceId = sourceObject.getLong("id");
            DynamicObject targetObject = targetDataMap.get(sourceId);
            if (targetObject != null) {
                this.copyDynamicObjectValue(sourceObject, targetObject, null, null);
                updateList.add(targetObject);
                continue;
            }
            DynamicObject newTargetObject = swcDataServiceHelper.generateEmptyDynamicObject();
            this.copyDynamicObjectValue(sourceObject, newTargetObject, null, null);
            insertList.add(newTargetObject);
        }
    }

    private void copyDynamicObjectValue(DynamicObject fromObj, DynamicObject toObj, Set<String> ignoreKeys, Map<String, String> transKeyMap) {
        if (fromObj == null || toObj == null) {
            return;
        }
        DataEntityPropertyCollection fromPros = fromObj.getDataEntityType().getProperties();
        if (fromPros == null || fromPros.size() == 0) {
            return;
        }
        DataEntityPropertyCollection toPros = toObj.getDataEntityType().getProperties();
        if (toPros == null || toPros.size() == 0) {
            return;
        }
        HashSet<String> fromPsSet = new HashSet<String>(fromPros.size());
        for (IDataEntityProperty pro : fromPros) {
            fromPsSet.add(String.valueOf(pro.getName()).toLowerCase());
        }
        HashSet<String> toPsSet = new HashSet<String>(fromPros.size());
        for (IDataEntityProperty pro : toPros) {
            toPsSet.add(String.valueOf(pro.getName()).toLowerCase());
        }
        for (IDataEntityProperty pro : fromPros) {
            String toProName;
            String fromProName = toProName = pro.getName();
            if (transKeyMap != null && Objects.nonNull(transKeyMap.get(fromProName))) {
                toProName = transKeyMap.get(fromProName);
            } else if (ignoreKeys != null && ignoreKeys.contains(toProName)) continue;
            if (!fromPsSet.contains(fromProName) || !toPsSet.contains(toProName)) continue;
            this.addEntity(fromObj, toObj, ignoreKeys, transKeyMap, toProName, fromProName);
        }
    }

    private Object addEntity(DynamicObject fromObj, DynamicObject toObj, Set<String> ignoreKeys, Map<String, String> transKeyMap, String toProName, String fromProName) {
        Object value = fromObj.get(fromProName);
        if (value instanceof DynamicObjectCollection) {
            DynamicObjectCollection formEntity = (DynamicObjectCollection)value;
            DynamicObjectCollection toEntity = toObj.getDynamicObjectCollection(toProName);
            if (toEntity != null) {
                toEntity.clear();
                DynamicObjectType entityType = toEntity.getDynamicObjectType();
                for (DynamicObject baseEntry : formEntity) {
                    DynamicObject newEntry = new DynamicObject(entityType);
                    this.copyDynamicObjectValue(baseEntry, newEntry, ignoreKeys, transKeyMap);
                    toEntity.add((Object)newEntry);
                }
            }
            toObj.set(toProName, (Object)toEntity);
        } else {
            toObj.set(toProName, value);
        }
        return value;
    }

    private Map<Long, DynamicObject> convertDataToMap(DynamicObject[] sourceData) {
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>(16);
        for (int i = 0; i < sourceData.length; ++i) {
            DynamicObject tmp = sourceData[i];
            result.put(tmp.getLong("id"), tmp);
        }
        return result;
    }

    private void updateStatusOrEnableSync(Map<String, Object> messageData, String fieldKey, String entityId) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityId);
        Map updateIdFieldRels = (Map)messageData.get("data");
        ArrayList<DynamicObject> dyobjs = new ArrayList<DynamicObject>(10);
        for (Map.Entry updateIdFieldRel : updateIdFieldRels.entrySet()) {
            DynamicObject dyobj = new DynamicObject((DynamicObjectType)entityType);
            dyobj.set("id", updateIdFieldRel.getKey());
            Map tempValues = (Map)updateIdFieldRel.getValue();
            if (tempValues == null || tempValues.isEmpty()) continue;
            tempValues.forEach((key, value) -> dyobj.set(key, value));
            dyobjs.add(dyobj);
        }
        SaveServiceHelper.update((DynamicObject[])((DynamicObject[])dyobjs.stream().toArray(DynamicObject[]::new)));
    }

    private void deleteSync(Map<String, Object> messageData, String entityId) {
        List deleteIds = (List)messageData.get("data");
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(entityId);
        serviceHelper.delete(deleteIds.toArray());
    }

    private void updateSync(Map<String, Object> messageData, String pageEntityId) {
        Map formHeadData;
        SWCDataServiceHelper serviceHelper;
        DynamicObject dyobj;
        Map syncDatas = (Map)messageData.get("data");
        if (null != syncDatas && !syncDatas.isEmpty() && null != (dyobj = (serviceHelper = new SWCDataServiceHelper(pageEntityId)).queryOne((formHeadData = (Map)syncDatas.get(pageEntityId)).get("id")))) {
            Map entityTypeMap = ((MainEntityType)dyobj.getDataEntityType()).getAllEntities();
            for (Map.Entry entityTypeEntry : entityTypeMap.entrySet()) {
                String entityId = (String)entityTypeEntry.getKey();
                Object syncData = syncDatas.get(entityId);
                if (null == syncData) continue;
                if (SWCStringUtils.equals((String)entityId, (String)pageEntityId)) {
                    this.setFormHeadFieldValue(dyobj, (Map)syncData, (EntityType)entityTypeEntry.getValue());
                    continue;
                }
                this.setEntryentityFieldValue(serviceHelper, entityId, dyobj, (List)syncData, (EntityType)entityTypeEntry.getValue());
            }
            serviceHelper.updateOne(dyobj);
        }
    }

    private void addNewSync(Map<String, Object> messageData, String pageEntityId) {
        Map syncDatas = (Map)messageData.get("data");
        if (null != syncDatas && !syncDatas.isEmpty()) {
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(pageEntityId);
            DynamicObject dyobj = serviceHelper.generateEmptyDynamicObject();
            Map entityTypeMap = ((MainEntityType)dyobj.getDataEntityType()).getAllEntities();
            for (Map.Entry entityTypeEntry : entityTypeMap.entrySet()) {
                String entityId = (String)entityTypeEntry.getKey();
                Object syncData = syncDatas.get(entityId);
                if (null == syncData) continue;
                if (SWCStringUtils.equals((String)entityId, (String)pageEntityId)) {
                    this.setFormHeadFieldValue(dyobj, (Map)syncData, (EntityType)entityTypeEntry.getValue());
                    continue;
                }
                this.setEntryentityFieldValue(serviceHelper, entityId, dyobj, (List)syncData, (EntityType)entityTypeEntry.getValue());
            }
            OperationServiceImpl opImpl = new OperationServiceImpl();
            OperationResult result = opImpl.localInvokeOperation("save", new DynamicObject[]{dyobj}, null);
            if (!result.isSuccess()) {
                log.error("OpSyncConsumer.localInvokeOperation SAVE error...getMessage: ", (Object)result.getMessage());
                log.error("OpSyncConsumer.localInvokeOperation SAVE error...getAllErrorInfo: ", (Object)result.getAllErrorInfo());
            }
        }
    }

    private void setEntryentityFieldValue(SWCDataServiceHelper serviceHelper, String entityId, DynamicObject dyobj, List<Map<String, Object>> datas, EntityType entityType) {
        DynamicObjectCollection entryentities = dyobj.getDynamicObjectCollection(entityId);
        entryentities.clear();
        for (Map<String, Object> data : datas) {
            DynamicObject entryentity = serviceHelper.generateEmptyEntryDynamicObject(entityId);
            this.setEntryFieldValue(entryentity, data, entityType);
            entryentities.add((Object)entryentity);
        }
    }

    private void setEntryFieldValue(DynamicObject dyobj, Map<String, Object> data, EntityType entityType) {
        this.setFieldValue(dyobj, data, entityType);
        dyobj.set("id", data.get("id"));
        dyobj.set("seq", data.get("seq"));
    }

    private void setFormHeadFieldValue(DynamicObject dyobj, Map<String, Object> data, EntityType entityType) {
        this.setFieldValue(dyobj, data, entityType);
        dyobj.set("id", data.get("id"));
    }

    private void setFieldValue(DynamicObject dyobj, Map<String, Object> data, EntityType entityType) {
        Map fieldMap = entityType.getFields();
        for (Map.Entry entry : fieldMap.entrySet()) {
            String fieldKey = (String)entry.getKey();
            Object fieldValue = data.get(fieldKey);
            IDataEntityProperty prop = (IDataEntityProperty)entry.getValue();
            if (null == fieldValue) continue;
            if (prop instanceof BasedataProp) {
                SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(((BasedataProp)prop).getBaseEntityId());
                DynamicObject newObj = serviceHelper.generateEmptyDynamicObject();
                newObj.set("id", fieldValue);
                dyobj.set(fieldKey, (Object)newObj);
                continue;
            }
            dyobj.set(fieldKey, fieldValue);
        }
    }
}

