/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.factory;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hpdi.business.service.IDataConvertService;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class DataTransformServiceFactory {
    private static final Log LOGGER = LogFactory.getLog(DataTransformServiceFactory.class);
    private static final Map<String, String> TYPESERVICEMAP = new HashMap<String, String>(16);

    public static IDataConvertService getService(String type) {
        if (SWCStringUtils.isEmpty((String)type)) {
            return null;
        }
        String clazzName = TYPESERVICEMAP.get(type.toLowerCase(Locale.ROOT));
        if (SWCStringUtils.isEmpty((String)clazzName)) {
            return null;
        }
        try {
            Method method = Class.forName(clazzName).getDeclaredMethod("getInstance", new Class[0]);
            return (IDataConvertService)method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            LOGGER.info("DataTransformServiceFactory get service error.", (Object)ex);
            return null;
        }
    }

    static {
        TYPESERVICEMAP.put(Long.class.getName().toLowerCase(Locale.ROOT), "kd.swc.hpdi.business.service.LongDataConvertService");
        TYPESERVICEMAP.put("long", "kd.swc.hpdi.business.service.LongDataConvertService");
        TYPESERVICEMAP.put("date", "kd.swc.hpdi.business.service.DateDataConvertService");
        TYPESERVICEMAP.put("java.util.date", "kd.swc.hpdi.business.service.DateDataConvertService");
        TYPESERVICEMAP.put("dynamicobject", "kd.swc.hpdi.business.service.DynamicObjectDataConvertService");
        TYPESERVICEMAP.put("kd.bos.dataentity.entity.dynamicobject", "kd.swc.hpdi.business.service.DynamicObjectDataConvertService");
        TYPESERVICEMAP.put("boolean", "kd.swc.hpdi.business.service.BooleanDataConvertService");
        TYPESERVICEMAP.put("java.lang.boolean", "kd.swc.hpdi.business.service.BooleanDataConvertService");
    }
}

