/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.helper;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.swc.hpdi.business.helper.BizDataBillEntryHelper;
import kd.swc.hpdi.common.constants.BizDataBillConstants;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class BizDataBillCalSumHelper
implements BizDataBillConstants {
    private static Log log = LogFactory.getLog(BizDataBillCalSumHelper.class);
    private static final String SELECT_PROPERTIES = "id, currency.id, entryentity.id, entryentity.bizitem.id, entryentity.bizitem.number, entryentity.value";

    public static final BizDataBillCalSumHelper getInstance() {
        return Load.calSumAsyncHelper;
    }

    public void doCalculate(IFormView view) {
        long start = System.currentTimeMillis();
        boolean isHorizontal = BizDataBillEntryHelper.isHorizontalTable(view);
        if (!isHorizontal) {
            return;
        }
        HashSet<String> numBizItemFields = new HashSet<String>(16);
        HashSet<String> amountBizItemFields = new HashSet<String>(16);
        boolean existsNumOrAmountField = this.getNumAndAmountFields(view, numBizItemFields, amountBizItemFields);
        if (!existsNumOrAmountField) {
            return;
        }
        log.info("BizDataBillCalSumHelper.doCalculate numBizItemFields: {}", numBizItemFields);
        log.info("BizDataBillCalSumHelper.doCalculate amountBizItemFields: {}", amountBizItemFields);
        List<Long> billEntIds = this.getEntryIds(view);
        if (billEntIds.size() < 2) {
            return;
        }
        HashMap<String, BigDecimal> bizItemSumMap = new HashMap<String, BigDecimal>(numBizItemFields.size() + amountBizItemFields.size());
        for (String numField : numBizItemFields) {
            bizItemSumMap.put(numField, BigDecimal.ZERO);
        }
        for (String amountField : amountBizItemFields) {
            bizItemSumMap.put(amountField, BigDecimal.ZERO);
        }
        HashSet<Long> currencyIdSet = new HashSet<Long>(16);
        HashSet<String> fillInItemSet = new HashSet<String>(16);
        int batchSize = 1000;
        List splitList = Lists.partition(billEntIds, (int)batchSize);
        for (List list : splitList) {
            this.queryAndProcessData(list, bizItemSumMap, numBizItemFields, amountBizItemFields, currencyIdSet, fillInItemSet);
        }
        log.info("BizDataBillCalSumHelper.doCalculate bizItemSumMap: {}", bizItemSumMap);
        if (currencyIdSet.size() != 1) {
            for (String string : amountBizItemFields) {
                bizItemSumMap.put(string, null);
            }
        }
        HashMap sumMap = new HashMap(bizItemSumMap.size());
        for (Map.Entry entry : bizItemSumMap.entrySet()) {
            if (!fillInItemSet.contains(entry.getKey()) || null == entry.getValue()) continue;
            sumMap.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        log.info("BizDataBillCalSumHelper.doCalculate sumMap: {}", sumMap);
        if (sumMap.size() > 0) {
            EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity");
            entryGrid.setFloatButtomData(sumMap);
        }
        long l = System.currentTimeMillis();
        log.info("BizDataBillCalSumHelper.doCalculate spend time: {}", (Object)(l - start));
    }

    private boolean getNumAndAmountFields(IFormView view, Set<String> numBizItemFields, Set<String> amountBizItemFields) {
        boolean existsNumOrAmountField = false;
        BizDataBillEntryHelper.getHorizontalBizItemFields(view);
        String numBizItemFieldStr = view.getPageCache().get("numBizItemFields");
        String amountBizItemFieldStr = view.getPageCache().get("amountBizItemFields");
        if (SWCStringUtils.isNotEmpty((String)numBizItemFieldStr)) {
            List numFields = SerializationUtils.fromJsonStringToList((String)numBizItemFieldStr, String.class);
            numBizItemFields.addAll(numFields);
            existsNumOrAmountField = true;
        }
        if (SWCStringUtils.isNotEmpty((String)amountBizItemFieldStr)) {
            List amountFields = SerializationUtils.fromJsonStringToList((String)amountBizItemFieldStr, String.class);
            amountBizItemFields.addAll(amountFields);
            existsNumOrAmountField = true;
        }
        return existsNumOrAmountField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Long> getEntryIds(IFormView view) {
        Long bizDataBillId = (Long)view.getModel().getDataEntity().getPkValue();
        QFilter qFilter = new QFilter("bizdatabillid", "=", (Object)bizDataBillId);
        ArrayList<Long> billEntIds = new ArrayList<Long>(10);
        try (DataSet dataSet = null;){
            log.info("BizDataBillCalSumHelper.getEntryIds queryDataSet begin...");
            dataSet = ORM.create().queryDataSet("BizDataBillEntryGridHelper.fillHorizontalData1", "hpdi_bizdatabillent", "id", qFilter.toArray());
            log.info("BizDataBillCalSumHelper.getEntryIds queryDataSet end...");
            for (Row row : dataSet) {
                billEntIds.add(row.getLong("id"));
            }
        }
        return billEntIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryAndProcessData(List<Long> entryIdList, Map<String, BigDecimal> bizItemSumMap, Set<String> numBizItemFields, Set<String> amountBizItemFields, Set<Long> currencyIdSet, Set<String> fillInItemSet) {
        try (DataSet dataSet = null;){
            QFilter filter = new QFilter("id", "in", entryIdList);
            log.info("BizDataBillCalSumHelper.queryAndProcessData queryDataSet begin...");
            dataSet = ORM.create().queryDataSet("BizDataBillCalSumHelper.queryAndProcessData", "hpdi_bizdatabillent", SELECT_PROPERTIES, filter.toArray());
            log.info("BizDataBillCalSumHelper.queryAndProcessData queryDataSet end...");
            for (Row row : dataSet) {
                String bizItemNum = row.getString("entryentity.bizitem.number").toLowerCase();
                if (amountBizItemFields.contains(bizItemNum)) {
                    currencyIdSet.add(row.getLong("currency.id"));
                    bizItemSumMap.put(bizItemNum, bizItemSumMap.get(bizItemNum).add(row.getBigDecimal("entryentity.value")));
                } else if (numBizItemFields.contains(bizItemNum)) {
                    bizItemSumMap.put(bizItemNum, bizItemSumMap.get(bizItemNum).add(row.getBigDecimal("entryentity.value")));
                }
                fillInItemSet.add(bizItemNum);
            }
        }
    }

    private static class Load {
        private static BizDataBillCalSumHelper calSumAsyncHelper = new BizDataBillCalSumHelper();

        private Load() {
        }
    }
}

