/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.helper;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hpdi.business.HPDIResMgrBusiness;
import kd.swc.hpdi.business.bizdata.filter.BizDataFilterChain;
import kd.swc.hpdi.business.bizdata.filter.UEDCommPreDataFilter;
import kd.swc.hpdi.business.bizdata.filter.UEDDataCODFilter;
import kd.swc.hpdi.business.bizdata.filter.UEDDataReliabilityFilter;
import kd.swc.hpdi.business.helper.BizDataBillEntryHelper;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCInteDateTimeUtil;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.time.DateUtils;

public class BizDataBillEntryCheckingHelper {
    private static final Log logger = LogFactory.getLog(BizDataBillEntryCheckingHelper.class);
    private static final String INITPRECISION = "0.0000000000";

    public static boolean checkEffectiveDate(IFormView formView, ChangeData effectiveDateChangeData, Date effectiveDate) {
        DynamicObject bizDataBill = formView.getModel().getDataEntity();
        DynamicObject calPeriodObj = bizDataBill.getDynamicObject("calperiod");
        Date startDate = calPeriodObj.getDate("startdate");
        Date endDate = calPeriodObj.getDate("enddate");
        Boolean isHorizontal = BizDataBillEntryHelper.isHorizontalTable(formView);
        Boolean cycle = isHorizontal != false ? BizDataBillEntryCheckingHelper.getHorizontalBizItemCycle(formView) : Boolean.valueOf(effectiveDateChangeData.getDataEntity().getBoolean("bizitem.cycle"));
        if (!cycle.booleanValue() && startDate.compareTo(effectiveDate) > 0 || effectiveDate.compareTo(endDate) > 0) {
            String errorMsg = ResManager.loadKDString((String)"\u201c\u751f\u6548\u65e5\u671f\u201d\u9700\u5728\u85aa\u8d44\u671f\u95f4\u5185\u201c[{0}~{1}]\u201d\u3002", (String)"BizDataBillEntryCheckingHelper_6", (String)"swc-hpdi-business", (Object[])new Object[0]);
            if (cycle.booleanValue()) {
                errorMsg = ResManager.loadKDString((String)"\u201c\u751f\u6548\u65e5\u671f\u201d\u9700\u5c0f\u4e8e\u7b49\u4e8e\u201c\u85aa\u8d44\u671f\u95f4\u7ed3\u675f\u65e5\u671f\uff1a{1}\u201d\u3002", (String)"BizDataBillEntryCheckingHelper_21", (String)"swc-hpdi-business", (Object[])new Object[0]);
            }
            formView.showErrorNotification(MessageFormat.format(errorMsg, SWCInteDateTimeUtil.formatDate((String)"hsbs_calperiod", (String)"startdate", (Date)startDate), SWCInteDateTimeUtil.formatDate((String)"hsbs_calperiod", (String)"enddate", (Date)endDate)));
            return false;
        }
        int rowIndex = effectiveDateChangeData.getRowIndex();
        int startRowIndex = BizDataBillEntryHelper.getCurrentPageStartRowIndex(formView);
        int dataIndex = rowIndex - startRowIndex;
        DynamicObjectCollection entryEntity = formView.getModel().getEntryEntity("entryentity");
        DynamicObject row = (DynamicObject)entryEntity.get(dataIndex);
        Date expiryDate = row.getDate("expirydate");
        if (expiryDate != null && expiryDate.compareTo(effectiveDate) < 0) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u201c\u751f\u6548\u65e5\u671f\u201d\u9700\u5c0f\u4e8e\u7b49\u4e8e\u201c\u5931\u6548\u65e5\u671f\u201d\u3002", (String)"BizDataBillEntryCheckingHelper_7", (String)"swc-hpdi-business", (Object[])new Object[0]));
            return false;
        }
        if (isHorizontal.booleanValue()) {
            return true;
        }
        boolean isCycle = row.getBoolean("bizitem.cycle");
        if (isCycle) {
            Long bizItemId = row.getLong("bizitem.id");
            ArrayList<Long> filterItemList = new ArrayList<Long>(10);
            filterItemList.add(bizItemId);
            Long empPosorgRelId = row.getDynamicObject("empposorgrel").getLong("id");
            DynamicObjectCollection bizDataColl = BizDataHelper.getBizData(filterItemList, null, empPosorgRelId);
            Date subumitEffectiveDate = null;
            for (DynamicObject bizData : bizDataColl) {
                Date bizDataEffectiveDate = bizData.getDate("effectivedate");
                if (effectiveDate.compareTo(bizDataEffectiveDate) > 0) continue;
                String msg = ResManager.loadKDString((String)"\u9488\u5bf9\u540c\u4e00\u4eba\u5458\u4efb\u804c\u540c\u4e00\u5faa\u73af\u9879\u7684\u4e1a\u52a1\u6570\u636e\uff0c\u4e0d\u80fd\u5728\u6700\u65b0\u4e1a\u52a1\u6570\u636e\u7684\u751f\u6548\u65e5\u671f\u524d\uff0c\u6216\u751f\u5931\u6548\u65e5\u671f\u4e2d\u95f4\u63d2\u5165\u3002\u4e1a\u52a1\u6570\u636e\u8bc6\u522b\u53f7{0}\uff0c\u751f\u6548\u65e5\u671f{1}\u3002", (String)"BizDataBillEntryCheckingHelper_20", (String)"swc-hpdi-business", (Object[])new Object[0]);
                formView.showErrorNotification(MessageFormat.format(msg, bizData.getString("bizdatacode"), SWCDateTimeUtils.formatDate((Date)bizDataEffectiveDate)));
                subumitEffectiveDate = bizDataEffectiveDate;
                break;
            }
            Long currentDataEntityId = bizDataBill.getLong("id");
            Map<String, List<DynamicObject>> unSubmitBizDataMap = BizDataHelper.getUnSubmitBizData(filterItemList, null, empPosorgRelId, currentDataEntityId);
            unSubmitBizDataMap.remove(bizDataBill.getString("billno"));
            for (Map.Entry<String, List<DynamicObject>> entry : unSubmitBizDataMap.entrySet()) {
                for (DynamicObject unSubmitBizData : entry.getValue()) {
                    Date bizDataEffectiveDate = unSubmitBizData.getDate("entryentity.effectivedate");
                    boolean isMismatch = bizDataEffectiveDate != null && effectiveDate.compareTo(bizDataEffectiveDate) <= 0 && subumitEffectiveDate != null && bizDataEffectiveDate.compareTo(subumitEffectiveDate) > 0;
                    if (!isMismatch) continue;
                    String msg = ResManager.loadKDString((String)"\u9488\u5bf9\u540c\u4e00\u4eba\u5458\u4efb\u804c\u540c\u4e00\u5faa\u73af\u9879\u7684\u4e1a\u52a1\u6570\u636e\uff0c\u4e0d\u80fd\u5728\u6700\u65b0\u4e1a\u52a1\u6570\u636e\u7684\u751f\u6548\u65e5\u671f\u524d\uff0c\u6216\u751f\u5931\u6548\u65e5\u671f\u4e2d\u95f4\u63d2\u5165\u3002\u5355\u636e\u7f16\u53f7\uff1a{0}\uff0c\u4e1a\u52a1\u6570\u636e\u8bc6\u522b\u53f7{1}\uff0c\u751f\u6548\u65e5\u671f{2}\u3002", (String)"BizDataBillEntryCheckingHelper_19", (String)"swc-hpdi-business", (Object[])new Object[0]);
                    formView.showErrorNotification(MessageFormat.format(msg, entry.getKey(), unSubmitBizData.getString("bizdatacode"), SWCDateTimeUtils.formatDate((Date)bizDataEffectiveDate)));
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean checkExpiryDate(IFormView formView, ChangeData expiryDateChangeData, Date expiryDate) {
        int rowIndex = expiryDateChangeData.getRowIndex();
        int startRowIndex = BizDataBillEntryHelper.getCurrentPageStartRowIndex(formView);
        int dataIndex = rowIndex - startRowIndex;
        DynamicObjectCollection entryEntity = formView.getModel().getEntryEntity("entryentity");
        DynamicObject row = (DynamicObject)entryEntity.get(dataIndex);
        Date effectiveDate = row.getDate("effectivedate");
        if (effectiveDate == null) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"BizDataBillEntryCheckingHelper_5", (String)"swc-hpdi-business", (Object[])new Object[0]));
            return false;
        }
        if (expiryDate.compareTo(effectiveDate) < 0) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u201c\u751f\u6548\u65e5\u671f\u201d\u9700\u5c0f\u4e8e\u7b49\u4e8e\u201c\u5931\u6548\u65e5\u671f\u201d\u3002", (String)"BizDataBillEntryCheckingHelper_4", (String)"swc-hpdi-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static boolean checkValue(IFormView formView, ChangeData valueData, String value, String fieldKey) {
        DynamicObject bizItemObj;
        int rowIndex = valueData.getRowIndex();
        int startRowIndex = BizDataBillEntryHelper.getCurrentPageStartRowIndex(formView);
        int dataIndex = rowIndex - startRowIndex;
        DynamicObjectCollection entryEntity = formView.getModel().getEntryEntity("entryentity");
        DynamicObject entry = (DynamicObject)entryEntity.get(dataIndex);
        if (BizDataBillEntryHelper.isHorizontalTable(formView)) {
            Map<String, DynamicObject> bizItemMap = BizDataBillEntryHelper.getHorizontalBizItemMap(formView.getModel().getDataEntity().getDynamicObject("bizitemgroup"));
            bizItemObj = bizItemMap.get(fieldKey);
        } else {
            bizItemObj = entry.getDynamicObject("bizitem");
        }
        if (SWCObjectUtils.isEmpty((Object)bizItemObj)) {
            formView.updateView("entryentity");
            return false;
        }
        long dataTypeId = bizItemObj.getLong("datatype.id");
        logger.info("======dataTypeId is {}=====", (Object)dataTypeId);
        DynamicObject bizItemGroup = formView.getModel().getDataEntity().getDynamicObject("bizitemgroup");
        Map<Long, DynamicObject> bizItemGroupEntMap = bizItemGroup.getDynamicObjectCollection("entryentity").stream().collect(Collectors.toMap(ent -> ent.getLong("bizitem.id"), ent -> ent, (k1, k2) -> k1));
        if (1020L == dataTypeId || 1010L == dataTypeId) {
            BigDecimal decimalValue;
            try {
                decimalValue = new BigDecimal(value);
                formView.getModel().setValue(fieldKey, (Object)decimalValue.toPlainString(), rowIndex);
            }
            catch (Exception e) {
                formView.getModel().setValue(fieldKey, null, rowIndex);
                formView.showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u7b26\u5408\u4e1a\u52a1\u9879\u76ee\u201c\u6570\u636e\u7c7b\u578b\u201d\u8981\u6c42\u3002", (String)"BizDataBillEntryCheckingHelper_8", (String)"swc-hpdi-business", (Object[])new Object[0]));
                return false;
            }
            int precision = decimalValue.scale();
            if (1010L == dataTypeId) {
                String scaleLimit = bizItemObj.getString("scalelimit");
                int scale = 10;
                if (!SWCStringUtils.isEmpty((String)scaleLimit)) {
                    scale = Integer.parseInt(scaleLimit);
                }
                if (scale < precision) {
                    formView.showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u9879\u76ee\u503c\u5c0f\u6570\u4f4d\u6570\u9700\u63a7\u5236\u5728\u201c{0}\u201d\u5185\u3002", (String)"BizDataBillEntryCheckingHelper_9", (String)"swc-hpdi-business", (Object[])new Object[0]), scale));
                    return false;
                }
                boolean isMinValNull = bizItemObj.getBoolean("isminvalnull");
                boolean isMaxValNull = bizItemObj.getBoolean("ismaxvalnull");
                BigDecimal minVal = bizItemObj.getBigDecimal("minvalue");
                BigDecimal maxVal = bizItemObj.getBigDecimal("maxvalue");
                DynamicObject bizItemGroupEnt = bizItemGroupEntMap.get(bizItemObj.getLong("id"));
                if (!SWCObjectUtils.isEmpty((Object)bizItemGroupEnt)) {
                    BigDecimal submitMaxValue = bizItemGroupEnt.getBigDecimal("submitmaxvalue");
                    BigDecimal submitMinValue = bizItemGroupEnt.getBigDecimal("submitminvalue");
                    if (null != submitMinValue) {
                        minVal = isMinValNull ? submitMinValue : submitMinValue.max(minVal);
                        isMinValNull = false;
                    }
                    if (null != submitMaxValue) {
                        maxVal = isMaxValNull ? submitMaxValue : submitMaxValue.min(maxVal);
                        isMaxValNull = false;
                    }
                }
                if (!isMinValNull && isMaxValNull && minVal.compareTo(decimalValue) > 0) {
                    formView.showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u9879\u76ee\u503c\u5e94\u7b26\u5408\u6700\u5c0f\u8f93\u5165\u503c\uff08{0}\uff09\u8981\u6c42\u3002", (String)"BizDataBillEntryCheckingHelper_15", (String)"swc-hpdi-business", (Object[])new Object[0]), minVal.setScale(scale, 4).toPlainString()));
                    return false;
                }
                if (isMinValNull && !isMaxValNull && maxVal.compareTo(decimalValue) < 0) {
                    formView.showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u9879\u76ee\u503c\u4e0d\u7b26\u5408\u6700\u5927\u8f93\u5165\u503c\u201c{0}\u201d\u7684\u8981\u6c42\u3002", (String)"BizDataBillEntryCheckingHelper_16", (String)"swc-hpdi-business", (Object[])new Object[0]), maxVal.setScale(scale, 4).toPlainString()));
                    return false;
                }
                if (!(isMinValNull || isMaxValNull || maxVal.compareTo(decimalValue) >= 0 && minVal.compareTo(decimalValue) <= 0)) {
                    formView.showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u9879\u76ee\u503c\u5e94\u7b26\u5408\u6700\u5c0f\u6700\u5927\u8f93\u5165\u503c\u8981\u6c42\uff08{0}~{1}\uff09\u3002", (String)"BizDataBillEntryCheckingHelper_17", (String)"swc-hpdi-business", (Object[])new Object[0]), minVal.setScale(scale, 4).toPlainString(), maxVal.setScale(scale, 4).toPlainString()));
                    return false;
                }
                DecimalFormat decimalFormat = new DecimalFormat(new BigDecimal(INITPRECISION).setScale(scale).toPlainString());
                formView.getModel().setValue(fieldKey, (Object)decimalFormat.format(decimalValue), rowIndex);
            } else {
                DynamicObject currency = entry.getDynamicObject("currency");
                int amtPrecision = 10;
                if (!SWCObjectUtils.isEmpty((Object)currency)) {
                    amtPrecision = currency.getInt("amtprecision");
                    if (amtPrecision < precision) {
                        formView.showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u9879\u76ee\u503c\u9700\u63a7\u5236\u5728\u5bf9\u5e94\u5e01\u79cd\u7684\u5e01\u79cd\u7cbe\u5ea6\u8303\u56f4{0}\u5185\u3002", (String)"BizDataBillEntryCheckingHelper_25", (String)"swc-hpdi-business", (Object[])new Object[0]), amtPrecision));
                        return false;
                    }
                    DynamicObjectCollection currencyColl = bizItemObj.getDynamicObjectCollection("currency");
                    HashSet<Long> currencyIdSet = new HashSet<Long>(16);
                    for (DynamicObject currencyObj : currencyColl) {
                        currencyIdSet.add(currencyObj.getLong("fbasedataid_id"));
                    }
                    if (currencyColl.size() > 0 && !currencyIdSet.contains(currency.getLong("id"))) {
                        formView.showErrorNotification(ResManager.loadKDString((String)"\u91d1\u989d\u7c7b\u578b\u7684\u9879\u76ee\u5e01\u79cd\u9700\u8981\u5728\u4e1a\u52a1\u9879\u76ee\u89c4\u5b9a\u7684\u5e01\u79cd\u8303\u56f4\u5185\u3002", (String)"BizDataBillEntryCheckingHelper_24", (String)"swc-hpdi-business", (Object[])new Object[0]));
                        return false;
                    }
                    DecimalFormat decimalFormat = new DecimalFormat(new BigDecimal(INITPRECISION).setScale(amtPrecision).toPlainString());
                    formView.getModel().setValue(fieldKey, (Object)decimalFormat.format(decimalValue), rowIndex);
                }
            }
        } else if (1050L == dataTypeId) {
            Date dateValue = null;
            String[] splitStr = value.trim().split("-");
            if (splitStr.length != 3) {
                formView.getModel().setValue(fieldKey, null, rowIndex);
                formView.showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u7b26\u5408\u4e1a\u52a1\u9879\u76ee\u201c\u6570\u636e\u7c7b\u578b\u201d\u8981\u6c42\uff0c\u65e5\u671f\u683c\u5f0f\u5e94\u4e3a\uff1ayyyy-MM-dd\u3002", (String)"BizDataBillEntryCheckingHelper_18", (String)"swc-hpdi-business", (Object[])new Object[0]));
                return false;
            }
            String year = splitStr[0];
            String month = splitStr[1];
            String day = splitStr[2];
            if (year.length() != 4 || month.length() != 2 || day.length() != 2) {
                formView.getModel().setValue(fieldKey, null, rowIndex);
                formView.showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u7b26\u5408\u4e1a\u52a1\u9879\u76ee\u201c\u6570\u636e\u7c7b\u578b\u201d\u8981\u6c42\uff0c\u65e5\u671f\u683c\u5f0f\u5e94\u4e3a\uff1ayyyy-MM-dd\u3002", (String)"BizDataBillEntryCheckingHelper_18", (String)"swc-hpdi-business", (Object[])new Object[0]));
                return false;
            }
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                dateValue = sdf.parse(value);
            }
            catch (Exception e) {
                formView.getModel().setValue(fieldKey, null, rowIndex);
                formView.showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u7b26\u5408\u4e1a\u52a1\u9879\u76ee\u201c\u6570\u636e\u7c7b\u578b\u201d\u8981\u6c42\uff0c\u65e5\u671f\u683c\u5f0f\u5e94\u4e3a\uff1ayyyy-MM-dd\u3002", (String)"BizDataBillEntryCheckingHelper_18", (String)"swc-hpdi-business", (Object[])new Object[0]));
                return false;
            }
            Date earliestDate = bizItemObj.getDate("earliestdate");
            Date lastDate = bizItemObj.getDate("lastdate");
            DynamicObject bizItemGroupEnt = bizItemGroupEntMap.get(bizItemObj.getLong("id"));
            if (!SWCObjectUtils.isEmpty((Object)bizItemGroupEnt)) {
                Date submitStartDate = bizItemGroupEnt.getDate("submitstartdate");
                Date submitEndDate = bizItemGroupEnt.getDate("submitenddate");
                earliestDate = BizDataHelper.getMaxDate(earliestDate, submitStartDate);
                lastDate = BizDataHelper.getMinDate(lastDate, submitEndDate);
            }
            if (earliestDate != null && lastDate == null && earliestDate.compareTo(dateValue) > 0) {
                formView.showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u9879\u76ee\u503c\u5e94\u7b26\u5408\u6700\u65e9\u65e5\u671f\uff08{0}\uff09\u8981\u6c42\u3002", (String)"BizDataBillEntryCheckingHelper_11", (String)"swc-hpdi-business", (Object[])new Object[0]), SWCDateTimeUtils.formatDate((Date)earliestDate)));
                return false;
            }
            if (earliestDate == null && lastDate != null && lastDate.compareTo(dateValue) < 0) {
                formView.showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u9879\u76ee\u503c\u4e0d\u7b26\u5408\u6700\u665a\u65e5\u671f\u201c{0}\u201d\u8981\u6c42\u3002", (String)"BizDataBillEntryCheckingHelper_12", (String)"swc-hpdi-business", (Object[])new Object[0]), SWCDateTimeUtils.formatDate((Date)lastDate)));
                return false;
            }
            if (earliestDate != null && lastDate != null && (earliestDate.compareTo(dateValue) > 0 || lastDate.compareTo(dateValue) < 0)) {
                formView.showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u9879\u76ee\u503c\u5e94\u7b26\u5408\u6700\u65e9\u6700\u665a\u65e5\u671f\u8981\u6c42\uff08{0}~{1}\uff09\u3002", (String)"BizDataBillEntryCheckingHelper_13", (String)"swc-hpdi-business", (Object[])new Object[0]), SWCDateTimeUtils.formatDate((Date)earliestDate), SWCDateTimeUtils.formatDate((Date)lastDate)));
                return false;
            }
        } else if (1030L == dataTypeId) {
            int dataLength = bizItemObj.getInt("datalength");
            if (value.length() > dataLength) {
                formView.showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u9879\u76ee\u503c\u957f\u5ea6\u5e94\u7b26\u5408\u4e1a\u52a1\u9879\u76ee\u6570\u636e\u957f\u5ea6\u8981\u6c42\uff08{0}\uff09\u3002", (String)"BizDataBillEntryCheckingHelper_14", (String)"swc-hpdi-business", (Object[])new Object[0]), dataLength));
                return false;
            }
        }
        return true;
    }

    public static void checkCurrencyPrecision(IFormView formView, ChangeData currencyChangeData, DynamicObject currencyValue) {
        int rowIndex = currencyChangeData.getRowIndex();
        int startRowIndex = BizDataBillEntryHelper.getCurrentPageStartRowIndex(formView);
        int dataIndex = rowIndex - startRowIndex;
        DynamicObjectCollection entryEntity = formView.getModel().getEntryEntity("entryentity");
        DynamicObject entry = (DynamicObject)entryEntity.get(dataIndex);
        if (BizDataBillEntryHelper.isHorizontalTable(formView)) {
            String amountItemFieldsStr = formView.getPageCache().get("amountBizItemFields");
            if (SWCStringUtils.isEmpty((String)amountItemFieldsStr)) {
                return;
            }
            List amountItemFields = SerializationUtils.fromJsonStringToList((String)amountItemFieldsStr, String.class);
            for (String field : amountItemFields) {
                String amountStr = entry.getString(field);
                BizDataBillEntryCheckingHelper.checkAmountValuePrecision(formView, amountStr, currencyValue, field, rowIndex);
            }
            return;
        }
        String value = entry.getString("value");
        BizDataBillEntryCheckingHelper.checkAmountValuePrecision(formView, value, currencyValue, "value", rowIndex);
    }

    public static Map<String, Map<String, Object>> checkUpdateExpiryDate(DynamicObject bizItemGroup, List<DynamicObject> newEntryData, String source) {
        ArrayList<DynamicObject> copyNewEntryData = new ArrayList<DynamicObject>(newEntryData.size());
        copyNewEntryData.addAll(newEntryData);
        HashMap<String, Map<String, Object>> responses = new HashMap<String, Map<String, Object>>(16);
        Iterator iterator = copyNewEntryData.iterator();
        int index = 1;
        while (iterator.hasNext()) {
            DynamicObject newEntry = (DynamicObject)iterator.next();
            String bizDataCode = newEntry.getString("bizdatacode");
            Map<String, Object> responseMap = BizDataBillEntryCheckingHelper.validateUpdateExpiryDate(newEntry, index);
            if (!responseMap.isEmpty()) {
                responses.put(bizDataCode, responseMap);
                iterator.remove();
            }
            ++index;
        }
        if (SWCListUtils.isEmpty(copyNewEntryData)) {
            return responses;
        }
        HashMap<String, Object> queryMap = new HashMap<String, Object>(16);
        queryMap.put("dataSource", source);
        queryMap.put("bizitemgroup", bizItemGroup);
        BizDataFilterChain filterChain = new BizDataFilterChain();
        queryMap.put("UEDDataCODFilter_expirydate", BizDataBillEntryCheckingHelper.getExpiryDateForUpdateExpiryDate(queryMap, newEntryData));
        if (SWCStringUtils.equals((String)source, (String)"2")) {
            filterChain.addFilter(new UEDCommPreDataFilter());
            filterChain.addFilter(new UEDDataReliabilityFilter());
        }
        filterChain.addFilter(new UEDDataCODFilter());
        filterChain.doFilter(queryMap, copyNewEntryData, filterChain, responses);
        return responses;
    }

    private static Map<String, Object> validateUpdateExpiryDate(DynamicObject newEntry, int index) {
        boolean isBefore;
        Date oEffectiveDate;
        Date oExpiryDate;
        HashMap<String, Object> responseMap = new HashMap<String, Object>(3);
        Date expiryDate = newEntry.getDate("updateexpirydate");
        if (expiryDate == null) {
            return responseMap;
        }
        String whenEqualsMsg = HPDIResMgrBusiness.getMsgOfExpiryDateUnchanged();
        String whenLessThanMsg = HPDIResMgrBusiness.getMsgOfNeedLaterThanEffectiveDate();
        String dataEntityName = newEntry.getDataEntityType().getName();
        if (SWCStringUtils.equals((String)dataEntityName, (String)"hpdi_bizdatabillent")) {
            DynamicObjectCollection details = newEntry.getDynamicObjectCollection("entryentity");
            DynamicObject detail = (DynamicObject)details.get(0);
            oExpiryDate = detail.getDate("expirydate");
            oEffectiveDate = detail.getDate("effectivedate");
            whenEqualsMsg = HPDIResMgrBusiness.getMsgOfExpiryDateUnchanged(index);
            whenLessThanMsg = HPDIResMgrBusiness.getMsgOfNeedLaterThanEffectiveDate(index);
        } else {
            oExpiryDate = newEntry.getDate("expirydate");
            oEffectiveDate = newEntry.getDate("effectivedate");
        }
        boolean isEqualExpiryDate = oExpiryDate != null && DateUtils.truncatedCompareTo((Date)expiryDate, (Date)oExpiryDate, (int)11) == 0;
        boolean bl = isBefore = oEffectiveDate != null && DateUtils.truncatedCompareTo((Date)expiryDate, (Date)oEffectiveDate, (int)11) == -1;
        if (isEqualExpiryDate) {
            responseMap.put("key_result_error_msg", whenEqualsMsg);
        } else if (isBefore) {
            responseMap.put("key_result_error_msg", whenLessThanMsg);
        }
        return responseMap;
    }

    private static Map<String, Date> getExpiryDateForUpdateExpiryDate(Map<String, Object> queryMap, List<DynamicObject> entries) {
        HashMap<String, Date> bizDataCodeAndDateMap = new HashMap<String, Date>(16);
        String dataSource = (String)queryMap.get("dataSource");
        for (DynamicObject entry : entries) {
            Date originalExpiryDate;
            String bizDataCode = entry.getString("bizdatacode");
            Date updateExpiryDate = entry.getDate("updateexpirydate");
            logger.info(MessageFormat.format("getExpiryDateForUpdateExpiryDate bizDataCode is:{0} ,updateExpiryDate is:{1}", bizDataCode, updateExpiryDate));
            if (updateExpiryDate == null) continue;
            String dataEntityName = entry.getDataEntityType().getName();
            if (SWCStringUtils.equals((String)dataEntityName, (String)"hpdi_bizdatabillent")) {
                DynamicObjectCollection details = entry.getDynamicObjectCollection("entryentity");
                DynamicObject detail = (DynamicObject)details.get(0);
                originalExpiryDate = detail.getDate("expirydate");
            } else {
                originalExpiryDate = entry.getDate("expirydate");
            }
            Date newExpiryDate = DateUtils.addDays((Date)updateExpiryDate, (int)1);
            if (originalExpiryDate == null) {
                bizDataCodeAndDateMap.put(bizDataCode, newExpiryDate);
                continue;
            }
            int truncatedCompareTo = DateUtils.truncatedCompareTo((Date)updateExpiryDate, (Date)originalExpiryDate, (int)11);
            switch (truncatedCompareTo) {
                case -1: {
                    bizDataCodeAndDateMap.put(bizDataCode, newExpiryDate);
                    break;
                }
                case 1: {
                    newExpiryDate = DateUtils.addDays((Date)originalExpiryDate, (int)1);
                    bizDataCodeAndDateMap.put(bizDataCode, newExpiryDate);
                    break;
                }
            }
        }
        return bizDataCodeAndDateMap;
    }

    private static void checkAmountValuePrecision(IFormView formView, String value, DynamicObject currencyValue, String fieldKey, int rowIndex) {
        BigDecimal decimalValue;
        if (SWCStringUtils.isEmpty((String)value)) {
            return;
        }
        String initPrecision = INITPRECISION;
        try {
            decimalValue = new BigDecimal(value);
            formView.getModel().setValue(fieldKey, (Object)decimalValue.toPlainString(), rowIndex);
        }
        catch (Exception e) {
            formView.getModel().setValue(fieldKey, null, rowIndex);
            formView.showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u7b26\u5408\u4e1a\u52a1\u9879\u76ee\u201c\u6570\u636e\u7c7b\u578b\u201d\u8981\u6c42\u3002", (String)"BizDataBillEntryCheckingHelper_8", (String)"swc-hpdi-business", (Object[])new Object[0]));
            return;
        }
        int precision = decimalValue.scale();
        int amtPrecision = currencyValue.getInt("amtprecision");
        if (amtPrecision < precision) {
            formView.showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u91d1\u989d\u7c7b\u578b\u9879\u76ee\u503c\u9700\u63a7\u5236\u5728\u5bf9\u5e94\u5e01\u79cd\u7684\u5e01\u79cd\u7cbe\u5ea6\u8303\u56f4{0}\u5185\u3002", (String)"BizDataBillEntryCheckingHelper_26", (String)"swc-hpdi-business", (Object[])new Object[0]), amtPrecision));
            return;
        }
        DecimalFormat decimalFormat = new DecimalFormat(new BigDecimal(initPrecision).setScale(amtPrecision).toPlainString());
        formView.getModel().setValue(fieldKey, (Object)decimalFormat.format(decimalValue), rowIndex);
    }

    private static Boolean getHorizontalBizItemCycle(IFormView formView) {
        Boolean cycle = Boolean.FALSE;
        String bizItemCycle = formView.getPageCache().get("bizitem.cycle");
        if (null != bizItemCycle) {
            cycle = Boolean.parseBoolean(bizItemCycle);
        } else {
            Map<String, Object> bizItemGroupMap = BizDataHelper.getBizItemGroupMapById(formView.getModel().getDataEntity().getDynamicObject("bizitemgroup"));
            List resultList = (List)bizItemGroupMap.get("result");
            if (CollectionUtils.isEmpty((Collection)resultList)) {
                return cycle;
            }
            List itemList = (List)((Map)resultList.get(0)).get("bizitem");
            if (CollectionUtils.isEmpty((Collection)itemList)) {
                return cycle;
            }
            cycle = MapUtils.getBoolean((Map)((Map)itemList.get(0)), (Object)"cycle");
            formView.getPageCache().put("bizitem.cycle", String.valueOf(cycle));
        }
        return cycle;
    }
}

