/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.helper;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.IntegerEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hpdi.business.extpoint.bizdatabill.IBizDataBillEntryExtService;
import kd.sdk.swc.hpdi.common.events.bizdatabill.AfterAddFieldContainerEvent;
import kd.sdk.swc.hpdi.common.events.bizdatabill.BizDataAddEntryFieldArgs;
import kd.swc.hpdi.business.HPDIResMgrBusiness;
import kd.swc.hpdi.business.helper.BizDataBillEntryExtService;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hpdi.business.util.HPDIServiceUtils;
import kd.swc.hpdi.common.constants.BizDataBillConstants;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.BooleanUtils;

public class BizDataBillEntryHelper
implements BizDataBillConstants {
    private static final Log LOGGER = LogFactory.getLog(BizDataBillEntryHelper.class);
    private static final String INITPRECISION = "0.0000000000";
    public static final String[] EDITABLE_FIELDS = new String[]{"effectivedate", "value", "calfrequency", "remark"};
    protected static final Set<String> BASE_DATA_FIELD_SET = new HashSet<String>();

    public static void setEntryFieldDisplay(IFormView formView, boolean isApproveNode) {
        formView.setVisible(Boolean.FALSE, new String[]{"sumcol"});
        String billStatus = formView.getModel().getDataEntity().getString("billstatus");
        if ("D".equals(billStatus) || "E".equals(billStatus) || "B".equals(billStatus) && isApproveNode) {
            formView.setVisible(Boolean.TRUE, new String[]{"dataapprovestatus", "approvedesc"});
            String entryFields = "dataapprovestatus,approvedesc";
            BizDataBillEntryHelper.removeCustomParamHideenEntryField(formView, entryFields);
        } else if ("C".equals(billStatus)) {
            formView.setVisible(Boolean.TRUE, new String[]{"bizdatastatus", "errormsg", "submiterror", "bizdatacode", "enttranssalarystatus"});
            String entryFields = "bizdatastatus,errormsg,submiterror,bizdatacode,enttranssalarystatus";
            BizDataBillEntryHelper.removeCustomParamHideenEntryField(formView, entryFields);
        }
    }

    public static void setEntityFieldVisible(IFormView formView) {
        IDataModel dataModel = formView.getModel();
        String billType = (String)dataModel.getValue("billtype");
        if (SWCStringUtils.equals((String)billType, (String)"2")) {
            formView.setVisible(Boolean.FALSE, new String[]{"iscycle", "relationdata", "bizdatacode", "viewrelationdata", "refreshrelationdata"});
            formView.setVisible(Boolean.TRUE, new String[]{"originalbizdatacode"});
            String entryFields = "iscycle,relationdata,bizdatacode,viewrelationdata,refreshrelationdata";
            BizDataBillEntryHelper.setCustomParamHideenEntryField(formView, entryFields);
        } else if (SWCStringUtils.equals((String)billType, (String)"1")) {
            formView.setVisible(Boolean.FALSE, new String[]{"updateexpirydate", "updateddesc", "originalbizdatacode"});
            String entryFields = "updateexpirydate,updateddesc,originalbizdatacode";
            BizDataBillEntryHelper.setCustomParamHideenEntryField(formView, entryFields);
        }
        BizDataBillEntryHelper.setMatchRuleFieldsVisible(formView);
        BizDataBillEntryHelper.setExpiryDateVisible(formView);
    }

    public static void modifyEntryByChangeBizItem(IFormView formView, MessageBoxClosedEvent event) {
        String customValue = event.getCustomVaule();
        Map customMap = (Map)JSON.parseObject((String)customValue, Map.class);
        Long oldBizItemId = (Long)customMap.computeIfAbsent("oldBizItemId", item -> Long.class);
        Integer rowIndex = (Integer)customMap.computeIfAbsent("rowIndex", item -> Integer.class);
        Long dataTypeId = MapUtils.getLong((Map)customMap, (Object)"datatypeid");
        AbstractFormDataModel model = (AbstractFormDataModel)formView.getModel();
        model.beginInit();
        if (MessageBoxResult.Yes.equals((Object)event.getResult())) {
            model.setValue("value", null, rowIndex.intValue());
            model.setValue("currency", null, rowIndex.intValue());
            model.setValue("effectivedate", null, rowIndex.intValue());
            model.setValue("expirydate", null, rowIndex.intValue());
            model.setValue("remark", null, rowIndex.intValue());
            BizDataBillEntryHelper.setEntryCurrency(formView, dataTypeId, rowIndex);
        } else {
            model.setValue("bizitem", (Object)oldBizItemId, rowIndex.intValue());
        }
        model.endInit();
        formView.updateView("entryentity");
        BizDataBillEntryHelper.setEntryFieldEnable(formView);
        BizDataBillEntryHelper.setEntryFieldMustInput(formView);
        BizDataBillEntryHelper.setFieldsNotQuickAddNew(formView);
    }

    public static QFilter getCurrencyFilter(IFormView formView, BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObjectCollection entryEntities = formView.getModel().getEntryEntity("entryentity");
        int rowIndex = beforeF7SelectEvent.getRow();
        int startRowIndex = BizDataBillEntryHelper.getCurrentPageStartRowIndex(formView);
        int dataIndex = rowIndex - startRowIndex;
        DynamicObject entry = (DynamicObject)entryEntities.get(dataIndex);
        DynamicObjectCollection currencyColl = new DynamicObjectCollection();
        if (BizDataBillEntryHelper.isHorizontalTable(formView)) {
            Map<String, DynamicObject> bizItemMap = BizDataBillEntryHelper.getHorizontalBizItemMap(formView.getModel().getDataEntity().getDynamicObject("bizitemgroup"));
            List mulBizItemIds = new ArrayList(10);
            MulBasedataDynamicObjectCollection mulBizItemColl = (MulBasedataDynamicObjectCollection)formView.getModel().getDataEntity().get("mulbizitem");
            if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)mulBizItemColl)) {
                mulBizItemIds = mulBizItemColl.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toList());
            }
            for (Map.Entry<String, DynamicObject> mapEntry : bizItemMap.entrySet()) {
                if (kd.bos.util.CollectionUtils.isNotEmpty(mulBizItemIds) && !mulBizItemIds.contains(mapEntry.getValue().getLong("id")) || !"1020_S".equals(mapEntry.getValue().getString("datatype.number"))) continue;
                DynamicObjectCollection subCurrencyColl = mapEntry.getValue().getDynamicObjectCollection("currency");
                if (kd.bos.util.CollectionUtils.isEmpty((Collection)subCurrencyColl)) {
                    return null;
                }
                currencyColl.addAll((Collection)subCurrencyColl);
            }
        } else {
            DynamicObject bizItemObj = entry.getDynamicObject("bizitem");
            if (SWCObjectUtils.isEmpty((Object)bizItemObj)) {
                formView.showTipNotification(HPDIResMgrBusiness.getMsgOfEntryNoBizItem());
                beforeF7SelectEvent.setCancel(true);
                return null;
            }
            currencyColl = bizItemObj.getDynamicObjectCollection("currency");
        }
        HashSet<Long> currencyIdSet = new HashSet<Long>(16);
        for (DynamicObject currency : currencyColl) {
            currencyIdSet.add(currency.getLong("fbasedataid_id"));
        }
        QFilter qFilter = null;
        if (currencyIdSet.size() > 0) {
            qFilter = new QFilter("id", "in", currencyIdSet);
        }
        return qFilter;
    }

    public static void setAddTypeEntry(IFormView formView, List<Map<Object, Object>> primaryKeyMapList, TableValueSetter setter) {
        List ids = primaryKeyMapList.stream().map(item -> MapUtils.getLong((Map)item, (Object)"depempId")).collect(Collectors.toList());
        QFilter filter = new QFilter("depemp", "in", ids);
        filter.and("iscurrentversion", "=", (Object)"1");
        SWCDataServiceHelper helper = HPDIDataServiceHelper.HRPI_EMPPOSORGREL_HELPER;
        DynamicObject[] empposorgrels = helper.query("id, depemp.id, company.id, position.id, apositiontype, job.id, postype.id, person.id, person.number, person.name, isprimary, startdate, enddate, adminorg.id", filter.toArray());
        Map<Long, DynamicObject> map = Arrays.stream(empposorgrels).collect(Collectors.toMap(obj -> obj.getLong("depemp.id"), obj -> obj, (k1, k2) -> k1));
        List<String> bizDataCodes = HPDIServiceUtils.getBizDataCodes("Manual", primaryKeyMapList.size());
        IPageCache pageCache = BizDataBillEntryHelper.getBizDataBillPageCache(formView);
        String cacheKey = String.format(Locale.ROOT, "bizItemGroupEmpposorgrelFields_%s", formView.getModel().getDataEntity().getLong("bizitemgroup.id"));
        List empFields = (List)SerializationUtils.deSerializeFromBase64((String)pageCache.get(cacheKey));
        int index = 0;
        ArrayList dataList = new ArrayList(ids.size());
        for (Map<Object, Object> pkMap : primaryKeyMapList) {
            Long depempId = MapUtils.getLong(pkMap, (Object)"depempId");
            DynamicObject empposorgrel = map.get(depempId);
            if (null == empposorgrel) {
                return;
            }
            HashMap<String, Object> data = new HashMap<String, Object>(16);
            data.put("depemp_id", depempId);
            data.put("f7ReturnId", pkMap.get("f7ReturnId"));
            data.put("empposorgrel_id", empposorgrel.getPkValue());
            data.put("person_id", empposorgrel.getLong("person.id"));
            data.put("entadminorg_id", empposorgrel.getLong("adminorg.id"));
            data.put("bizdatacode", bizDataCodes.get(index));
            if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)empFields)) {
                DataEntityPropertyCollection dataEntityPropertyCollection = empposorgrel.getDataEntityType().getProperties();
                for (String key : empFields) {
                    if (BASE_DATA_FIELD_SET.contains(key)) {
                        data.put(BizDataBillEntryHelper.getBaseDataIdField(key), empposorgrel.get(BizDataBillEntryHelper.getBaseDataId(key)));
                        continue;
                    }
                    if (!dataEntityPropertyCollection.containsKey((Object)key) && (null == key || !key.contains(".") || !dataEntityPropertyCollection.containsKey((Object)key.split("\\.")[0]))) continue;
                    data.put(BizDataBillEntryHelper.getNewKey(key), empposorgrel.get(BizDataBillEntryHelper.getFieldName(key)));
                }
            }
            dataList.add(data);
            ++index;
        }
        BizDataAddEntryFieldArgs fieldArgs = new BizDataAddEntryFieldArgs();
        fieldArgs.setDataList(dataList);
        fieldArgs.setBizDataBill(formView.getModel().getDataEntity());
        fieldArgs.setDepempMappingList(primaryKeyMapList);
        BizDataBillEntryExtService extService = new BizDataBillEntryExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)extService, IBizDataBillEntryExtService.class, (String)"kd.sdk.swc.hpdi.business.extpoint.bizdatabill.IBizDataBillEntryExtService#setAddTypeEntry", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.setAddEntryFieldValue(fieldArgs);
            return null;
        });
        Set entryEntityFields = formView.getModel().getEntryEntity("entryentity").getDynamicObjectType().getProperties().stream().map(prop -> prop.getName()).collect(Collectors.toSet());
        index = 0;
        for (Map map2 : dataList) {
            for (Map.Entry prop2 : map2.entrySet()) {
                if (!entryEntityFields.contains(prop2.getKey())) continue;
                setter.set((String)prop2.getKey(), prop2.getValue(), index);
            }
            formView.setEnable(Boolean.FALSE, index, new String[]{"calfrequency", "effectivedate", "expirydate", "remark", "value", "currency"});
            ++index;
        }
    }

    public static DynamicObject[] getBizDataById(Object[] ids) {
        SWCDataServiceHelper bizDataHelper = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER;
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        return bizDataHelper.query("empposorgrel,bizdate,payrollgrp,salaryfile,bizitem,value,currency,calfrequency,effectivedate,expirydate,description,bizdatastatus,bizdatacode,modifytime,createtime", new QFilter[]{qFilter});
    }

    public static String getFieldName(String key) {
        if (null != key && !key.contains("person.") && key.contains(".number")) {
            key = key.replace(".number", ".name");
        }
        return key;
    }

    public static String getNewKey(String key) {
        if (null == key) {
            return null;
        }
        return key.replace('.', '_');
    }

    public static DynamicObject dealEntry(Long bizDataBillId, DynamicObject entry, DynamicObject dbEntry) {
        Map<String, String> fieldRlsMap = BizDataBillEntryHelper.getFieldRelationMap(bizDataBillId);
        if (dbEntry == null) {
            dbEntry = HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER.generateEmptyDynamicObject();
        }
        dbEntry.set("bizdatabillid", (Object)bizDataBillId);
        for (Map.Entry<String, String> fieldRls : fieldRlsMap.entrySet()) {
            if (!dbEntry.containsProperty(fieldRls.getValue()) || !entry.containsProperty(fieldRls.getKey())) continue;
            dbEntry.set(fieldRls.getValue(), entry.get(fieldRls.getKey()));
        }
        return dbEntry;
    }

    public static void dealDetail(DynamicObject entry, DynamicObject dbEntry, DynamicObject bizItemGroup) {
        Map<String, String> detailFieldRlsMap = BizDataBillEntryHelper.getDetailFieldRelationMap();
        DynamicObjectCollection bizDataDetails = dbEntry.getDynamicObjectCollection("entryentity");
        String showType = bizItemGroup.getString("modeltype");
        boolean detailsIsNull = kd.bos.util.CollectionUtils.isEmpty((Collection)bizDataDetails);
        Map<String, DynamicObject> bizItemMap = BizDataBillEntryHelper.getHorizontalBizItemMap(bizItemGroup);
        DataEntityPropertyCollection properties = entry.getDynamicObjectType().getProperties();
        if ("2".equals(showType)) {
            Map<Long, DynamicObject> dbDetailMap = bizDataDetails.stream().collect(Collectors.toMap(detail -> detail.getLong("bizitem.id"), detail -> detail, (k1, k2) -> k2));
            boolean sysFillCurrency = "2".equals(bizItemGroup.getString("currencyfilltype"));
            DynamicObject sysCurrency = bizItemGroup.getDynamicObject("sysfillcurrency");
            DecimalFormat decimalFormat = null;
            int amtPrecision = 0;
            if (sysFillCurrency) {
                amtPrecision = sysCurrency.getInt("amtprecision");
                decimalFormat = new DecimalFormat(new BigDecimal(INITPRECISION).setScale(amtPrecision).toPlainString());
            }
            boolean fillAmountItem = false;
            for (Map.Entry<String, DynamicObject> mapEntry : bizItemMap.entrySet()) {
                if (!properties.containsKey((Object)mapEntry.getKey())) continue;
                Object value = entry.get(mapEntry.getKey());
                boolean isInvalidStr = false;
                if (value instanceof String) {
                    String valueStr = (String)value;
                    isInvalidStr = SWCStringUtils.isEmpty((String)valueStr) || valueStr.trim().length() == 0;
                }
                DynamicObject bizItem = mapEntry.getValue();
                Long bizItemId = bizItem.getLong("id");
                DynamicObject bizItemDetail = dbDetailMap.get(bizItemId);
                if (null != value && !isInvalidStr) {
                    BigDecimal decimalValue;
                    int scale;
                    if (null == bizItemDetail) {
                        bizItemDetail = HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER.generateEmptyEntryDynamicObject(dbEntry, "entryentity");
                        bizDataDetails.add((Object)bizItemDetail);
                    }
                    bizItemDetail.set("bizitem", (Object)bizItem);
                    bizItemDetail.set("value", value);
                    if (value instanceof Date) {
                        bizItemDetail.set("value", (Object)SWCDateTimeUtils.format((Date)((Date)value), (String)"yyyy-MM-dd"));
                    }
                    bizItemDetail.set("effectivedate", entry.get("effectivedate"));
                    bizItemDetail.set("expirydate", entry.get("expirydate"));
                    if (1020L != bizItem.getLong("datatype.id")) continue;
                    fillAmountItem = true;
                    if (!sysFillCurrency || null == decimalFormat || (scale = (decimalValue = new BigDecimal(String.valueOf(value))).scale()) >= amtPrecision) continue;
                    value = decimalFormat.format(decimalValue);
                    entry.set(mapEntry.getKey(), value);
                    bizItemDetail.set("value", value);
                    continue;
                }
                if (bizItemDetail == null) continue;
                bizDataDetails.remove((Object)bizItemDetail);
            }
            if (sysFillCurrency) {
                if (fillAmountItem) {
                    dbEntry.set("currency", (Object)sysCurrency);
                    entry.set("currency", (Object)sysCurrency);
                } else {
                    dbEntry.set("currency", null);
                    entry.set("currency", null);
                }
            }
        } else {
            DynamicObject bizItemDetail;
            if (detailsIsNull) {
                bizItemDetail = HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER.generateEmptyEntryDynamicObject(dbEntry, "entryentity");
                bizDataDetails.add((Object)bizItemDetail);
            } else {
                bizItemDetail = (DynamicObject)bizDataDetails.get(0);
            }
            for (Map.Entry<String, String> fieldRls : detailFieldRlsMap.entrySet()) {
                Object value = entry.get(fieldRls.getKey());
                if ("bizitem".equals(fieldRls.getKey()) && !SWCObjectUtils.isEmpty((Object)value)) {
                    bizItemDetail.set(fieldRls.getValue(), (Object)bizItemMap.get(((DynamicObject)value).getString("number").toLowerCase()));
                    continue;
                }
                bizItemDetail.set(fieldRls.getValue(), value);
            }
        }
    }

    public static void invokeOperation(String operationKey, DynamicObject[] data) {
        if (data == null || data.length == 0) {
            return;
        }
        OperationServiceImpl operationService = new OperationServiceImpl();
        OperateOption opOption = OperateOption.create();
        OperationResult tempOpResult = operationService.localInvokeOperation(operationKey, data, opOption);
        if (!tempOpResult.isSuccess()) {
            List allErrorOrValidateInfo = tempOpResult.getAllErrorOrValidateInfo();
            if (kd.bos.util.CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
                throw new KDBizException(tempOpResult.getMessage());
            }
            throw new KDBizException(allErrorOrValidateInfo.stream().map(IOperateInfo::getMessage).distinct().collect(Collectors.joining(System.lineSeparator())));
        }
    }

    public static void invokeOperation(String operationKey, OperateOption opOption, DynamicObject[] data) {
        if (data == null || data.length == 0) {
            return;
        }
        OperationServiceImpl operationService = new OperationServiceImpl();
        OperationResult tempOpResult = operationService.localInvokeOperation(operationKey, data, opOption);
        if (!tempOpResult.isSuccess()) {
            List allErrorOrValidateInfo = tempOpResult.getAllErrorOrValidateInfo();
            if (kd.bos.util.CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
                throw new KDBizException(tempOpResult.getMessage());
            }
            throw new KDBizException(allErrorOrValidateInfo.stream().map(IOperateInfo::getMessage).distinct().collect(Collectors.joining(System.lineSeparator())));
        }
    }

    public static void bizDataBillDetailUpdateForOldData() {
        LOGGER.info("BizDataBillEntryHelper.bizDataBillDetailUpdateForOldData begin...");
        String sql = "select fentryid, fbizitemid, fvalue, feffectivedate, fexpirydate from t_hpdi_bizdatabillent a where not exists(select d.fentryid from t_hpdi_bizdatabilldetail d where d.fentryid = a.fentryid ) ";
        HashMap dataMap = new HashMap(16);
        SWCDbUtil.query((DBRoute)new DBRoute("hpdi"), (String)sql, (Object[])new Object[0], rs -> {
            while (rs.next()) {
                DynamicObject entry = HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER.generateEmptyEntryDynamicObject("entryentity");
                Long bizItemId = rs.getLong("fbizitemid");
                if (bizItemId == null || bizItemId == 0L) continue;
                entry.set("bizitem", (Object)bizItemId);
                entry.set("value", (Object)rs.getString("fvalue"));
                entry.set("effectivedate", (Object)rs.getDate("feffectivedate"));
                entry.set("expirydate", (Object)rs.getDate("fexpirydate"));
                Long entryId = rs.getLong("fentryid");
                ArrayList<DynamicObject> detailDys = (ArrayList<DynamicObject>)dataMap.get(entryId);
                if (detailDys == null) {
                    detailDys = new ArrayList<DynamicObject>(16);
                    dataMap.put(entryId, detailDys);
                }
                detailDys.add(entry);
            }
            return null;
        });
        if (dataMap.size() == 0) {
            new ScheduleServiceHelper();
            boolean isSucc = ScheduleServiceHelper.deletePlan((String)"2XZLY8IV+3ON");
            LOGGER.info("BizDataBillEntryHelper.bizDataBillDetailUpdateForOldData execing...deletePlan isSucc...{}", (Object)isSucc);
            return;
        }
        LOGGER.info("BizDataBillEntryHelper.bizDataBillDetailUpdateForOldData execing...dataMap.size...{}", (Object)dataMap.size());
        QFilter qFilter = new QFilter("id", "in", dataMap.keySet());
        DynamicObject[] entDys = HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER.query(SWCHisBaseDataHelper.getSelectProperties((String)"hpdi_bizdatabillent"), new QFilter[]{qFilter});
        LOGGER.info("BizDataBillEntryHelper.bizDataBillDetailUpdateForOldData execing...entDys.length...{}", (Object)entDys.length);
        for (DynamicObject entDy : entDys) {
            DynamicObjectCollection detailDys = entDy.getDynamicObjectCollection("entryentity");
            List detailDyNew = (List)dataMap.get(entDy.get("id"));
            if (detailDyNew == null) continue;
            for (DynamicObject detailDy : detailDyNew) {
                entDy.set("effectivedateent", (Object)detailDy.getDate("effectivedate"));
                entDy.set("expirydateent", (Object)detailDy.getDate("expirydate"));
                DynamicObject entry = HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER.generateEmptyEntryDynamicObject(entDy, "entryentity");
                entry.set("bizitem", (Object)detailDy.getLong("bizitem"));
                entry.set("value", (Object)detailDy.getString("value"));
                entry.set("effectivedate", (Object)detailDy.getDate("effectivedate"));
                entry.set("expirydate", (Object)detailDy.getDate("expirydate"));
                detailDys.add((Object)entry);
            }
        }
        HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER.save(entDys);
        LOGGER.info("BizDataBillEntryHelper.bizDataBillDetailUpdateForOldData end...entDys.length...{}", (Object)entDys.length);
    }

    public static ListShowParameter constructPersonF7() {
        ListShowParameter listShowParameter = BizDataBillEntryHelper.constructShowParameter("hrpi_personquerylistf7", "hrpi_depempf7querylist");
        listShowParameter.setAppId("hrpi");
        listShowParameter.setCustomParam("numberKey", (Object)"hrpi_person.number");
        listShowParameter.setCustomParam("nameKey", (Object)"hrpi_person.name");
        Long userId = RequestContext.get().getCurrUserId();
        String adminOrgKey = BizDataBillEntryHelper.checkEntryPermByAdminorgvid() ? "adminorgvid" : "adminorg";
        Set adminOrgQSet = SWCPermissionServiceHelper.getAdminOrgSetByPermItem((Long)userId, (String)"0NXW1VOPH+QV", (String)"hpdi_bizdatabillent", (String)"47156aff000000ac", (String)"empposorgrel.".concat(adminOrgKey));
        if (adminOrgQSet != null) {
            QFilter qFilter = new QFilter("hrpi_empposorgrel.".concat(adminOrgKey), "in", (Object)adminOrgQSet);
            listShowParameter.getListFilterParameter().setFilter(qFilter);
        }
        boolean isSuperUser = SWCPermissionServiceHelper.isSuperUser();
        QFilter empposFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)userId, (String)"0NXW1VOPH+QV", (String)"hpdi_bizdatabillent", (String)"empposorgrel", (String)"47150e89000000ac");
        if (!isSuperUser && empposFilter != null) {
            empposFilter.__setProperty("hrpi_empposorgrel." + empposFilter.getProperty());
            for (QFilter.QFilterNest tmpFilter : empposFilter.getNests(true)) {
                tmpFilter.getFilter().__setProperty("hrpi_empposorgrel." + tmpFilter.getFilter().getProperty());
            }
            listShowParameter.getListFilterParameter().setFilter(empposFilter);
        }
        return listShowParameter;
    }

    public static ListShowParameter constructBizDataF7(IFormView formView) {
        DynamicObjectCollection entryEntity;
        ListShowParameter listShowParameter = BizDataBillEntryHelper.constructShowParameter("bos_listf7", "hpdi_bizdata");
        String orderBy = "empposorgrel.adminorg.name, empposorgrel.person.number";
        DynamicObject bizItemGroupObj = formView.getModel().getDataEntity().getDynamicObject("bizitemgroup");
        DynamicObjectCollection bizItemGroupEntry = bizItemGroupObj.getDynamicObjectCollection("entryentity");
        ArrayList itemIds = new ArrayList(bizItemGroupEntry.size());
        bizItemGroupEntry.forEach(entry -> itemIds.add(entry.getLong("bizitem.id")));
        QFilter qFilter = new QFilter("bizdatastatus", "=", (Object)"3");
        qFilter.and("bizitemgroup.id", "=", (Object)bizItemGroupObj.getLong("id"));
        qFilter.and("bizitem.id", "in", itemIds);
        qFilter.and("bizitem.cycle", "=", (Object)"1");
        qFilter.and("bizitem.status", "=", (Object)"C");
        qFilter.and("bizitem.enable", "=", (Object)"1");
        qFilter.and("billtype", "=", (Object)"1");
        Long userId = RequestContext.get().getCurrUserId();
        String adminOrgKey = BizDataBillEntryHelper.checkEntryPermByAdminorgvid() ? "adminorgvid" : "adminorg";
        Set adminOrgQSet = SWCPermissionServiceHelper.getAdminOrgSetByPermItem((Long)userId, (String)"0NXW1VOPH+QV", (String)"hpdi_bizdatabillent", (String)"47156aff000000ac", (String)"empposorgrel.".concat(adminOrgKey));
        if (adminOrgQSet != null) {
            qFilter.and("empposorgrel.".concat(adminOrgKey), "in", (Object)adminOrgQSet);
        }
        boolean isSuperUser = SWCPermissionServiceHelper.isSuperUser();
        QFilter empposFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)RequestContext.get().getCurrUserId(), (String)"0NXW1VOPH+QV", (String)"hpdi_bizdatabillent", (String)"empposorgrel", (String)"47150e89000000ac");
        if (!isSuperUser && empposFilter != null) {
            empposFilter.__setProperty("empposorgrel." + empposFilter.getProperty());
            for (QFilter.QFilterNest tmpFilter : empposFilter.getNests(true)) {
                tmpFilter.getFilter().__setProperty("empposorgrel." + tmpFilter.getFilter().getProperty());
            }
            qFilter.and(empposFilter);
        }
        IDataModel model = formView.getModel();
        ArrayList selectedBizDataCode = new ArrayList(model.getEntryRowCount("entryentity"));
        SWCDataServiceHelper entHelper = HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER;
        QFilter entFilter = new QFilter("bizdatabillid", "=", (Object)model.getDataEntity().getLong("id"));
        DynamicObject[] entCol = entHelper.query("bizdatacode", entFilter.toArray());
        if (null != entCol && entCol.length > 0) {
            Arrays.stream(entCol).forEach(ent -> selectedBizDataCode.add(ent.getString("bizdatacode")));
        }
        if (!SWCListUtils.isEmpty((List)(entryEntity = model.getEntryEntity("entryentity")))) {
            if ("hpdi_bizdatabillnewentry".equals(formView.getFormShowParameter().getFormId())) {
                entryEntity.forEach(entry -> selectedBizDataCode.add(entry.getString("bizdatacode")));
            }
            qFilter.and("bizdatacode", "not in", selectedBizDataCode);
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        qFilters.add(qFilter);
        listShowParameter.getListFilterParameter().setQFilters(qFilters);
        listShowParameter.getListFilterParameter().setOrderBy(orderBy);
        listShowParameter.setCustomParam("isCloseBizDataBillShowF7", (Object)"1");
        listShowParameter.setCustomParam("numberKey", (Object)"empposorgrel.person.number");
        listShowParameter.setCustomParam("nameKey", (Object)"empposorgrel.person.name");
        return listShowParameter;
    }

    public static ListShowParameter constructShowParameter(String formId, String billFormId) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId(formId);
        listShowParameter.setBillFormId(billFormId);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setHeight("600");
        inlineStyleCss.setWidth("1000");
        listShowParameter.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        listShowParameter.setMultiSelect(true);
        listShowParameter.setLookUp(true);
        listShowParameter.setShowApproved(true);
        listShowParameter.setShowUsed(true);
        listShowParameter.setShowTitle(false);
        listShowParameter.setHasRight(true);
        return listShowParameter;
    }

    public static void showEntryCol(IFormView formView) {
        formView.setVisible(Boolean.FALSE, "dataapprovestatus,approvedesc,bizdatastatus,errormsg,submiterror,datacode,sumcol,enttranssalarystatus".split(","));
        BizDataBillEntryHelper.setCustomParamHideenEntryField(formView, "dataapprovestatus,approvedesc,bizdatastatus,errormsg,submiterror,datacode,sumcol,enttranssalarystatus");
    }

    public static void setCustomParamHideenEntryField(IFormView formView, String hideenEntryField) {
        String hideenEntryFields = (String)formView.getFormShowParameter().getCustomParam("hideen_entry_fields");
        hideenEntryFields = hideenEntryFields + "," + hideenEntryField + ",";
        formView.getFormShowParameter().setCustomParam("hideen_entry_fields", (Object)hideenEntryFields);
        formView.cacheFormShowParameter();
    }

    private static void removeCustomParamHideenEntryField(IFormView formView, String showEntryField) {
        String hideenEntryFields = (String)formView.getFormShowParameter().getCustomParam("hideen_entry_fields");
        if (hideenEntryFields == null) {
            return;
        }
        String[] hideenEntryFieldArr = showEntryField.split(",");
        for (int i = 0; i < hideenEntryFieldArr.length; ++i) {
            String oneField = hideenEntryFieldArr[i] + ",";
            hideenEntryFields = hideenEntryFields.replace(oneField, "");
        }
        formView.getFormShowParameter().setCustomParam("hideen_entry_fields", (Object)hideenEntryFields);
        formView.cacheFormShowParameter();
    }

    public static void setUpdateTypeEntry(IFormView view, DynamicObjectCollection entryEntity, TableValueSetter setter, Boolean flag, Long bizItemGroupId) {
        IPageCache pageCache = BizDataBillEntryHelper.getBizDataBillPageCache(view);
        String cacheKey = String.format(Locale.ROOT, "bizItemGroupEmpposorgrelFields_%s", bizItemGroupId);
        List empFields = (List)SerializationUtils.deSerializeFromBase64((String)pageCache.get(cacheKey));
        for (int index = 0; index < entryEntity.size(); ++index) {
            DynamicObject bizData = (DynamicObject)entryEntity.get(index);
            setter.set("bizdate", (Object)bizData.getDate("bizdate"), index);
            setter.set("value", (Object)bizData.getString("value"), index);
            setter.set("effectivedate", (Object)bizData.getDate("effectivedate"), index);
            setter.set("expirydate", (Object)bizData.getDate("expirydate"), index);
            if (BooleanUtils.isTrue((Boolean)flag)) {
                setter.set("remark", (Object)bizData.getString("remark"), index);
            } else {
                setter.set("remark", (Object)bizData.getString("description"), index);
            }
            setter.set("bizdatastatus", (Object)bizData.getString("bizdatastatus"), index);
            setter.set("bizdatacode", (Object)bizData.getString("bizdatacode"), index);
            setter.set("originalbizdatacode", (Object)bizData.getString("bizdatacode"), index);
            setter.set("salaryfile_id", (Object)bizData.getLong("salaryfile.id"), index);
            setter.set("payrollgrp_id", (Object)bizData.getLong("payrollgrp.id"), index);
            setter.set("empposorgrel_id", (Object)bizData.getLong("empposorgrel.id"), index);
            setter.set("bizitem_id", (Object)bizData.getLong("bizitem.id"), index);
            setter.set("currency_id", (Object)bizData.getLong("currency.id"), index);
            setter.set("calfrequency_id", (Object)bizData.getLong("calfrequency.id"), index);
            DynamicObject empposorgrel = bizData.getDynamicObject("empposorgrel");
            setter.set("person_id", (Object)empposorgrel.getLong("person.id"), index);
            setter.set("entadminorg_id", (Object)empposorgrel.getLong("adminorg.id"), index);
            if (!kd.bos.util.CollectionUtils.isNotEmpty((Collection)empFields)) continue;
            DataEntityPropertyCollection empProperties = empposorgrel.getDataEntityType().getProperties();
            for (String key : empFields) {
                if (BASE_DATA_FIELD_SET.contains(key)) {
                    setter.set(BizDataBillEntryHelper.getBaseDataIdField(key), empposorgrel.get(BizDataBillEntryHelper.getBaseDataId(key)), index);
                    continue;
                }
                if (!empProperties.containsKey((Object)key) && (null == key || !key.contains(".") || !empProperties.containsKey((Object)key.split("\\.")[0]))) continue;
                setter.set(BizDataBillEntryHelper.getNewKey(key), empposorgrel.get(BizDataBillEntryHelper.getFieldName(key)), index);
            }
        }
    }

    public static void setEntryFieldEnable(IFormView view) {
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("entryentity");
        String billType = (String)view.getModel().getValue("billtype");
        boolean isHorizontal = BizDataBillEntryHelper.isHorizontalTable(view);
        List<Object> bizItemFields = new ArrayList(10);
        boolean containAmountField = false;
        if (isHorizontal) {
            bizItemFields = BizDataBillEntryHelper.getHorizontalBizItemFields(view);
            containAmountField = Boolean.parseBoolean(view.getPageCache().get("containAmountBizItem"));
        }
        boolean sysFillCurrency = "2".equals(view.getModel().getDataEntity().getString("bizitemgroup.currencyfilltype"));
        int index = BizDataBillEntryHelper.getCurrentPageStartRowIndex(view);
        int dataIndex = 0;
        while (dataIndex < entryEntity.size()) {
            switch (billType) {
                case "1": {
                    if (isHorizontal) {
                        view.setEnable(Boolean.TRUE, index, new String[]{"effectivedate", "value", "calfrequency", "remark"});
                        if (containAmountField && !sysFillCurrency) {
                            view.setEnable(Boolean.TRUE, index, new String[]{"currency"});
                        } else {
                            view.setEnable(Boolean.FALSE, index, new String[]{"currency"});
                        }
                        view.setEnable(Boolean.FALSE, index, new String[]{"expirydate"});
                        break;
                    }
                    DynamicObject bizItemObj = ((DynamicObject)entryEntity.get(dataIndex)).getDynamicObject("bizitem");
                    if (bizItemObj == null) {
                        view.setEnable(Boolean.FALSE, index, EDITABLE_FIELDS);
                        view.setEnable(Boolean.FALSE, index, new String[]{"expirydate"});
                        view.setEnable(Boolean.FALSE, index, new String[]{"currency"});
                        break;
                    }
                    view.setEnable(Boolean.TRUE, index, EDITABLE_FIELDS);
                    long dataTypeId = bizItemObj.getLong("datatype.id");
                    if (dataTypeId == 1020L && !sysFillCurrency) {
                        view.setEnable(Boolean.TRUE, index, new String[]{"currency"});
                    } else {
                        view.setEnable(Boolean.FALSE, index, new String[]{"currency"});
                    }
                    if ("1".equals(bizItemObj.getString("cycle"))) {
                        view.setEnable(Boolean.TRUE, index, new String[]{"expirydate"});
                        break;
                    }
                    view.setEnable(Boolean.FALSE, index, new String[]{"expirydate"});
                    break;
                }
                case "2": {
                    view.setEnable(Boolean.FALSE, index, EDITABLE_FIELDS);
                    view.setEnable(Boolean.FALSE, index, new String[]{"expirydate"});
                    view.setEnable(Boolean.FALSE, index, new String[]{"currency"});
                    view.setEnable(Boolean.TRUE, index, new String[]{"bizdate"});
                    view.setEnable(Boolean.TRUE, index, new String[]{"updateexpirydate", "updateddesc"});
                    if (isHorizontal) {
                        String[] bizItemArray = new String[bizItemFields.size()];
                        view.setEnable(Boolean.FALSE, index, bizItemFields.toArray(bizItemArray));
                        break;
                    }
                    view.setEnable(Boolean.FALSE, index, new String[]{"bizitem"});
                    break;
                }
            }
            ++dataIndex;
            ++index;
        }
    }

    public static void setEntryFieldMustInput(IFormView view) {
        String billType = (String)view.getModel().getValue("billtype");
        boolean isHorizontal = BizDataBillEntryHelper.isHorizontalTable(view);
        if (SWCStringUtils.equals((String)billType, (String)"1")) {
            DateEdit effectiveDateEdit;
            if (!isHorizontal) {
                BasedataEdit bizItemEdit = (BasedataEdit)view.getControl("bizitem");
                bizItemEdit.setMustInput(true);
                TextEdit valueEdit = (TextEdit)view.getControl("value");
                valueEdit.setMustInput(true);
            }
            if ((effectiveDateEdit = (DateEdit)view.getControl("effectivedate")) != null) {
                effectiveDateEdit.setMustInput(true);
            }
        }
    }

    public static void setMustInputForUpdateExpiryDate(IFormView view) {
        String billType;
        switch (billType = (String)view.getModel().getValue("billtype")) {
            case "1": {
                BizDataBillEntryHelper.setEntryFieldMustInput(view);
                break;
            }
            case "2": {
                DateEdit dateEdit2 = (DateEdit)view.getControl("updateexpirydate");
                dateEdit2.setMustInput(true);
                break;
            }
        }
    }

    public static int getCurrentPageStartRowIndex(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        String sourceType = pageCache.get("newentryoperation");
        if (null != sourceType && "ADD".equals(sourceType)) {
            return 0;
        }
        String pageRowsStr = pageCache.get("pagerows");
        String pageIndexStr = pageCache.get("pageindex");
        int pageRows = 20;
        int pageIndex = 1;
        if (null != pageIndexStr) {
            pageRows = Integer.parseInt(pageRowsStr);
            pageIndex = Integer.parseInt(pageIndexStr);
        }
        int startRowIndex = (pageIndex - 1) * pageRows;
        return startRowIndex;
    }

    private static Map<String, String> getDetailFieldRelationMap() {
        HashMap<String, String> detailFieldRlsMap = new HashMap<String, String>(16);
        detailFieldRlsMap.put("bizitem", "bizitem");
        detailFieldRlsMap.put("value", "value");
        detailFieldRlsMap.put("effectivedate", "effectivedate");
        detailFieldRlsMap.put("expirydate", "expirydate");
        return detailFieldRlsMap;
    }

    private static Map<String, String> getFieldRelationMap(Long bizDataBillId) {
        HashMap<String, String> fieldRlsMap = new HashMap<String, String>(16);
        fieldRlsMap.put("id", "id");
        fieldRlsMap.put("empposorgrel", "empposorgrel");
        fieldRlsMap.put("bizdate", "bizdate");
        fieldRlsMap.put("relationdata", "relationdata");
        fieldRlsMap.put("currency", "currency");
        fieldRlsMap.put("calfrequency", "calfrequency");
        fieldRlsMap.put("updateexpirydate", "updateexpirydate");
        fieldRlsMap.put("updateddesc", "updateddesc");
        fieldRlsMap.put("remark", "remark");
        fieldRlsMap.put("dataapprovestatus", "dataapprovestatus");
        fieldRlsMap.put("approvedesc", "approvedesc");
        fieldRlsMap.put("bizdatastatus", "bizdatastatus");
        fieldRlsMap.put("errormsg", "errormsg");
        fieldRlsMap.put("submiterror", "submiterror");
        fieldRlsMap.put("bizdatacode", "bizdatacode");
        fieldRlsMap.put("salaryfile", "salaryfile");
        fieldRlsMap.put("payrollgrp", "payrollgrp");
        fieldRlsMap.put("bizdatadim", "bizdatadim");
        fieldRlsMap.put("effectivedate", "effectivedateent");
        fieldRlsMap.put("expirydate", "expirydateent");
        AfterAddFieldContainerEvent event = new AfterAddFieldContainerEvent();
        HashMap<String, Long> customParams = new HashMap<String, Long>(16);
        customParams.put("bizDataBillId", bizDataBillId);
        SWCDataServiceHelper bizDataBillHelper = HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER;
        DynamicObject bizDataBill = bizDataBillHelper.queryOne("bizitemgroup.id", (Object)bizDataBillId);
        customParams.put("bizItemGroupId", bizDataBill.getLong("bizitemgroup.id"));
        event.setCustomParams(customParams);
        Map<String, String> extRelationMap = BizDataBillEntryHelper.invokeAfterAddFieldContainer(event);
        if (extRelationMap != null) {
            fieldRlsMap.putAll(extRelationMap);
        }
        return fieldRlsMap;
    }

    private static Map<String, String> invokeAfterAddFieldContainer(AfterAddFieldContainerEvent args) {
        BizDataBillEntryExtService ExtService = new BizDataBillEntryExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)ExtService, IBizDataBillEntryExtService.class, (String)"kd.sdk.swc.hpdi.business.extpoint.bizdatabill.IBizDataBillEntryExtService#afterAddFieldContainer", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.afterAddFieldContainer(args);
            return null;
        });
        return args.getFieldRelationMap();
    }

    public static String getBaseDataIdField(String baseDataKey) {
        if (null == baseDataKey) {
            return null;
        }
        StringBuilder sb = new StringBuilder(baseDataKey);
        sb.append("_id");
        return sb.toString();
    }

    public static String getBaseDataId(String baseDataKey) {
        if (null == baseDataKey) {
            return null;
        }
        StringBuilder sb = new StringBuilder(baseDataKey);
        sb.append(".id");
        return sb.toString();
    }

    public static void removeEntryDataCache(boolean removeAll, Long bizDataBillId, List<Long> entryIds) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "hpdi_bizdatabill_entry_changed_%s", bizDataBillId));
        Set changedEntryIds = (Set)appCache.get("changed_entry_id_collection", HashSet.class);
        if (changedEntryIds == null) {
            return;
        }
        Map changedEntryMap = (Map)appCache.get("changed_entry_map", HashMap.class);
        if (changedEntryMap == null) {
            return;
        }
        if (removeAll) {
            if (!CollectionUtils.isEmpty((Collection)changedEntryIds)) {
                changedEntryIds.forEach(id -> appCache.remove(String.valueOf(id)));
                appCache.remove("changed_entry_id_collection");
            }
            appCache.remove("changed_entry_map");
        } else {
            if (kd.bos.util.CollectionUtils.isEmpty(entryIds)) {
                return;
            }
            entryIds.forEach(entryId -> {
                appCache.remove(String.valueOf(entryId));
                changedEntryIds.remove(entryId);
                changedEntryMap.remove(String.valueOf(entryId));
            });
            appCache.put("changed_entry_id_collection", (Object)changedEntryIds);
            appCache.put("changed_entry_map", (Object)changedEntryMap);
        }
    }

    public static Map<String, Object> getQueryMap(DynamicObject bizDataBill) {
        DynamicObjectCollection bizDataRuleFields;
        String billNo = bizDataBill.getString("billno");
        String billType = bizDataBill.getString("billtype");
        String handleType = bizDataBill.getString("handletype");
        DynamicObject bizItemGroup = bizDataBill.getDynamicObject("bizitemgroup");
        DynamicObject calPeriod = bizDataBill.getDynamicObject("calperiod");
        Long orgId = bizDataBill.getLong("org.id");
        HashMap<String, Object> queryMap = new HashMap<String, Object>(16);
        queryMap.put("billno", billNo);
        queryMap.put("billtype", billType);
        queryMap.put("handletype", handleType);
        queryMap.put("bizitemgroup", bizItemGroup);
        queryMap.put("org", orgId);
        if (!SWCObjectUtils.isEmpty((Object)calPeriod)) {
            queryMap.put("periodStartDate", calPeriod.getDate("startdate"));
            queryMap.put("periodEndDate", calPeriod.getDate("enddate"));
            queryMap.put("calperiod", calPeriod);
            queryMap.put("calperiodtype", calPeriod.getLong("periodtypeid"));
        }
        DynamicObject bizDataRuleObj = BizDataBillEntryHelper.getBizDataObjRuleByItemGroup(bizItemGroup);
        boolean bizDateMustInput = false;
        if (!SWCObjectUtils.isEmpty((Object)bizDataRuleObj) && kd.bos.util.CollectionUtils.isNotEmpty((Collection)(bizDataRuleFields = bizDataRuleObj.getDynamicObjectCollection("entryentity")))) {
            for (DynamicObject field : bizDataRuleFields) {
                if (!"bizdate".equals(field.getString("bizobjruleconf.number"))) continue;
                bizDateMustInput = "0".equals(field.getString("fillmode"));
                break;
            }
        }
        queryMap.put("bizDateMustInput", bizDateMustInput);
        return queryMap;
    }

    public static Map<Long, List<ExtendedDataEntity>> convertExtendedDataEntityToMap(ExtendedDataEntity[] dataEntities, List<Long> billIds) {
        return Arrays.stream(dataEntities).collect(Collectors.groupingBy(data -> {
            long billId = data.getDataEntity().getLong("bizdatabillid");
            billIds.add(billId);
            return billId;
        }));
    }

    public static Map<Long, DynamicObject> getBizDataBillInfoByBillIds(List<Long> billIds) {
        DynamicObject[] bizDataBills = BizDataBillEntryHelper.getBizDataBillById(billIds);
        return Arrays.stream(bizDataBills).collect(Collectors.toMap(bizDataBill -> bizDataBill.getLong("id"), Function.identity(), (key1, key2) -> key1));
    }

    public static DynamicObject[] getBizDataBillById(List<Long> ids) {
        SWCDataServiceHelper bizDataBillHelper = HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER;
        QFilter qFilter = new QFilter("id", "in", ids);
        return bizDataBillHelper.query("id,bizitemgroup,billno,billtype,handletype,calperiod.startdate,calperiod.enddate,calperiod.periodtypeid, org, bizitemgroup.entryentity.bizitem.maxinputtime", new QFilter[]{qFilter});
    }

    public static DynamicObject getBizDataBillById(Long id) {
        SWCDataServiceHelper bizDataBillHelper = HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER;
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        return bizDataBillHelper.queryOne("id,bizitemgroup,billno,billtype,handletype,calperiod.startdate,calperiod.enddate,calperiod.periodtypeid", new QFilter[]{qFilter});
    }

    public static void setFieldsTextAlign(IFormView formView) {
        EntryGrid entryGrid = (EntryGrid)formView.getControl("entryentity");
        List columns = entryGrid.getItems();
        boolean isHorizontal = BizDataBillEntryHelper.isHorizontalTable(formView);
        boolean isNewEntryForm = "hpdi_bizdatabillnewentry".equals(formView.getFormShowParameter().getFormId());
        List numBizItemFields = new ArrayList(10);
        List amountBizItemFields = new ArrayList(10);
        boolean existsNumOrAmountField = false;
        if (isHorizontal) {
            BizDataBillEntryHelper.getHorizontalBizItemFields(formView);
            String numBizItemFieldStr = formView.getPageCache().get("numBizItemFields");
            String amountBizItemFieldStr = formView.getPageCache().get("amountBizItemFields");
            if (SWCStringUtils.isNotEmpty((String)numBizItemFieldStr)) {
                numBizItemFields = SerializationUtils.fromJsonStringToList((String)numBizItemFieldStr, String.class);
                existsNumOrAmountField = true;
            }
            if (SWCStringUtils.isNotEmpty((String)amountBizItemFieldStr)) {
                amountBizItemFields = SerializationUtils.fromJsonStringToList((String)amountBizItemFieldStr, String.class);
                existsNumOrAmountField = true;
            }
        }
        for (Control column : columns) {
            String textAlign = "left";
            if (column instanceof AmountEdit || column instanceof IntegerEdit || column instanceof DecimalEdit) {
                textAlign = "right";
                if (isHorizontal && !isNewEntryForm && existsNumOrAmountField) {
                    entryGrid.setColumnProperty(column.getKey(), "sum", (Object)1);
                }
            } else {
                if ((!kd.bos.util.CollectionUtils.isNotEmpty(numBizItemFields) || !numBizItemFields.contains(column.getKey())) && (!kd.bos.util.CollectionUtils.isNotEmpty(amountBizItemFields) || !amountBizItemFields.contains(column.getKey()))) continue;
                textAlign = "right";
            }
            entryGrid.setColumnProperty(column.getKey(), "text-align", (Object)textAlign);
        }
    }

    public static void deleteEntryData(IFormView view) {
        IDataModel model = view.getModel();
        AbstractFormDataModel dataModel = (AbstractFormDataModel)model;
        dataModel.deleteEntryData("entryentity");
        QFilter filter = new QFilter("bizdatabillid", "=", model.getDataEntity().getPkValue());
        HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER.deleteByFilter(filter.toArray());
        view.updateView("entryentity");
        model.setValue("personcount", null);
        model.setValue("bizitemcount", null);
        model.setValue("bizdatacount", null);
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("is_self_save", "true");
        BizDataBillEntryHelper.removeEntryDataCache(true, model.getDataEntity().getLong("id"), null);
        view.invokeOperation("save", operateOption);
        view.invokeOperation("refresh");
    }

    public static void setFieldsNotQuickAddNew(IFormView formView) {
        ClientViewProxy clientViewProxy = (ClientViewProxy)formView.getService(IClientViewProxy.class);
        boolean isHorizontal = BizDataBillEntryHelper.isHorizontalTable(formView);
        if (!isHorizontal) {
            clientViewProxy.invokeControlMethod("entryentity", "setColEditorProp", new Object[]{"bizitem", "qan", Boolean.FALSE});
        }
        clientViewProxy.invokeControlMethod("entryentity", "setColEditorProp", new Object[]{"currency", "qan", Boolean.FALSE});
        clientViewProxy.invokeControlMethod("entryentity", "setColEditorProp", new Object[]{"calfrequency", "qan", Boolean.FALSE});
    }

    public static boolean isHorizontalTable(IFormView view) {
        String modelType = view.getModel().getDataEntity().getDynamicObject("bizitemgroup").getString("modeltype");
        return "2".equals(modelType);
    }

    public static List<String> getHorizontalBizItemFields(IFormView formView) {
        ArrayList<String> bizItemFields = new ArrayList(10);
        String bizItemFieldsStr = formView.getPageCache().get("bizItemFields");
        if (StringUtils.isEmpty((String)bizItemFieldsStr)) {
            SWCDataServiceHelper bigHelper;
            DynamicObject bizItemGroup;
            DynamicObjectCollection bizItems;
            List<Object> mulBizItemIds = new ArrayList(10);
            MulBasedataDynamicObjectCollection mulBizItemColl = (MulBasedataDynamicObjectCollection)formView.getModel().getDataEntity().get("mulbizitem");
            if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)mulBizItemColl)) {
                mulBizItemIds = mulBizItemColl.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toList());
            }
            if (kd.bos.util.CollectionUtils.isEmpty((Collection)(bizItems = (bizItemGroup = (bigHelper = HPDIDataServiceHelper.HSBS_BIZITEMGROUP_HELPER).queryOne((Object)formView.getModel().getDataEntity().getLong("bizitemgroup.id"))).getDynamicObjectCollection("entryentity")))) {
                return bizItemFields;
            }
            boolean containAmountField = false;
            ArrayList<String> amountFields = new ArrayList<String>(10);
            ArrayList<String> numFields = new ArrayList<String>(10);
            for (DynamicObject bizItem : bizItems) {
                if (kd.bos.util.CollectionUtils.isNotEmpty(mulBizItemIds) && !mulBizItemIds.contains(bizItem.getLong("bizitem.id"))) continue;
                String field = bizItem.getString("bizitem.number").toLowerCase();
                bizItemFields.add(field);
                if ("1020_S".equals(bizItem.getString("bizitem.datatype.number"))) {
                    containAmountField = true;
                    amountFields.add(field);
                    continue;
                }
                if (!"1010_S".equals(bizItem.getString("bizitem.datatype.number"))) continue;
                numFields.add(field);
            }
            bizItemFieldsStr = SerializationUtils.toJsonString(bizItemFields);
            String amountItemFieldsStr = SerializationUtils.toJsonString(amountFields);
            String numItemFieldsStr = SerializationUtils.toJsonString(numFields);
            formView.getPageCache().put("bizItemFields", bizItemFieldsStr);
            formView.getPageCache().put("amountBizItemFields", amountItemFieldsStr);
            formView.getPageCache().put("containAmountBizItem", String.valueOf(containAmountField));
            formView.getPageCache().put("numBizItemFields", numItemFieldsStr);
        } else {
            bizItemFields = SerializationUtils.fromJsonStringToList((String)bizItemFieldsStr, String.class);
        }
        return bizItemFields;
    }

    public static Map<String, DynamicObject> getHorizontalBizItemMap(DynamicObject bizItemGroup) {
        SWCDataServiceHelper bigHelper = HPDIDataServiceHelper.HSBS_BIZITEMGROUP_HELPER;
        bizItemGroup = bigHelper.queryOne((Object)bizItemGroup.getLong("id"));
        Map<String, DynamicObject> map = new HashMap<String, DynamicObject>(16);
        DynamicObjectCollection bizItems = bizItemGroup.getDynamicObjectCollection("entryentity");
        if (kd.bos.util.CollectionUtils.isEmpty((Collection)bizItems)) {
            return map;
        }
        map = bizItems.stream().collect(Collectors.toMap(item -> item.getDynamicObject("bizitem").getString("number").toLowerCase(), item -> item.getDynamicObject("bizitem"), (k1, k2) -> k1));
        return map;
    }

    public static int getRealRowIndex(Long bizDataBillId, Long entryId, int rowIndex) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "hpdi_bizdatabill_entry_changed_%s", bizDataBillId));
        Map changedEntryMap = (Map)appCache.get("changed_entry_map", HashMap.class);
        if (null != changedEntryMap && changedEntryMap.containsKey(String.valueOf(entryId))) {
            rowIndex = (Integer)changedEntryMap.get(String.valueOf(entryId));
        }
        return rowIndex;
    }

    public static void setEntryCurrency(IFormView view, Long dataTypeId, int rowIndex) {
        if (null == dataTypeId) {
            view.getModel().setValue("currency", null, rowIndex);
            return;
        }
        if (1020L != dataTypeId) {
            return;
        }
        boolean sysFillCurrency = "2".equals(view.getModel().getDataEntity().getString("bizitemgroup.currencyfilltype"));
        if (!sysFillCurrency) {
            return;
        }
        view.getModel().setValue("currency", (Object)view.getModel().getDataEntity().getDynamicObject("bizitemgroup.sysfillcurrency"), rowIndex);
    }

    public static IPageCache getBizDataBillPageCache(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        if ("hpdi_bizdatabillnewentry".equals(view.getEntityId())) {
            pageCache = view.getParentView().getPageCache();
        }
        return pageCache;
    }

    public static String checkBizItemInvalid(DynamicObject entryEntity, int rowIndex, boolean isHorizontal, Set<String> effectiveBizItemKeys, Set<String> currentBizItemKeys) {
        String msg = null;
        String errorMsg = isHorizontal ? HPDIResMgrBusiness.getMsgOfBizItemHasChanged() : HPDIResMgrBusiness.getMsgOfSelectBizItemInvalid(rowIndex);
        if (isHorizontal) {
            Set effectiveKeys = effectiveBizItemKeys.stream().map(key -> key.toLowerCase()).collect(Collectors.toSet());
            for (String key2 : currentBizItemKeys) {
                if (effectiveKeys.contains(key2)) continue;
                msg = errorMsg;
                break;
            }
        } else if (!SWCObjectUtils.isEmpty((Object)entryEntity.getDynamicObject("bizitem")) && !effectiveBizItemKeys.contains(entryEntity.getString("bizitem.number").toLowerCase())) {
            msg = errorMsg;
        }
        return msg;
    }

    public static DynamicObject getBizDataObjRuleByItemGroup(DynamicObject bizItemGroup) {
        DynamicObject bizDataRuleObj = bizItemGroup.getDynamicObject("bizdataobjrule");
        SWCDataServiceHelper bdroHelper = HPDIDataServiceHelper.HSBS_BIZDATAOBJRULE_HELPER;
        bizDataRuleObj = SWCObjectUtils.isEmpty((Object)bizDataRuleObj) ? BizDataHelper.queryDefaultBizDataObjRule() : bdroHelper.queryOne(bizDataRuleObj.getPkValue());
        return bizDataRuleObj;
    }

    private static void setMatchRuleFieldsVisible(IFormView formView) {
        DynamicObject bizDataBill = formView.getModel().getDataEntity();
        DynamicObject bizItemGroup = bizDataBill.getDynamicObject("bizitemgroup");
        if (SWCObjectUtils.isEmpty((Object)bizItemGroup)) {
            return;
        }
        String billType = bizDataBill.getString("billtype");
        DynamicObject bizDataRuleObj = BizDataBillEntryHelper.getBizDataObjRuleByItemGroup(bizItemGroup);
        if ("1".equals(billType) && "2".equals(bizDataRuleObj.getString("matchrule"))) {
            formView.setVisible(Boolean.TRUE, new String[]{"bizdatadim"});
            BizDataBillEntryHelper.removeCustomParamHideenEntryField(formView, "bizdatadim");
        } else {
            formView.setVisible(Boolean.FALSE, new String[]{"bizdatadim"});
            BizDataBillEntryHelper.setCustomParamHideenEntryField(formView, "bizdatadim");
        }
    }

    private static void setExpiryDateVisible(IFormView formView) {
        List itemList;
        List resultList;
        DynamicObject bizItemGroup = formView.getModel().getDataEntity().getDynamicObject("bizitemgroup");
        if (SWCObjectUtils.isEmpty((Object)bizItemGroup)) {
            return;
        }
        Map<String, Object> bizItemGroupMap = BizDataHelper.getBizItemGroupMapById(bizItemGroup);
        boolean isVisible = true;
        if (bizItemGroupMap != null && MapUtils.getBoolean(bizItemGroupMap, (Object)"success").booleanValue() && kd.bos.util.CollectionUtils.isNotEmpty((Collection)(resultList = (List)bizItemGroupMap.get("result"))) && kd.bos.util.CollectionUtils.isNotEmpty((Collection)(itemList = (List)((Map)resultList.get(0)).get("bizitem")))) {
            isVisible = MapUtils.getBoolean((Map)((Map)itemList.get(0)), (Object)"cycle");
        }
        if (isVisible) {
            BizDataBillEntryHelper.removeCustomParamHideenEntryField(formView, "expirydate");
        } else {
            BizDataBillEntryHelper.setCustomParamHideenEntryField(formView, "expirydate");
        }
        formView.setVisible(Boolean.valueOf(isVisible), new String[]{"expirydate"});
    }

    public static void setMatchRuleFieldsMustInput(IFormView formView) {
        DynamicObject bizDataBill = formView.getModel().getDataEntity();
        DynamicObject bizItemGroup = bizDataBill.getDynamicObject("bizitemgroup");
        if (SWCObjectUtils.isEmpty((Object)bizItemGroup)) {
            return;
        }
        String billType = bizDataBill.getString("billtype");
        DynamicObject bizDataRuleObj = BizDataBillEntryHelper.getBizDataObjRuleByItemGroup(bizItemGroup);
        BasedataEdit bizDataDimEdit = (BasedataEdit)formView.getControl("bizdatadim");
        if ("1".equals(billType) && "2".equals(bizDataRuleObj.getString("matchrule"))) {
            bizDataDimEdit.setMustInput(true);
        } else {
            bizDataDimEdit.setMustInput(false);
        }
    }

    public static void updateTransSalaryStatus(Table<String, String, String> statusTable) {
        DynamicObject[] bizDataBillEntArr;
        if (statusTable.isEmpty()) {
            return;
        }
        Set bizDataCodes = statusTable.rowKeySet();
        Set billNoSet = statusTable.columnKeySet();
        QFilter filter1 = new QFilter("billno", "in", (Object)billNoSet);
        DynamicObject[] bizDataBillArr = HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER.query("id, billno, ischange", new QFilter[]{filter1});
        ArrayList<Long> bizDataBillIds = new ArrayList<Long>(bizDataBillArr.length);
        HashMap<Long, String> billMap = new HashMap<Long, String>(bizDataBillArr.length);
        for (DynamicObject bizDataBill : bizDataBillArr) {
            bizDataBillIds.add(bizDataBill.getLong("id"));
            billMap.put(bizDataBill.getLong("id"), bizDataBill.getString("billno"));
            bizDataBill.set("ischange", (Object)"1");
        }
        QFilter filter2 = new QFilter("bizdatacode", "in", (Object)bizDataCodes);
        filter2.and("bizdatabillid", "in", bizDataBillIds);
        for (DynamicObject ent : bizDataBillEntArr = HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER.query("bizdatabillid, bizdatacode, enttranssalarystatus", new QFilter[]{filter2})) {
            ent.set("enttranssalarystatus", statusTable.get((Object)ent.getString("bizdatacode"), billMap.get(ent.getLong("bizdatabillid"))));
        }
        HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER.update(bizDataBillEntArr);
        HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER.update(bizDataBillArr);
    }

    public static boolean checkEntryPermByAdminorgvid() {
        return BizDataBillEntryHelper.checkEntityCtrl("hpdi_bizdatabillent", "empposorgrel.adminorgvid");
    }

    private static boolean checkEntityCtrl(String entityNumber, String propkey) {
        SWCDataServiceHelper ctrlOrm = new SWCDataServiceHelper("hrcs_entityctrl");
        QFilter dimFilter = new QFilter("entitytype", "=", (Object)entityNumber);
        QFilter propkeyFilter = new QFilter("entryentity.propkey", "=", (Object)propkey);
        return ctrlOrm.isExists(new QFilter[]{dimFilter, propkeyFilter});
    }

    static {
        BASE_DATA_FIELD_SET.add("job");
        BASE_DATA_FIELD_SET.add("company");
        BASE_DATA_FIELD_SET.add("postype");
        BASE_DATA_FIELD_SET.add("position");
    }
}

