/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.helper;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hpdi.business.extpoint.bizdatabill.IBizDataBillEntryExtService;
import kd.sdk.swc.hpdi.common.events.bizdatabill.AfterAddFieldContainerEvent;
import kd.swc.hpdi.business.bizdata.enums.OperateStep;
import kd.swc.hpdi.business.bizdata.enums.PresentErrorEnum;
import kd.swc.hpdi.business.bizdata.filter.BizDataFilterChain;
import kd.swc.hpdi.business.bizdata.filter.BizItemConflictFilter;
import kd.swc.hpdi.business.helper.BizDataBillEntryExtService;
import kd.swc.hpdi.business.helper.BizDataBillEntryHelper;
import kd.swc.hpdi.business.helper.BizDataSubmitMultiService;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hpdi.business.service.AddTransSalaryService;
import kd.swc.hpdi.business.service.ITransSalaryService;
import kd.swc.hpdi.business.service.UpdateTransSalaryService;
import kd.swc.hpdi.business.util.HPDIServiceUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.BizDataStatusEnum;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.MapUtils;

public class BizDataHelper {
    private static final Log LOGGER = LogFactory.getLog(BizDataHelper.class);
    private static final String KEY_CALPERIOD_TYPE = "calperiodtype";
    private static final String IMPORTSTARTPLUGIN_0 = ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u683c\u5f0f\u7684\u6570\u636e\u6a21\u677f\u3002 \u8bf7\u68c0\u67e5\u6570\u636e\u6a21\u677f\uff1a1\u3001\u6570\u636e\u6a21\u677f\u4e0e\u5355\u636e\u5b9e\u4f53\u662f\u5426\u5339\u914d\uff1b2\u3001\u6570\u636e\u6a21\u677f\u662f\u5426\u5728\u7b2c\u4e00\u4e2a\u5de5\u4f5c\u8868\u3002", (String)"ImportStartPlugin_0", (String)"bos-import", (Object[])new Object[0]);
    protected static final Map<String, String> RELATION_MAP = new HashMap<String, String>();
    private static Log logger = LogFactory.getLog(BizDataHelper.class);
    private static final Map<String, ITransSalaryService> INSTANCE_MAP = new HashMap<String, ITransSalaryService>();
    private static final String SELECTBILLENTPROPERTIES = "empposorgrel,salaryfile.id,payrollgrp.id,empposorgrel.adminorg.id,bizdate,relationdata,currency,calfrequency,effectivedateent,expirydateent,updateexpirydate,updateddesc,remark,dataapprovestatus,approvedesc,bizdatastatus,errormsg,submiterror,bizdatacode,originalbizdatacode,bizdatabillid,entryentity.id,entryentity.bizitem,entryentity.value,entryentity.effectivedate,entryentity.expirydate";
    private static final String SELECT_BILLENT_PROPS_FIX = "empposorgrel.adminorg.id, entryentity.id, ";
    private static final String HPDI_BIZDATABILL_NEWENTRY = "hpdi_bizdatabillnewentry";
    private static final String KEY_DELETEENTRYIDS = "deleteentryids";

    public static String getSelectBillEntProperties() {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"hpdi_bizdatabillent");
        List allFields = SWCHisBaseDataHelper.getFields((MainEntityType)mainEntityType);
        List entryentityFields = SWCHisBaseDataHelper.getEntityFields((MainEntityType)mainEntityType, (String)"entryentity");
        for (String field : entryentityFields) {
            allFields.add("entryentity." + field);
        }
        String allSelectProps = SELECT_BILLENT_PROPS_FIX + String.join((CharSequence)",", allFields);
        return allSelectProps;
    }

    public static void abandonBeforeDo(IFormView view) {
        view.showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5e9f\u5f03\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"BizDataHelper_0", (String)"swc-hpdi-business", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("abandon_confirm"));
    }

    public static void abandonCheckClose(IFormView view, MessageBoxClosedEvent messageBoxClosedEvent) {
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            OperateOption op = OperateOption.create();
            view.invokeOperation("doabandon", op);
        }
    }

    public static void afterDoAbandon(IFormView view, AfterDoOperationEventArgs args) {
        List allErrorList = args.getOperationResult().getAllErrorOrValidateInfo();
        if (CollectionUtils.isEmpty((Collection)allErrorList)) {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u5e9f\u5f03\u6210\u529f\u3002", (String)"BizDataHelper_1", (String)"swc-hpdi-business", (Object[])new Object[0]));
        }
    }

    public static Map<String, String> getRuleConfMap() {
        HashMap<String, String> ruleConfMap = new HashMap<String, String>(16);
        ruleConfMap.put("person.number", "personnumber");
        ruleConfMap.put("person.name", "personname");
        ruleConfMap.put("adminorg.number", "adminorgname");
        ruleConfMap.put("job.number", "jobname");
        ruleConfMap.put("isprimary", "isprimary");
        ruleConfMap.put("postype.number", "postypename");
        ruleConfMap.put("startdate", "startdate");
        ruleConfMap.put("enddate", "enddate");
        ruleConfMap.put("company.number", "companyname");
        ruleConfMap.put("position.number", "positionname");
        ruleConfMap.put("bizdate", "bizdate");
        ruleConfMap.put("apositiontype", "apositiontype");
        return ruleConfMap;
    }

    public static int[] getEntryIndexArrByEntryName(IFormView view, String entryName) {
        EntryGrid entryGrid = (EntryGrid)view.getControl(entryName);
        return entryGrid.getSelectRows();
    }

    public static void intervalTransSalary() {
        SWCDataServiceHelper bizDataHelper = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER;
        QFilter bizDataFilter = new QFilter("bizdatastatus", "=", (Object)"2");
        bizDataFilter.and(new QFilter("createtime", "<=", (Object)SWCDateTimeUtils.getBeforeDay((Date)new Date())));
        DynamicObject[] bizDataArr = bizDataHelper.query("id, bizdatastatus, batchnum, empposorgrel, salaryfile, payrollgrp, bizitemgroup, bizitemgroup.calperiodtype.id, bizitem, currency, effectivedate, expirydate, bizdatacode, description, value, transsalaryerror, submitdate, errormsg, billtype, bizdatarecord, depemp", new QFilter[]{bizDataFilter});
        if (null != bizDataArr && bizDataArr.length > 0) {
            List<List<DynamicObject>> bizDatasSplit = BizDataHelper.splitBizData(Arrays.asList(bizDataArr));
            for (List<DynamicObject> bizDatas : bizDatasSplit) {
                BizDataHelper.transSalaryOneBatch(bizDatas);
            }
        }
    }

    public static List<List<DynamicObject>> splitBizData(List<DynamicObject> bizDataList) {
        ArrayList<List<DynamicObject>> bizDatasSplit = new ArrayList<List<DynamicObject>>(10);
        ArrayList<DynamicObject> normalBizDataList = new ArrayList<DynamicObject>(10);
        HashMap<Long, ArrayList<DynamicObject>> bizDataMap = new HashMap<Long, ArrayList<DynamicObject>>(10);
        for (DynamicObject bizData : bizDataList) {
            Long recordId = bizData.getLong("bizdatarecord.id");
            if (recordId == null || recordId == 0L) {
                normalBizDataList.add(bizData);
                continue;
            }
            ArrayList<DynamicObject> bizDatasTmp = (ArrayList<DynamicObject>)bizDataMap.get(recordId);
            if (bizDatasTmp == null) {
                bizDatasTmp = new ArrayList<DynamicObject>(10);
                bizDataMap.put(recordId, bizDatasTmp);
            }
            bizDatasTmp.add(bizData);
        }
        List normalBizDatasSplit = Lists.partition(normalBizDataList, (int)500);
        bizDatasSplit.addAll(normalBizDatasSplit);
        ArrayList tmpBizDataList = new ArrayList(10);
        int recordIdTotalNum = bizDataMap.size();
        int recordIdCurrNum = 0;
        for (List bizDatas : bizDataMap.values()) {
            ++recordIdCurrNum;
            if (tmpBizDataList.size() != 0 && tmpBizDataList.size() + bizDatas.size() > 500) {
                bizDatasSplit.add(tmpBizDataList);
                tmpBizDataList = new ArrayList(10);
            }
            tmpBizDataList.addAll(bizDatas);
            if (recordIdCurrNum != recordIdTotalNum) continue;
            bizDatasSplit.add(tmpBizDataList);
        }
        return bizDatasSplit;
    }

    private static void transSalaryOneBatch(List<DynamicObject> bizDatas) {
        try (TXHandle txHandle = TX.requiresNew();){
            Map<String, List<DynamicObject>> collect = bizDatas.stream().collect(Collectors.groupingBy(bizData -> bizData.getString("billtype")));
            if (!CollectionUtils.isEmpty((Collection)collect.get("2"))) {
                BizDataHelper.getTransSalaryService(UpdateTransSalaryService.class).transSalary(collect.get("2"), OperateStep.AUTO_TRANS_SALARY.getCode());
            }
            if (!CollectionUtils.isEmpty((Collection)collect.get("1"))) {
                BizDataHelper.getTransSalaryService(AddTransSalaryService.class).transSalary(collect.get("1"), OperateStep.AUTO_TRANS_SALARY.getCode());
            }
            txHandle.commit();
        }
    }

    public static ITransSalaryService getTransSalaryService(Class<? extends ITransSalaryService> clz) {
        logger.info(MessageFormat.format("BizDataHelper.getTransSalaryService ClassName is {0}", clz.getName()));
        ITransSalaryService service = INSTANCE_MAP.get(clz.getName());
        return service;
    }

    public static List<DynamicObject> submissionDo(DynamicObject bizDataBill) {
        Long bizDataBillId = bizDataBill.getLong("id");
        LOGGER.info("BizDataHelper.submissionDo..main.begin..bizDataBillId={}", (Object)bizDataBillId);
        SWCDataServiceHelper entryHelper = HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER;
        QFilter eFilter = new QFilter("bizdatabillid", "=", (Object)bizDataBill.getLong("id"));
        DynamicObject[] entryEntityArr = entryHelper.query(BizDataHelper.getSelectBillEntProperties(), eFilter.toArray());
        LOGGER.info("BizDataHelper.submissionDo...bizDataBillId={}...entry.length={}", (Object)bizDataBillId, (Object)entryEntityArr.length);
        DynamicObjectCollection entryEntitys = new DynamicObjectCollection();
        entryEntitys.addAll(Arrays.asList(entryEntityArr));
        int failCount = 0;
        ArrayList<DynamicObject> waitEntitys = new ArrayList<DynamicObject>(10);
        for (int i = 0; i < entryEntitys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntitys.get(i);
            boolean errorMsgEmpty = SWCStringUtils.isEmpty((String)entry.getString("errormsg"));
            boolean dataApproveStatusNotPass = "1".equals(entry.getString("dataapprovestatus"));
            if (dataApproveStatusNotPass) {
                entry.set("errormsg", entry.get("approvedesc"));
                entry.set("submiterror", (Object)PresentErrorEnum.NOT_PASS.getCode());
            }
            if (!errorMsgEmpty || dataApproveStatusNotPass) {
                entry.set("bizdatastatus", (Object)"2");
                ++failCount;
                continue;
            }
            waitEntitys.add(entry);
        }
        ArrayList<DynamicObject> bizDatas = new ArrayList<DynamicObject>();
        DynamicObjectCollection bizDataRecords = new DynamicObjectCollection();
        Map<String, Object> bizDataMap = BizDataSubmitMultiService.getInstance().packageBizData(waitEntitys, bizDataBill);
        bizDatas.addAll((Collection)bizDataMap.get("bizDatas"));
        bizDataRecords.addAll((Collection)bizDataMap.get("bizDataRecords"));
        LOGGER.info("BizDataHelper.submissionDo...bizDataBillId={}...result.length={}", (Object)bizDataBillId, (Object)bizDatas.size());
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        dynamicObjects.addAll(bizDatas);
        HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.save(dynamicObjects);
        LOGGER.info("BizDataHelper.submissionDo...bizDataBillId={}...result.save={}", (Object)bizDataBillId, (Object)bizDatas.size());
        if (bizDataRecords.size() >= 1) {
            HPDIDataServiceHelper.HPDI_BIZDATARECORD_HELPER.save(bizDataRecords);
            LOGGER.info("BizDataHelper.submissionDo...bizDataBillId={}...result.saveRecord={}", (Object)bizDataBillId, (Object)bizDataRecords.size());
        }
        int totalCount = entryEntitys.size();
        if (failCount == 0) {
            bizDataBill.set("datastatus", (Object)kd.swc.hpdi.business.bizdata.enums.BizDataStatusEnum.ALL_PRESENT.getCode());
        } else if (totalCount == failCount) {
            bizDataBill.set("datastatus", (Object)kd.swc.hpdi.business.bizdata.enums.BizDataStatusEnum.ALL_FAILED_PRESENT.getCode());
        } else if (totalCount > failCount) {
            bizDataBill.set("datastatus", (Object)kd.swc.hpdi.business.bizdata.enums.BizDataStatusEnum.PART_PRESENT.getCode());
        }
        bizDataBill.set("bizdatafailcount", (Object)failCount);
        HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER.saveOne(bizDataBill);
        LOGGER.info("BizDataHelper.submissionDo...bizDataBillId={}...bizDataBill.save", (Object)bizDataBillId);
        HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER.save(entryEntitys);
        LOGGER.info("BizDataHelper.submissionDo...bizDataBillId={}...entryEntitys.save={}", (Object)bizDataBillId, (Object)entryEntitys.size());
        BizDataHelper.recordErrorCaseSubmission(bizDataBill, entryEntitys);
        LOGGER.info("BizDataHelper.submissionDo...bizDataBillId={}...entryEntitys.recordErrorCaseSubmission={}", (Object)bizDataBillId, (Object)entryEntitys.size());
        LOGGER.info("BizDataHelper.submissionDo..main.end..bizDataBillId={}", (Object)bizDataBillId);
        return bizDatas;
    }

    public static Map<String, Object> packageBizData(List<DynamicObject> waitSubEntitys, DynamicObject bizDataBill) {
        HashMap<String, Object> bizDataMap = new HashMap<String, Object>(16);
        ArrayList<DynamicObject> bizDatas = new ArrayList<DynamicObject>();
        DynamicObjectCollection bizDataRecords = new DynamicObjectCollection();
        bizDataMap.put("bizDatas", bizDatas);
        bizDataMap.put("bizDataRecords", bizDataRecords);
        long[] recordIds = DB.genLongIds((String)"hpdi_bizdatarecord", (int)waitSubEntitys.size());
        int size = waitSubEntitys.stream().collect(Collectors.summingInt(entry -> entry.getDynamicObjectCollection("entryentity").size()));
        long[] ids = DB.genLongIds((String)"hpdi_bizdata", (int)size);
        List detailIds = Arrays.stream(ids).boxed().collect(Collectors.toList());
        Iterator iterator = detailIds.iterator();
        Set<String> ingoreFields = BizDataHelper.getBillEntDetailSet();
        boolean isHorizontal = "2".equals(bizDataBill.getDynamicObject("bizitemgroup").getString("modeltype"));
        for (int i = 0; i < waitSubEntitys.size(); ++i) {
            DynamicObject entry2 = waitSubEntitys.get(i);
            entry2.set("bizdatastatus", (Object)"1");
            entry2.set("enttranssalarystatus", (Object)BizDataStatusEnum.TO_BE_PUSH_SALARY.getCode());
            DynamicObjectCollection details = entry2.getDynamicObjectCollection("entryentity");
            DynamicObject bizDataRecord = null;
            for (int j = 0; j < details.size(); ++j) {
                DynamicObject detail = (DynamicObject)details.get(j);
                DynamicObject bizData = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.generateEmptyDynamicObject();
                BizDataHelper.transferDynamicObject(entry2, bizData, ingoreFields, null);
                if (!"1020_S".equals(detail.getDynamicObject("bizitem").getString("datatype.number"))) {
                    bizData.set("currency", null);
                }
                BizDataHelper.transferDynamicObject(detail, bizData, null, null);
                bizData.set("submitdate", (Object)new Date());
                bizData.set("submission", (Object)"1");
                bizData.set("bizitemgroup", (Object)bizDataBill.getDynamicObject("bizitemgroup"));
                bizData.set("applyno", (Object)bizDataBill.getString("billno"));
                bizData.set("adminorg", (Object)entry2.getLong("empposorgrel.adminorg.id"));
                bizData.set("depemp", (Object)entry2.getLong("empposorgrel.depemp.id"));
                bizData.set("billtype", (Object)bizDataBill.getString("billtype"));
                if ("2".equals(bizDataBill.getString("billtype"))) {
                    bizData.set("expirydate", (Object)entry2.getDate("updateexpirydate"));
                }
                bizData.set("bizdatastatus", (Object)"1");
                bizData.set("relationrecord", (Object)"B");
                bizData.set("description", (Object)entry2.getString("remark"));
                if (iterator.hasNext()) {
                    bizData.set("id", iterator.next());
                }
                bizData.set("calfrequency", (Object)entry2.getLong("calfrequency.id"));
                bizData.set("calperiod", (Object)bizDataBill.getLong("calperiod.id"));
                bizData.set("salaryfile", (Object)entry2.getLong("salaryfile.id"));
                bizData.set("payrollgrp", (Object)entry2.getLong("payrollgrp.id"));
                if (isHorizontal && 0 == j) {
                    bizDataRecord = HPDIDataServiceHelper.HPDI_BIZDATARECORD_HELPER.generateEmptyDynamicObject();
                    BizDataHelper.transferDynamicObject(bizData, bizDataRecord, null, null);
                    bizDataRecord.set("id", (Object)recordIds[i]);
                    bizDataRecord.set("currency", (Object)entry2.getLong("currency.id"));
                    bizDataRecords.add((Object)bizDataRecord);
                }
                if (isHorizontal) {
                    bizData.set("bizdatarecord", (Object)bizDataRecord);
                } else {
                    bizData.set("bizdatarecord", (Object)0L);
                }
                bizDatas.add(bizData);
            }
        }
        return bizDataMap;
    }

    public static void recordErrorCaseSubmission(DynamicObject bizDataBill, DynamicObjectCollection entryEntitys) {
        int failCount = (int)((long)entryEntitys.size() - entryEntitys.stream().filter(obj -> SWCStringUtils.isEmpty((String)obj.getString("errormsg"))).count());
        if (failCount > 0) {
            DynamicObject errorObject = HPDIDataServiceHelper.HPDI_BIZDATAERRORLOG_HELPER.generateEmptyDynamicObject();
            errorObject.set("billno", (Object)bizDataBill.getString("billno"));
            errorObject.set("operatestage", (Object)OperateStep.SUBMIT.getCode());
            errorObject.set("bizitemgroup", (Object)bizDataBill.getDynamicObject("bizitemgroup"));
            RequestContext requestContext = RequestContext.get();
            if (requestContext != null) {
                errorObject.set("creator", (Object)RequestContext.get().getCurrUserId());
            }
            errorObject.set("operatetime", (Object)new Date());
            errorObject.set("operatenum", (Object)entryEntitys.size());
            errorObject.set("adminorg", (Object)bizDataBill.getDynamicObject("adminorg"));
            entryEntitys.stream().filter(obj -> !SWCStringUtils.isEmpty((String)obj.getString("submiterror"))).forEach(obj -> {
                String errorFiled = RELATION_MAP.get(obj.getString("submiterror"));
                if (errorFiled != null) {
                    errorObject.set(errorFiled, (Object)(errorObject.getInt(errorFiled) + 1));
                }
            });
            BizDataHelper.setErrorTotal(errorObject);
            HPDIDataServiceHelper.HPDI_BIZDATAERRORLOG_HELPER.saveOne(errorObject);
        }
    }

    public static void setErrorTotal(DynamicObject errorObject) {
        int overInputNum = errorObject.getInt("overinputnum");
        int notInTimeWindowNum = errorObject.getInt("notintimewindownum");
        int notPassAuditNum = errorObject.getInt("notpassauditnum");
        int notMatchFileNum = errorObject.getInt("notmatchfilenum");
        int matchMoreFileNum = errorObject.getInt("matchmorefilenum");
        int otherNum = errorObject.getInt("othernum");
        errorObject.set("totalnum", (Object)(overInputNum + notInTimeWindowNum + notPassAuditNum + notMatchFileNum + matchMoreFileNum + otherNum));
    }

    public static void transferDynamicObject(DynamicObject from, DynamicObject to, Set<String> ignoreField, Map<String, String> mappingField) {
        DynamicObjectType fromMainEntityType = (DynamicObjectType)from.getDataEntityType();
        String toEntity = to.getDataEntityType().getName();
        MainEntityType toMainEntityType = (MainEntityType)to.getDataEntityType();
        Map<String, List<IDataEntityProperty>> fieldMaps = BizDataHelper.getEntityPropertiesMap(toMainEntityType);
        for (IDataEntityProperty property : fieldMaps.get(toEntity)) {
            String fieldName = property.getName();
            if (ignoreField != null && ignoreField.contains(fieldName)) continue;
            BizDataHelper.setFieldValue(from, to, fromMainEntityType, property, fieldName, mappingField);
        }
    }

    private static void setFieldValue(DynamicObject from, DynamicObject to, DynamicObjectType fromMainEntityType, IDataEntityProperty property, String fieldName, Map<String, String> mappingField) {
        String fromField = null;
        if (mappingField != null) {
            fromField = mappingField.get(fieldName);
        }
        if (fromField != null) {
            to.set(fieldName, from.get(fromField));
            return;
        }
        fromField = fieldName;
        if (!fromMainEntityType.getProperties().containsKey((Object)fromField)) {
            return;
        }
        if (property instanceof MulBasedataProp) {
            SWCHisBaseDataHelper.copyMulBaseDataField((DynamicObject)from, (DynamicObject)to, (String)fieldName);
        } else {
            to.set(fieldName, from.get(fieldName));
        }
    }

    public static Map<String, List<IDataEntityProperty>> getEntityPropertiesMap(MainEntityType mainEntityType) {
        Map entityTypeMap = mainEntityType.getAllEntities();
        HashMap<String, List<IDataEntityProperty>> entityFieldsMap = new HashMap<String, List<IDataEntityProperty>>(entityTypeMap.size());
        for (Map.Entry entry : entityTypeMap.entrySet()) {
            String entity = (String)entry.getKey();
            EntityType entityType = (EntityType)entry.getValue();
            Map fieldsMap = entityType.getFields();
            ArrayList<IDataEntityProperty> fields = new ArrayList<IDataEntityProperty>(fieldsMap.size());
            for (Map.Entry entry01 : fieldsMap.entrySet()) {
                IDataEntityProperty entityProperty = (IDataEntityProperty)entry01.getValue();
                fields.add(entityProperty);
            }
            entityFieldsMap.put(entity, fields);
        }
        return entityFieldsMap;
    }

    public static void initRecordMap(String billNo, Map<String, DynamicObject> recordMap, String keyField) {
        if (billNo != null && !"".equals(billNo)) {
            if (recordMap.get(billNo) != null) {
                DynamicObject errorObject = recordMap.get(billNo);
                errorObject.set(keyField, (Object)(errorObject.getInt(keyField) + 1));
            } else {
                DynamicObject errorObject = HPDIDataServiceHelper.HPDI_BIZDATAERRORLOG_HELPER.generateEmptyDynamicObject();
                errorObject.set("billno", (Object)billNo);
                errorObject.set(keyField, (Object)1);
                recordMap.put(billNo, errorObject);
            }
        }
    }

    public static Map<String, Object> getCod(List<Map<String, Object>> params) {
        logger.info(String.valueOf(JSON.toJSON(params)));
        Map result = (Map)SWCMServiceUtils.invokeSWCService((String)"hsas", (String)"IHSASService", (String)"queryPayNodeTimes", (Object[])new Object[]{params});
        logger.info(String.valueOf(JSON.toJSON((Object)result)));
        return result;
    }

    public static void updateBizData(Map<String, Object> param, Map<String, DynamicObject> recordMap) {
        logger.info("updateBizData param:", (Object)JSON.toJSONString(param));
        List paramList = (List)param.get("result");
        Map bizDataCodeMap = paramList.stream().collect(Collectors.toMap(map -> (String)map.get("bizDataCode"), Function.identity(), (key1, key2) -> key1));
        Set<String> bizDataCodeSet = bizDataCodeMap.keySet();
        logger.info("bizDataCodeMap:", (Object)JSON.toJSONString(bizDataCodeMap));
        SWCDataServiceHelper bizDataHelper = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER;
        QFilter bizDataFilter = new QFilter("bizdatacode", "in", bizDataCodeSet);
        DynamicObject[] bizDataArr = bizDataHelper.query("id, calperiod, bizdatastatus, errormsg, transsalaryerror, bizdatacode, calsalarydate, batchnum, applyno", new QFilter[]{bizDataFilter});
        Boolean success = (Boolean)param.get("success");
        String errorMsg = (String)param.get("message");
        for (DynamicObject bizDataDy : bizDataArr) {
            String billNo = bizDataDy.getString("applyno");
            bizDataDy.set("batchnum", (Object)billNo);
            Map bizDataMap = (Map)bizDataCodeMap.get(bizDataDy.getString("bizdatacode"));
            logger.info("bizDataMap:", (Object)JSON.toJSONString((Object)bizDataMap));
            if (CollectionUtils.isEmpty((Map)bizDataMap)) continue;
            bizDataDy.set("calperiod", bizDataMap.get("calPeriodId"));
            if (Boolean.TRUE.equals(success)) {
                String status = String.valueOf(bizDataMap.get("status"));
                if ("1".equals(status)) {
                    bizDataDy.set("bizdatastatus", (Object)"3");
                    bizDataDy.set("calsalarydate", (Object)new Date());
                    bizDataDy.set("errormsg", (Object)" ");
                    continue;
                }
                String errorReason = (String)bizDataMap.get("errorReason");
                bizDataDy.set("bizdatastatus", (Object)"4");
                bizDataDy.set("errormsg", (Object)new LocaleString(errorReason));
                if (billNo == null) continue;
                BizDataHelper.initRecordMap(billNo, recordMap, "othernum");
                continue;
            }
            bizDataDy.set("bizdatastatus", (Object)"4");
            bizDataDy.set("errormsg", (Object)new LocaleString(errorMsg));
            if (billNo == null) continue;
            BizDataHelper.initRecordMap(billNo, recordMap, "othernum");
        }
        bizDataHelper.update(bizDataArr);
    }

    public static Map<Long, DynamicObject> getBizItemFormBizItemGroup(Map<String, Object> queryMap, List<DynamicObject> bizDataBillEntries) {
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>(16);
        if (queryMap == null || queryMap.isEmpty()) {
            return result;
        }
        DynamicObject bizItemGroup = queryMap.getOrDefault("bizitemgroup", null);
        if (bizItemGroup == null) {
            return result;
        }
        ArrayList<Long> bizItemGrpIdList = new ArrayList<Long>(1);
        bizItemGrpIdList.add((Long)bizItemGroup.getPkValue());
        DynamicObject[] itemGroupList = null;
        try {
            itemGroupList = HPDIServiceUtils.getBizItemGroupById(bizItemGrpIdList);
        }
        catch (Exception exception) {
            LOGGER.error(MessageFormat.format("BizDataHelper-getBizItemFormBizItemGroup getBizItemGroupById Exception:", exception));
        }
        if (itemGroupList == null || itemGroupList.length == 0) {
            return result;
        }
        DynamicObject queryBizItemGroup = itemGroupList[0];
        DynamicObjectCollection bizItems = queryBizItemGroup.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)bizItems)) {
            return result;
        }
        Map<Long, DynamicObject> bizItemMap = BizDataHelper.convertBizItemsToMap(bizItems);
        for (int i = 0; i < bizDataBillEntries.size(); ++i) {
            DynamicObject bizDataBillEntry = bizDataBillEntries.get(i);
            DynamicObjectCollection details = bizDataBillEntry.getDynamicObjectCollection("entryentity");
            for (DynamicObject excelBizItem : details) {
                Long itemId;
                DynamicObject bizItem;
                DynamicObject currentBizItem = excelBizItem.getDynamicObject("bizitem");
                if (SWCObjectUtils.isEmpty((Object)currentBizItem) || (bizItem = bizItemMap.get(itemId = Long.valueOf(currentBizItem.getLong("id")))) == null) continue;
                result.put(itemId, bizItem);
            }
        }
        return result;
    }

    private static Map<Long, DynamicObject> convertBizItemsToMap(DynamicObjectCollection bizItems) {
        return bizItems.stream().collect(Collectors.toMap(bu -> bu.getLong("bizitem.id"), bu -> bu, (k1, k2) -> k1));
    }

    public static Map<String, Object> getBizItemGroupMapById(DynamicObject bizItemGroup) {
        ArrayList<Long> bizItemGrpIdList = new ArrayList<Long>(1);
        bizItemGrpIdList.add((Long)bizItemGroup.getPkValue());
        Map<String, Object> bizItemGroupMap = null;
        try {
            bizItemGroupMap = HPDIServiceUtils.getBizItemGroupData(bizItemGrpIdList);
        }
        catch (Exception exception) {
            MessageFormat.format("BizDataHelper-getBizItemFormBizItemGroup getBizItemGroupById Exception:", exception);
        }
        return bizItemGroupMap;
    }

    public static Map<String, Map<String, Object>> getBizDataPeriod(List<DynamicObject> bizDatas) {
        HashMap<String, Map<String, Object>> calPeriodsToBeReturned = new HashMap<String, Map<String, Object>>(16);
        for (DynamicObject bizData : bizDatas) {
            String bizDataCode = bizData.getString("bizdatacode");
            HashMap<String, String> calPeriodToBeReturned = new HashMap<String, String>(7);
            calPeriodToBeReturned.put("periodnumber", bizData.getString("calperiod.number"));
            calPeriodToBeReturned.put("periodname", bizData.getString("calperiod.name"));
            calPeriodsToBeReturned.put(bizDataCode, calPeriodToBeReturned);
        }
        return calPeriodsToBeReturned;
    }

    public static Map<String, Map<String, Object>> getMoneyPeriodFormBizItemGroup(Map<String, Object> queryMap, List<DynamicObject> bizDataEntries) {
        HashMap<String, Map<String, Object>> calPeriodsToBeReturned = new HashMap<String, Map<String, Object>>(16);
        DynamicObjectCollection calPeriods = BizDataHelper.getCalPeriods(queryMap);
        if (CollectionUtils.isEmpty((Collection)calPeriods)) {
            return calPeriodsToBeReturned;
        }
        String billType = (String)queryMap.get("billtype");
        String dataEntityName = bizDataEntries.get(0).getDataEntityType().getName();
        for (DynamicObject bizDataEntry : bizDataEntries) {
            Date effectDate;
            String bizDataCode = bizDataEntry.getString("bizdatacode");
            if (SWCStringUtils.equals((String)dataEntityName, (String)"hpdi_bizdatabillent")) {
                DynamicObjectCollection details = bizDataEntry.getDynamicObjectCollection("entryentity");
                DynamicObject detail = (DynamicObject)details.get(0);
                effectDate = detail.getDate("effectivedate");
            } else {
                effectDate = bizDataEntry.getDate("effectivedate");
            }
            if (effectDate == null) continue;
            effectDate = SWCDateTimeUtils.truncateDate((Date)effectDate);
            if ("2".equals(billType)) {
                Map expiryDateMap = (Map)queryMap.get("BizDataUpdateCODFilter_expirydate");
                effectDate = (Date)expiryDateMap.get(bizDataCode);
            } else if ("3".equals(billType)) {
                Map uedExpiryDateMap = (Map)queryMap.get("UEDDataCODFilter_expirydate");
                effectDate = (Date)uedExpiryDateMap.get(bizDataCode);
            }
            if (effectDate == null) {
                logger.info("BizDataHelper.getMoneyPeriodFormBizItemGroup effectDate is null");
                continue;
            }
            BizDataHelper.getCalPeriodInfo(calPeriods, calPeriodsToBeReturned, effectDate, bizDataCode);
        }
        return calPeriodsToBeReturned;
    }

    public static DynamicObjectCollection getCalPeriods(Map<String, Object> queryMap) {
        if (queryMap == null || queryMap.get("bizitemgroup") == null) {
            return null;
        }
        DynamicObject bizItemGroup = (DynamicObject)queryMap.get("bizitemgroup");
        DynamicObject calPeriodObj = bizItemGroup.getDynamicObject(KEY_CALPERIOD_TYPE);
        if (calPeriodObj == null) {
            return null;
        }
        DynamicObject calPeriodType = HPDIDataServiceHelper.HSBS_CALPERIODTYPE_HELPER.queryOne("entryentity.startdate,entryentity.enddate,entryentity.periodnumber,entryentity.periodname", calPeriodObj.getPkValue());
        if (calPeriodType == null) {
            return null;
        }
        DynamicObjectCollection calPeriods = calPeriodType.getDynamicObjectCollection("entryentity");
        return calPeriods;
    }

    public static void getCalPeriodInfo(DynamicObjectCollection calPeriods, Map<String, Map<String, Object>> calPeriodsToBeReturned, Date effectDate, String bizDataCode) {
        for (DynamicObject calPeriod : calPeriods) {
            Date startDate = calPeriod.getDate("startdate");
            Date endDate = calPeriod.getDate("enddate");
            if (startDate == null || endDate == null) continue;
            startDate = SWCDateTimeUtils.truncateDate((Date)startDate);
            endDate = SWCDateTimeUtils.truncateDate((Date)endDate);
            if (effectDate.before(startDate) || effectDate.after(endDate)) continue;
            HashMap<String, Object> calPeriodToBeReturned = new HashMap<String, Object>(7);
            calPeriodToBeReturned.put("startdate", startDate);
            calPeriodToBeReturned.put("enddate", endDate);
            calPeriodToBeReturned.put("periodnumber", calPeriod.getString("periodnumber"));
            calPeriodToBeReturned.put("periodname", calPeriod.getString("periodname"));
            calPeriodsToBeReturned.put(bizDataCode, calPeriodToBeReturned);
            logger.info(MessageFormat.format("periodStartDate is {0} periodEndDate is {1} periodNumber is {2}", startDate, endDate, calPeriod.getString("periodnumber")));
        }
    }

    public static void rejectBizData(Map<String, Object> map, List<Map<String, Object>> parameterList) {
        if (CollectionUtils.isEmpty(parameterList)) {
            return;
        }
        ArrayList<String> bizDataCodeList = new ArrayList<String>();
        parameterList.stream().forEach(obj -> {
            if (obj.get("bizdatacode") != null) {
                bizDataCodeList.add((String)obj.get("bizdatacode"));
            }
        });
        if (CollectionUtils.isEmpty(bizDataCodeList)) {
            return;
        }
        ArrayList<Long> userIdList = new ArrayList<Long>();
        parameterList.stream().forEach(obj -> {
            if (obj.get("userid") != null) {
                userIdList.add(Long.valueOf((String)obj.get("userid")));
            }
        });
        Map<String, String> userNameMap = BizDataHelper.getUserNameById(userIdList);
        Map<String, Map<String, Object>> parameterListMap = parameterList.stream().collect(Collectors.toMap(param -> (String)param.get("bizdatacode"), param -> param, (k1, k2) -> k2));
        BizDataHelper.rejectDealBizData(bizDataCodeList, parameterListMap, userNameMap);
        BizDataHelper.rejectDealBizDataRecord(bizDataCodeList, parameterListMap, userNameMap);
        map.put("success", Boolean.TRUE);
        map.put("errormsg", "");
    }

    private static void rejectDealBizData(List<String> bizDataCodeList, Map<String, Map<String, Object>> parameterListMap, Map<String, String> userNameMap) {
        DynamicObject[] bizDatas;
        for (DynamicObject bizData : bizDatas = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.query("bizdatacode,bizdatastatus,errormsg", new QFilter[]{new QFilter("bizdatacode", "in", bizDataCodeList)})) {
            String bizDataCode = bizData.getString("bizdatacode");
            Map<String, Object> parameterMap = parameterListMap.get(bizDataCode);
            if (parameterMap == null) continue;
            bizData.set("bizdatastatus", (Object)"6");
            StringBuilder errorSb = new StringBuilder();
            if (parameterMap.get("userid") == null) continue;
            errorSb.append(userNameMap.get(parameterMap.get("userid").toString()));
            errorSb.append(':');
            errorSb.append((String)parameterMap.get("errormsg"));
            bizData.set("errormsg", (Object)new LocaleString(errorSb.toString()));
        }
        HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.update(bizDatas);
    }

    private static void rejectDealBizDataRecord(List<String> bizDataCodeList, Map<String, Map<String, Object>> parameterListMap, Map<String, String> userNameMap) {
        DynamicObject[] bizDataRecords;
        for (DynamicObject bizData : bizDataRecords = HPDIDataServiceHelper.HPDI_BIZDATARECORD_HELPER.query("bizdatacode,bizdatastatus,errormsg", new QFilter[]{new QFilter("bizdatacode", "in", bizDataCodeList)})) {
            String bizDataCode = bizData.getString("bizdatacode");
            Map<String, Object> parameterMap = parameterListMap.get(bizDataCode);
            if (parameterMap == null) continue;
            bizData.set("bizdatastatus", (Object)"6");
            StringBuilder errorSb = new StringBuilder();
            if (parameterMap.get("userid") == null) continue;
            errorSb.append(userNameMap.get(parameterMap.get("userid").toString()));
            errorSb.append(':');
            errorSb.append((String)parameterMap.get("errormsg"));
            bizData.set("errormsg", (Object)new LocaleString(errorSb.toString()));
        }
        HPDIDataServiceHelper.HPDI_BIZDATARECORD_HELPER.update(bizDataRecords);
    }

    public static Map<String, String> getUserNameById(List<Long> userIdList) {
        SWCDataServiceHelper helper = HPDIDataServiceHelper.BOS_USER_HELPER;
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", userIdList)};
        DynamicObject[] lockUser = helper.query("name", filters);
        Map<String, String> userNameMap = new HashMap<String, String>(16);
        if (lockUser != null) {
            userNameMap = Arrays.asList(lockUser).stream().collect(Collectors.toMap(user -> user.getString("id"), user -> user.getString("name"), (k1, k2) -> k2));
        }
        return userNameMap;
    }

    public static DynamicObject getBizDataRuleByVersion(Long ruleId, Long versionId) {
        DynamicObject result = new DynamicObject();
        Map<String, Object> map = HPDIServiceUtils.getBizDataRuleObj(BizDataHelper.initRuleFilter(ruleId, versionId));
        if (!SWCObjectUtils.isEmpty(map) && ((Boolean)map.get("success")).booleanValue() && map.get("data") != null) {
            result = (DynamicObject)map.get("data");
            LOGGER.info(String.valueOf(result.getLong("id")));
        }
        return result;
    }

    public static QFilter initRuleFilter(Long ruleId, Long versionId) {
        if (ruleId == null || ruleId == 0L) {
            QFilter result = new QFilter("default", "=", (Object)Boolean.TRUE).and(new QFilter("iscurrentversion", "=", (Object)"1"));
            return result;
        }
        QFilter result = new QFilter("boid", "=", (Object)ruleId);
        if (versionId != null && versionId != 0L) {
            result.and(new QFilter("id", "=", (Object)versionId));
        }
        return result;
    }

    public static void setRuleVersionCaseSaveBizItemGroup(IFormView formView) {
        DynamicObject bizDataBill = formView.getModel().getDataEntity();
        bizDataBill.set("bizdataruleversion", (Object)BizDataHelper.getRuleVersionByBizItemGroup(formView));
    }

    public static String getRuleVersionByBizItemGroup(IFormView formView) {
        String result = "";
        Long ruleId = 0L;
        Long versionId = 0L;
        DynamicObject bizDataBill = formView.getModel().getDataEntity();
        LOGGER.info("getRuleVersionByBizItemGroup-begin");
        if (bizDataBill != null) {
            LOGGER.info("bizDataBill-is-not-null");
            DynamicObject bizItemGroup = bizDataBill.getDynamicObject("bizitemgroup");
            if (bizItemGroup != null) {
                String ruleNumber = bizItemGroup.getString("bizdataobjrule.number");
                LOGGER.info(MessageFormat.format("rulenumber is {0}", ruleNumber));
                if (ruleNumber != null && !"".equals(ruleNumber)) {
                    DynamicObject ruleObj = HPDIDataServiceHelper.HSBS_BIZDATAOBJRULE_HELPER.queryOne("sourcevid,boid", new QFilter[]{new QFilter("number", "=", (Object)ruleNumber).and(new QFilter("iscurrentversion", "=", (Object)"1"))});
                    LOGGER.info("ruleObj-is-not-null");
                    if (ruleObj != null) {
                        versionId = ruleObj.getLong("sourcevid");
                        LOGGER.info(MessageFormat.format("versionId is {0}", versionId));
                        ruleId = ruleObj.getLong("boid");
                        LOGGER.info(MessageFormat.format("ruleId is {0}", ruleId));
                    }
                }
            }
        }
        StringBuilder ruleVersion = new StringBuilder();
        ruleVersion.append(ruleId);
        ruleVersion.append('-');
        ruleVersion.append(versionId);
        result = ruleVersion.toString();
        return result;
    }

    public static void refreshRelationData(DynamicObject billObj) {
        DynamicObject[] billEnts = HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER.query(BizDataHelper.getSelectBillEntProperties(), new QFilter[]{new QFilter("bizdatabillid", "=", billObj.getPkValue()), new QFilter("entryentity.bizitem.cycle", "=", (Object)"1")});
        DynamicObjectCollection entCollection = new DynamicObjectCollection();
        entCollection.addAll(Arrays.asList(billEnts));
        List entCollectionSplit = Lists.partition((List)entCollection, (int)500);
        for (List entCollectionTmp : entCollectionSplit) {
            DynamicObjectCollection entCollectionBatch = new DynamicObjectCollection();
            entCollectionBatch.addAll((Collection)entCollectionTmp);
            BizDataHelper.refreshRelationDataCore(billObj, entCollectionBatch);
        }
        String clearSQL = "delete from t_hpdi_bizdatarelation r where not exists(select 1 from t_hpdi_bizdatabillent e where e.fbizdatacode = r.fbizdatacode) and r.fbillno ='" + billObj.getString("billno") + "'";
        SWCDbUtil.execute((DBRoute)new DBRoute("hpdi"), (String)clearSQL, null);
    }

    public static void refreshRelationDataPart(DynamicObject billObj, List<Long> entryIds) {
        DynamicObject[] billEnts = HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER.query(BizDataHelper.getSelectBillEntProperties(), new QFilter[]{new QFilter("id", "in", entryIds), new QFilter("entryentity.bizitem.cycle", "=", (Object)"1")});
        DynamicObjectCollection entCollection = new DynamicObjectCollection();
        entCollection.addAll(Arrays.asList(billEnts));
        BizDataHelper.refreshRelationDataCore(billObj, entCollection);
    }

    private static void refreshRelationDataCore(DynamicObject billObj, DynamicObjectCollection entryEntitys) {
        if (CollectionUtils.isEmpty((Collection)entryEntitys)) {
            return;
        }
        Map<String, Object> queryMap = BizDataBillEntryHelper.getQueryMap(billObj);
        ArrayList<DynamicObject> bizDataBillEntries = new ArrayList<DynamicObject>(entryEntitys.size());
        for (DynamicObject obj : entryEntitys) {
            obj.set("relationdata", (Object)"B");
            bizDataBillEntries.add(obj);
        }
        BizDataFilterChain filterChain = new BizDataFilterChain();
        filterChain.addFilter(new BizItemConflictFilter());
        filterChain.doFilter(queryMap, bizDataBillEntries, filterChain, new HashMap<String, Map<String, Object>>());
        HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER.save(entryEntitys);
    }

    public static boolean isUpdateExpiryDate(IDataModel bizDataBillModel) {
        try {
            String billType = bizDataBillModel.getDataEntity().getString("billtype");
            logger.info(MessageFormat.format("BizDataHelper-isUpdateExpiryDate billType is:{0}, {1}", billType, bizDataBillModel.getDataEntity()));
            if (SWCStringUtils.equals((String)billType, (String)"2")) {
                return true;
            }
        }
        catch (Throwable throwable) {
            logger.error(MessageFormat.format("BizDataHelper-isUpdateExpiryDate exception. throwable:{0}", throwable));
        }
        return false;
    }

    public static Map<String, Object> getSalaryPeriod(List<Map<String, Object>> bizDataCodeList) {
        Map<String, Object> queryUsagePeriodMap;
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)1);
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)2);
        paramMap.put("opsystem", "hpdi");
        paramMap.put("data", bizDataCodeList);
        try {
            queryUsagePeriodMap = HPDIServiceUtils.queryUsagePeriod(paramMap);
        }
        catch (Throwable throwable) {
            LOGGER.error("BizDataHelper-getSalaryPeriod:queryUsagePeriod exception");
            throw new KDBizException(throwable, new ErrorCode("", throwable.getMessage()), new Object[0]);
        }
        if (MapUtils.isNotEmpty(queryUsagePeriodMap) && ((Boolean)queryUsagePeriodMap.get("success")).booleanValue()) {
            Object[] periods;
            List result = (List)queryUsagePeriodMap.get("result");
            ArrayList notFoundResult = new ArrayList(1);
            result = result.stream().filter(map -> {
                Object usagePeriod = map.get("usageperiod");
                if (usagePeriod instanceof Integer && (Integer)usagePeriod == -1) {
                    notFoundResult.add(map.get("bizdatacode"));
                    return false;
                }
                return true;
            }).collect(Collectors.toList());
            if (!SWCListUtils.isEmpty(notFoundResult)) {
                LOGGER.info("BizDataHelper-getSalaryPeriod,notFoundUsagePeriod:{0}", (Object)JSON.toJSONString(notFoundResult));
            }
            if (SWCListUtils.isEmpty(result)) {
                LOGGER.info("BizDataHelper-getSalaryPeriod:queryUsagePeriodResult is empty");
                return resultMap;
            }
            HashMap periodAndCodeMap = new HashMap(16);
            for (Map map2 : result) {
                Object period2 = map2.get("usageperiod");
                if (period2 == null) continue;
                periodAndCodeMap.put(map2.get("bizdatacode"), period2);
            }
            List<Long> usagePeriodIds = result.stream().filter(item -> item.get("usageperiod") != null).map(map -> (Long)map.get("usageperiod")).collect(Collectors.toList());
            if (SWCListUtils.isEmpty(usagePeriodIds)) {
                LOGGER.info("BizDataHelper-getSalaryPeriod:usagePeriodIds is empty");
                return resultMap;
            }
            LOGGER.info(MessageFormat.format("BizDataHelper-getSalaryPeriod:usagePeriodIds={0}", usagePeriodIds.toString()));
            try {
                periods = HPDIServiceUtils.queryPeriodData(usagePeriodIds);
            }
            catch (Throwable throwable) {
                LOGGER.error(MessageFormat.format("BizDataHelper-getSalaryPeriod:queryPeriodData exception:{0}", throwable));
                throw new KDBizException(throwable, new ErrorCode("", throwable.getMessage()), new Object[0]);
            }
            if (SWCArrayUtils.isEmpty((Object[])periods)) {
                LOGGER.info("BizDataHelper-getSalaryPeriod:queryPeriodData is empty");
            } else {
                ArrayList idList = new ArrayList(periods.length);
                Arrays.stream(periods).forEach(item -> idList.add(item.getLong("id")));
                LOGGER.info(MessageFormat.format("BizDataHelper-getSalaryPeriod:queryPeriodData ids is {0}", idList));
            }
            Map periodMap = Arrays.stream(periods).collect(Collectors.toMap(period -> period.getLong("id"), Function.identity(), (oldValue, newValue) -> oldValue));
            HashMap<String, DynamicObject> bizDataCodePeriodMap = new HashMap<String, DynamicObject>(16);
            for (Map.Entry periodAndCode : periodAndCodeMap.entrySet()) {
                Long usageperiod = (Long)periodAndCode.getValue();
                DynamicObject period3 = (DynamicObject)periodMap.get(usageperiod);
                if (period3 == null) continue;
                bizDataCodePeriodMap.put(String.valueOf(periodAndCode.getKey()), period3);
            }
            resultMap.put("periodResult", bizDataCodePeriodMap);
        }
        return resultMap;
    }

    public static Map<String, DynamicObject> getRelationData(List<DynamicObject> bizDataList) {
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>(16);
        Object[] relationBizDataDB = BizDataHelper.getRelationDataFromDB(bizDataList);
        if (SWCArrayUtils.isEmpty((Object[])relationBizDataDB)) {
            return result;
        }
        Map<String, DynamicObject> relationDataMap = Stream.of(relationBizDataDB).collect(Collectors.toMap(rd -> rd.getLong("bizitem.id") + "_" + rd.getLong("empposorgrel.id"), rd -> rd, (oldValue, newValue) -> oldValue));
        return relationDataMap;
    }

    private static DynamicObject[] getRelationDataFromDB(List<DynamicObject> bizDataList) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        qFilters.add(new QFilter("bizdatastatus", "=", (Object)"3"));
        qFilters.add(new QFilter("billtype", "=", (Object)"1"));
        qFilters.add(new QFilter("bizitem.cycle", "=", (Object)"1"));
        ArrayList<Long> empPosOrgRelIds = new ArrayList<Long>(bizDataList.size());
        ArrayList<Long> itemIds = new ArrayList<Long>(bizDataList.size());
        HashSet<String> bizDataCodes = new HashSet<String>(bizDataList.size());
        for (DynamicObject bizData : bizDataList) {
            empPosOrgRelIds.add(bizData.getLong("empposorgrel.id"));
            itemIds.add(bizData.getLong("bizitem.id"));
            bizDataCodes.add(bizData.getString("bizdatacode"));
        }
        if (!SWCListUtils.isEmpty(empPosOrgRelIds)) {
            qFilters.add(new QFilter("empposorgrel", "in", empPosOrgRelIds));
        }
        if (!SWCListUtils.isEmpty(itemIds)) {
            qFilters.add(new QFilter("bizitem", "in", itemIds));
        }
        DynamicObject[] bizDataArray = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.query("empposorgrel,bizitem,bizdatacode,effectivedate,expirydate,bizdatastatus,relationrecord,calperiod,salaryfile,payrollgrp", qFilters.toArray(new QFilter[qFilters.size()]), "effectivedate desc");
        List<DynamicObject> filterList = Arrays.stream(bizDataArray).filter(dy -> !bizDataCodes.contains(dy.getString("bizdatacode"))).collect(Collectors.toList());
        return filterList.toArray(new DynamicObject[0]);
    }

    public static boolean isRelationShip(DynamicObject bizData, DynamicObject relationData) {
        boolean result = false;
        Date excelEffectDate = bizData.getDate("effectivedate");
        Date transSalaryDate = relationData.getDate("effectivedate");
        Date transSalaryExpiryDate = relationData.getDate("expirydate");
        if (excelEffectDate != null && transSalaryDate != null && excelEffectDate.after(transSalaryDate) && (transSalaryExpiryDate == null || transSalaryExpiryDate != null && excelEffectDate.before(transSalaryExpiryDate))) {
            result = true;
        }
        return result;
    }

    public static List<Long> findRelationIds(Long selectId) {
        ArrayList<Long> result = new ArrayList<Long>(10);
        SWCDataServiceHelper bizDataHelper = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER;
        DynamicObject bizData = bizDataHelper.queryOne("billtype,effectivedate,empposorgrel,bizitem", (Object)selectId);
        if (bizData == null) {
            return result;
        }
        String billType = bizData.getString("billtype");
        if ("1".equals(billType)) {
            DynamicObject[] objs;
            QFilter sameGrelFilter = new QFilter("empposorgrel", "=", (Object)bizData.getLong("empposorgrel.id"));
            QFilter sameItemFilter = new QFilter("bizitem", "=", (Object)bizData.getLong("bizitem.id"));
            QFilter trasalryFilter = new QFilter("bizdatastatus", "=", (Object)"1").or("bizdatastatus", "=", (Object)"4");
            QFilter dateFilter = new QFilter("effectivedate", "<", (Object)bizData.getDate("effectivedate"));
            for (DynamicObject obj : objs = bizDataHelper.query(new QFilter[]{sameGrelFilter, sameItemFilter, trasalryFilter, dateFilter})) {
                result.add(obj.getLong("id"));
            }
        }
        return result;
    }

    public static Map<Long, Long> batchFindRelationIds(List<Long> selectIds) {
        QFilter idFilter;
        HashMap<Long, Long> result = new HashMap<Long, Long>(16);
        QFilter filter = new QFilter("id", "in", selectIds);
        Object[] bizDataArr = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.query("billtype,effectivedate,empposorgrel.id,bizitem.id", new QFilter[]{filter});
        if (SWCArrayUtils.isEmpty((Object[])bizDataArr)) {
            return result;
        }
        ArrayList<Object> bizDataListOfAddType = new ArrayList<Object>(bizDataArr.length);
        HashSet<Long> empposorgrelIds = new HashSet<Long>(16);
        HashSet<Long> bizItemIds = new HashSet<Long>(16);
        ArrayList<Long> bizDataIds = new ArrayList<Long>(bizDataArr.length);
        for (Object bizData3 : bizDataArr) {
            if (!"1".equals(bizData3.getString("billtype"))) continue;
            bizDataListOfAddType.add(bizData3);
            empposorgrelIds.add(bizData3.getLong("empposorgrel.id"));
            bizItemIds.add(bizData3.getLong("bizitem.id"));
            bizDataIds.add(bizData3.getLong("id"));
        }
        if (CollectionUtils.isEmpty(bizDataListOfAddType)) {
            return result;
        }
        QFilter empFilter = new QFilter("empposorgrel", "in", empposorgrelIds);
        QFilter itemFilter = new QFilter("bizitem", "in", bizItemIds);
        QFilter statusFilter = new QFilter("bizdatastatus", "in", (Object)new String[]{BizDataStatusEnum.TO_BE_PUSH_SALARY.getCode(), BizDataStatusEnum.PUSHED_SALARY_FAIL.getCode(), BizDataStatusEnum.WITHDRAWN.getCode()});
        Object[] relatedBizDataArr = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.query("id,effectivedate,empposorgrel.id,bizitem.id", new QFilter[]{empFilter, itemFilter, statusFilter, idFilter = new QFilter("id", "not in", bizDataIds)});
        if (SWCArrayUtils.isEmpty((Object[])relatedBizDataArr)) {
            return result;
        }
        Map<String, List<DynamicObject>> groupMap = Arrays.stream(relatedBizDataArr).sorted((bizData1, bizData2) -> BizDataHelper.sortBizDataByEffectiveDate(bizData1, bizData2)).collect(Collectors.groupingBy(bizData -> BizDataHelper.getRelatedKey(bizData)));
        for (DynamicObject dynamicObject : bizDataListOfAddType) {
            List<DynamicObject> subList = groupMap.get(BizDataHelper.getRelatedKey(dynamicObject));
            if (CollectionUtils.isEmpty(subList)) continue;
            Long bizDataId = dynamicObject.getLong("id");
            for (DynamicObject relareDy : subList) {
                if (1 == BizDataHelper.sortBizDataByEffectiveDate(relareDy, dynamicObject)) break;
                result.put(relareDy.getLong("id"), bizDataId);
            }
        }
        return result;
    }

    private static String getRelatedKey(DynamicObject bizData) {
        return bizData.getString("empposorgrel.id") + "_" + bizData.getString("bizitem.id");
    }

    private static int sortBizDataByEffectiveDate(DynamicObject bizData1, DynamicObject bizData2) {
        Date effectiveDate1 = bizData1.getDate("effectivedate");
        Date effectiveDate2 = bizData2.getDate("effectivedate");
        if (null == effectiveDate1) {
            return 1;
        }
        if (null == effectiveDate2) {
            return -1;
        }
        return effectiveDate1.compareTo(effectiveDate2);
    }

    public static Map<Long, List<DynamicObject>> getSubmittedDataMap(List<Long> filterItemList, DynamicObject calPeriod, Long empPosorgRelId) {
        DynamicObjectCollection bizDataColl = BizDataHelper.getBizData(filterItemList, calPeriod, empPosorgRelId);
        HashMap<Long, List<DynamicObject>> itemAndBizDataMap = new HashMap<Long, List<DynamicObject>>(16);
        for (DynamicObject bizDataObj : bizDataColl) {
            Boolean cycle = bizDataObj.getBoolean("bizitem.cycle");
            Long bizItemId = bizDataObj.getLong("bizitem.id");
            if (cycle.booleanValue()) continue;
            List bizDataList = itemAndBizDataMap.getOrDefault(bizItemId, new ArrayList());
            bizDataList.add(bizDataObj);
            itemAndBizDataMap.put(bizItemId, bizDataList);
        }
        return itemAndBizDataMap;
    }

    public static void getUnSubmittedDataMap(List<Long> filterItemList, DynamicObject calPeriod, Long empPosorgRelId, Map<Long, List<DynamicObject>> itemAndBizDataMap, Long currentDataEntityId, IFormView formView) {
        String deleteEntryIdsStr;
        Map<String, List<DynamicObject>> billMap = BizDataHelper.getUnSubmitBizData(filterItemList, calPeriod, empPosorgRelId, currentDataEntityId);
        List bizDataList = null;
        boolean isAddEntryShowForm = HPDI_BIZDATABILL_NEWENTRY.equals(formView.getFormShowParameter().getFormId());
        HashSet<Long> deleteEntryIds = new HashSet<Long>(10);
        if (!isAddEntryShowForm && null != (deleteEntryIdsStr = formView.getPageCache().get(KEY_DELETEENTRYIDS))) {
            String[] deleteEntryIdStrArray;
            for (String entryId : deleteEntryIdStrArray = deleteEntryIdsStr.split(",")) {
                deleteEntryIds.add(Long.valueOf(entryId));
            }
        }
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "hpdi_bizdatabill_entry_changed_%s", currentDataEntityId));
        Set changedEntryIds = (Set)appCache.get("changed_entry_id_collection", HashSet.class);
        for (Map.Entry<String, List<DynamicObject>> entry : billMap.entrySet()) {
            for (DynamicObject dy : entry.getValue()) {
                Boolean cycle = dy.getBoolean("entryentity.bizitem.cycle");
                Long bizItemId = dy.getLong("entryentity.bizitem.id");
                if (cycle.booleanValue()) continue;
                DynamicObject obj = dy;
                boolean isCurrentBillEntry = currentDataEntityId.equals(dy.getLong("bizdatabillid"));
                if (!isAddEntryShowForm && isCurrentBillEntry) {
                    boolean isChangedRow;
                    if (deleteEntryIds.contains(dy.getLong("id"))) continue;
                    boolean bl = isChangedRow = org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)changedEntryIds) && changedEntryIds.contains(dy.getLong("id"));
                    if (isChangedRow) {
                        obj = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)((String)appCache.get(String.valueOf(dy.getLong("id")), String.class)));
                        bizItemId = obj.getLong("bizitem.id");
                    }
                }
                bizDataList = itemAndBizDataMap.getOrDefault(bizItemId, new ArrayList());
                bizDataList.add(obj);
                itemAndBizDataMap.put(bizItemId, bizDataList);
            }
        }
    }

    public static DynamicObjectCollection getBizData(List<Long> filterItemList, DynamicObject calPeriod, Long empPosorgRelId) {
        ArrayList<Long> empPosorgRelIds = new ArrayList<Long>(1);
        empPosorgRelIds.add(empPosorgRelId);
        return BizDataHelper.getBizData(filterItemList, calPeriod, empPosorgRelIds);
    }

    public static DynamicObjectCollection getBizData(List<Long> filterItemList, DynamicObject calPeriod, Collection<Long> empPosorgRelIds) {
        QFilter filter = new QFilter("bizitem", "in", filterItemList);
        filter.and("empposorgrel", "in", empPosorgRelIds);
        filter.and("bizdatastatus", "not in", (Object)new String[]{"5", "6", "8"});
        filter.and("bizitem.cycle", "=", (Object)Character.valueOf('0'));
        if (!SWCObjectUtils.isEmpty((Object)calPeriod)) {
            filter.and("calperiod", "=", (Object)calPeriod.getLong("id"));
        }
        SWCDataServiceHelper helper = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER;
        return helper.queryOriginalCollection("id, bizitem, bizitem.cycle, bizitem.id, empposorgrel.id, calperiod.id, bizdatacode, effectivedate, applyno, empposorgrel.person.name", new QFilter[]{filter}, "effectivedate desc");
    }

    public static DynamicObjectCollection getBizData(QFilter filter) {
        SWCDataServiceHelper helper = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER;
        String selectFileds = "id, bizitem, bizitem.cycle, bizitem.id, empposorgrel.id, calperiod.id, bizdatacode, effectivedate";
        return helper.queryOriginalCollection(selectFileds, new QFilter[]{filter}, "effectivedate desc");
    }

    public static Map<String, List<DynamicObject>> getUnSubmitBizData(List<Long> filterItemList, DynamicObject calPeriod, Long empPosorgRelId, Long currentDataEntityId) {
        QFilter entFilter = new QFilter("empposorgrel", "=", (Object)empPosorgRelId);
        entFilter.and("entryentity.bizitem", "in", filterItemList);
        entFilter.and("entryentity.bizitem.cycle", "=", (Object)Character.valueOf('0'));
        SWCDataServiceHelper entHelper = HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER;
        DynamicObjectCollection entCollection = entHelper.queryOriginalCollection("id, bizdatabillid, bizdatacode, entryentity.bizitem, entryentity.bizitem.cycle, entryentity.bizitem.id, entryentity.effectivedate", entFilter.toArray());
        Map<Long, List<DynamicObject>> entMap = entCollection.stream().collect(Collectors.groupingBy(ent -> ent.getLong("bizdatabillid")));
        QFilter filter = new QFilter("id", "in", entMap.keySet());
        filter.and("billstatus", "not in", (Object)new String[]{"C", "E", "F"});
        if (!SWCObjectUtils.isEmpty((Object)calPeriod)) {
            filter.and("calperiod", "=", (Object)calPeriod.getLong("id"));
        }
        SWCDataServiceHelper helper = HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER;
        DynamicObjectCollection billCollection = helper.queryOriginalCollection("billno, id", new QFilter[]{filter});
        HashMap<String, List<DynamicObject>> map = new HashMap<String, List<DynamicObject>>(entMap.size());
        billCollection.forEach(bill -> map.put(bill.getString("billno"), (List<DynamicObject>)entMap.get(bill.getLong("id"))));
        return map;
    }

    public static Table<Long, Long, List<DynamicObject>> getCurrentDataEntityItemMap(DynamicObjectCollection entryEntities) {
        ArrayList<DynamicObject> bizItemList = null;
        HashBasedTable table = HashBasedTable.create();
        for (DynamicObject obj : entryEntities) {
            Long bizItemId = obj.getLong("bizitem.id");
            Long empPosorgRelId = obj.getDynamicObject("empposorgrel").getLong("id");
            if (SWCObjectUtils.isEmpty((Object)bizItemId) || bizItemId == 0L) continue;
            bizItemList = (ArrayList<DynamicObject>)table.get((Object)empPosorgRelId, (Object)bizItemId);
            if (bizItemList == null) {
                bizItemList = new ArrayList<DynamicObject>();
            }
            bizItemList.add(obj);
            table.put((Object)empPosorgRelId, (Object)bizItemId, bizItemList);
        }
        return table;
    }

    public static List<Long> getNeedRemoveItemIdList(DynamicObjectCollection bizItemColl, Map<Long, Integer> bizDataMaxInputTimeMap, Map<Long, List<DynamicObject>> itemAndBizDataMap, Table<Long, Long, List<DynamicObject>> currentDataEntityItemTable, Long empPosorgRelId) {
        ArrayList<Long> needRemoveItemIdList = new ArrayList<Long>(10);
        for (DynamicObject bizItemEntry : bizItemColl) {
            Long bizItemId = bizItemEntry.getLong("bizitem.id");
            int maxInputTime = bizDataMaxInputTimeMap.get(bizItemId);
            List bizData = itemAndBizDataMap.getOrDefault(bizItemId, new ArrayList());
            List currentList = (List)currentDataEntityItemTable.get((Object)empPosorgRelId, (Object)bizItemId);
            if (!SWCObjectUtils.isEmpty((Object)currentList)) {
                bizData.addAll(currentList);
            }
            if (bizData.size() == 0 || bizData.size() < maxInputTime) continue;
            needRemoveItemIdList.add(bizItemId);
        }
        return needRemoveItemIdList;
    }

    public static boolean isSuccessFromApi(Map<String, Object> resp) {
        List resultDelList;
        boolean result = false;
        if (resp != null && "true".equals(resp.get("success").toString()) && !CollectionUtils.isEmpty((Collection)(resultDelList = (List)resp.get("result"))) && SWCStringUtils.equals((String)((String)((Map)resultDelList.get(0)).get("status")), (String)"1")) {
            result = true;
        }
        return result;
    }

    public static void addFieldKeys(List<String> fieldKeys) {
        fieldKeys.add("billstatus");
        fieldKeys.add("billno");
        fieldKeys.add("adminorg");
        fieldKeys.add("auditdate");
        fieldKeys.add("bizitemgroup");
        fieldKeys.add("datastatus");
        fieldKeys.add("bizdatafailcount");
        fieldKeys.add("billtype");
        fieldKeys.add("handletype");
        fieldKeys.add("calperiod");
        fieldKeys.add("bizdatacount");
        fieldKeys.add("transsalarystatus");
        fieldKeys.add("ischange");
        fieldKeys.add("mulbizitem");
        fieldKeys.add("bizitemgroup.createorg");
        fieldKeys.add("entryentity.bizitem");
        fieldKeys.add("entryentity.empposorgrel");
        fieldKeys.add("entryentity.bizdate");
        fieldKeys.add("entryentity.payrollgrp");
        fieldKeys.add("entryentity.salaryfile");
        fieldKeys.add("entryentity.effectivedate");
        fieldKeys.add("entryentity.expirydate");
        fieldKeys.add("entryentity.currency");
        fieldKeys.add("entryentity.value");
        fieldKeys.add("entryentity.remark");
        fieldKeys.add("entryentity.dataapprovestatus");
        fieldKeys.add("entryentity.approvedesc");
        fieldKeys.add("entryentity.bizdatastatus");
        fieldKeys.add("entryentity.errormsg");
        fieldKeys.add("entryentity.submiterror");
        fieldKeys.add("entryentity.bizdatacode");
        fieldKeys.add("entryentity.relationdata");
        fieldKeys.add("entryentity.updateexpirydate");
        fieldKeys.add("entryentity.updateddesc");
        fieldKeys.add("entryentity.originalbizdatacode");
        fieldKeys.add("entryentity.calfrequency");
        fieldKeys.add("entryentity.enttranssalarystatus");
        AfterAddFieldContainerEvent event = new AfterAddFieldContainerEvent();
        Map<String, String> extRelationMap = BizDataHelper.invokeAfterAddFieldContainer(event);
        if (extRelationMap != null) {
            for (String prop : extRelationMap.keySet()) {
                fieldKeys.add("entryentity." + prop);
            }
        }
    }

    private static Map<String, String> invokeAfterAddFieldContainer(AfterAddFieldContainerEvent args) {
        BizDataBillEntryExtService ExtService = new BizDataBillEntryExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)ExtService, IBizDataBillEntryExtService.class, (String)"kd.sdk.swc.hpdi.business.extpoint.bizdatabill.IBizDataBillEntryExtService#afterAddFieldContainer", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.afterAddFieldContainer(args);
            return null;
        });
        return args.getFieldRelationMap();
    }

    public static void refreshEntryEntity(IDataModel dataModel) {
        Map<String, Integer> countMap = BizDataHelper.refreshBillDataCount(dataModel.getDataEntity().getLong("id"));
        dataModel.setValue("personcount", (Object)countMap.get("personcount"));
        dataModel.setValue("bizitemcount", (Object)countMap.get("bizitemcount"));
        dataModel.setValue("bizdatacount", (Object)countMap.get("bizdatacount"));
    }

    public static Map<String, Integer> refreshBillDataCount(Long bizDataBillId) {
        Map<String, Integer> countMap = BizDataHelper.getBillDataCount(bizDataBillId);
        BizDataHelper.updateOverviewData(bizDataBillId, countMap);
        return countMap;
    }

    public static Map<String, Integer> getBillDataCount(Long bizDataBillId) {
        QFilter qFilter = new QFilter("bizdatabillid", "=", (Object)bizDataBillId);
        int entryNum = HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER.count("hpdi_bizdatabillent", new QFilter[]{qFilter});
        int empposNum = HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER.count("hpdi_bizdatabillent", "empposorgrel", new QFilter[]{qFilter}, (Distinctable)WithDistinctable.get());
        int itemNum = HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER.count("hpdi_bizdatabillent", "entryentity.bizitem", new QFilter[]{qFilter}, (Distinctable)WithDistinctable.get());
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(5);
        countMap.put("bizdatacount", entryNum);
        countMap.put("personcount", empposNum);
        countMap.put("bizitemcount", itemNum);
        return countMap;
    }

    private static void updateOverviewData(Long bizdatabillid, Map<String, Integer> countMap) {
        DynamicObject obj = HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER.queryOne("bizdatacount,bizitemcount,personcount", new QFilter[]{new QFilter("id", "=", (Object)bizdatabillid)});
        if (!SWCObjectUtils.isEmpty((Object)obj)) {
            obj.set("personcount", (Object)countMap.get("personcount"));
            obj.set("bizitemcount", (Object)countMap.get("bizitemcount"));
            obj.set("bizdatacount", (Object)countMap.get("bizdatacount"));
            HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.updateOne(obj);
        }
    }

    private static Set<String> getBillEntDetailSet() {
        HashSet<String> detailFields = new HashSet<String>();
        detailFields.add("bizitem");
        detailFields.add("value");
        detailFields.add("effectivedate");
        detailFields.add("expirydate");
        return detailFields;
    }

    public static String getCountDownByTime(Date endTime, Date nowDate) {
        StringBuilder result = new StringBuilder();
        if (!SWCObjectUtils.isEmpty((Object)endTime)) {
            Map<String, Long> countDownMap = BizDataHelper.getCountDownMap((endTime.getTime() - nowDate.getTime()) / 1000L);
            result.append(ResManager.loadKDString((String)"{0}\u5929{1}\u5c0f\u65f6{2}\u5206{3}\u79d2", (String)"BizDataBillEdit_10", (String)"swc-hpdi-business", (Object[])new Object[]{countDownMap.get("day"), countDownMap.get("hour"), countDownMap.get("minute"), countDownMap.get("second")}));
        }
        return result.toString();
    }

    private static Map<String, Long> getCountDownMap(long totalSeconds) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)4);
        long second = 0L;
        long minute = 0L;
        long hour = 0L;
        long day = 0L;
        if (totalSeconds > 0L && (second = totalSeconds) > 60L) {
            minute = second / 60L;
            second %= 60L;
            if (minute > 60L) {
                hour = minute / 60L;
                minute %= 60L;
                if (hour > 24L) {
                    day = hour / 24L;
                    hour %= 24L;
                }
            }
        }
        result.put("second", second);
        result.put("minute", minute);
        result.put("hour", hour);
        result.put("day", day);
        return result;
    }

    public static boolean isContainLoopItem(long id) {
        DynamicObject bizItemGroupInfo = BizDataHelper.getBizItemGroupDetail(id);
        if (bizItemGroupInfo == null || bizItemGroupInfo.getLong("id") == 0L) {
            logger.info("BizDataBillEdit.isContainLoopItem:query hsbs_bizitemgroup is empty");
            return false;
        }
        DynamicObjectCollection bizItems = bizItemGroupInfo.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)bizItems)) {
            return false;
        }
        boolean isMatch = bizItems.stream().anyMatch(item -> {
            String status = item.getString("bizitem.status");
            String enable = item.getString("bizitem.enable");
            String cycle = item.getString("bizitem.cycle");
            return SWCStringUtils.equals((String)status, (String)"C") && SWCStringUtils.equals((String)enable, (String)"1") && SWCStringUtils.equals((String)cycle, (String)"1");
        });
        return isMatch;
    }

    private static DynamicObject getBizItemGroupDetail(long bizItemGroupId) {
        if (bizItemGroupId == 0L) {
            return null;
        }
        ArrayList<Long> bizItemGrpIdList = new ArrayList<Long>(1);
        bizItemGrpIdList.add(bizItemGroupId);
        DynamicObject[] itemGroupList = null;
        try {
            itemGroupList = HPDIServiceUtils.getBizItemGroupById(bizItemGrpIdList);
        }
        catch (Exception exception) {
            logger.error("BizDataBillEdit getBizItemGroupById Exception:{0}", (Throwable)exception);
        }
        if (itemGroupList == null || itemGroupList.length < 1) {
            return null;
        }
        return itemGroupList[0];
    }

    public static Map<String, Object> getUnSubmitBizData(List<Long> filterItemList, DynamicObject calPeriod, Collection<Long> empPosorgRelIds, Collection<String> bizDataCodes) {
        QFilter entFilter = new QFilter("empposorgrel", "in", empPosorgRelIds);
        entFilter.and("entryentity.bizitem", "in", filterItemList);
        entFilter.and("entryentity.bizitem.cycle", "=", (Object)Character.valueOf('0'));
        SWCDataServiceHelper entHelper = HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER;
        DynamicObjectCollection entCollection = entHelper.queryOriginalCollection("id, bizdatabillid, bizdatacode, empposorgrel.id, empposorgrel.person.name, entryentity.bizitem, entryentity.bizitem.cycle, entryentity.bizitem.id, entryentity.effectivedate", entFilter.toArray());
        List filterEntCol = entCollection.stream().filter(ent -> !bizDataCodes.contains(ent.getString("bizdatacode"))).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> entMap = filterEntCol.stream().collect(Collectors.groupingBy(ent -> ent.getLong("bizdatabillid")));
        QFilter filter = new QFilter("id", "in", entMap.keySet());
        filter.and("billstatus", "not in", (Object)new String[]{"C", "E", "F"});
        if (!SWCObjectUtils.isEmpty((Object)calPeriod)) {
            filter.and("calperiod", "=", (Object)calPeriod.getLong("id"));
        }
        SWCDataServiceHelper helper = HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER;
        DynamicObjectCollection billCollection = helper.queryOriginalCollection("billno, id", new QFilter[]{filter});
        Map<Long, DynamicObject> billNoMap = billCollection.stream().collect(Collectors.toMap(bill -> bill.getLong("id"), bill -> bill, (k1, k2) -> k1));
        ArrayList bizDataColl = new ArrayList(10);
        for (Map.Entry<Long, List<DynamicObject>> entry : entMap.entrySet()) {
            if (!billNoMap.containsKey(entry.getKey())) continue;
            bizDataColl.addAll(entry.getValue());
        }
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("billNoMap", billNoMap);
        result.put("bizDataColl", bizDataColl);
        return result;
    }

    public static Map<String, Map<String, Object>> getBizDataCodeResultMap(Map<String, Object> resp) {
        List resultDelList;
        Map<String, Map> bizDataCodeResultMap = null;
        if (MapUtils.isNotEmpty(resp) && "true".equals(resp.get("success").toString()) && !CollectionUtils.isEmpty((Collection)(resultDelList = (List)resp.get("result")))) {
            bizDataCodeResultMap = resultDelList.stream().collect(Collectors.toMap(map -> (String)map.get("bizdatacode"), map -> map, (k1, k2) -> k1));
        }
        return bizDataCodeResultMap;
    }

    public static QFilter getOrgFilterBizOrgPerm() {
        HasPermOrgResult permOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"0NXW1VOPH+QV", (String)"hpdi_bizdatabill", (String)"47150e89000000ac");
        if (permOrgResult.hasAllOrgPerm()) {
            return null;
        }
        List allOrgList = permOrgResult.getHasPermOrgs();
        QFilter orgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_bizitemgroup", (List)allOrgList, (boolean)true);
        return orgFilter;
    }

    public static QFilter assembleOrgFilterByBizOrgPerm() {
        QFilter filter = BizDataHelper.getOrgFilterBizOrgPerm();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitemgroup");
        Object[] dys = helper.query("id", new QFilter[]{filter});
        if (SWCArrayUtils.isEmpty((Object[])dys)) {
            return new QFilter("1", "!=", (Object)1);
        }
        List bizItemGroupIds = Arrays.stream(dys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        return new QFilter("bizitemgroup", "in", bizItemGroupIds);
    }

    public static boolean hasOrgPermission(Long orgId) {
        HasPermOrgResult permOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"0NXW1VOPH+QV", (String)"hpdi_bizdatabill", (String)"47150e89000000ac");
        if (permOrgResult.hasAllOrgPerm()) {
            return true;
        }
        List orgIDList = permOrgResult.getHasPermOrgs();
        return null != orgIDList && orgIDList.contains(orgId);
    }

    public static DynamicObject queryDefaultBizDataObjRule() {
        SWCDataServiceHelper bdroHelper = HPDIDataServiceHelper.HSBS_BIZDATAOBJRULE_HELPER;
        QFilter filter = new QFilter("default", "=", (Object)"1");
        filter.and("enable", "=", (Object)"1");
        filter.and("iscurrentversion", "=", (Object)"1");
        DynamicObject bizDataRuleObj = bdroHelper.queryOne(SWCHisBaseDataHelper.getSelectProperties((String)"hsbs_bizdataobjrule"), filter.toArray());
        return bizDataRuleObj;
    }

    public static Set<Long> getBizItemIdsHasPerm(Long orgId, Set<Long> bizItemIds) {
        DynamicObject[] bizItemArr;
        HashSet<Long> hasPermBizItemIds = new HashSet<Long>(bizItemIds.size());
        QFilter filter = new QFilter("id", "in", bizItemIds);
        filter.and(SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_bizitem", (Long)orgId));
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitem");
        for (DynamicObject bizItem : bizItemArr = helper.query("id", new QFilter[]{filter})) {
            hasPermBizItemIds.add(bizItem.getLong("id"));
        }
        return hasPermBizItemIds;
    }

    public static List<DynamicObject> getBizDataDimByIds(List<Long> bizDataDimIds) {
        ArrayList<DynamicObject> bizDataDims = new ArrayList<DynamicObject>(10);
        if (CollectionUtils.isEmpty(bizDataDimIds)) {
            return bizDataDims;
        }
        QFilter filter = new QFilter("id", "in", bizDataDimIds);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizdatadim");
        DynamicObject[] bizDataDimArr = helper.query(SWCHisBaseDataHelper.getSelectProperties((String)"hsbs_bizdatadim"), new QFilter[]{filter});
        bizDataDims.addAll(Arrays.asList(bizDataDimArr));
        return bizDataDims;
    }

    public static Date getMaxDate(Date date1, Date date2) {
        if (date1 == null) {
            return date2;
        }
        if (date2 == null) {
            return date1;
        }
        Date res = date1.before(date2) ? date2 : date1;
        return res;
    }

    public static Date getMinDate(Date date1, Date date2) {
        if (date1 == null) {
            return date2;
        }
        if (date2 == null) {
            return date1;
        }
        Date res = date1.before(date2) ? date1 : date2;
        return res;
    }

    static {
        RELATION_MAP.put(PresentErrorEnum.OUT_INPUT_TIME.getCode(), "overinputnum");
        RELATION_MAP.put(PresentErrorEnum.NOT_IN_PERIOD.getCode(), "notintimewindownum");
        RELATION_MAP.put(PresentErrorEnum.NOT_PASS.getCode(), "notpassauditnum");
        RELATION_MAP.put(PresentErrorEnum.NOT_MATCH_SALARY.getCode(), "notmatchfilenum");
        RELATION_MAP.put(PresentErrorEnum.MATCH_MORE_SALARY.getCode(), "matchmorefilenum");
        RELATION_MAP.put(PresentErrorEnum.OTHER.getCode(), "othernum");
        INSTANCE_MAP.put(AddTransSalaryService.class.getName(), new AddTransSalaryService());
        INSTANCE_MAP.put(UpdateTransSalaryService.class.getName(), new UpdateTransSalaryService());
    }
}

